# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertPolicyArgs', 'AlertPolicy']

@pulumi.input_type
class AlertPolicyArgs:
    def __init__(__self__, *,
                 alert_policy_type: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 severity: pulumi.Input[str],
                 alert_policy_rule_details: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AlertPolicy resource.
        :param pulumi.Input[str] alert_policy_type: Indicates the Data Safe feature the alert policy belongs to
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the alert policy.
        :param pulumi.Input[str] severity: (Updatable) Severity level of the alert raised by this policy.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]] alert_policy_rule_details: The details of the alert policy rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the alert policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the alert policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "alert_policy_type", alert_policy_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "severity", severity)
        if alert_policy_rule_details is not None:
            pulumi.set(__self__, "alert_policy_rule_details", alert_policy_rule_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="alertPolicyType")
    def alert_policy_type(self) -> pulumi.Input[str]:
        """
        Indicates the Data Safe feature the alert policy belongs to
        """
        return pulumi.get(self, "alert_policy_type")

    @alert_policy_type.setter
    def alert_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "alert_policy_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment where you want to create the alert policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[str]:
        """
        (Updatable) Severity level of the alert raised by this policy.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[str]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="alertPolicyRuleDetails")
    def alert_policy_rule_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]]]:
        """
        The details of the alert policy rule.
        """
        return pulumi.get(self, "alert_policy_rule_details")

    @alert_policy_rule_details.setter
    def alert_policy_rule_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]]]):
        pulumi.set(self, "alert_policy_rule_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the alert policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the alert policy. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AlertPolicyState:
    def __init__(__self__, *,
                 alert_policy_rule_details: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]]] = None,
                 alert_policy_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_user_defined: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AlertPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]] alert_policy_rule_details: The details of the alert policy rule.
        :param pulumi.Input[str] alert_policy_type: Indicates the Data Safe feature the alert policy belongs to
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the alert policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the alert policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the alert policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_user_defined: Indicates if the alert policy is user-defined (true) or pre-defined (false).
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the alert policy.
        :param pulumi.Input[str] severity: (Updatable) Severity level of the alert raised by this policy.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Creation date and time of the alert policy, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: Last date and time the alert policy was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if alert_policy_rule_details is not None:
            pulumi.set(__self__, "alert_policy_rule_details", alert_policy_rule_details)
        if alert_policy_type is not None:
            pulumi.set(__self__, "alert_policy_type", alert_policy_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_user_defined is not None:
            pulumi.set(__self__, "is_user_defined", is_user_defined)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alertPolicyRuleDetails")
    def alert_policy_rule_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]]]:
        """
        The details of the alert policy rule.
        """
        return pulumi.get(self, "alert_policy_rule_details")

    @alert_policy_rule_details.setter
    def alert_policy_rule_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyAlertPolicyRuleDetailArgs']]]]):
        pulumi.set(self, "alert_policy_rule_details", value)

    @property
    @pulumi.getter(name="alertPolicyType")
    def alert_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the Data Safe feature the alert policy belongs to
        """
        return pulumi.get(self, "alert_policy_type")

    @alert_policy_type.setter
    def alert_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_policy_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment where you want to create the alert policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the alert policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the alert policy. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isUserDefined")
    def is_user_defined(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the alert policy is user-defined (true) or pre-defined (false).
        """
        return pulumi.get(self, "is_user_defined")

    @is_user_defined.setter
    def is_user_defined(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_user_defined", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the alert policy.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Severity level of the alert raised by this policy.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the alert.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Creation date and time of the alert policy, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Last date and time the alert policy was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AlertPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_policy_rule_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyAlertPolicyRuleDetailArgs', 'AlertPolicyAlertPolicyRuleDetailArgsDict']]]]] = None,
                 alert_policy_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Alert Policy resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new user-defined alert policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alert_policy = oci.data_safe.AlertPolicy("test_alert_policy",
            alert_policy_type=alert_policy_alert_policy_type,
            compartment_id=compartment_id,
            severity=alert_policy_severity,
            alert_policy_rule_details=[{
                "expression": alert_policy_alert_policy_rule_details_expression,
                "description": alert_policy_alert_policy_rule_details_description,
                "display_name": alert_policy_alert_policy_rule_details_display_name,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=alert_policy_description,
            display_name=alert_policy_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AlertPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/alertPolicy:AlertPolicy test_alert_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyAlertPolicyRuleDetailArgs', 'AlertPolicyAlertPolicyRuleDetailArgsDict']]]] alert_policy_rule_details: The details of the alert policy rule.
        :param pulumi.Input[str] alert_policy_type: Indicates the Data Safe feature the alert policy belongs to
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the alert policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the alert policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the alert policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] severity: (Updatable) Severity level of the alert raised by this policy.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Alert Policy resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new user-defined alert policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alert_policy = oci.data_safe.AlertPolicy("test_alert_policy",
            alert_policy_type=alert_policy_alert_policy_type,
            compartment_id=compartment_id,
            severity=alert_policy_severity,
            alert_policy_rule_details=[{
                "expression": alert_policy_alert_policy_rule_details_expression,
                "description": alert_policy_alert_policy_rule_details_description,
                "display_name": alert_policy_alert_policy_rule_details_display_name,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=alert_policy_description,
            display_name=alert_policy_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AlertPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/alertPolicy:AlertPolicy test_alert_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param AlertPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_policy_rule_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyAlertPolicyRuleDetailArgs', 'AlertPolicyAlertPolicyRuleDetailArgsDict']]]]] = None,
                 alert_policy_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertPolicyArgs.__new__(AlertPolicyArgs)

            __props__.__dict__["alert_policy_rule_details"] = alert_policy_rule_details
            if alert_policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'alert_policy_type'")
            __props__.__dict__["alert_policy_type"] = alert_policy_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["is_user_defined"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AlertPolicy, __self__).__init__(
            'oci:DataSafe/alertPolicy:AlertPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_policy_rule_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyAlertPolicyRuleDetailArgs', 'AlertPolicyAlertPolicyRuleDetailArgsDict']]]]] = None,
            alert_policy_type: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_user_defined: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            severity: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AlertPolicy':
        """
        Get an existing AlertPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyAlertPolicyRuleDetailArgs', 'AlertPolicyAlertPolicyRuleDetailArgsDict']]]] alert_policy_rule_details: The details of the alert policy rule.
        :param pulumi.Input[str] alert_policy_type: Indicates the Data Safe feature the alert policy belongs to
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the alert policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the alert policy.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the alert policy. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_user_defined: Indicates if the alert policy is user-defined (true) or pre-defined (false).
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the alert policy.
        :param pulumi.Input[str] severity: (Updatable) Severity level of the alert raised by this policy.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Creation date and time of the alert policy, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: Last date and time the alert policy was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertPolicyState.__new__(_AlertPolicyState)

        __props__.__dict__["alert_policy_rule_details"] = alert_policy_rule_details
        __props__.__dict__["alert_policy_type"] = alert_policy_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_user_defined"] = is_user_defined
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["severity"] = severity
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AlertPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertPolicyRuleDetails")
    def alert_policy_rule_details(self) -> pulumi.Output[Sequence['outputs.AlertPolicyAlertPolicyRuleDetail']]:
        """
        The details of the alert policy rule.
        """
        return pulumi.get(self, "alert_policy_rule_details")

    @property
    @pulumi.getter(name="alertPolicyType")
    def alert_policy_type(self) -> pulumi.Output[str]:
        """
        Indicates the Data Safe feature the alert policy belongs to
        """
        return pulumi.get(self, "alert_policy_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment where you want to create the alert policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the alert policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the alert policy. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isUserDefined")
    def is_user_defined(self) -> pulumi.Output[bool]:
        """
        Indicates if the alert policy is user-defined (true) or pre-defined (false).
        """
        return pulumi.get(self, "is_user_defined")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the alert policy.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[str]:
        """
        (Updatable) Severity level of the alert raised by this policy.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the alert.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Creation date and time of the alert policy, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Last date and time the alert policy was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

