# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetReportDefinitionResult',
    'AwaitableGetReportDefinitionResult',
    'get_report_definition',
    'get_report_definition_output',
]

@pulumi.output_type
class GetReportDefinitionResult:
    """
    A collection of values returned by getReportDefinition.
    """
    def __init__(__self__, category=None, column_filters=None, column_infos=None, column_sortings=None, compartment_id=None, compliance_standards=None, data_source=None, defined_tags=None, description=None, display_name=None, display_order=None, freeform_tags=None, id=None, is_seeded=None, lifecycle_details=None, parent_id=None, record_time_span=None, report_definition_id=None, schedule=None, scheduled_report_compartment_id=None, scheduled_report_mime_type=None, scheduled_report_name=None, scheduled_report_row_limit=None, scim_filter=None, state=None, summaries=None, system_tags=None, time_created=None, time_updated=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if column_filters and not isinstance(column_filters, list):
            raise TypeError("Expected argument 'column_filters' to be a list")
        pulumi.set(__self__, "column_filters", column_filters)
        if column_infos and not isinstance(column_infos, list):
            raise TypeError("Expected argument 'column_infos' to be a list")
        pulumi.set(__self__, "column_infos", column_infos)
        if column_sortings and not isinstance(column_sortings, list):
            raise TypeError("Expected argument 'column_sortings' to be a list")
        pulumi.set(__self__, "column_sortings", column_sortings)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_standards and not isinstance(compliance_standards, list):
            raise TypeError("Expected argument 'compliance_standards' to be a list")
        pulumi.set(__self__, "compliance_standards", compliance_standards)
        if data_source and not isinstance(data_source, str):
            raise TypeError("Expected argument 'data_source' to be a str")
        pulumi.set(__self__, "data_source", data_source)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_order and not isinstance(display_order, int):
            raise TypeError("Expected argument 'display_order' to be a int")
        pulumi.set(__self__, "display_order", display_order)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_seeded and not isinstance(is_seeded, bool):
            raise TypeError("Expected argument 'is_seeded' to be a bool")
        pulumi.set(__self__, "is_seeded", is_seeded)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if record_time_span and not isinstance(record_time_span, str):
            raise TypeError("Expected argument 'record_time_span' to be a str")
        pulumi.set(__self__, "record_time_span", record_time_span)
        if report_definition_id and not isinstance(report_definition_id, str):
            raise TypeError("Expected argument 'report_definition_id' to be a str")
        pulumi.set(__self__, "report_definition_id", report_definition_id)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if scheduled_report_compartment_id and not isinstance(scheduled_report_compartment_id, str):
            raise TypeError("Expected argument 'scheduled_report_compartment_id' to be a str")
        pulumi.set(__self__, "scheduled_report_compartment_id", scheduled_report_compartment_id)
        if scheduled_report_mime_type and not isinstance(scheduled_report_mime_type, str):
            raise TypeError("Expected argument 'scheduled_report_mime_type' to be a str")
        pulumi.set(__self__, "scheduled_report_mime_type", scheduled_report_mime_type)
        if scheduled_report_name and not isinstance(scheduled_report_name, str):
            raise TypeError("Expected argument 'scheduled_report_name' to be a str")
        pulumi.set(__self__, "scheduled_report_name", scheduled_report_name)
        if scheduled_report_row_limit and not isinstance(scheduled_report_row_limit, int):
            raise TypeError("Expected argument 'scheduled_report_row_limit' to be a int")
        pulumi.set(__self__, "scheduled_report_row_limit", scheduled_report_row_limit)
        if scim_filter and not isinstance(scim_filter, str):
            raise TypeError("Expected argument 'scim_filter' to be a str")
        pulumi.set(__self__, "scim_filter", scim_filter)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if summaries and not isinstance(summaries, list):
            raise TypeError("Expected argument 'summaries' to be a list")
        pulumi.set(__self__, "summaries", summaries)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Specifies the name of the category that this report belongs to.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="columnFilters")
    def column_filters(self) -> Sequence['outputs.GetReportDefinitionColumnFilterResult']:
        """
        An array of columnFilter objects. A columnFilter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        """
        return pulumi.get(self, "column_filters")

    @property
    @pulumi.getter(name="columnInfos")
    def column_infos(self) -> Sequence['outputs.GetReportDefinitionColumnInfoResult']:
        """
        An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        """
        return pulumi.get(self, "column_infos")

    @property
    @pulumi.getter(name="columnSortings")
    def column_sortings(self) -> Sequence['outputs.GetReportDefinitionColumnSortingResult']:
        """
        An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        """
        return pulumi.get(self, "column_sortings")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the report definition.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="complianceStandards")
    def compliance_standards(self) -> Sequence[str]:
        """
        The list of the data protection regulations/standards used in the report that will help demonstrate compliance.
        """
        return pulumi.get(self, "compliance_standards")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> str:
        """
        Specifies the name of a resource that provides data for the report. For example alerts, events.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the report definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of the report definition.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayOrder")
    def display_order(self) -> int:
        """
        Specifies the order in which the summary must be displayed.
        """
        return pulumi.get(self, "display_order")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the report definition.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> bool:
        """
        Signifies whether the definition is seeded or user defined. Values can either be 'true' or 'false'.
        """
        return pulumi.get(self, "is_seeded")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the report definition in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> str:
        """
        The OCID of the parent report definition. In the case of seeded report definition, this is same as definition OCID.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="recordTimeSpan")
    def record_time_span(self) -> str:
        """
        The time span for the records in the report to be scheduled. <period-value><period> Allowed period strings - "H","D","M","Y" Each of the above fields potentially introduce constraints. A workRequest is created only when period-value satisfies all the constraints. Constraints introduced: 1. period = H (The allowed range for period-value is [1, 23]) 2. period = D (The allowed range for period-value is [1, 30]) 3. period = M (The allowed range for period-value is [1, 11]) 4. period = Y (The minimum period-value is 1)
        """
        return pulumi.get(self, "record_time_span")

    @property
    @pulumi.getter(name="reportDefinitionId")
    def report_definition_id(self) -> str:
        return pulumi.get(self, "report_definition_id")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        The schedule to generate the report periodically in the specified format: <version-string>;<version-specific-schedule>
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="scheduledReportCompartmentId")
    def scheduled_report_compartment_id(self) -> str:
        """
        The OCID of the compartment in which the scheduled resource will be created.
        """
        return pulumi.get(self, "scheduled_report_compartment_id")

    @property
    @pulumi.getter(name="scheduledReportMimeType")
    def scheduled_report_mime_type(self) -> str:
        """
        Specifies the format of the report ( either .xls or .pdf or .json)
        """
        return pulumi.get(self, "scheduled_report_mime_type")

    @property
    @pulumi.getter(name="scheduledReportName")
    def scheduled_report_name(self) -> str:
        """
        The name of the report to be scheduled.
        """
        return pulumi.get(self, "scheduled_report_name")

    @property
    @pulumi.getter(name="scheduledReportRowLimit")
    def scheduled_report_row_limit(self) -> int:
        """
        Specifies the limit on the number of rows in the report.
        """
        return pulumi.get(self, "scheduled_report_row_limit")

    @property
    @pulumi.getter(name="scimFilter")
    def scim_filter(self) -> str:
        """
        Additional scim filters used to get the specific summary.
        """
        return pulumi.get(self, "scim_filter")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def summaries(self) -> Sequence['outputs.GetReportDefinitionSummaryResult']:
        """
        An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        """
        return pulumi.get(self, "summaries")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Specifies the date and time the report definition was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the report definition was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetReportDefinitionResult(GetReportDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReportDefinitionResult(
            category=self.category,
            column_filters=self.column_filters,
            column_infos=self.column_infos,
            column_sortings=self.column_sortings,
            compartment_id=self.compartment_id,
            compliance_standards=self.compliance_standards,
            data_source=self.data_source,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            display_order=self.display_order,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_seeded=self.is_seeded,
            lifecycle_details=self.lifecycle_details,
            parent_id=self.parent_id,
            record_time_span=self.record_time_span,
            report_definition_id=self.report_definition_id,
            schedule=self.schedule,
            scheduled_report_compartment_id=self.scheduled_report_compartment_id,
            scheduled_report_mime_type=self.scheduled_report_mime_type,
            scheduled_report_name=self.scheduled_report_name,
            scheduled_report_row_limit=self.scheduled_report_row_limit,
            scim_filter=self.scim_filter,
            state=self.state,
            summaries=self.summaries,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_report_definition(report_definition_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReportDefinitionResult:
    """
    This data source provides details about a specific Report Definition resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of report definition specified by the identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_report_definition = oci.DataSafe.get_report_definition(report_definition_id=test_report_definition_oci_data_safe_report_definition["id"])
    ```


    :param str report_definition_id: Unique report definition identifier
    """
    __args__ = dict()
    __args__['reportDefinitionId'] = report_definition_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getReportDefinition:getReportDefinition', __args__, opts=opts, typ=GetReportDefinitionResult).value

    return AwaitableGetReportDefinitionResult(
        category=pulumi.get(__ret__, 'category'),
        column_filters=pulumi.get(__ret__, 'column_filters'),
        column_infos=pulumi.get(__ret__, 'column_infos'),
        column_sortings=pulumi.get(__ret__, 'column_sortings'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compliance_standards=pulumi.get(__ret__, 'compliance_standards'),
        data_source=pulumi.get(__ret__, 'data_source'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_order=pulumi.get(__ret__, 'display_order'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_seeded=pulumi.get(__ret__, 'is_seeded'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        record_time_span=pulumi.get(__ret__, 'record_time_span'),
        report_definition_id=pulumi.get(__ret__, 'report_definition_id'),
        schedule=pulumi.get(__ret__, 'schedule'),
        scheduled_report_compartment_id=pulumi.get(__ret__, 'scheduled_report_compartment_id'),
        scheduled_report_mime_type=pulumi.get(__ret__, 'scheduled_report_mime_type'),
        scheduled_report_name=pulumi.get(__ret__, 'scheduled_report_name'),
        scheduled_report_row_limit=pulumi.get(__ret__, 'scheduled_report_row_limit'),
        scim_filter=pulumi.get(__ret__, 'scim_filter'),
        state=pulumi.get(__ret__, 'state'),
        summaries=pulumi.get(__ret__, 'summaries'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_report_definition_output(report_definition_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReportDefinitionResult]:
    """
    This data source provides details about a specific Report Definition resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of report definition specified by the identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_report_definition = oci.DataSafe.get_report_definition(report_definition_id=test_report_definition_oci_data_safe_report_definition["id"])
    ```


    :param str report_definition_id: Unique report definition identifier
    """
    __args__ = dict()
    __args__['reportDefinitionId'] = report_definition_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getReportDefinition:getReportDefinition', __args__, opts=opts, typ=GetReportDefinitionResult)
    return __ret__.apply(lambda __response__: GetReportDefinitionResult(
        category=pulumi.get(__response__, 'category'),
        column_filters=pulumi.get(__response__, 'column_filters'),
        column_infos=pulumi.get(__response__, 'column_infos'),
        column_sortings=pulumi.get(__response__, 'column_sortings'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compliance_standards=pulumi.get(__response__, 'compliance_standards'),
        data_source=pulumi.get(__response__, 'data_source'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        display_order=pulumi.get(__response__, 'display_order'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_seeded=pulumi.get(__response__, 'is_seeded'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        record_time_span=pulumi.get(__response__, 'record_time_span'),
        report_definition_id=pulumi.get(__response__, 'report_definition_id'),
        schedule=pulumi.get(__response__, 'schedule'),
        scheduled_report_compartment_id=pulumi.get(__response__, 'scheduled_report_compartment_id'),
        scheduled_report_mime_type=pulumi.get(__response__, 'scheduled_report_mime_type'),
        scheduled_report_name=pulumi.get(__response__, 'scheduled_report_name'),
        scheduled_report_row_limit=pulumi.get(__response__, 'scheduled_report_row_limit'),
        scim_filter=pulumi.get(__response__, 'scim_filter'),
        state=pulumi.get(__response__, 'state'),
        summaries=pulumi.get(__response__, 'summaries'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
