# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MaskingReportManagementArgs', 'MaskingReportManagement']

@pulumi.input_type
class MaskingReportManagementArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 masking_policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MaskingReportManagement resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[str] target_id: The OCID of the target database masked.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if masking_policy_id is not None:
            pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that contains the masking report.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target database masked.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class _MaskingReportManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_drop_temp_tables_enabled: Optional[pulumi.Input[bool]] = None,
                 is_redo_logging_enabled: Optional[pulumi.Input[bool]] = None,
                 is_refresh_stats_enabled: Optional[pulumi.Input[bool]] = None,
                 masking_policy_id: Optional[pulumi.Input[str]] = None,
                 masking_work_request_id: Optional[pulumi.Input[str]] = None,
                 parallel_degree: Optional[pulumi.Input[str]] = None,
                 recompile: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_masking_finished: Optional[pulumi.Input[str]] = None,
                 time_masking_started: Optional[pulumi.Input[str]] = None,
                 total_masked_columns: Optional[pulumi.Input[str]] = None,
                 total_masked_objects: Optional[pulumi.Input[str]] = None,
                 total_masked_schemas: Optional[pulumi.Input[str]] = None,
                 total_masked_sensitive_types: Optional[pulumi.Input[str]] = None,
                 total_masked_values: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MaskingReportManagement resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[bool] is_drop_temp_tables_enabled: Indicates if the temporary tables created during the masking operation were dropped after masking.
        :param pulumi.Input[bool] is_redo_logging_enabled: Indicates if redo logging was enabled during the masking operation.
        :param pulumi.Input[bool] is_refresh_stats_enabled: Indicates if statistics gathering was enabled during the masking operation.
        :param pulumi.Input[str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[str] masking_work_request_id: The OCID of the masking work request that resulted in this masking report.
        :param pulumi.Input[str] parallel_degree: Indicates if parallel execution was enabled during the masking operation.
        :param pulumi.Input[str] recompile: Indicates how invalid objects were recompiled post the masking operation.
        :param pulumi.Input[str] state: The current state of the masking report.
        :param pulumi.Input[str] target_id: The OCID of the target database masked.
        :param pulumi.Input[str] time_created: The date and time the masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_masking_finished: The date and time data masking finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        :param pulumi.Input[str] time_masking_started: The date and time data masking started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        :param pulumi.Input[str] total_masked_columns: The total number of masked columns.
        :param pulumi.Input[str] total_masked_objects: The total number of unique objects (tables and editioning views) that contain the masked columns.
        :param pulumi.Input[str] total_masked_schemas: The total number of unique schemas that contain the masked columns.
        :param pulumi.Input[str] total_masked_sensitive_types: The total number of unique sensitive types associated with the masked columns.
        :param pulumi.Input[str] total_masked_values: The total number of masked values.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_drop_temp_tables_enabled is not None:
            pulumi.set(__self__, "is_drop_temp_tables_enabled", is_drop_temp_tables_enabled)
        if is_redo_logging_enabled is not None:
            pulumi.set(__self__, "is_redo_logging_enabled", is_redo_logging_enabled)
        if is_refresh_stats_enabled is not None:
            pulumi.set(__self__, "is_refresh_stats_enabled", is_refresh_stats_enabled)
        if masking_policy_id is not None:
            pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if masking_work_request_id is not None:
            pulumi.set(__self__, "masking_work_request_id", masking_work_request_id)
        if parallel_degree is not None:
            pulumi.set(__self__, "parallel_degree", parallel_degree)
        if recompile is not None:
            pulumi.set(__self__, "recompile", recompile)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_masking_finished is not None:
            pulumi.set(__self__, "time_masking_finished", time_masking_finished)
        if time_masking_started is not None:
            pulumi.set(__self__, "time_masking_started", time_masking_started)
        if total_masked_columns is not None:
            pulumi.set(__self__, "total_masked_columns", total_masked_columns)
        if total_masked_objects is not None:
            pulumi.set(__self__, "total_masked_objects", total_masked_objects)
        if total_masked_schemas is not None:
            pulumi.set(__self__, "total_masked_schemas", total_masked_schemas)
        if total_masked_sensitive_types is not None:
            pulumi.set(__self__, "total_masked_sensitive_types", total_masked_sensitive_types)
        if total_masked_values is not None:
            pulumi.set(__self__, "total_masked_values", total_masked_values)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that contains the masking report.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isDropTempTablesEnabled")
    def is_drop_temp_tables_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the temporary tables created during the masking operation were dropped after masking.
        """
        return pulumi.get(self, "is_drop_temp_tables_enabled")

    @is_drop_temp_tables_enabled.setter
    def is_drop_temp_tables_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_drop_temp_tables_enabled", value)

    @property
    @pulumi.getter(name="isRedoLoggingEnabled")
    def is_redo_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if redo logging was enabled during the masking operation.
        """
        return pulumi.get(self, "is_redo_logging_enabled")

    @is_redo_logging_enabled.setter
    def is_redo_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_redo_logging_enabled", value)

    @property
    @pulumi.getter(name="isRefreshStatsEnabled")
    def is_refresh_stats_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if statistics gathering was enabled during the masking operation.
        """
        return pulumi.get(self, "is_refresh_stats_enabled")

    @is_refresh_stats_enabled.setter
    def is_refresh_stats_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_refresh_stats_enabled", value)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter(name="maskingWorkRequestId")
    def masking_work_request_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the masking work request that resulted in this masking report.
        """
        return pulumi.get(self, "masking_work_request_id")

    @masking_work_request_id.setter
    def masking_work_request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "masking_work_request_id", value)

    @property
    @pulumi.getter(name="parallelDegree")
    def parallel_degree(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates if parallel execution was enabled during the masking operation.
        """
        return pulumi.get(self, "parallel_degree")

    @parallel_degree.setter
    def parallel_degree(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parallel_degree", value)

    @property
    @pulumi.getter
    def recompile(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates how invalid objects were recompiled post the masking operation.
        """
        return pulumi.get(self, "recompile")

    @recompile.setter
    def recompile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recompile", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the masking report.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target database masked.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeMaskingFinished")
    def time_masking_finished(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time data masking finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_masking_finished")

    @time_masking_finished.setter
    def time_masking_finished(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_masking_finished", value)

    @property
    @pulumi.getter(name="timeMaskingStarted")
    def time_masking_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time data masking started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_masking_started")

    @time_masking_started.setter
    def time_masking_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_masking_started", value)

    @property
    @pulumi.getter(name="totalMaskedColumns")
    def total_masked_columns(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of masked columns.
        """
        return pulumi.get(self, "total_masked_columns")

    @total_masked_columns.setter
    def total_masked_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_masked_columns", value)

    @property
    @pulumi.getter(name="totalMaskedObjects")
    def total_masked_objects(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of unique objects (tables and editioning views) that contain the masked columns.
        """
        return pulumi.get(self, "total_masked_objects")

    @total_masked_objects.setter
    def total_masked_objects(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_masked_objects", value)

    @property
    @pulumi.getter(name="totalMaskedSchemas")
    def total_masked_schemas(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of unique schemas that contain the masked columns.
        """
        return pulumi.get(self, "total_masked_schemas")

    @total_masked_schemas.setter
    def total_masked_schemas(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_masked_schemas", value)

    @property
    @pulumi.getter(name="totalMaskedSensitiveTypes")
    def total_masked_sensitive_types(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of unique sensitive types associated with the masked columns.
        """
        return pulumi.get(self, "total_masked_sensitive_types")

    @total_masked_sensitive_types.setter
    def total_masked_sensitive_types(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_masked_sensitive_types", value)

    @property
    @pulumi.getter(name="totalMaskedValues")
    def total_masked_values(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of masked values.
        """
        return pulumi.get(self, "total_masked_values")

    @total_masked_values.setter
    def total_masked_values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_masked_values", value)


class MaskingReportManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 masking_policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides Masking Report Management resource in Oracle Cloud Infrastructure Data Safe service.

        Gets the details of the specified masking report.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_masking_report_management = oci.data_safe.MaskingReportManagement("test_masking_report_management",
            target_id=test_target_database["id"],
            masking_policy_id=test_masking_policy["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[str] target_id: The OCID of the target database masked.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MaskingReportManagementArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides Masking Report Management resource in Oracle Cloud Infrastructure Data Safe service.

        Gets the details of the specified masking report.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_masking_report_management = oci.data_safe.MaskingReportManagement("test_masking_report_management",
            target_id=test_target_database["id"],
            masking_policy_id=test_masking_policy["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param MaskingReportManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaskingReportManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 masking_policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaskingReportManagementArgs.__new__(MaskingReportManagementArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["masking_policy_id"] = masking_policy_id
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["is_drop_temp_tables_enabled"] = None
            __props__.__dict__["is_redo_logging_enabled"] = None
            __props__.__dict__["is_refresh_stats_enabled"] = None
            __props__.__dict__["masking_work_request_id"] = None
            __props__.__dict__["parallel_degree"] = None
            __props__.__dict__["recompile"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_masking_finished"] = None
            __props__.__dict__["time_masking_started"] = None
            __props__.__dict__["total_masked_columns"] = None
            __props__.__dict__["total_masked_objects"] = None
            __props__.__dict__["total_masked_schemas"] = None
            __props__.__dict__["total_masked_sensitive_types"] = None
            __props__.__dict__["total_masked_values"] = None
        super(MaskingReportManagement, __self__).__init__(
            'oci:DataSafe/maskingReportManagement:MaskingReportManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            is_drop_temp_tables_enabled: Optional[pulumi.Input[bool]] = None,
            is_redo_logging_enabled: Optional[pulumi.Input[bool]] = None,
            is_refresh_stats_enabled: Optional[pulumi.Input[bool]] = None,
            masking_policy_id: Optional[pulumi.Input[str]] = None,
            masking_work_request_id: Optional[pulumi.Input[str]] = None,
            parallel_degree: Optional[pulumi.Input[str]] = None,
            recompile: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_masking_finished: Optional[pulumi.Input[str]] = None,
            time_masking_started: Optional[pulumi.Input[str]] = None,
            total_masked_columns: Optional[pulumi.Input[str]] = None,
            total_masked_objects: Optional[pulumi.Input[str]] = None,
            total_masked_schemas: Optional[pulumi.Input[str]] = None,
            total_masked_sensitive_types: Optional[pulumi.Input[str]] = None,
            total_masked_values: Optional[pulumi.Input[str]] = None) -> 'MaskingReportManagement':
        """
        Get an existing MaskingReportManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[bool] is_drop_temp_tables_enabled: Indicates if the temporary tables created during the masking operation were dropped after masking.
        :param pulumi.Input[bool] is_redo_logging_enabled: Indicates if redo logging was enabled during the masking operation.
        :param pulumi.Input[bool] is_refresh_stats_enabled: Indicates if statistics gathering was enabled during the masking operation.
        :param pulumi.Input[str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[str] masking_work_request_id: The OCID of the masking work request that resulted in this masking report.
        :param pulumi.Input[str] parallel_degree: Indicates if parallel execution was enabled during the masking operation.
        :param pulumi.Input[str] recompile: Indicates how invalid objects were recompiled post the masking operation.
        :param pulumi.Input[str] state: The current state of the masking report.
        :param pulumi.Input[str] target_id: The OCID of the target database masked.
        :param pulumi.Input[str] time_created: The date and time the masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_masking_finished: The date and time data masking finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        :param pulumi.Input[str] time_masking_started: The date and time data masking started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        :param pulumi.Input[str] total_masked_columns: The total number of masked columns.
        :param pulumi.Input[str] total_masked_objects: The total number of unique objects (tables and editioning views) that contain the masked columns.
        :param pulumi.Input[str] total_masked_schemas: The total number of unique schemas that contain the masked columns.
        :param pulumi.Input[str] total_masked_sensitive_types: The total number of unique sensitive types associated with the masked columns.
        :param pulumi.Input[str] total_masked_values: The total number of masked values.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaskingReportManagementState.__new__(_MaskingReportManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["is_drop_temp_tables_enabled"] = is_drop_temp_tables_enabled
        __props__.__dict__["is_redo_logging_enabled"] = is_redo_logging_enabled
        __props__.__dict__["is_refresh_stats_enabled"] = is_refresh_stats_enabled
        __props__.__dict__["masking_policy_id"] = masking_policy_id
        __props__.__dict__["masking_work_request_id"] = masking_work_request_id
        __props__.__dict__["parallel_degree"] = parallel_degree
        __props__.__dict__["recompile"] = recompile
        __props__.__dict__["state"] = state
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_masking_finished"] = time_masking_finished
        __props__.__dict__["time_masking_started"] = time_masking_started
        __props__.__dict__["total_masked_columns"] = total_masked_columns
        __props__.__dict__["total_masked_objects"] = total_masked_objects
        __props__.__dict__["total_masked_schemas"] = total_masked_schemas
        __props__.__dict__["total_masked_sensitive_types"] = total_masked_sensitive_types
        __props__.__dict__["total_masked_values"] = total_masked_values
        return MaskingReportManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment that contains the masking report.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="isDropTempTablesEnabled")
    def is_drop_temp_tables_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates if the temporary tables created during the masking operation were dropped after masking.
        """
        return pulumi.get(self, "is_drop_temp_tables_enabled")

    @property
    @pulumi.getter(name="isRedoLoggingEnabled")
    def is_redo_logging_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates if redo logging was enabled during the masking operation.
        """
        return pulumi.get(self, "is_redo_logging_enabled")

    @property
    @pulumi.getter(name="isRefreshStatsEnabled")
    def is_refresh_stats_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates if statistics gathering was enabled during the masking operation.
        """
        return pulumi.get(self, "is_refresh_stats_enabled")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> pulumi.Output[str]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter(name="maskingWorkRequestId")
    def masking_work_request_id(self) -> pulumi.Output[str]:
        """
        The OCID of the masking work request that resulted in this masking report.
        """
        return pulumi.get(self, "masking_work_request_id")

    @property
    @pulumi.getter(name="parallelDegree")
    def parallel_degree(self) -> pulumi.Output[str]:
        """
        Indicates if parallel execution was enabled during the masking operation.
        """
        return pulumi.get(self, "parallel_degree")

    @property
    @pulumi.getter
    def recompile(self) -> pulumi.Output[str]:
        """
        Indicates how invalid objects were recompiled post the masking operation.
        """
        return pulumi.get(self, "recompile")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the masking report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The OCID of the target database masked.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeMaskingFinished")
    def time_masking_finished(self) -> pulumi.Output[str]:
        """
        The date and time data masking finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_masking_finished")

    @property
    @pulumi.getter(name="timeMaskingStarted")
    def time_masking_started(self) -> pulumi.Output[str]:
        """
        The date and time data masking started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_masking_started")

    @property
    @pulumi.getter(name="totalMaskedColumns")
    def total_masked_columns(self) -> pulumi.Output[str]:
        """
        The total number of masked columns.
        """
        return pulumi.get(self, "total_masked_columns")

    @property
    @pulumi.getter(name="totalMaskedObjects")
    def total_masked_objects(self) -> pulumi.Output[str]:
        """
        The total number of unique objects (tables and editioning views) that contain the masked columns.
        """
        return pulumi.get(self, "total_masked_objects")

    @property
    @pulumi.getter(name="totalMaskedSchemas")
    def total_masked_schemas(self) -> pulumi.Output[str]:
        """
        The total number of unique schemas that contain the masked columns.
        """
        return pulumi.get(self, "total_masked_schemas")

    @property
    @pulumi.getter(name="totalMaskedSensitiveTypes")
    def total_masked_sensitive_types(self) -> pulumi.Output[str]:
        """
        The total number of unique sensitive types associated with the masked columns.
        """
        return pulumi.get(self, "total_masked_sensitive_types")

    @property
    @pulumi.getter(name="totalMaskedValues")
    def total_masked_values(self) -> pulumi.Output[str]:
        """
        The total number of masked values.
        """
        return pulumi.get(self, "total_masked_values")

