# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    """
    A collection of values returned by getConnection.
    """
    def __init__(__self__, access_token=None, app_password=None, base_url=None, compartment_id=None, connection_id=None, connection_type=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, last_connection_validation_results=None, project_id=None, state=None, system_tags=None, time_created=None, time_updated=None, tls_verify_configs=None, username=None):
        if access_token and not isinstance(access_token, str):
            raise TypeError("Expected argument 'access_token' to be a str")
        pulumi.set(__self__, "access_token", access_token)
        if app_password and not isinstance(app_password, str):
            raise TypeError("Expected argument 'app_password' to be a str")
        pulumi.set(__self__, "app_password", app_password)
        if base_url and not isinstance(base_url, str):
            raise TypeError("Expected argument 'base_url' to be a str")
        pulumi.set(__self__, "base_url", base_url)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if connection_type and not isinstance(connection_type, str):
            raise TypeError("Expected argument 'connection_type' to be a str")
        pulumi.set(__self__, "connection_type", connection_type)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_connection_validation_results and not isinstance(last_connection_validation_results, list):
            raise TypeError("Expected argument 'last_connection_validation_results' to be a list")
        pulumi.set(__self__, "last_connection_validation_results", last_connection_validation_results)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if tls_verify_configs and not isinstance(tls_verify_configs, list):
            raise TypeError("Expected argument 'tls_verify_configs' to be a list")
        pulumi.set(__self__, "tls_verify_configs", tls_verify_configs)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> str:
        """
        The OCID of personal access token saved in secret store.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="appPassword")
    def app_password(self) -> str:
        """
        OCID of personal Bitbucket Cloud AppPassword saved in secret store
        """
        return pulumi.get(self, "app_password")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The Base URL of the hosted BitbucketServer/Visual Builder Studio server.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> str:
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> str:
        """
        The type of connection.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional description about the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Connection display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastConnectionValidationResults")
    def last_connection_validation_results(self) -> Sequence['outputs.GetConnectionLastConnectionValidationResultResult']:
        """
        The result of validating the credentials of a connection.
        """
        return pulumi.get(self, "last_connection_validation_results")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the connection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the connection was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the connection was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="tlsVerifyConfigs")
    def tls_verify_configs(self) -> Sequence['outputs.GetConnectionTlsVerifyConfigResult']:
        """
        TLS configuration used by build service to verify TLS connection.
        """
        return pulumi.get(self, "tls_verify_configs")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Public Bitbucket Cloud Username in plain text
        """
        return pulumi.get(self, "username")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            access_token=self.access_token,
            app_password=self.app_password,
            base_url=self.base_url,
            compartment_id=self.compartment_id,
            connection_id=self.connection_id,
            connection_type=self.connection_type,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            last_connection_validation_results=self.last_connection_validation_results,
            project_id=self.project_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            tls_verify_configs=self.tls_verify_configs,
            username=self.username)


def get_connection(connection_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    This data source provides details about a specific Connection resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a connection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection = oci.DevOps.get_connection(connection_id=test_connection_oci_devops_connection["id"])
    ```


    :param str connection_id: Unique connection identifier.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        access_token=pulumi.get(__ret__, 'access_token'),
        app_password=pulumi.get(__ret__, 'app_password'),
        base_url=pulumi.get(__ret__, 'base_url'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_id=pulumi.get(__ret__, 'connection_id'),
        connection_type=pulumi.get(__ret__, 'connection_type'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        last_connection_validation_results=pulumi.get(__ret__, 'last_connection_validation_results'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        tls_verify_configs=pulumi.get(__ret__, 'tls_verify_configs'),
        username=pulumi.get(__ret__, 'username'))
def get_connection_output(connection_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionResult]:
    """
    This data source provides details about a specific Connection resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a connection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection = oci.DevOps.get_connection(connection_id=test_connection_oci_devops_connection["id"])
    ```


    :param str connection_id: Unique connection identifier.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult)
    return __ret__.apply(lambda __response__: GetConnectionResult(
        access_token=pulumi.get(__response__, 'access_token'),
        app_password=pulumi.get(__response__, 'app_password'),
        base_url=pulumi.get(__response__, 'base_url'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connection_id=pulumi.get(__response__, 'connection_id'),
        connection_type=pulumi.get(__response__, 'connection_type'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        last_connection_validation_results=pulumi.get(__response__, 'last_connection_validation_results'),
        project_id=pulumi.get(__response__, 'project_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        tls_verify_configs=pulumi.get(__response__, 'tls_verify_configs'),
        username=pulumi.get(__response__, 'username')))
