# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrPlanExecutionsResult',
    'AwaitableGetDrPlanExecutionsResult',
    'get_dr_plan_executions',
    'get_dr_plan_executions_output',
]

@pulumi.output_type
class GetDrPlanExecutionsResult:
    """
    A collection of values returned by getDrPlanExecutions.
    """
    def __init__(__self__, display_name=None, dr_plan_execution_collections=None, dr_plan_execution_id=None, dr_protection_group_id=None, filters=None, id=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_plan_execution_collections and not isinstance(dr_plan_execution_collections, list):
            raise TypeError("Expected argument 'dr_plan_execution_collections' to be a list")
        pulumi.set(__self__, "dr_plan_execution_collections", dr_plan_execution_collections)
        if dr_plan_execution_id and not isinstance(dr_plan_execution_id, str):
            raise TypeError("Expected argument 'dr_plan_execution_id' to be a str")
        pulumi.set(__self__, "dr_plan_execution_id", dr_plan_execution_id)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the step execution.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drPlanExecutionCollections")
    def dr_plan_execution_collections(self) -> Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionResult']:
        """
        The list of dr_plan_execution_collection.
        """
        return pulumi.get(self, "dr_plan_execution_collections")

    @property
    @pulumi.getter(name="drPlanExecutionId")
    def dr_plan_execution_id(self) -> Optional[str]:
        return pulumi.get(self, "dr_plan_execution_id")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> str:
        """
        The OCID of the DR protection group to which this DR plan execution belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrPlanExecutionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the DR plan execution.
        """
        return pulumi.get(self, "state")


class AwaitableGetDrPlanExecutionsResult(GetDrPlanExecutionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrPlanExecutionsResult(
            display_name=self.display_name,
            dr_plan_execution_collections=self.dr_plan_execution_collections,
            dr_plan_execution_id=self.dr_plan_execution_id,
            dr_protection_group_id=self.dr_protection_group_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_dr_plan_executions(display_name: Optional[str] = None,
                           dr_plan_execution_id: Optional[str] = None,
                           dr_protection_group_id: Optional[str] = None,
                           filters: Optional[Sequence[Union['GetDrPlanExecutionsFilterArgs', 'GetDrPlanExecutionsFilterArgsDict']]] = None,
                           state: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrPlanExecutionsResult:
    """
    This data source provides the list of Dr Plan Executions in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of all DR plan executions for a DR protection group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plan_executions = oci.DisasterRecovery.get_dr_plan_executions(dr_protection_group_id=test_dr_protection_group["id"],
        display_name=dr_plan_execution_display_name,
        dr_plan_execution_id=test_dr_plan_execution["id"],
        state=dr_plan_execution_state)
    ```


    :param str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param str dr_plan_execution_id: The OCID of the DR plan execution.  Example: `ocid1.drplanexecution.oc1..uniqueID`
    :param str dr_protection_group_id: The OCID of the DR protection group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param str state: A filter to return only DR plan executions that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['drPlanExecutionId'] = dr_plan_execution_id
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getDrPlanExecutions:getDrPlanExecutions', __args__, opts=opts, typ=GetDrPlanExecutionsResult).value

    return AwaitableGetDrPlanExecutionsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_plan_execution_collections=pulumi.get(__ret__, 'dr_plan_execution_collections'),
        dr_plan_execution_id=pulumi.get(__ret__, 'dr_plan_execution_id'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_dr_plan_executions_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  dr_plan_execution_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  dr_protection_group_id: Optional[pulumi.Input[str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDrPlanExecutionsFilterArgs', 'GetDrPlanExecutionsFilterArgsDict']]]]] = None,
                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrPlanExecutionsResult]:
    """
    This data source provides the list of Dr Plan Executions in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of all DR plan executions for a DR protection group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plan_executions = oci.DisasterRecovery.get_dr_plan_executions(dr_protection_group_id=test_dr_protection_group["id"],
        display_name=dr_plan_execution_display_name,
        dr_plan_execution_id=test_dr_plan_execution["id"],
        state=dr_plan_execution_state)
    ```


    :param str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param str dr_plan_execution_id: The OCID of the DR plan execution.  Example: `ocid1.drplanexecution.oc1..uniqueID`
    :param str dr_protection_group_id: The OCID of the DR protection group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param str state: A filter to return only DR plan executions that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['drPlanExecutionId'] = dr_plan_execution_id
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DisasterRecovery/getDrPlanExecutions:getDrPlanExecutions', __args__, opts=opts, typ=GetDrPlanExecutionsResult)
    return __ret__.apply(lambda __response__: GetDrPlanExecutionsResult(
        display_name=pulumi.get(__response__, 'display_name'),
        dr_plan_execution_collections=pulumi.get(__response__, 'dr_plan_execution_collections'),
        dr_plan_execution_id=pulumi.get(__response__, 'dr_plan_execution_id'),
        dr_protection_group_id=pulumi.get(__response__, 'dr_protection_group_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
