# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetTargetsResult',
    'AwaitableGetFleetTargetsResult',
    'get_fleet_targets',
    'get_fleet_targets_output',
]

@pulumi.output_type
class GetFleetTargetsResult:
    """
    A collection of values returned by getFleetTargets.
    """
    def __init__(__self__, display_name=None, filters=None, fleet_id=None, fleet_target_collections=None, id=None, product=None, resource_display_name=None, resource_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if fleet_target_collections and not isinstance(fleet_target_collections, list):
            raise TypeError("Expected argument 'fleet_target_collections' to be a list")
        pulumi.set(__self__, "fleet_target_collections", fleet_target_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if resource_display_name and not isinstance(resource_display_name, str):
            raise TypeError("Expected argument 'resource_display_name' to be a str")
        pulumi.set(__self__, "resource_display_name", resource_display_name)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetTargetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetTargetCollections")
    def fleet_target_collections(self) -> Sequence['outputs.GetFleetTargetsFleetTargetCollectionResult']:
        """
        The list of fleet_target_collection.
        """
        return pulumi.get(self, "fleet_target_collections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        Product to which the target belongs to.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="resourceDisplayName")
    def resource_display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "resource_display_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "resource_id")


class AwaitableGetFleetTargetsResult(GetFleetTargetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetTargetsResult(
            display_name=self.display_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            fleet_target_collections=self.fleet_target_collections,
            id=self.id,
            product=self.product,
            resource_display_name=self.resource_display_name,
            resource_id=self.resource_id)


def get_fleet_targets(display_name: Optional[str] = None,
                      filters: Optional[Sequence[Union['GetFleetTargetsFilterArgs', 'GetFleetTargetsFilterArgsDict']]] = None,
                      fleet_id: Optional[str] = None,
                      product: Optional[str] = None,
                      resource_display_name: Optional[str] = None,
                      resource_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetTargetsResult:
    """
    This data source provides the list of Fleet Targets in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of FleetTargets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_targets = oci.FleetAppsManagement.get_fleet_targets(fleet_id=test_fleet["id"],
        display_name=fleet_target_display_name,
        product=fleet_target_product,
        resource_display_name=fleet_target_resource_display_name,
        resource_id=test_resource["id"])
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: unique Fleet identifier
    :param str product: Product Name
    :param str resource_display_name: Resource Display Name
    :param str resource_id: Resource Identifier
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['product'] = product
    __args__['resourceDisplayName'] = resource_display_name
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetTargets:getFleetTargets', __args__, opts=opts, typ=GetFleetTargetsResult).value

    return AwaitableGetFleetTargetsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        fleet_target_collections=pulumi.get(__ret__, 'fleet_target_collections'),
        id=pulumi.get(__ret__, 'id'),
        product=pulumi.get(__ret__, 'product'),
        resource_display_name=pulumi.get(__ret__, 'resource_display_name'),
        resource_id=pulumi.get(__ret__, 'resource_id'))
def get_fleet_targets_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetTargetsFilterArgs', 'GetFleetTargetsFilterArgsDict']]]]] = None,
                             fleet_id: Optional[pulumi.Input[str]] = None,
                             product: Optional[pulumi.Input[Optional[str]]] = None,
                             resource_display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetTargetsResult]:
    """
    This data source provides the list of Fleet Targets in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of FleetTargets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_targets = oci.FleetAppsManagement.get_fleet_targets(fleet_id=test_fleet["id"],
        display_name=fleet_target_display_name,
        product=fleet_target_product,
        resource_display_name=fleet_target_resource_display_name,
        resource_id=test_resource["id"])
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: unique Fleet identifier
    :param str product: Product Name
    :param str resource_display_name: Resource Display Name
    :param str resource_id: Resource Identifier
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['product'] = product
    __args__['resourceDisplayName'] = resource_display_name
    __args__['resourceId'] = resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetTargets:getFleetTargets', __args__, opts=opts, typ=GetFleetTargetsResult)
    return __ret__.apply(lambda __response__: GetFleetTargetsResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        fleet_target_collections=pulumi.get(__response__, 'fleet_target_collections'),
        id=pulumi.get(__response__, 'id'),
        product=pulumi.get(__response__, 'product'),
        resource_display_name=pulumi.get(__response__, 'resource_display_name'),
        resource_id=pulumi.get(__response__, 'resource_id')))
