# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFusionEnvironmentFamilyLimitsAndUsageResult',
    'AwaitableGetFusionEnvironmentFamilyLimitsAndUsageResult',
    'get_fusion_environment_family_limits_and_usage',
    'get_fusion_environment_family_limits_and_usage_output',
]

@pulumi.output_type
class GetFusionEnvironmentFamilyLimitsAndUsageResult:
    """
    A collection of values returned by getFusionEnvironmentFamilyLimitsAndUsage.
    """
    def __init__(__self__, development_limit_and_usages=None, fusion_environment_family_id=None, id=None, production_limit_and_usages=None, test_limit_and_usages=None):
        if development_limit_and_usages and not isinstance(development_limit_and_usages, list):
            raise TypeError("Expected argument 'development_limit_and_usages' to be a list")
        pulumi.set(__self__, "development_limit_and_usages", development_limit_and_usages)
        if fusion_environment_family_id and not isinstance(fusion_environment_family_id, str):
            raise TypeError("Expected argument 'fusion_environment_family_id' to be a str")
        pulumi.set(__self__, "fusion_environment_family_id", fusion_environment_family_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if production_limit_and_usages and not isinstance(production_limit_and_usages, list):
            raise TypeError("Expected argument 'production_limit_and_usages' to be a list")
        pulumi.set(__self__, "production_limit_and_usages", production_limit_and_usages)
        if test_limit_and_usages and not isinstance(test_limit_and_usages, list):
            raise TypeError("Expected argument 'test_limit_and_usages' to be a list")
        pulumi.set(__self__, "test_limit_and_usages", test_limit_and_usages)

    @property
    @pulumi.getter(name="developmentLimitAndUsages")
    def development_limit_and_usages(self) -> Sequence['outputs.GetFusionEnvironmentFamilyLimitsAndUsageDevelopmentLimitAndUsageResult']:
        """
        The limit and usage for a specific environment type, for example, production, development, or test.
        """
        return pulumi.get(self, "development_limit_and_usages")

    @property
    @pulumi.getter(name="fusionEnvironmentFamilyId")
    def fusion_environment_family_id(self) -> str:
        return pulumi.get(self, "fusion_environment_family_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="productionLimitAndUsages")
    def production_limit_and_usages(self) -> Sequence['outputs.GetFusionEnvironmentFamilyLimitsAndUsageProductionLimitAndUsageResult']:
        """
        The limit and usage for a specific environment type, for example, production, development, or test.
        """
        return pulumi.get(self, "production_limit_and_usages")

    @property
    @pulumi.getter(name="testLimitAndUsages")
    def test_limit_and_usages(self) -> Sequence['outputs.GetFusionEnvironmentFamilyLimitsAndUsageTestLimitAndUsageResult']:
        """
        The limit and usage for a specific environment type, for example, production, development, or test.
        """
        return pulumi.get(self, "test_limit_and_usages")


class AwaitableGetFusionEnvironmentFamilyLimitsAndUsageResult(GetFusionEnvironmentFamilyLimitsAndUsageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentFamilyLimitsAndUsageResult(
            development_limit_and_usages=self.development_limit_and_usages,
            fusion_environment_family_id=self.fusion_environment_family_id,
            id=self.id,
            production_limit_and_usages=self.production_limit_and_usages,
            test_limit_and_usages=self.test_limit_and_usages)


def get_fusion_environment_family_limits_and_usage(fusion_environment_family_id: Optional[str] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentFamilyLimitsAndUsageResult:
    """
    This data source provides details about a specific Fusion Environment Family Limits And Usage resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets the number of environments (usage) of each type in the fusion environment family, as well as the limit that's allowed to be created based on the group's associated subscriptions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_family_limits_and_usage = oci.Functions.get_fusion_environment_family_limits_and_usage(fusion_environment_family_id=test_fusion_environment_family["id"])
    ```


    :param str fusion_environment_family_id: The unique identifier (OCID) of the FusionEnvironmentFamily.
    """
    __args__ = dict()
    __args__['fusionEnvironmentFamilyId'] = fusion_environment_family_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentFamilyLimitsAndUsage:getFusionEnvironmentFamilyLimitsAndUsage', __args__, opts=opts, typ=GetFusionEnvironmentFamilyLimitsAndUsageResult).value

    return AwaitableGetFusionEnvironmentFamilyLimitsAndUsageResult(
        development_limit_and_usages=pulumi.get(__ret__, 'development_limit_and_usages'),
        fusion_environment_family_id=pulumi.get(__ret__, 'fusion_environment_family_id'),
        id=pulumi.get(__ret__, 'id'),
        production_limit_and_usages=pulumi.get(__ret__, 'production_limit_and_usages'),
        test_limit_and_usages=pulumi.get(__ret__, 'test_limit_and_usages'))
def get_fusion_environment_family_limits_and_usage_output(fusion_environment_family_id: Optional[pulumi.Input[str]] = None,
                                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFusionEnvironmentFamilyLimitsAndUsageResult]:
    """
    This data source provides details about a specific Fusion Environment Family Limits And Usage resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets the number of environments (usage) of each type in the fusion environment family, as well as the limit that's allowed to be created based on the group's associated subscriptions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_family_limits_and_usage = oci.Functions.get_fusion_environment_family_limits_and_usage(fusion_environment_family_id=test_fusion_environment_family["id"])
    ```


    :param str fusion_environment_family_id: The unique identifier (OCID) of the FusionEnvironmentFamily.
    """
    __args__ = dict()
    __args__['fusionEnvironmentFamilyId'] = fusion_environment_family_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getFusionEnvironmentFamilyLimitsAndUsage:getFusionEnvironmentFamilyLimitsAndUsage', __args__, opts=opts, typ=GetFusionEnvironmentFamilyLimitsAndUsageResult)
    return __ret__.apply(lambda __response__: GetFusionEnvironmentFamilyLimitsAndUsageResult(
        development_limit_and_usages=pulumi.get(__response__, 'development_limit_and_usages'),
        fusion_environment_family_id=pulumi.get(__response__, 'fusion_environment_family_id'),
        id=pulumi.get(__response__, 'id'),
        production_limit_and_usages=pulumi.get(__response__, 'production_limit_and_usages'),
        test_limit_and_usages=pulumi.get(__response__, 'test_limit_and_usages')))
