# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetsResult',
    'AwaitableGetFleetsResult',
    'get_fleets',
    'get_fleets_output',
]

@pulumi.output_type
class GetFleetsResult:
    """
    A collection of values returned by getFleets.
    """
    def __init__(__self__, compartment_id=None, display_name=None, display_name_contains=None, filters=None, fleet_collections=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_collections and not isinstance(fleet_collections, list):
            raise TypeError("Expected argument 'fleet_collections' to be a list")
        pulumi.set(__self__, "fleet_collections", fleet_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Fleet.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the Fleet.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetCollections")
    def fleet_collections(self) -> Sequence['outputs.GetFleetsFleetCollectionResult']:
        """
        The list of fleet_collection.
        """
        return pulumi.get(self, "fleet_collections")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The lifecycle state of the Fleet.
        """
        return pulumi.get(self, "state")


class AwaitableGetFleetsResult(GetFleetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            fleet_collections=self.fleet_collections,
            id=self.id,
            state=self.state)


def get_fleets(compartment_id: Optional[str] = None,
               display_name: Optional[str] = None,
               display_name_contains: Optional[str] = None,
               filters: Optional[Sequence[Union['GetFleetsFilterArgs', 'GetFleetsFilterArgsDict']]] = None,
               id: Optional[str] = None,
               state: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetsResult:
    """
    This data source provides the list of Fleets in Oracle Cloud Infrastructure Jms service.

    Returns a list of all the Fleets contained by a compartment. The query parameter `compartmentId`
    is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleets = oci.Jms.get_fleets(compartment_id=compartment_id,
        display_name=fleet_display_name,
        display_name_contains=fleet_display_name_contains,
        id=fleet_id,
        state=fleet_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str display_name: The display name.
    :param str display_name_contains: Filter the list with displayName contains the given value.
    :param str id: The ID.
    :param str state: The state of the lifecycle.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleets:getFleets', __args__, opts=opts, typ=GetFleetsResult).value

    return AwaitableGetFleetsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_collections=pulumi.get(__ret__, 'fleet_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_fleets_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                      display_name: Optional[pulumi.Input[Optional[str]]] = None,
                      display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetsFilterArgs', 'GetFleetsFilterArgsDict']]]]] = None,
                      id: Optional[pulumi.Input[Optional[str]]] = None,
                      state: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetsResult]:
    """
    This data source provides the list of Fleets in Oracle Cloud Infrastructure Jms service.

    Returns a list of all the Fleets contained by a compartment. The query parameter `compartmentId`
    is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleets = oci.Jms.get_fleets(compartment_id=compartment_id,
        display_name=fleet_display_name,
        display_name_contains=fleet_display_name_contains,
        id=fleet_id,
        state=fleet_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str display_name: The display name.
    :param str display_name_contains: Filter the list with displayName contains the given value.
    :param str id: The ID.
    :param str state: The state of the lifecycle.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleets:getFleets', __args__, opts=opts, typ=GetFleetsResult)
    return __ret__.apply(lambda __response__: GetFleetsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_collections=pulumi.get(__response__, 'fleet_collections'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
