# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStreamDistributionChannelResult',
    'AwaitableGetStreamDistributionChannelResult',
    'get_stream_distribution_channel',
    'get_stream_distribution_channel_output',
]

@pulumi.output_type
class GetStreamDistributionChannelResult:
    """
    A collection of values returned by getStreamDistributionChannel.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, domain_name=None, freeform_tags=None, id=None, is_lock_override=None, locks=None, state=None, stream_distribution_channel_id=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_distribution_channel_id and not isinstance(stream_distribution_channel_id, str):
            raise TypeError("Expected argument 'stream_distribution_channel_id' to be a str")
        pulumi.set(__self__, "stream_distribution_channel_id", stream_distribution_channel_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Stream Distribution Channel display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Unique domain name of the Distribution Channel.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetStreamDistributionChannelLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Stream Distribution Channel.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamDistributionChannelId")
    def stream_distribution_channel_id(self) -> str:
        return pulumi.get(self, "stream_distribution_channel_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the Stream Distribution Channel was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when the Stream Distribution Channel was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetStreamDistributionChannelResult(GetStreamDistributionChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamDistributionChannelResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            domain_name=self.domain_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_lock_override=self.is_lock_override,
            locks=self.locks,
            state=self.state,
            stream_distribution_channel_id=self.stream_distribution_channel_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_stream_distribution_channel(stream_distribution_channel_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamDistributionChannelResult:
    """
    This data source provides details about a specific Stream Distribution Channel resource in Oracle Cloud Infrastructure Media Services service.

    Gets a Stream Distribution Channel by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_distribution_channel = oci.MediaServices.get_stream_distribution_channel(stream_distribution_channel_id=test_stream_distribution_channel_oci_media_services_stream_distribution_channel["id"])
    ```


    :param str stream_distribution_channel_id: Unique Stream Distribution Channel path identifier.
    """
    __args__ = dict()
    __args__['streamDistributionChannelId'] = stream_distribution_channel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getStreamDistributionChannel:getStreamDistributionChannel', __args__, opts=opts, typ=GetStreamDistributionChannelResult).value

    return AwaitableGetStreamDistributionChannelResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        locks=pulumi.get(__ret__, 'locks'),
        state=pulumi.get(__ret__, 'state'),
        stream_distribution_channel_id=pulumi.get(__ret__, 'stream_distribution_channel_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_stream_distribution_channel_output(stream_distribution_channel_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStreamDistributionChannelResult]:
    """
    This data source provides details about a specific Stream Distribution Channel resource in Oracle Cloud Infrastructure Media Services service.

    Gets a Stream Distribution Channel by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_distribution_channel = oci.MediaServices.get_stream_distribution_channel(stream_distribution_channel_id=test_stream_distribution_channel_oci_media_services_stream_distribution_channel["id"])
    ```


    :param str stream_distribution_channel_id: Unique Stream Distribution Channel path identifier.
    """
    __args__ = dict()
    __args__['streamDistributionChannelId'] = stream_distribution_channel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getStreamDistributionChannel:getStreamDistributionChannel', __args__, opts=opts, typ=GetStreamDistributionChannelResult)
    return __ret__.apply(lambda __response__: GetStreamDistributionChannelResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_lock_override=pulumi.get(__response__, 'is_lock_override'),
        locks=pulumi.get(__response__, 'locks'),
        state=pulumi.get(__response__, 'state'),
        stream_distribution_channel_id=pulumi.get(__response__, 'stream_distribution_channel_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
