# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubscriptionsResult',
    'AwaitableGetSubscriptionsResult',
    'get_subscriptions',
    'get_subscriptions_output',
]

@pulumi.output_type
class GetSubscriptionsResult:
    """
    A collection of values returned by getSubscriptions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, subscriptions=None, topic_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if subscriptions and not isinstance(subscriptions, list):
            raise TypeError("Expected argument 'subscriptions' to be a list")
        pulumi.set(__self__, "subscriptions", subscriptions)
        if topic_id and not isinstance(topic_id, str):
            raise TypeError("Expected argument 'topic_id' to be a str")
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSubscriptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def subscriptions(self) -> Sequence['outputs.GetSubscriptionsSubscriptionResult']:
        """
        The list of subscriptions.
        """
        return pulumi.get(self, "subscriptions")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated topic.
        """
        return pulumi.get(self, "topic_id")


class AwaitableGetSubscriptionsResult(GetSubscriptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            subscriptions=self.subscriptions,
            topic_id=self.topic_id)


def get_subscriptions(compartment_id: Optional[str] = None,
                      filters: Optional[Sequence[Union['GetSubscriptionsFilterArgs', 'GetSubscriptionsFilterArgsDict']]] = None,
                      topic_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionsResult:
    """
    This data source provides the list of Subscriptions in Oracle Cloud Infrastructure Notifications service.

    Lists the subscriptions in the specified compartment or topic.

    Transactions Per Minute (TPM) per-tenancy limit for this operation: 60.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscriptions = oci.Ons.get_subscriptions(compartment_id=compartment_id,
        topic_id=test_notification_topic["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str topic_id: Return all subscriptions that are subscribed to the given topic OCID. Either this query parameter or the compartmentId query parameter must be set.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['topicId'] = topic_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ons/getSubscriptions:getSubscriptions', __args__, opts=opts, typ=GetSubscriptionsResult).value

    return AwaitableGetSubscriptionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        subscriptions=pulumi.get(__ret__, 'subscriptions'),
        topic_id=pulumi.get(__ret__, 'topic_id'))
def get_subscriptions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSubscriptionsFilterArgs', 'GetSubscriptionsFilterArgsDict']]]]] = None,
                             topic_id: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionsResult]:
    """
    This data source provides the list of Subscriptions in Oracle Cloud Infrastructure Notifications service.

    Lists the subscriptions in the specified compartment or topic.

    Transactions Per Minute (TPM) per-tenancy limit for this operation: 60.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscriptions = oci.Ons.get_subscriptions(compartment_id=compartment_id,
        topic_id=test_notification_topic["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str topic_id: Return all subscriptions that are subscribed to the given topic OCID. Either this query parameter or the compartmentId query parameter must be set.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['topicId'] = topic_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Ons/getSubscriptions:getSubscriptions', __args__, opts=opts, typ=GetSubscriptionsResult)
    return __ret__.apply(lambda __response__: GetSubscriptionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        subscriptions=pulumi.get(__response__, 'subscriptions'),
        topic_id=pulumi.get(__response__, 'topic_id')))
