# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpaInstanceResult',
    'AwaitableGetOpaInstanceResult',
    'get_opa_instance',
    'get_opa_instance_output',
]

@pulumi.output_type
class GetOpaInstanceResult:
    """
    A collection of values returned by getOpaInstance.
    """
    def __init__(__self__, attachments=None, compartment_id=None, consumption_model=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, idcs_at=None, identity_app_display_name=None, identity_app_guid=None, identity_app_opc_service_instance_guid=None, identity_domain_url=None, instance_url=None, is_breakglass_enabled=None, metering_type=None, opa_instance_id=None, shape_name=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if consumption_model and not isinstance(consumption_model, str):
            raise TypeError("Expected argument 'consumption_model' to be a str")
        pulumi.set(__self__, "consumption_model", consumption_model)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_at and not isinstance(idcs_at, str):
            raise TypeError("Expected argument 'idcs_at' to be a str")
        pulumi.set(__self__, "idcs_at", idcs_at)
        if identity_app_display_name and not isinstance(identity_app_display_name, str):
            raise TypeError("Expected argument 'identity_app_display_name' to be a str")
        pulumi.set(__self__, "identity_app_display_name", identity_app_display_name)
        if identity_app_guid and not isinstance(identity_app_guid, str):
            raise TypeError("Expected argument 'identity_app_guid' to be a str")
        pulumi.set(__self__, "identity_app_guid", identity_app_guid)
        if identity_app_opc_service_instance_guid and not isinstance(identity_app_opc_service_instance_guid, str):
            raise TypeError("Expected argument 'identity_app_opc_service_instance_guid' to be a str")
        pulumi.set(__self__, "identity_app_opc_service_instance_guid", identity_app_opc_service_instance_guid)
        if identity_domain_url and not isinstance(identity_domain_url, str):
            raise TypeError("Expected argument 'identity_domain_url' to be a str")
        pulumi.set(__self__, "identity_domain_url", identity_domain_url)
        if instance_url and not isinstance(instance_url, str):
            raise TypeError("Expected argument 'instance_url' to be a str")
        pulumi.set(__self__, "instance_url", instance_url)
        if is_breakglass_enabled and not isinstance(is_breakglass_enabled, bool):
            raise TypeError("Expected argument 'is_breakglass_enabled' to be a bool")
        pulumi.set(__self__, "is_breakglass_enabled", is_breakglass_enabled)
        if metering_type and not isinstance(metering_type, str):
            raise TypeError("Expected argument 'metering_type' to be a str")
        pulumi.set(__self__, "metering_type", metering_type)
        if opa_instance_id and not isinstance(opa_instance_id, str):
            raise TypeError("Expected argument 'opa_instance_id' to be a str")
        pulumi.set(__self__, "opa_instance_id", opa_instance_id)
        if shape_name and not isinstance(shape_name, str):
            raise TypeError("Expected argument 'shape_name' to be a str")
        pulumi.set(__self__, "shape_name", shape_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetOpaInstanceAttachmentResult']:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> str:
        """
        The entitlement used for billing purposes
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Process Automation instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        OpaInstance Identifier, can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> str:
        return pulumi.get(self, "idcs_at")

    @property
    @pulumi.getter(name="identityAppDisplayName")
    def identity_app_display_name(self) -> str:
        """
        This property specifies the name of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_display_name")

    @property
    @pulumi.getter(name="identityAppGuid")
    def identity_app_guid(self) -> str:
        """
        This property specifies the GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user role mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_guid")

    @property
    @pulumi.getter(name="identityAppOpcServiceInstanceGuid")
    def identity_app_opc_service_instance_guid(self) -> str:
        """
        This property specifies the OPC Service Instance GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_opc_service_instance_guid")

    @property
    @pulumi.getter(name="identityDomainUrl")
    def identity_domain_url(self) -> str:
        """
        This property specifies the domain url of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_domain_url")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        OPA Instance URL
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="isBreakglassEnabled")
    def is_breakglass_enabled(self) -> bool:
        """
        indicates if breakGlass is enabled for the opa instance.
        """
        return pulumi.get(self, "is_breakglass_enabled")

    @property
    @pulumi.getter(name="meteringType")
    def metering_type(self) -> str:
        """
        MeteringType Identifier
        """
        return pulumi.get(self, "metering_type")

    @property
    @pulumi.getter(name="opaInstanceId")
    def opa_instance_id(self) -> str:
        return pulumi.get(self, "opa_instance_id")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> str:
        """
        Shape of the instance.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the OpaInstance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when OpaInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the OpaInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOpaInstanceResult(GetOpaInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpaInstanceResult(
            attachments=self.attachments,
            compartment_id=self.compartment_id,
            consumption_model=self.consumption_model,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            idcs_at=self.idcs_at,
            identity_app_display_name=self.identity_app_display_name,
            identity_app_guid=self.identity_app_guid,
            identity_app_opc_service_instance_guid=self.identity_app_opc_service_instance_guid,
            identity_domain_url=self.identity_domain_url,
            instance_url=self.instance_url,
            is_breakglass_enabled=self.is_breakglass_enabled,
            metering_type=self.metering_type,
            opa_instance_id=self.opa_instance_id,
            shape_name=self.shape_name,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_opa_instance(opa_instance_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpaInstanceResult:
    """
    This data source provides details about a specific Opa Instance resource in Oracle Cloud Infrastructure Opa service.

    Gets a OpaInstance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opa_instance = oci.Opa.get_opa_instance(opa_instance_id=test_opa_instance_oci_opa_opa_instance["id"])
    ```


    :param str opa_instance_id: unique OpaInstance identifier
    """
    __args__ = dict()
    __args__['opaInstanceId'] = opa_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opa/getOpaInstance:getOpaInstance', __args__, opts=opts, typ=GetOpaInstanceResult).value

    return AwaitableGetOpaInstanceResult(
        attachments=pulumi.get(__ret__, 'attachments'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        consumption_model=pulumi.get(__ret__, 'consumption_model'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        idcs_at=pulumi.get(__ret__, 'idcs_at'),
        identity_app_display_name=pulumi.get(__ret__, 'identity_app_display_name'),
        identity_app_guid=pulumi.get(__ret__, 'identity_app_guid'),
        identity_app_opc_service_instance_guid=pulumi.get(__ret__, 'identity_app_opc_service_instance_guid'),
        identity_domain_url=pulumi.get(__ret__, 'identity_domain_url'),
        instance_url=pulumi.get(__ret__, 'instance_url'),
        is_breakglass_enabled=pulumi.get(__ret__, 'is_breakglass_enabled'),
        metering_type=pulumi.get(__ret__, 'metering_type'),
        opa_instance_id=pulumi.get(__ret__, 'opa_instance_id'),
        shape_name=pulumi.get(__ret__, 'shape_name'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_opa_instance_output(opa_instance_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpaInstanceResult]:
    """
    This data source provides details about a specific Opa Instance resource in Oracle Cloud Infrastructure Opa service.

    Gets a OpaInstance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opa_instance = oci.Opa.get_opa_instance(opa_instance_id=test_opa_instance_oci_opa_opa_instance["id"])
    ```


    :param str opa_instance_id: unique OpaInstance identifier
    """
    __args__ = dict()
    __args__['opaInstanceId'] = opa_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opa/getOpaInstance:getOpaInstance', __args__, opts=opts, typ=GetOpaInstanceResult)
    return __ret__.apply(lambda __response__: GetOpaInstanceResult(
        attachments=pulumi.get(__response__, 'attachments'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        consumption_model=pulumi.get(__response__, 'consumption_model'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        idcs_at=pulumi.get(__response__, 'idcs_at'),
        identity_app_display_name=pulumi.get(__response__, 'identity_app_display_name'),
        identity_app_guid=pulumi.get(__response__, 'identity_app_guid'),
        identity_app_opc_service_instance_guid=pulumi.get(__response__, 'identity_app_opc_service_instance_guid'),
        identity_domain_url=pulumi.get(__response__, 'identity_domain_url'),
        instance_url=pulumi.get(__response__, 'instance_url'),
        is_breakglass_enabled=pulumi.get(__response__, 'is_breakglass_enabled'),
        metering_type=pulumi.get(__response__, 'metering_type'),
        opa_instance_id=pulumi.get(__response__, 'opa_instance_id'),
        shape_name=pulumi.get(__response__, 'shape_name'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
