# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedInstanceGroupResult',
    'AwaitableGetManagedInstanceGroupResult',
    'get_managed_instance_group',
    'get_managed_instance_group_output',
]

@pulumi.output_type
class GetManagedInstanceGroupResult:
    """
    A collection of values returned by getManagedInstanceGroup.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, managed_instance_count=None, managed_instance_group_id=None, managed_instance_ids=None, managed_instances=None, os_family=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_count and not isinstance(managed_instance_count, int):
            raise TypeError("Expected argument 'managed_instance_count' to be a int")
        pulumi.set(__self__, "managed_instance_count", managed_instance_count)
        if managed_instance_group_id and not isinstance(managed_instance_group_id, str):
            raise TypeError("Expected argument 'managed_instance_group_id' to be a str")
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if managed_instance_ids and not isinstance(managed_instance_ids, list):
            raise TypeError("Expected argument 'managed_instance_ids' to be a list")
        pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if managed_instances and not isinstance(managed_instances, list):
            raise TypeError("Expected argument 'managed_instances' to be a list")
        pulumi.set(__self__, "managed_instances", managed_instances)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Information specified by the user about the managed instance group
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User friendly name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceCount")
    def managed_instance_count(self) -> int:
        return pulumi.get(self, "managed_instance_count")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> str:
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Sequence[str]:
        return pulumi.get(self, "managed_instance_ids")

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> Sequence['outputs.GetManagedInstanceGroupManagedInstanceResult']:
        """
        list of Managed Instances in the group
        """
        return pulumi.get(self, "managed_instances")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> str:
        """
        The Operating System type of the managed instance.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Software Source.
        """
        return pulumi.get(self, "state")


class AwaitableGetManagedInstanceGroupResult(GetManagedInstanceGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceGroupResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            managed_instance_count=self.managed_instance_count,
            managed_instance_group_id=self.managed_instance_group_id,
            managed_instance_ids=self.managed_instance_ids,
            managed_instances=self.managed_instances,
            os_family=self.os_family,
            state=self.state)


def get_managed_instance_group(managed_instance_group_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceGroupResult:
    """
    This data source provides details about a specific Managed Instance Group resource in Oracle Cloud Infrastructure OS Management service.

    Returns a specific Managed Instance Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_group = oci.OsManagement.get_managed_instance_group(managed_instance_group_id=test_managed_instance_group_oci_osmanagement_managed_instance_group["id"])
    ```


    :param str managed_instance_group_id: OCID for the managed instance group
    """
    __args__ = dict()
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagement/getManagedInstanceGroup:getManagedInstanceGroup', __args__, opts=opts, typ=GetManagedInstanceGroupResult).value

    return AwaitableGetManagedInstanceGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_count=pulumi.get(__ret__, 'managed_instance_count'),
        managed_instance_group_id=pulumi.get(__ret__, 'managed_instance_group_id'),
        managed_instance_ids=pulumi.get(__ret__, 'managed_instance_ids'),
        managed_instances=pulumi.get(__ret__, 'managed_instances'),
        os_family=pulumi.get(__ret__, 'os_family'),
        state=pulumi.get(__ret__, 'state'))
def get_managed_instance_group_output(managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedInstanceGroupResult]:
    """
    This data source provides details about a specific Managed Instance Group resource in Oracle Cloud Infrastructure OS Management service.

    Returns a specific Managed Instance Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_group = oci.OsManagement.get_managed_instance_group(managed_instance_group_id=test_managed_instance_group_oci_osmanagement_managed_instance_group["id"])
    ```


    :param str managed_instance_group_id: OCID for the managed instance group
    """
    __args__ = dict()
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagement/getManagedInstanceGroup:getManagedInstanceGroup', __args__, opts=opts, typ=GetManagedInstanceGroupResult)
    return __ret__.apply(lambda __response__: GetManagedInstanceGroupResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_count=pulumi.get(__response__, 'managed_instance_count'),
        managed_instance_group_id=pulumi.get(__response__, 'managed_instance_group_id'),
        managed_instance_ids=pulumi.get(__response__, 'managed_instance_ids'),
        managed_instances=pulumi.get(__response__, 'managed_instances'),
        os_family=pulumi.get(__response__, 'os_family'),
        state=pulumi.get(__response__, 'state')))
