# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityAttributeArgs', 'SecurityAttribute']

@pulumi.input_type
class SecurityAttributeArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 security_attribute_namespace_id: pulumi.Input[str],
                 is_retired: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input['SecurityAttributeValidatorArgs']] = None):
        """
        The set of arguments for constructing a SecurityAttribute resource.
        :param pulumi.Input[str] description: (Updatable) The description you assign to the security attribute during creation.
        :param pulumi.Input[str] security_attribute_namespace_id: The OCID of the security attribute namespace.
        :param pulumi.Input[bool] is_retired: Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        :param pulumi.Input[str] name: The name you assign to the security attribute during creation. This is the security attribute key. The name must be unique within the namespace and cannot be changed.
        :param pulumi.Input['SecurityAttributeValidatorArgs'] validator: (Updatable) Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).
               
               If you define a validator after a value has been set for a security attribute, then any updates that attempt to change the value must pass the additional validation defined by the current rule. Previously set values (even those that would fail the current validation) are not updated. You can still update other attributes to resources that contain a non-valid security attribute.
               
               To clear the validator call UpdateSecurityAttribute with [DefaultSecuirtyAttributeValidator](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/datatypes/DefaultTagDefinitionValidator).
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "security_attribute_namespace_id", security_attribute_namespace_id)
        if is_retired is not None:
            pulumi.set(__self__, "is_retired", is_retired)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if validator is not None:
            pulumi.set(__self__, "validator", validator)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        (Updatable) The description you assign to the security attribute during creation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="securityAttributeNamespaceId")
    def security_attribute_namespace_id(self) -> pulumi.Input[str]:
        """
        The OCID of the security attribute namespace.
        """
        return pulumi.get(self, "security_attribute_namespace_id")

    @security_attribute_namespace_id.setter
    def security_attribute_namespace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_attribute_namespace_id", value)

    @property
    @pulumi.getter(name="isRetired")
    def is_retired(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        """
        return pulumi.get(self, "is_retired")

    @is_retired.setter
    def is_retired(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_retired", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you assign to the security attribute during creation. This is the security attribute key. The name must be unique within the namespace and cannot be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def validator(self) -> Optional[pulumi.Input['SecurityAttributeValidatorArgs']]:
        """
        (Updatable) Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).

        If you define a validator after a value has been set for a security attribute, then any updates that attempt to change the value must pass the additional validation defined by the current rule. Previously set values (even those that would fail the current validation) are not updated. You can still update other attributes to resources that contain a non-valid security attribute.

        To clear the validator call UpdateSecurityAttribute with [DefaultSecuirtyAttributeValidator](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/datatypes/DefaultTagDefinitionValidator).
        """
        return pulumi.get(self, "validator")

    @validator.setter
    def validator(self, value: Optional[pulumi.Input['SecurityAttributeValidatorArgs']]):
        pulumi.set(self, "validator", value)


@pulumi.input_type
class _SecurityAttributeState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_retired: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_attribute_namespace_id: Optional[pulumi.Input[str]] = None,
                 security_attribute_namespace_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input['SecurityAttributeValidatorArgs']] = None):
        """
        Input properties used for looking up and filtering SecurityAttribute resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the security attribute definition.
        :param pulumi.Input[str] description: (Updatable) The description you assign to the security attribute during creation.
        :param pulumi.Input[bool] is_retired: Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        :param pulumi.Input[str] name: The name you assign to the security attribute during creation. This is the security attribute key. The name must be unique within the namespace and cannot be changed.
        :param pulumi.Input[str] security_attribute_namespace_id: The OCID of the security attribute namespace.
        :param pulumi.Input[str] security_attribute_namespace_name: The name of the security attribute namespace that contains the security attribute.
        :param pulumi.Input[str] state: The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted security attribute's `lifecycleState` changes from DELETING to DELETED.
        :param pulumi.Input[str] time_created: Date and time the security attribute was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] type: The data type of the security attribute.
        :param pulumi.Input['SecurityAttributeValidatorArgs'] validator: (Updatable) Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).
               
               If you define a validator after a value has been set for a security attribute, then any updates that attempt to change the value must pass the additional validation defined by the current rule. Previously set values (even those that would fail the current validation) are not updated. You can still update other attributes to resources that contain a non-valid security attribute.
               
               To clear the validator call UpdateSecurityAttribute with [DefaultSecuirtyAttributeValidator](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/datatypes/DefaultTagDefinitionValidator).
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_retired is not None:
            pulumi.set(__self__, "is_retired", is_retired)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_attribute_namespace_id is not None:
            pulumi.set(__self__, "security_attribute_namespace_id", security_attribute_namespace_id)
        if security_attribute_namespace_name is not None:
            pulumi.set(__self__, "security_attribute_namespace_name", security_attribute_namespace_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validator is not None:
            pulumi.set(__self__, "validator", validator)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that contains the security attribute definition.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description you assign to the security attribute during creation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isRetired")
    def is_retired(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        """
        return pulumi.get(self, "is_retired")

    @is_retired.setter
    def is_retired(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_retired", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you assign to the security attribute during creation. This is the security attribute key. The name must be unique within the namespace and cannot be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityAttributeNamespaceId")
    def security_attribute_namespace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the security attribute namespace.
        """
        return pulumi.get(self, "security_attribute_namespace_id")

    @security_attribute_namespace_id.setter
    def security_attribute_namespace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_attribute_namespace_id", value)

    @property
    @pulumi.getter(name="securityAttributeNamespaceName")
    def security_attribute_namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security attribute namespace that contains the security attribute.
        """
        return pulumi.get(self, "security_attribute_namespace_name")

    @security_attribute_namespace_name.setter
    def security_attribute_namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_attribute_namespace_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted security attribute's `lifecycleState` changes from DELETING to DELETED.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the security attribute was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type of the security attribute.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def validator(self) -> Optional[pulumi.Input['SecurityAttributeValidatorArgs']]:
        """
        (Updatable) Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).

        If you define a validator after a value has been set for a security attribute, then any updates that attempt to change the value must pass the additional validation defined by the current rule. Previously set values (even those that would fail the current validation) are not updated. You can still update other attributes to resources that contain a non-valid security attribute.

        To clear the validator call UpdateSecurityAttribute with [DefaultSecuirtyAttributeValidator](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/datatypes/DefaultTagDefinitionValidator).
        """
        return pulumi.get(self, "validator")

    @validator.setter
    def validator(self, value: Optional[pulumi.Input['SecurityAttributeValidatorArgs']]):
        pulumi.set(self, "validator", value)


class SecurityAttribute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_retired: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_attribute_namespace_id: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input[Union['SecurityAttributeValidatorArgs', 'SecurityAttributeValidatorArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Security Attribute resource in Oracle Cloud Infrastructure Security Attribute service.

        Creates a new security attribute in the specified security attribute namespace.

        The security attribute requires either the OCID or the name of the security attribute namespace that will contain this
        security attribute.

        You must specify a *name* for the attribute, which must be unique across all attributes in the security attribute namespace
        and cannot be changed. The only valid characters for security attribute names are: 0-9, A-Z, a-z, -, _ characters.
        Names are case insensitive. That means, for example, "mySecurityAttribute" and "mysecurityattribute" are not allowed in the same namespace.
        If you specify a name that's already in use in the security attribute namespace, a 409 error is returned.

        The security attribute must have a *description*. It does not have to be unique, and you can change it with
        [UpdateSecurityAttribute](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/Tag/UpdateSecurityAttribute).

        When a validator is specified, The security attribute must have a value type. Security attribute can use either a static value or a list of possible values. Static values are entered by a user when applying the security attribute to a resource. Lists are created by the user and the user must apply a value from the list. Lists are validated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_attribute = oci.security_attribute.SecurityAttribute("test_security_attribute",
            description=security_attribute_description,
            name=security_attribute_name,
            security_attribute_namespace_id=test_security_attribute_namespace["id"],
            validator={
                "validator_type": security_attribute_validator_validator_type,
                "values": security_attribute_validator_values,
            })
        ```

        ## Import

        SecurityAttributes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:SecurityAttribute/securityAttribute:SecurityAttribute test_security_attribute "securityAttributeNamespaces/{securityAttributeNamespaceId}/securityAttributes/{securityAttributeName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: (Updatable) The description you assign to the security attribute during creation.
        :param pulumi.Input[bool] is_retired: Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        :param pulumi.Input[str] name: The name you assign to the security attribute during creation. This is the security attribute key. The name must be unique within the namespace and cannot be changed.
        :param pulumi.Input[str] security_attribute_namespace_id: The OCID of the security attribute namespace.
        :param pulumi.Input[Union['SecurityAttributeValidatorArgs', 'SecurityAttributeValidatorArgsDict']] validator: (Updatable) Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).
               
               If you define a validator after a value has been set for a security attribute, then any updates that attempt to change the value must pass the additional validation defined by the current rule. Previously set values (even those that would fail the current validation) are not updated. You can still update other attributes to resources that contain a non-valid security attribute.
               
               To clear the validator call UpdateSecurityAttribute with [DefaultSecuirtyAttributeValidator](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/datatypes/DefaultTagDefinitionValidator).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityAttributeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Security Attribute resource in Oracle Cloud Infrastructure Security Attribute service.

        Creates a new security attribute in the specified security attribute namespace.

        The security attribute requires either the OCID or the name of the security attribute namespace that will contain this
        security attribute.

        You must specify a *name* for the attribute, which must be unique across all attributes in the security attribute namespace
        and cannot be changed. The only valid characters for security attribute names are: 0-9, A-Z, a-z, -, _ characters.
        Names are case insensitive. That means, for example, "mySecurityAttribute" and "mysecurityattribute" are not allowed in the same namespace.
        If you specify a name that's already in use in the security attribute namespace, a 409 error is returned.

        The security attribute must have a *description*. It does not have to be unique, and you can change it with
        [UpdateSecurityAttribute](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/Tag/UpdateSecurityAttribute).

        When a validator is specified, The security attribute must have a value type. Security attribute can use either a static value or a list of possible values. Static values are entered by a user when applying the security attribute to a resource. Lists are created by the user and the user must apply a value from the list. Lists are validated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_security_attribute = oci.security_attribute.SecurityAttribute("test_security_attribute",
            description=security_attribute_description,
            name=security_attribute_name,
            security_attribute_namespace_id=test_security_attribute_namespace["id"],
            validator={
                "validator_type": security_attribute_validator_validator_type,
                "values": security_attribute_validator_values,
            })
        ```

        ## Import

        SecurityAttributes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:SecurityAttribute/securityAttribute:SecurityAttribute test_security_attribute "securityAttributeNamespaces/{securityAttributeNamespaceId}/securityAttributes/{securityAttributeName}"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityAttributeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityAttributeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_retired: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_attribute_namespace_id: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input[Union['SecurityAttributeValidatorArgs', 'SecurityAttributeValidatorArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityAttributeArgs.__new__(SecurityAttributeArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["is_retired"] = is_retired
            __props__.__dict__["name"] = name
            if security_attribute_namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_attribute_namespace_id'")
            __props__.__dict__["security_attribute_namespace_id"] = security_attribute_namespace_id
            __props__.__dict__["validator"] = validator
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["security_attribute_namespace_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["type"] = None
        super(SecurityAttribute, __self__).__init__(
            'oci:SecurityAttribute/securityAttribute:SecurityAttribute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            is_retired: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            security_attribute_namespace_id: Optional[pulumi.Input[str]] = None,
            security_attribute_namespace_name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            validator: Optional[pulumi.Input[Union['SecurityAttributeValidatorArgs', 'SecurityAttributeValidatorArgsDict']]] = None) -> 'SecurityAttribute':
        """
        Get an existing SecurityAttribute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the security attribute definition.
        :param pulumi.Input[str] description: (Updatable) The description you assign to the security attribute during creation.
        :param pulumi.Input[bool] is_retired: Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        :param pulumi.Input[str] name: The name you assign to the security attribute during creation. This is the security attribute key. The name must be unique within the namespace and cannot be changed.
        :param pulumi.Input[str] security_attribute_namespace_id: The OCID of the security attribute namespace.
        :param pulumi.Input[str] security_attribute_namespace_name: The name of the security attribute namespace that contains the security attribute.
        :param pulumi.Input[str] state: The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted security attribute's `lifecycleState` changes from DELETING to DELETED.
        :param pulumi.Input[str] time_created: Date and time the security attribute was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] type: The data type of the security attribute.
        :param pulumi.Input[Union['SecurityAttributeValidatorArgs', 'SecurityAttributeValidatorArgsDict']] validator: (Updatable) Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).
               
               If you define a validator after a value has been set for a security attribute, then any updates that attempt to change the value must pass the additional validation defined by the current rule. Previously set values (even those that would fail the current validation) are not updated. You can still update other attributes to resources that contain a non-valid security attribute.
               
               To clear the validator call UpdateSecurityAttribute with [DefaultSecuirtyAttributeValidator](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/datatypes/DefaultTagDefinitionValidator).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityAttributeState.__new__(_SecurityAttributeState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["is_retired"] = is_retired
        __props__.__dict__["name"] = name
        __props__.__dict__["security_attribute_namespace_id"] = security_attribute_namespace_id
        __props__.__dict__["security_attribute_namespace_name"] = security_attribute_namespace_name
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["type"] = type
        __props__.__dict__["validator"] = validator
        return SecurityAttribute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment that contains the security attribute definition.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description you assign to the security attribute during creation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isRetired")
    def is_retired(self) -> pulumi.Output[bool]:
        """
        Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        """
        return pulumi.get(self, "is_retired")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name you assign to the security attribute during creation. This is the security attribute key. The name must be unique within the namespace and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityAttributeNamespaceId")
    def security_attribute_namespace_id(self) -> pulumi.Output[str]:
        """
        The OCID of the security attribute namespace.
        """
        return pulumi.get(self, "security_attribute_namespace_id")

    @property
    @pulumi.getter(name="securityAttributeNamespaceName")
    def security_attribute_namespace_name(self) -> pulumi.Output[str]:
        """
        The name of the security attribute namespace that contains the security attribute.
        """
        return pulumi.get(self, "security_attribute_namespace_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted security attribute's `lifecycleState` changes from DELETING to DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date and time the security attribute was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The data type of the security attribute.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def validator(self) -> pulumi.Output[Optional['outputs.SecurityAttributeValidator']]:
        """
        (Updatable) Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).

        If you define a validator after a value has been set for a security attribute, then any updates that attempt to change the value must pass the additional validation defined by the current rule. Previously set values (even those that would fail the current validation) are not updated. You can still update other attributes to resources that contain a non-valid security attribute.

        To clear the validator call UpdateSecurityAttribute with [DefaultSecuirtyAttributeValidator](https://docs.cloud.oracle.com/iaas/api/#/en/securityattribute/latest/datatypes/DefaultTagDefinitionValidator).
        """
        return pulumi.get(self, "validator")

