# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiscoveryJobResult',
    'AwaitableGetDiscoveryJobResult',
    'get_discovery_job',
    'get_discovery_job_output',
]

@pulumi.output_type
class GetDiscoveryJobResult:
    """
    A collection of values returned by getDiscoveryJob.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, discovery_client=None, discovery_details=None, discovery_job_id=None, discovery_type=None, freeform_tags=None, id=None, should_propagate_tags_to_discovered_resources=None, state=None, status=None, status_message=None, system_tags=None, tenant_id=None, time_updated=None, user_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_client and not isinstance(discovery_client, str):
            raise TypeError("Expected argument 'discovery_client' to be a str")
        pulumi.set(__self__, "discovery_client", discovery_client)
        if discovery_details and not isinstance(discovery_details, list):
            raise TypeError("Expected argument 'discovery_details' to be a list")
        pulumi.set(__self__, "discovery_details", discovery_details)
        if discovery_job_id and not isinstance(discovery_job_id, str):
            raise TypeError("Expected argument 'discovery_job_id' to be a str")
        pulumi.set(__self__, "discovery_job_id", discovery_job_id)
        if discovery_type and not isinstance(discovery_type, str):
            raise TypeError("Expected argument 'discovery_type' to be a str")
        pulumi.set(__self__, "discovery_type", discovery_type)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if should_propagate_tags_to_discovered_resources and not isinstance(should_propagate_tags_to_discovered_resources, bool):
            raise TypeError("Expected argument 'should_propagate_tags_to_discovered_resources' to be a bool")
        pulumi.set(__self__, "should_propagate_tags_to_discovered_resources", should_propagate_tags_to_discovered_resources)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_message and not isinstance(status_message, str):
            raise TypeError("Expected argument 'status_message' to be a str")
        pulumi.set(__self__, "status_message", status_message)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryClient")
    def discovery_client(self) -> str:
        """
        Client who submits discovery job.
        """
        return pulumi.get(self, "discovery_client")

    @property
    @pulumi.getter(name="discoveryDetails")
    def discovery_details(self) -> Sequence['outputs.GetDiscoveryJobDiscoveryDetailResult']:
        """
        The request of DiscoveryJob Resource details.
        """
        return pulumi.get(self, "discovery_details")

    @property
    @pulumi.getter(name="discoveryJobId")
    def discovery_job_id(self) -> str:
        return pulumi.get(self, "discovery_job_id")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> str:
        """
        Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of Discovery job
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="shouldPropagateTagsToDiscoveredResources")
    def should_propagate_tags_to_discovered_resources(self) -> bool:
        return pulumi.get(self, "should_propagate_tags_to_discovered_resources")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the DiscoveryJob Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies the status of the discovery job
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        The short summary of the status of the discovery job
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The OCID of Tenant
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the discovery Job was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The OCID of user in which the job is submitted
        """
        return pulumi.get(self, "user_id")


class AwaitableGetDiscoveryJobResult(GetDiscoveryJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveryJobResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            discovery_client=self.discovery_client,
            discovery_details=self.discovery_details,
            discovery_job_id=self.discovery_job_id,
            discovery_type=self.discovery_type,
            freeform_tags=self.freeform_tags,
            id=self.id,
            should_propagate_tags_to_discovered_resources=self.should_propagate_tags_to_discovered_resources,
            state=self.state,
            status=self.status,
            status_message=self.status_message,
            system_tags=self.system_tags,
            tenant_id=self.tenant_id,
            time_updated=self.time_updated,
            user_id=self.user_id)


def get_discovery_job(discovery_job_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveryJobResult:
    """
    This data source provides details about a specific Discovery Job resource in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get the details of discovery Job by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_job = oci.StackMonitoring.get_discovery_job(discovery_job_id=test_discovery_job_oci_stack_monitoring_discovery_job["id"])
    ```


    :param str discovery_job_id: The Discovery Job ID
    """
    __args__ = dict()
    __args__['discoveryJobId'] = discovery_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getDiscoveryJob:getDiscoveryJob', __args__, opts=opts, typ=GetDiscoveryJobResult).value

    return AwaitableGetDiscoveryJobResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        discovery_client=pulumi.get(__ret__, 'discovery_client'),
        discovery_details=pulumi.get(__ret__, 'discovery_details'),
        discovery_job_id=pulumi.get(__ret__, 'discovery_job_id'),
        discovery_type=pulumi.get(__ret__, 'discovery_type'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        should_propagate_tags_to_discovered_resources=pulumi.get(__ret__, 'should_propagate_tags_to_discovered_resources'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        status_message=pulumi.get(__ret__, 'status_message'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_discovery_job_output(discovery_job_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiscoveryJobResult]:
    """
    This data source provides details about a specific Discovery Job resource in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get the details of discovery Job by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_job = oci.StackMonitoring.get_discovery_job(discovery_job_id=test_discovery_job_oci_stack_monitoring_discovery_job["id"])
    ```


    :param str discovery_job_id: The Discovery Job ID
    """
    __args__ = dict()
    __args__['discoveryJobId'] = discovery_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getDiscoveryJob:getDiscoveryJob', __args__, opts=opts, typ=GetDiscoveryJobResult)
    return __ret__.apply(lambda __response__: GetDiscoveryJobResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        discovery_client=pulumi.get(__response__, 'discovery_client'),
        discovery_details=pulumi.get(__response__, 'discovery_details'),
        discovery_job_id=pulumi.get(__response__, 'discovery_job_id'),
        discovery_type=pulumi.get(__response__, 'discovery_type'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        should_propagate_tags_to_discovered_resources=pulumi.get(__response__, 'should_propagate_tags_to_discovered_resources'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        status_message=pulumi.get(__response__, 'status_message'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        user_id=pulumi.get(__response__, 'user_id')))
