"""Command implementations for Cascade."""

# TODO: The auto registration should avoid so much duplication here,
# but the tests aren't working with that properly. It also really
# confuses Claude, so either I need to stop 'Clauding' or find some
# way around that. For now, live with the duplication.

# TODO: Also! Now that I've moved all the commands into separate modules,
# this should be easier still. But I do need to figure out what the
# exported names should be for each of the groups.

from . import (  # noqa: F401
    advanced_utils,
    builtin,
    compression,
    data_processing,
    exec_commands,
    file_utils,
    filesystem_read,
    filesystem_write,
    math_utils,
    monitoring,
    network,
    other_utils,
    pebble_cli,
    script,
    system,
    system_info,
    text_utils,
    theme,
    user_management,
)
from ._base import Command
from .advanced_utils import (
    BracketTestCommand,
    DoubleBracketTestCommand,
    HostidCommand,
    LessCommand,
    LoggerCommand,
    MoreCommand,
    PatchCommand,
    PidofCommand,
    PstraceCommand,
    TeeCommand,
    TestCommand,
    XargsCommand,
    YesCommand,
)
from .builtin import (
    AliasCommand,
    BeepCommand,
    BzcatCommand,
    CalCommand,
    CdCommand,
    CutCommand,
    DateCommand,
    EchoCommand,
    EditCommand,
    EnvCommand,
    FalseCommand,
    GrepCommand,
    HdCommand,
    HexdumpCommand,
    HistoryCommand,
    IdCommand,
    InfoCommand,
    JqCommand,
    LsofCommand,
    MarkdownCommand,
    Md5sumCommand,
    MkpasswdCommand,
    PebblesayCommand,
    PrintenvCommand,
    PrintfCommand,
    PwdCommand,
    Sha1sumCommand,
    Sha256sumCommand,
    Sha512sumCommand,
    SleepCommand,
    SortCommand,
    TacCommand,
    TimeCommand,
    TimeoutCommand,
    TrueCommand,
    UlimitCommand,
    UniqCommand,
    UsleepCommand,
    WatchCommand,
    WcCommand,
    WhoamiCommand,
    YqCommand,
    ZcatCommand,
)
from .other_utils import (
    CpioCommand,
    IpcsCommand,
    NmeterCommand,
    PipeProgressCommand,
    ArCommand,
    BasenameCommand,
    CatvCommand,
    ClearCommand,
    CryptpwCommand,
    EgrepCommand,
    FgrepCommand,
    GetoptCommand,
    LzmacatCommand,
    ReformineCommand,
    ResetCommand,
    SedCommand,
    StringsCommand,
    UnlzopCommand,
)
from .compression import (
    BunzipCommand,
    BzipCommand,
    CompressCommand,
    GunzipCommand,
    GzipCommand,
    LzmaCommand,
    TarCommand,
    UncompressCommand,
    UnlzmaCommand,
    UnzipCommand,
)
from .data_processing import DdCommand, OdCommand, SplitCommand
from .exec_commands import (
    EnvdirCommand,
    ExecCommand,
    LocalCommand,
    RunCommand,
    RunPartsCommand,
    ShellCommand,
    WhichCommand,
)
from .file_utils import (
    BlkidCommand,
    CksumCommand,
    CmpCommand,
    CommCommand,
    DirnameCommand,
    FindfsCommand,
    LsattrCommand,
    MktempCommand,
    MountpointCommand,
    ReadlinkCommand,
    RealpathCommand,
    SumCommand,
    VolnameCommand,
)
from .filesystem_read import (
    CatCommand,
    DiffCommand,
    FindCommand,
    HeadCommand,
    ListCommand,
    StatCommand,
    TailCommand,
)
from .filesystem_write import (
    CopyCommand,
    MakeDirCommand,
    MoveCommand,
    RemoveCommand,
    RemoveDirCommand,
    TouchCommand,
)
from .math_utils import DcCommand, ExprCommand, IpcalcCommand
from .monitoring import TopCommand
from .network import (
    ArpCommand,
    DnsdomainnameCommand,
    IfconfigCommand,
    IpaddrCommand,
    IpCommand,
    IplinkCommand,
    IprouteCommand,
    IpruleCommand,
    NetstatCommand,
    NetworkCommand,
    RouteCommand,
    SocketStatsCommand,
)
from .pebble_cli import (
    AddCommand,
    ChangesCommand,
    CheckCommand,
    ChecksCommand,
    HealthCommand,
    LogsCommand,
    NoticeCommand,
    NoticesCommand,
    NotifyCommand,
    PebbleCommand,
    PlanCommand,
    PullCommand,
    PushCommand,
    ReplanCommand,
    RestartCommand,
    ServicesCommand,
    SignalCommand,
    StartChecksCommand,
    StartCommand,
    StopChecksCommand,
    StopCommand,
    TasksCommand,
)
from .script import ScriptCommand, ScriptreplayCommand
from .system import (
    CpuinfoCommand,
    DashboardCommand,
    DiskUsageCommand,
    DmesgCommand,
    DuCommand,
    FdinfoCommand,
    FreeCommand,
    FuserCommand,
    IostatCommand,
    LastCommand,
    LoadavgCommand,
    MeminfoCommand,
    MountCommand,
    PgrepCommand,
    ProcessCommand,
    PstreeCommand,
    SyslogCommand,
    UptimeCommand,
    VmstatCommand,
    WCommand,
    WhoCommand,
)
from .system_info import (
    DumpkmapCommand,
    DumpleasesCommand,
    HostnameCommand,
    LognameCommand,
    LsmodCommand,
    ReadprofileCommand,
    RunlevelCommand,
    SysctlCommand,
    TtyCommand,
    TtysizeCommand,
    UnameCommand,
)
from .text_utils import (
    Dos2unixCommand,
    ExpandCommand,
    FoldCommand,
    SeqCommand,
    TrCommand,
    UnexpandCommand,
    Unix2dosCommand,
)
from .theme import ThemeCommand
from .user_management import (
    AddgroupCommand,
    AdduserCommand,
    DelgroupCommand,
    DeluserCommand,
)

__all__ = [
    "AddCommand",
    "AddgroupCommand",
    "AdduserCommand",
    "AliasCommand",
    "ArCommand",
    "ArpCommand",
    "BasenameCommand",
    "BeepCommand",
    "BlkidCommand",
    "BracketTestCommand",
    "BunzipCommand",
    "BzcatCommand",
    "BzipCommand",
    "CalCommand",
    "CatCommand",
    "CatvCommand",
    "CdCommand",
    "ChangesCommand",
    "CheckCommand",
    "ChecksCommand",
    "CksumCommand",
    "ClearCommand",
    "CmpCommand",
    "CommCommand",
    "Command",
    "CompressCommand",
    "CopyCommand",
    "CpioCommand",
    "CpuinfoCommand",
    "CryptpwCommand",
    "CutCommand",
    "DashboardCommand",
    "DateCommand",
    "DcCommand",
    "DdCommand",
    "DelgroupCommand",
    "DeluserCommand",
    "DiffCommand",
    "DirnameCommand",
    "DiskUsageCommand",
    "DmesgCommand",
    "DnsdomainnameCommand",
    "DuCommand",
    "Dos2unixCommand",
    "DoubleBracketTestCommand",
    "DumpkmapCommand",
    "DumpleasesCommand",
    "EchoCommand",
    "EditCommand",
    "EgrepCommand",
    "EnvCommand",
    "EnvdirCommand",
    "ExecCommand",
    "ExpandCommand",
    "ExprCommand",
    "FalseCommand",
    "FdinfoCommand",
    "FgrepCommand",
    "FindCommand",
    "FindfsCommand",
    "FoldCommand",
    "FreeCommand",
    "FuserCommand",
    "GetoptCommand",
    "GrepCommand",
    "GunzipCommand",
    "GzipCommand",
    "HdCommand",
    "HeadCommand",
    "HealthCommand",
    "HexdumpCommand",
    "HistoryCommand",
    "HostidCommand",
    "HostnameCommand",
    "IdCommand",
    "IfconfigCommand",
    "InfoCommand",
    "IostatCommand",
    "IpCommand",
    "IpaddrCommand",
    "IpcalcCommand",
    "IpcsCommand",
    "IplinkCommand",
    "IprouteCommand",
    "IpruleCommand",
    "JqCommand",
    "LastCommand",
    "LessCommand",
    "ListCommand",
    "LoadavgCommand",
    "LocalCommand",
    "LoggerCommand",
    "LognameCommand",
    "LogsCommand",
    "LsattrCommand",
    "LsmodCommand",
    "LsofCommand",
    "LzmaCommand",
    "LzmacatCommand",
    "MeminfoCommand",
    "LzopCommand",
    "LzopcatCommand",
    "MakeDirCommand",
    "MakemimeCommand",
    "MarkdownCommand",
    "Md5sumCommand",
    "MkpasswdCommand",
    "MktempCommand",
    "MoreCommand",
    "MountCommand",
    "MountpointCommand",
    "MoveCommand",
    "NetstatCommand",
    "NetworkCommand",
    "NmeterCommand",
    "NoticeCommand",
    "NoticesCommand",
    "NotifyCommand",
    "OdCommand",
    "PatchCommand",
    "PebbleCommand",
    "PebblesayCommand",
    "PgrepCommand",
    "PidofCommand",
    "PipeProgressCommand",
    "PlanCommand",
    "PrintenvCommand",
    "PrintfCommand",
    "ProcessCommand",
    "PstraceCommand",
    "PstreeCommand",
    "PullCommand",
    "PushCommand",
    "PwdCommand",
    "ReadlinkCommand",
    "ReadprofileCommand",
    "RealpathCommand",
    "ReformineCommand",
    "RemoveCommand",
    "RemoveDirCommand",
    "ReplanCommand",
    "ResetCommand",
    "RestartCommand",
    "RouteCommand",
    "RunCommand",
    "RunPartsCommand",
    "RunlevelCommand",
    "ScriptCommand",
    "ScriptreplayCommand",
    "SedCommand",
    "SeqCommand",
    "ServicesCommand",
    "Sha1sumCommand",
    "Sha256sumCommand",
    "Sha512sumCommand",
    "ShellCommand",
    "SignalCommand",
    "SleepCommand",
    "SocketStatsCommand",
    "SortCommand",
    "SplitCommand",
    "StartChecksCommand",
    "StartCommand",
    "StatCommand",
    "StopChecksCommand",
    "StopCommand",
    "StringsCommand",
    "SumCommand",
    "SysctlCommand",
    "SyslogCommand",
    "TacCommand",
    "TailCommand",
    "TarCommand",
    "TasksCommand",
    "TeeCommand",
    "TestCommand",
    "ThemeCommand",
    "TimeCommand",
    "TimeoutCommand",
    "TopCommand",
    "TouchCommand",
    "TrCommand",
    "TrueCommand",
    "TtyCommand",
    "TtysizeCommand",
    "UlimitCommand",
    "UnameCommand",
    "UncompressCommand",
    "UnexpandCommand",
    "UniqCommand",
    "Unix2dosCommand",
    "UnlzmaCommand",
    "UnlzopCommand",
    "UnzipCommand",
    "UptimeCommand",
    "UsleepCommand",
    "VmstatCommand",
    "VolnameCommand",
    "WatchCommand",
    "WCommand",
    "WcCommand",
    "WhichCommand",
    "WhoamiCommand",
    "WhoCommand",
    "XargsCommand",
    "YesCommand",
    "YqCommand",
    "ZcatCommand",
]
