# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApiKeyArgs', 'ApiKey']

@pulumi.input_type
class ApiKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 remote_config_read_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ApiKey resource.
        :param pulumi.Input[_builtins.str] name: Name for API Key.
        :param pulumi.Input[_builtins.bool] remote_config_read_enabled: Whether the API key is used for remote config. Set to true only if remote config is enabled in `/organization-settings/remote-config`.
        """
        pulumi.set(__self__, "name", name)
        if remote_config_read_enabled is not None:
            pulumi.set(__self__, "remote_config_read_enabled", remote_config_read_enabled)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name for API Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remoteConfigReadEnabled")
    def remote_config_read_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the API key is used for remote config. Set to true only if remote config is enabled in `/organization-settings/remote-config`.
        """
        return pulumi.get(self, "remote_config_read_enabled")

    @remote_config_read_enabled.setter
    def remote_config_read_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_config_read_enabled", value)


@pulumi.input_type
class _ApiKeyState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_config_read_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ApiKey resources.
        :param pulumi.Input[_builtins.str] key: The value of the API Key.
        :param pulumi.Input[_builtins.str] name: Name for API Key.
        :param pulumi.Input[_builtins.bool] remote_config_read_enabled: Whether the API key is used for remote config. Set to true only if remote config is enabled in `/organization-settings/remote-config`.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_config_read_enabled is not None:
            pulumi.set(__self__, "remote_config_read_enabled", remote_config_read_enabled)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the API Key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for API Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remoteConfigReadEnabled")
    def remote_config_read_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the API key is used for remote config. Set to true only if remote config is enabled in `/organization-settings/remote-config`.
        """
        return pulumi.get(self, "remote_config_read_enabled")

    @remote_config_read_enabled.setter
    def remote_config_read_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_config_read_enabled", value)


@pulumi.type_token("datadog:index/apiKey:ApiKey")
class ApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_config_read_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Datadog API Key resource. This can be used to create and manage Datadog API Keys. Import functionality for this resource is deprecated and will be removed in a future release with prior notice. Securely store your API keys using a secret management system or use this resource to create and manage new API keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog API Key
        foo = datadog.ApiKey("foo", name="foo-application")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/apiKey:ApiKey foo 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name for API Key.
        :param pulumi.Input[_builtins.bool] remote_config_read_enabled: Whether the API key is used for remote config. Set to true only if remote config is enabled in `/organization-settings/remote-config`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog API Key resource. This can be used to create and manage Datadog API Keys. Import functionality for this resource is deprecated and will be removed in a future release with prior notice. Securely store your API keys using a secret management system or use this resource to create and manage new API keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog API Key
        foo = datadog.ApiKey("foo", name="foo-application")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/apiKey:ApiKey foo 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param ApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_config_read_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["remote_config_read_enabled"] = remote_config_read_enabled
            __props__.__dict__["key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApiKey, __self__).__init__(
            'datadog:index/apiKey:ApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            remote_config_read_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ApiKey':
        """
        Get an existing ApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key: The value of the API Key.
        :param pulumi.Input[_builtins.str] name: Name for API Key.
        :param pulumi.Input[_builtins.bool] remote_config_read_enabled: Whether the API key is used for remote config. Set to true only if remote config is enabled in `/organization-settings/remote-config`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiKeyState.__new__(_ApiKeyState)

        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["remote_config_read_enabled"] = remote_config_read_enabled
        return ApiKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the API Key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for API Key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="remoteConfigReadEnabled")
    def remote_config_read_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the API key is used for remote config. Set to true only if remote config is enabled in `/organization-settings/remote-config`.
        """
        return pulumi.get(self, "remote_config_read_enabled")

