# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationAccountArgs', 'IntegrationAccount']

@pulumi.input_type
class IntegrationAccountArgs:
    def __init__(__self__, *,
                 aws_account_id: pulumi.Input[_builtins.str],
                 aws_partition: pulumi.Input[_builtins.str],
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auth_config: Optional[pulumi.Input['IntegrationAccountAuthConfigArgs']] = None,
                 aws_regions: Optional[pulumi.Input['IntegrationAccountAwsRegionsArgs']] = None,
                 logs_config: Optional[pulumi.Input['IntegrationAccountLogsConfigArgs']] = None,
                 metrics_config: Optional[pulumi.Input['IntegrationAccountMetricsConfigArgs']] = None,
                 resources_config: Optional[pulumi.Input['IntegrationAccountResourcesConfigArgs']] = None,
                 traces_config: Optional[pulumi.Input['IntegrationAccountTracesConfigArgs']] = None):
        """
        The set of arguments for constructing a IntegrationAccount resource.
        :param pulumi.Input[_builtins.str] aws_account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] aws_partition: AWS Account partition.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to apply to all metrics in the account. Defaults to `[]`.
        :param pulumi.Input['IntegrationAccountAuthConfigArgs'] auth_config: Configure how Datadog authenticates to your AWS account. Either `aws_auth_config_keys` or `aws_auth_config_role` block is required within.
        :param pulumi.Input['IntegrationAccountAwsRegionsArgs'] aws_regions: AWS regions to collect data from. Defaults to `include_all` if block is empty.
        :param pulumi.Input['IntegrationAccountLogsConfigArgs'] logs_config: Configure log autosubscription for your Datadog Forwarder Lambda functions. The `lambda_fowarder` block is required within, but may be empty to use defaults.
        :param pulumi.Input['IntegrationAccountMetricsConfigArgs'] metrics_config: Configure metrics collection from AWS CloudWatch. The `namespace_filters` block is required within, but may be empty to use defaults.
        :param pulumi.Input['IntegrationAccountResourcesConfigArgs'] resources_config: AWS resources collection config. May be empty to use defaults.
        :param pulumi.Input['IntegrationAccountTracesConfigArgs'] traces_config: AWS traces collection config. The `xray_services` block is required within, but may be empty to use defaults.
        """
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        pulumi.set(__self__, "aws_partition", aws_partition)
        if account_tags is not None:
            pulumi.set(__self__, "account_tags", account_tags)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if aws_regions is not None:
            pulumi.set(__self__, "aws_regions", aws_regions)
        if logs_config is not None:
            pulumi.set(__self__, "logs_config", logs_config)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if resources_config is not None:
            pulumi.set(__self__, "resources_config", resources_config)
        if traces_config is not None:
            pulumi.set(__self__, "traces_config", traces_config)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="awsPartition")
    def aws_partition(self) -> pulumi.Input[_builtins.str]:
        """
        AWS Account partition.
        """
        return pulumi.get(self, "aws_partition")

    @aws_partition.setter
    def aws_partition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aws_partition", value)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to all metrics in the account. Defaults to `[]`.
        """
        return pulumi.get(self, "account_tags")

    @account_tags.setter
    def account_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_tags", value)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['IntegrationAccountAuthConfigArgs']]:
        """
        Configure how Datadog authenticates to your AWS account. Either `aws_auth_config_keys` or `aws_auth_config_role` block is required within.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['IntegrationAccountAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter(name="awsRegions")
    def aws_regions(self) -> Optional[pulumi.Input['IntegrationAccountAwsRegionsArgs']]:
        """
        AWS regions to collect data from. Defaults to `include_all` if block is empty.
        """
        return pulumi.get(self, "aws_regions")

    @aws_regions.setter
    def aws_regions(self, value: Optional[pulumi.Input['IntegrationAccountAwsRegionsArgs']]):
        pulumi.set(self, "aws_regions", value)

    @_builtins.property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> Optional[pulumi.Input['IntegrationAccountLogsConfigArgs']]:
        """
        Configure log autosubscription for your Datadog Forwarder Lambda functions. The `lambda_fowarder` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "logs_config")

    @logs_config.setter
    def logs_config(self, value: Optional[pulumi.Input['IntegrationAccountLogsConfigArgs']]):
        pulumi.set(self, "logs_config", value)

    @_builtins.property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['IntegrationAccountMetricsConfigArgs']]:
        """
        Configure metrics collection from AWS CloudWatch. The `namespace_filters` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['IntegrationAccountMetricsConfigArgs']]):
        pulumi.set(self, "metrics_config", value)

    @_builtins.property
    @pulumi.getter(name="resourcesConfig")
    def resources_config(self) -> Optional[pulumi.Input['IntegrationAccountResourcesConfigArgs']]:
        """
        AWS resources collection config. May be empty to use defaults.
        """
        return pulumi.get(self, "resources_config")

    @resources_config.setter
    def resources_config(self, value: Optional[pulumi.Input['IntegrationAccountResourcesConfigArgs']]):
        pulumi.set(self, "resources_config", value)

    @_builtins.property
    @pulumi.getter(name="tracesConfig")
    def traces_config(self) -> Optional[pulumi.Input['IntegrationAccountTracesConfigArgs']]:
        """
        AWS traces collection config. The `xray_services` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "traces_config")

    @traces_config.setter
    def traces_config(self, value: Optional[pulumi.Input['IntegrationAccountTracesConfigArgs']]):
        pulumi.set(self, "traces_config", value)


@pulumi.input_type
class _IntegrationAccountState:
    def __init__(__self__, *,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auth_config: Optional[pulumi.Input['IntegrationAccountAuthConfigArgs']] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_partition: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_regions: Optional[pulumi.Input['IntegrationAccountAwsRegionsArgs']] = None,
                 logs_config: Optional[pulumi.Input['IntegrationAccountLogsConfigArgs']] = None,
                 metrics_config: Optional[pulumi.Input['IntegrationAccountMetricsConfigArgs']] = None,
                 resources_config: Optional[pulumi.Input['IntegrationAccountResourcesConfigArgs']] = None,
                 traces_config: Optional[pulumi.Input['IntegrationAccountTracesConfigArgs']] = None):
        """
        Input properties used for looking up and filtering IntegrationAccount resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to apply to all metrics in the account. Defaults to `[]`.
        :param pulumi.Input['IntegrationAccountAuthConfigArgs'] auth_config: Configure how Datadog authenticates to your AWS account. Either `aws_auth_config_keys` or `aws_auth_config_role` block is required within.
        :param pulumi.Input[_builtins.str] aws_account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] aws_partition: AWS Account partition.
        :param pulumi.Input['IntegrationAccountAwsRegionsArgs'] aws_regions: AWS regions to collect data from. Defaults to `include_all` if block is empty.
        :param pulumi.Input['IntegrationAccountLogsConfigArgs'] logs_config: Configure log autosubscription for your Datadog Forwarder Lambda functions. The `lambda_fowarder` block is required within, but may be empty to use defaults.
        :param pulumi.Input['IntegrationAccountMetricsConfigArgs'] metrics_config: Configure metrics collection from AWS CloudWatch. The `namespace_filters` block is required within, but may be empty to use defaults.
        :param pulumi.Input['IntegrationAccountResourcesConfigArgs'] resources_config: AWS resources collection config. May be empty to use defaults.
        :param pulumi.Input['IntegrationAccountTracesConfigArgs'] traces_config: AWS traces collection config. The `xray_services` block is required within, but may be empty to use defaults.
        """
        if account_tags is not None:
            pulumi.set(__self__, "account_tags", account_tags)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_partition is not None:
            pulumi.set(__self__, "aws_partition", aws_partition)
        if aws_regions is not None:
            pulumi.set(__self__, "aws_regions", aws_regions)
        if logs_config is not None:
            pulumi.set(__self__, "logs_config", logs_config)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if resources_config is not None:
            pulumi.set(__self__, "resources_config", resources_config)
        if traces_config is not None:
            pulumi.set(__self__, "traces_config", traces_config)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to apply to all metrics in the account. Defaults to `[]`.
        """
        return pulumi.get(self, "account_tags")

    @account_tags.setter
    def account_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_tags", value)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['IntegrationAccountAuthConfigArgs']]:
        """
        Configure how Datadog authenticates to your AWS account. Either `aws_auth_config_keys` or `aws_auth_config_role` block is required within.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['IntegrationAccountAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="awsPartition")
    def aws_partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Account partition.
        """
        return pulumi.get(self, "aws_partition")

    @aws_partition.setter
    def aws_partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_partition", value)

    @_builtins.property
    @pulumi.getter(name="awsRegions")
    def aws_regions(self) -> Optional[pulumi.Input['IntegrationAccountAwsRegionsArgs']]:
        """
        AWS regions to collect data from. Defaults to `include_all` if block is empty.
        """
        return pulumi.get(self, "aws_regions")

    @aws_regions.setter
    def aws_regions(self, value: Optional[pulumi.Input['IntegrationAccountAwsRegionsArgs']]):
        pulumi.set(self, "aws_regions", value)

    @_builtins.property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> Optional[pulumi.Input['IntegrationAccountLogsConfigArgs']]:
        """
        Configure log autosubscription for your Datadog Forwarder Lambda functions. The `lambda_fowarder` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "logs_config")

    @logs_config.setter
    def logs_config(self, value: Optional[pulumi.Input['IntegrationAccountLogsConfigArgs']]):
        pulumi.set(self, "logs_config", value)

    @_builtins.property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['IntegrationAccountMetricsConfigArgs']]:
        """
        Configure metrics collection from AWS CloudWatch. The `namespace_filters` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['IntegrationAccountMetricsConfigArgs']]):
        pulumi.set(self, "metrics_config", value)

    @_builtins.property
    @pulumi.getter(name="resourcesConfig")
    def resources_config(self) -> Optional[pulumi.Input['IntegrationAccountResourcesConfigArgs']]:
        """
        AWS resources collection config. May be empty to use defaults.
        """
        return pulumi.get(self, "resources_config")

    @resources_config.setter
    def resources_config(self, value: Optional[pulumi.Input['IntegrationAccountResourcesConfigArgs']]):
        pulumi.set(self, "resources_config", value)

    @_builtins.property
    @pulumi.getter(name="tracesConfig")
    def traces_config(self) -> Optional[pulumi.Input['IntegrationAccountTracesConfigArgs']]:
        """
        AWS traces collection config. The `xray_services` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "traces_config")

    @traces_config.setter
    def traces_config(self, value: Optional[pulumi.Input['IntegrationAccountTracesConfigArgs']]):
        pulumi.set(self, "traces_config", value)


@pulumi.type_token("datadog:aws/integrationAccount:IntegrationAccount")
class IntegrationAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auth_config: Optional[pulumi.Input[Union['IntegrationAccountAuthConfigArgs', 'IntegrationAccountAuthConfigArgsDict']]] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_partition: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_regions: Optional[pulumi.Input[Union['IntegrationAccountAwsRegionsArgs', 'IntegrationAccountAwsRegionsArgsDict']]] = None,
                 logs_config: Optional[pulumi.Input[Union['IntegrationAccountLogsConfigArgs', 'IntegrationAccountLogsConfigArgsDict']]] = None,
                 metrics_config: Optional[pulumi.Input[Union['IntegrationAccountMetricsConfigArgs', 'IntegrationAccountMetricsConfigArgsDict']]] = None,
                 resources_config: Optional[pulumi.Input[Union['IntegrationAccountResourcesConfigArgs', 'IntegrationAccountResourcesConfigArgsDict']]] = None,
                 traces_config: Optional[pulumi.Input[Union['IntegrationAccountTracesConfigArgs', 'IntegrationAccountTracesConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import datadog:aws/integrationAccount:IntegrationAccount example "<datadog-aws-account-config-id>"
        ```

         AWS Account Config ID can be retrieved by using the [List all AWS integrations](https://docs.datadoghq.com/api/latest/aws-integration/#list-all-aws-integrations) endpoint and querying by AWS Account ID.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to apply to all metrics in the account. Defaults to `[]`.
        :param pulumi.Input[Union['IntegrationAccountAuthConfigArgs', 'IntegrationAccountAuthConfigArgsDict']] auth_config: Configure how Datadog authenticates to your AWS account. Either `aws_auth_config_keys` or `aws_auth_config_role` block is required within.
        :param pulumi.Input[_builtins.str] aws_account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] aws_partition: AWS Account partition.
        :param pulumi.Input[Union['IntegrationAccountAwsRegionsArgs', 'IntegrationAccountAwsRegionsArgsDict']] aws_regions: AWS regions to collect data from. Defaults to `include_all` if block is empty.
        :param pulumi.Input[Union['IntegrationAccountLogsConfigArgs', 'IntegrationAccountLogsConfigArgsDict']] logs_config: Configure log autosubscription for your Datadog Forwarder Lambda functions. The `lambda_fowarder` block is required within, but may be empty to use defaults.
        :param pulumi.Input[Union['IntegrationAccountMetricsConfigArgs', 'IntegrationAccountMetricsConfigArgsDict']] metrics_config: Configure metrics collection from AWS CloudWatch. The `namespace_filters` block is required within, but may be empty to use defaults.
        :param pulumi.Input[Union['IntegrationAccountResourcesConfigArgs', 'IntegrationAccountResourcesConfigArgsDict']] resources_config: AWS resources collection config. May be empty to use defaults.
        :param pulumi.Input[Union['IntegrationAccountTracesConfigArgs', 'IntegrationAccountTracesConfigArgsDict']] traces_config: AWS traces collection config. The `xray_services` block is required within, but may be empty to use defaults.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import datadog:aws/integrationAccount:IntegrationAccount example "<datadog-aws-account-config-id>"
        ```

         AWS Account Config ID can be retrieved by using the [List all AWS integrations](https://docs.datadoghq.com/api/latest/aws-integration/#list-all-aws-integrations) endpoint and querying by AWS Account ID.

        :param str resource_name: The name of the resource.
        :param IntegrationAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auth_config: Optional[pulumi.Input[Union['IntegrationAccountAuthConfigArgs', 'IntegrationAccountAuthConfigArgsDict']]] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_partition: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_regions: Optional[pulumi.Input[Union['IntegrationAccountAwsRegionsArgs', 'IntegrationAccountAwsRegionsArgsDict']]] = None,
                 logs_config: Optional[pulumi.Input[Union['IntegrationAccountLogsConfigArgs', 'IntegrationAccountLogsConfigArgsDict']]] = None,
                 metrics_config: Optional[pulumi.Input[Union['IntegrationAccountMetricsConfigArgs', 'IntegrationAccountMetricsConfigArgsDict']]] = None,
                 resources_config: Optional[pulumi.Input[Union['IntegrationAccountResourcesConfigArgs', 'IntegrationAccountResourcesConfigArgsDict']]] = None,
                 traces_config: Optional[pulumi.Input[Union['IntegrationAccountTracesConfigArgs', 'IntegrationAccountTracesConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationAccountArgs.__new__(IntegrationAccountArgs)

            __props__.__dict__["account_tags"] = account_tags
            __props__.__dict__["auth_config"] = auth_config
            if aws_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'aws_account_id'")
            __props__.__dict__["aws_account_id"] = aws_account_id
            if aws_partition is None and not opts.urn:
                raise TypeError("Missing required property 'aws_partition'")
            __props__.__dict__["aws_partition"] = aws_partition
            __props__.__dict__["aws_regions"] = aws_regions
            __props__.__dict__["logs_config"] = logs_config
            __props__.__dict__["metrics_config"] = metrics_config
            __props__.__dict__["resources_config"] = resources_config
            __props__.__dict__["traces_config"] = traces_config
        super(IntegrationAccount, __self__).__init__(
            'datadog:aws/integrationAccount:IntegrationAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auth_config: Optional[pulumi.Input[Union['IntegrationAccountAuthConfigArgs', 'IntegrationAccountAuthConfigArgsDict']]] = None,
            aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            aws_partition: Optional[pulumi.Input[_builtins.str]] = None,
            aws_regions: Optional[pulumi.Input[Union['IntegrationAccountAwsRegionsArgs', 'IntegrationAccountAwsRegionsArgsDict']]] = None,
            logs_config: Optional[pulumi.Input[Union['IntegrationAccountLogsConfigArgs', 'IntegrationAccountLogsConfigArgsDict']]] = None,
            metrics_config: Optional[pulumi.Input[Union['IntegrationAccountMetricsConfigArgs', 'IntegrationAccountMetricsConfigArgsDict']]] = None,
            resources_config: Optional[pulumi.Input[Union['IntegrationAccountResourcesConfigArgs', 'IntegrationAccountResourcesConfigArgsDict']]] = None,
            traces_config: Optional[pulumi.Input[Union['IntegrationAccountTracesConfigArgs', 'IntegrationAccountTracesConfigArgsDict']]] = None) -> 'IntegrationAccount':
        """
        Get an existing IntegrationAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to apply to all metrics in the account. Defaults to `[]`.
        :param pulumi.Input[Union['IntegrationAccountAuthConfigArgs', 'IntegrationAccountAuthConfigArgsDict']] auth_config: Configure how Datadog authenticates to your AWS account. Either `aws_auth_config_keys` or `aws_auth_config_role` block is required within.
        :param pulumi.Input[_builtins.str] aws_account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] aws_partition: AWS Account partition.
        :param pulumi.Input[Union['IntegrationAccountAwsRegionsArgs', 'IntegrationAccountAwsRegionsArgsDict']] aws_regions: AWS regions to collect data from. Defaults to `include_all` if block is empty.
        :param pulumi.Input[Union['IntegrationAccountLogsConfigArgs', 'IntegrationAccountLogsConfigArgsDict']] logs_config: Configure log autosubscription for your Datadog Forwarder Lambda functions. The `lambda_fowarder` block is required within, but may be empty to use defaults.
        :param pulumi.Input[Union['IntegrationAccountMetricsConfigArgs', 'IntegrationAccountMetricsConfigArgsDict']] metrics_config: Configure metrics collection from AWS CloudWatch. The `namespace_filters` block is required within, but may be empty to use defaults.
        :param pulumi.Input[Union['IntegrationAccountResourcesConfigArgs', 'IntegrationAccountResourcesConfigArgsDict']] resources_config: AWS resources collection config. May be empty to use defaults.
        :param pulumi.Input[Union['IntegrationAccountTracesConfigArgs', 'IntegrationAccountTracesConfigArgsDict']] traces_config: AWS traces collection config. The `xray_services` block is required within, but may be empty to use defaults.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationAccountState.__new__(_IntegrationAccountState)

        __props__.__dict__["account_tags"] = account_tags
        __props__.__dict__["auth_config"] = auth_config
        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["aws_partition"] = aws_partition
        __props__.__dict__["aws_regions"] = aws_regions
        __props__.__dict__["logs_config"] = logs_config
        __props__.__dict__["metrics_config"] = metrics_config
        __props__.__dict__["resources_config"] = resources_config
        __props__.__dict__["traces_config"] = traces_config
        return IntegrationAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Tags to apply to all metrics in the account. Defaults to `[]`.
        """
        return pulumi.get(self, "account_tags")

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> pulumi.Output[Optional['outputs.IntegrationAccountAuthConfig']]:
        """
        Configure how Datadog authenticates to your AWS account. Either `aws_auth_config_keys` or `aws_auth_config_role` block is required within.
        """
        return pulumi.get(self, "auth_config")

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="awsPartition")
    def aws_partition(self) -> pulumi.Output[_builtins.str]:
        """
        AWS Account partition.
        """
        return pulumi.get(self, "aws_partition")

    @_builtins.property
    @pulumi.getter(name="awsRegions")
    def aws_regions(self) -> pulumi.Output[Optional['outputs.IntegrationAccountAwsRegions']]:
        """
        AWS regions to collect data from. Defaults to `include_all` if block is empty.
        """
        return pulumi.get(self, "aws_regions")

    @_builtins.property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> pulumi.Output[Optional['outputs.IntegrationAccountLogsConfig']]:
        """
        Configure log autosubscription for your Datadog Forwarder Lambda functions. The `lambda_fowarder` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "logs_config")

    @_builtins.property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> pulumi.Output[Optional['outputs.IntegrationAccountMetricsConfig']]:
        """
        Configure metrics collection from AWS CloudWatch. The `namespace_filters` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "metrics_config")

    @_builtins.property
    @pulumi.getter(name="resourcesConfig")
    def resources_config(self) -> pulumi.Output[Optional['outputs.IntegrationAccountResourcesConfig']]:
        """
        AWS resources collection config. May be empty to use defaults.
        """
        return pulumi.get(self, "resources_config")

    @_builtins.property
    @pulumi.getter(name="tracesConfig")
    def traces_config(self) -> pulumi.Output[Optional['outputs.IntegrationAccountTracesConfig']]:
        """
        AWS traces collection config. The `xray_services` block is required within, but may be empty to use defaults.
        """
        return pulumi.get(self, "traces_config")

