# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IntegrationAccountArgs', 'IntegrationAccount']

@pulumi.input_type
class IntegrationAccountArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IntegrationAccount resource.
        :param pulumi.Input[_builtins.str] api_key: The API key (or token) for the Cloudflare account.
        :param pulumi.Input[_builtins.str] name: The name of the Cloudflare account.
        :param pulumi.Input[_builtins.str] email: The email associated with the Cloudflare account. If an API key is provided (and not a token), this field is also required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: An allowlist of resources to pull metrics for. Includes `web`, `dns`, `lb` (load balancer), and `worker`).
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[_builtins.str]:
        """
        The API key (or token) for the Cloudflare account.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cloudflare account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email associated with the Cloudflare account. If an API key is provided (and not a token), this field is also required.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An allowlist of resources to pull metrics for. Includes `web`, `dns`, `lb` (load balancer), and `worker`).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class _IntegrationAccountState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IntegrationAccount resources.
        :param pulumi.Input[_builtins.str] api_key: The API key (or token) for the Cloudflare account.
        :param pulumi.Input[_builtins.str] email: The email associated with the Cloudflare account. If an API key is provided (and not a token), this field is also required.
        :param pulumi.Input[_builtins.str] name: The name of the Cloudflare account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: An allowlist of resources to pull metrics for. Includes `web`, `dns`, `lb` (load balancer), and `worker`).
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key (or token) for the Cloudflare account.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email associated with the Cloudflare account. If an API key is provided (and not a token), this field is also required.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cloudflare account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An allowlist of resources to pull metrics for. Includes `web`, `dns`, `lb` (load balancer), and `worker`).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resources", value)


@pulumi.type_token("datadog:cloudflare/integrationAccount:IntegrationAccount")
class IntegrationAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog IntegrationCloudflareAccount resource. This can be used to create and manage Datadog integration_cloudflare_account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new integration_cloudflare_account resource
        foo = datadog.cloudflare.IntegrationAccount("foo",
            api_key="12345678910abc",
            email="test-email@example.com",
            name="test-name")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:cloudflare/integrationAccount:IntegrationAccount new_list "<ID>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: The API key (or token) for the Cloudflare account.
        :param pulumi.Input[_builtins.str] email: The email associated with the Cloudflare account. If an API key is provided (and not a token), this field is also required.
        :param pulumi.Input[_builtins.str] name: The name of the Cloudflare account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: An allowlist of resources to pull metrics for. Includes `web`, `dns`, `lb` (load balancer), and `worker`).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog IntegrationCloudflareAccount resource. This can be used to create and manage Datadog integration_cloudflare_account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create new integration_cloudflare_account resource
        foo = datadog.cloudflare.IntegrationAccount("foo",
            api_key="12345678910abc",
            email="test-email@example.com",
            name="test-name")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:cloudflare/integrationAccount:IntegrationAccount new_list "<ID>"
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationAccountArgs.__new__(IntegrationAccountArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["email"] = email
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["resources"] = resources
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IntegrationAccount, __self__).__init__(
            'datadog:cloudflare/integrationAccount:IntegrationAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'IntegrationAccount':
        """
        Get an existing IntegrationAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: The API key (or token) for the Cloudflare account.
        :param pulumi.Input[_builtins.str] email: The email associated with the Cloudflare account. If an API key is provided (and not a token), this field is also required.
        :param pulumi.Input[_builtins.str] name: The name of the Cloudflare account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: An allowlist of resources to pull metrics for. Includes `web`, `dns`, `lb` (load balancer), and `worker`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationAccountState.__new__(_IntegrationAccountState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["email"] = email
        __props__.__dict__["name"] = name
        __props__.__dict__["resources"] = resources
        return IntegrationAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[_builtins.str]:
        """
        The API key (or token) for the Cloudflare account.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The email associated with the Cloudflare account. If an API key is provided (and not a token), this field is also required.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cloudflare account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An allowlist of resources to pull metrics for. Includes `web`, `dns`, `lb` (load balancer), and `worker`).
        """
        return pulumi.get(self, "resources")

