# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ComplianceResourceEvaluationFilterArgs', 'ComplianceResourceEvaluationFilter']

@pulumi.input_type
class ComplianceResourceEvaluationFilterArgs:
    def __init__(__self__, *,
                 cloud_provider: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 tags: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a ComplianceResourceEvaluationFilter resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider of the filter's targeted resource. Only `aws`, `gcp`, or `azure` are considered valid cloud
               providers.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the of the filter's targeted resource. Different cloud providers target different resource IDs: - `aws`:
               account ID - `gcp`: project ID - `azure`: subscription ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to filter misconfiguration detections. Each entry should follow the format: "key":"value".
        """
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud provider of the filter's targeted resource. Only `aws`, `gcp`, or `azure` are considered valid cloud
        providers.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the of the filter's targeted resource. Different cloud providers target different resource IDs: - `aws`:
        account ID - `gcp`: project ID - `azure`: subscription ID
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of tags to filter misconfiguration detections. Each entry should follow the format: "key":"value".
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ComplianceResourceEvaluationFilterState:
    def __init__(__self__, *,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ComplianceResourceEvaluationFilter resources.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider of the filter's targeted resource. Only `aws`, `gcp`, or `azure` are considered valid cloud
               providers.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the of the filter's targeted resource. Different cloud providers target different resource IDs: - `aws`:
               account ID - `gcp`: project ID - `azure`: subscription ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to filter misconfiguration detections. Each entry should follow the format: "key":"value".
        """
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud provider of the filter's targeted resource. Only `aws`, `gcp`, or `azure` are considered valid cloud
        providers.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the of the filter's targeted resource. Different cloud providers target different resource IDs: - `aws`:
        account ID - `gcp`: project ID - `azure`: subscription ID
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags to filter misconfiguration detections. Each entry should follow the format: "key":"value".
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("datadog:index/complianceResourceEvaluationFilter:ComplianceResourceEvaluationFilter")
class ComplianceResourceEvaluationFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog ComplianceResourceEvaluationFilter resource. This can be used to create and manage a compliance resource evaluation filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Manage Datadog compliance resource evaluation filters
        basic_filter = datadog.ComplianceResourceEvaluationFilter("basic_filter",
            tags=["tag1:val1"],
            cloud_provider="aws",
            resource_id="000000000000")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/complianceResourceEvaluationFilter:ComplianceResourceEvaluationFilter test_filter aws:00000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider of the filter's targeted resource. Only `aws`, `gcp`, or `azure` are considered valid cloud
               providers.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the of the filter's targeted resource. Different cloud providers target different resource IDs: - `aws`:
               account ID - `gcp`: project ID - `azure`: subscription ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to filter misconfiguration detections. Each entry should follow the format: "key":"value".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComplianceResourceEvaluationFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog ComplianceResourceEvaluationFilter resource. This can be used to create and manage a compliance resource evaluation filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Manage Datadog compliance resource evaluation filters
        basic_filter = datadog.ComplianceResourceEvaluationFilter("basic_filter",
            tags=["tag1:val1"],
            cloud_provider="aws",
            resource_id="000000000000")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/complianceResourceEvaluationFilter:ComplianceResourceEvaluationFilter test_filter aws:00000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ComplianceResourceEvaluationFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComplianceResourceEvaluationFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComplianceResourceEvaluationFilterArgs.__new__(ComplianceResourceEvaluationFilterArgs)

            if cloud_provider is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_provider'")
            __props__.__dict__["cloud_provider"] = cloud_provider
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if tags is None and not opts.urn:
                raise TypeError("Missing required property 'tags'")
            __props__.__dict__["tags"] = tags
        super(ComplianceResourceEvaluationFilter, __self__).__init__(
            'datadog:index/complianceResourceEvaluationFilter:ComplianceResourceEvaluationFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ComplianceResourceEvaluationFilter':
        """
        Get an existing ComplianceResourceEvaluationFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_provider: The cloud provider of the filter's targeted resource. Only `aws`, `gcp`, or `azure` are considered valid cloud
               providers.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the of the filter's targeted resource. Different cloud providers target different resource IDs: - `aws`:
               account ID - `gcp`: project ID - `azure`: subscription ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to filter misconfiguration detections. Each entry should follow the format: "key":"value".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComplianceResourceEvaluationFilterState.__new__(_ComplianceResourceEvaluationFilterState)

        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["tags"] = tags
        return ComplianceResourceEvaluationFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud provider of the filter's targeted resource. Only `aws`, `gcp`, or `azure` are considered valid cloud
        providers.
        """
        return pulumi.get(self, "cloud_provider")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the of the filter's targeted resource. Different cloud providers target different resource IDs: - `aws`:
        account ID - `gcp`: project ID - `azure`: subscription ID
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of tags to filter misconfiguration detections. Each entry should follow the format: "key":"value".
        """
        return pulumi.get(self, "tags")

