# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetActionConnectionResult',
    'AwaitableGetActionConnectionResult',
    'get_action_connection',
    'get_action_connection_output',
]

@pulumi.output_type
class GetActionConnectionResult:
    """
    A collection of values returned by getActionConnection.
    """
    def __init__(__self__, aws=None, http=None, id=None, name=None):
        if aws and not isinstance(aws, dict):
            raise TypeError("Expected argument 'aws' to be a dict")
        pulumi.set(__self__, "aws", aws)
        if http and not isinstance(http, dict):
            raise TypeError("Expected argument 'http' to be a dict")
        pulumi.set(__self__, "http", http)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Optional['outputs.GetActionConnectionAwsResult']:
        """
        Configuration for an AWS connection
        """
        return pulumi.get(self, "aws")

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional['outputs.GetActionConnectionHttpResult']:
        """
        Configuration for an HTTP connection
        """
        return pulumi.get(self, "http")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID for Connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the connection
        """
        return pulumi.get(self, "name")


class AwaitableGetActionConnectionResult(GetActionConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActionConnectionResult(
            aws=self.aws,
            http=self.http,
            id=self.id,
            name=self.name)


def get_action_connection(aws: Optional[Union['GetActionConnectionAwsArgs', 'GetActionConnectionAwsArgsDict']] = None,
                          http: Optional[Union['GetActionConnectionHttpArgs', 'GetActionConnectionHttpArgsDict']] = None,
                          id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActionConnectionResult:
    """
    A connection that can be used in Actions, including in the Workflow Automation and App Builder products. This data source requires a registered application key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    my_connection = datadog.get_action_connection(id="11111111-2222-3333-4444-555555555555")
    ```


    :param Union['GetActionConnectionAwsArgs', 'GetActionConnectionAwsArgsDict'] aws: Configuration for an AWS connection
    :param Union['GetActionConnectionHttpArgs', 'GetActionConnectionHttpArgsDict'] http: Configuration for an HTTP connection
    :param _builtins.str id: ID for Connection.
    """
    __args__ = dict()
    __args__['aws'] = aws
    __args__['http'] = http
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getActionConnection:getActionConnection', __args__, opts=opts, typ=GetActionConnectionResult).value

    return AwaitableGetActionConnectionResult(
        aws=pulumi.get(__ret__, 'aws'),
        http=pulumi.get(__ret__, 'http'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_action_connection_output(aws: Optional[pulumi.Input[Optional[Union['GetActionConnectionAwsArgs', 'GetActionConnectionAwsArgsDict']]]] = None,
                                 http: Optional[pulumi.Input[Optional[Union['GetActionConnectionHttpArgs', 'GetActionConnectionHttpArgsDict']]]] = None,
                                 id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetActionConnectionResult]:
    """
    A connection that can be used in Actions, including in the Workflow Automation and App Builder products. This data source requires a registered application key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    my_connection = datadog.get_action_connection(id="11111111-2222-3333-4444-555555555555")
    ```


    :param Union['GetActionConnectionAwsArgs', 'GetActionConnectionAwsArgsDict'] aws: Configuration for an AWS connection
    :param Union['GetActionConnectionHttpArgs', 'GetActionConnectionHttpArgsDict'] http: Configuration for an HTTP connection
    :param _builtins.str id: ID for Connection.
    """
    __args__ = dict()
    __args__['aws'] = aws
    __args__['http'] = http
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getActionConnection:getActionConnection', __args__, opts=opts, typ=GetActionConnectionResult)
    return __ret__.apply(lambda __response__: GetActionConnectionResult(
        aws=pulumi.get(__response__, 'aws'),
        http=pulumi.get(__response__, 'http'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
