# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIncidentTypeResult',
    'AwaitableGetIncidentTypeResult',
    'get_incident_type',
    'get_incident_type_output',
]

@pulumi.output_type
class GetIncidentTypeResult:
    """
    A collection of values returned by getIncidentType.
    """
    def __init__(__self__, description=None, id=None, is_default=None, name=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the incident type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the incident type.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether this incident type is the default type.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the incident type.
        """
        return pulumi.get(self, "name")


class AwaitableGetIncidentTypeResult(GetIncidentTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIncidentTypeResult(
            description=self.description,
            id=self.id,
            is_default=self.is_default,
            name=self.name)


def get_incident_type(id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIncidentTypeResult:
    """
    Use this data source to retrieve information about an existing incident type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_incident_type(id="01234567-89ab-cdef-0123-456789abcdef")
    ```


    :param _builtins.str id: The ID of the incident type.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getIncidentType:getIncidentType', __args__, opts=opts, typ=GetIncidentTypeResult).value

    return AwaitableGetIncidentTypeResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        name=pulumi.get(__ret__, 'name'))
def get_incident_type_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIncidentTypeResult]:
    """
    Use this data source to retrieve information about an existing incident type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_incident_type(id="01234567-89ab-cdef-0123-456789abcdef")
    ```


    :param _builtins.str id: The ID of the incident type.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getIncidentType:getIncidentType', __args__, opts=opts, typ=GetIncidentTypeResult)
    return __ret__.apply(lambda __response__: GetIncidentTypeResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        name=pulumi.get(__response__, 'name')))
