# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRumRetentionFiltersResult',
    'AwaitableGetRumRetentionFiltersResult',
    'get_rum_retention_filters',
    'get_rum_retention_filters_output',
]

@pulumi.output_type
class GetRumRetentionFiltersResult:
    """
    A collection of values returned by getRumRetentionFilters.
    """
    def __init__(__self__, application_id=None, id=None, retention_filters=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if retention_filters and not isinstance(retention_filters, list):
            raise TypeError("Expected argument 'retention_filters' to be a list")
        pulumi.set(__self__, "retention_filters", retention_filters)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        RUM application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="retentionFilters")
    def retention_filters(self) -> Sequence['outputs.GetRumRetentionFiltersRetentionFilterResult']:
        """
        The list of RUM retention filters.
        """
        return pulumi.get(self, "retention_filters")


class AwaitableGetRumRetentionFiltersResult(GetRumRetentionFiltersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRumRetentionFiltersResult(
            application_id=self.application_id,
            id=self.id,
            retention_filters=self.retention_filters)


def get_rum_retention_filters(application_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRumRetentionFiltersResult:
    """
    Provides a Datadog RUM retention filters datasource. This can be used to retrieve all RUM retention filters for a given RUM application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    testing_rum_retention_filters = datadog.get_rum_retention_filters(application_id="<APPLICATION_ID>")
    ```


    :param _builtins.str application_id: RUM application ID.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getRumRetentionFilters:getRumRetentionFilters', __args__, opts=opts, typ=GetRumRetentionFiltersResult).value

    return AwaitableGetRumRetentionFiltersResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        id=pulumi.get(__ret__, 'id'),
        retention_filters=pulumi.get(__ret__, 'retention_filters'))
def get_rum_retention_filters_output(application_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRumRetentionFiltersResult]:
    """
    Provides a Datadog RUM retention filters datasource. This can be used to retrieve all RUM retention filters for a given RUM application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    testing_rum_retention_filters = datadog.get_rum_retention_filters(application_id="<APPLICATION_ID>")
    ```


    :param _builtins.str application_id: RUM application ID.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getRumRetentionFilters:getRumRetentionFilters', __args__, opts=opts, typ=GetRumRetentionFiltersResult)
    return __ret__.apply(lambda __response__: GetRumRetentionFiltersResult(
        application_id=pulumi.get(__response__, 'application_id'),
        id=pulumi.get(__response__, 'id'),
        retention_filters=pulumi.get(__response__, 'retention_filters')))
