# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogsCustomPipelineArgs', 'LogsCustomPipeline']

@pulumi.input_type
class LogsCustomPipelineArgs:
    def __init__(__self__, *,
                 filters: pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineFilterArgs']]],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 processors: Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineProcessorArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LogsCustomPipeline resource.
        """
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if processors is not None:
            pulumi.set(__self__, "processors", processors)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineFilterArgs']]]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineFilterArgs']]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def processors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineProcessorArgs']]]]:
        return pulumi.get(self, "processors")

    @processors.setter
    def processors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineProcessorArgs']]]]):
        pulumi.set(self, "processors", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LogsCustomPipelineState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineFilterArgs']]]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 processors: Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineProcessorArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LogsCustomPipeline resources.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if processors is not None:
            pulumi.set(__self__, "processors", processors)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineFilterArgs']]]]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def processors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineProcessorArgs']]]]:
        return pulumi.get(self, "processors")

    @processors.setter
    def processors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogsCustomPipelineProcessorArgs']]]]):
        pulumi.set(self, "processors", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("datadog:index/logsCustomPipeline:LogsCustomPipeline")
class LogsCustomPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsCustomPipelineFilterArgs', 'LogsCustomPipelineFilterArgsDict']]]]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 processors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsCustomPipelineProcessorArgs', 'LogsCustomPipelineProcessorArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/) resource, which is used to create and manage Datadog logs custom pipelines. Each `LogsCustomPipeline` resource defines a complete pipeline. The order of the pipelines is maintained in a different resource: `LogsPipelineOrder`. When creating a new pipeline, you need to **explicitly** add this pipeline to the `LogsPipelineOrder` resource to track the pipeline. Similarly, when a pipeline needs to be destroyed, remove its references from the `LogsPipelineOrder` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_pipeline = datadog.LogsCustomPipeline("sample_pipeline",
            filters=[{
                "query": "source:foo",
            }],
            name="sample pipeline",
            is_enabled=True,
            processors=[
                {
                    "arithmetic_processor": {
                        "expression": "(time1 - time2)*1000",
                        "target": "my_arithmetic",
                        "is_replace_missing": True,
                        "name": "sample arithmetic processor",
                        "is_enabled": True,
                    },
                },
                {
                    "attribute_remapper": {
                        "sources": ["db.instance"],
                        "source_type": "tag",
                        "target": "db",
                        "target_type": "attribute",
                        "target_format": "string",
                        "preserve_source": True,
                        "override_on_conflict": False,
                        "name": "sample attribute processor",
                        "is_enabled": True,
                    },
                },
                {
                    "category_processor": {
                        "target": "foo.severity",
                        "categories": [
                            {
                                "name": "debug",
                                "filter": {
                                    "query": "@severity: \\".\\"",
                                },
                            },
                            {
                                "name": "verbose",
                                "filter": {
                                    "query": "@severity: \\"-\\"",
                                },
                            },
                        ],
                        "name": "sample category processor",
                        "is_enabled": True,
                    },
                },
                {
                    "date_remapper": {
                        "sources": [
                            "_timestamp",
                            "published_date",
                        ],
                        "name": "sample date remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "geo_ip_parser": {
                        "sources": ["network.client.ip"],
                        "target": "network.client.geoip",
                        "name": "sample geo ip parser",
                        "is_enabled": True,
                    },
                },
                {
                    "grok_parser": {
                        "samples": ["sample log 1"],
                        "source": "message",
                        "grok": {
                            "support_rules": "",
                            "match_rules": "Rule %{word:my_word2} %{number:my_float2}",
                        },
                        "name": "sample grok parser",
                        "is_enabled": True,
                    },
                },
                {
                    "lookup_processor": {
                        "source": "service_id",
                        "target": "service_name",
                        "lookup_tables": ["1,my service"],
                        "default_lookup": "unknown service",
                        "name": "sample lookup processor",
                        "is_enabled": True,
                    },
                },
                {
                    "message_remapper": {
                        "sources": ["msg"],
                        "name": "sample message remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "pipeline": {
                        "filters": [{
                            "query": "source:foo",
                        }],
                        "processors": [{
                            "url_parser": {
                                "name": "sample url parser",
                                "sources": [
                                    "url",
                                    "extra",
                                ],
                                "target": "http_url",
                                "normalize_ending_slashes": True,
                            },
                        }],
                        "name": "nested pipeline",
                        "is_enabled": True,
                    },
                },
                {
                    "service_remapper": {
                        "sources": ["service"],
                        "name": "sample service remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "status_remapper": {
                        "sources": [
                            "info",
                            "trace",
                        ],
                        "name": "sample status remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "string_builder_processor": {
                        "target": "user_activity",
                        "template": "%{user.name} logged in at %{timestamp}",
                        "name": "sample string builder processor",
                        "is_enabled": True,
                        "is_replace_missing": False,
                    },
                },
                {
                    "trace_id_remapper": {
                        "sources": ["dd.trace_id"],
                        "name": "sample trace id remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "user_agent_parser": {
                        "sources": [
                            "user",
                            "agent",
                        ],
                        "target": "http_agent",
                        "is_encoded": False,
                        "name": "sample user agent parser",
                        "is_enabled": True,
                    },
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        To find the pipeline ID, click the "edit" button in the UI to open the pipeline details.

        The pipeline ID is the last part of the URL.

        ```sh
        $ pulumi import datadog:index/logsCustomPipeline:LogsCustomPipeline name> <pipelineID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsCustomPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/) resource, which is used to create and manage Datadog logs custom pipelines. Each `LogsCustomPipeline` resource defines a complete pipeline. The order of the pipelines is maintained in a different resource: `LogsPipelineOrder`. When creating a new pipeline, you need to **explicitly** add this pipeline to the `LogsPipelineOrder` resource to track the pipeline. Similarly, when a pipeline needs to be destroyed, remove its references from the `LogsPipelineOrder` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_pipeline = datadog.LogsCustomPipeline("sample_pipeline",
            filters=[{
                "query": "source:foo",
            }],
            name="sample pipeline",
            is_enabled=True,
            processors=[
                {
                    "arithmetic_processor": {
                        "expression": "(time1 - time2)*1000",
                        "target": "my_arithmetic",
                        "is_replace_missing": True,
                        "name": "sample arithmetic processor",
                        "is_enabled": True,
                    },
                },
                {
                    "attribute_remapper": {
                        "sources": ["db.instance"],
                        "source_type": "tag",
                        "target": "db",
                        "target_type": "attribute",
                        "target_format": "string",
                        "preserve_source": True,
                        "override_on_conflict": False,
                        "name": "sample attribute processor",
                        "is_enabled": True,
                    },
                },
                {
                    "category_processor": {
                        "target": "foo.severity",
                        "categories": [
                            {
                                "name": "debug",
                                "filter": {
                                    "query": "@severity: \\".\\"",
                                },
                            },
                            {
                                "name": "verbose",
                                "filter": {
                                    "query": "@severity: \\"-\\"",
                                },
                            },
                        ],
                        "name": "sample category processor",
                        "is_enabled": True,
                    },
                },
                {
                    "date_remapper": {
                        "sources": [
                            "_timestamp",
                            "published_date",
                        ],
                        "name": "sample date remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "geo_ip_parser": {
                        "sources": ["network.client.ip"],
                        "target": "network.client.geoip",
                        "name": "sample geo ip parser",
                        "is_enabled": True,
                    },
                },
                {
                    "grok_parser": {
                        "samples": ["sample log 1"],
                        "source": "message",
                        "grok": {
                            "support_rules": "",
                            "match_rules": "Rule %{word:my_word2} %{number:my_float2}",
                        },
                        "name": "sample grok parser",
                        "is_enabled": True,
                    },
                },
                {
                    "lookup_processor": {
                        "source": "service_id",
                        "target": "service_name",
                        "lookup_tables": ["1,my service"],
                        "default_lookup": "unknown service",
                        "name": "sample lookup processor",
                        "is_enabled": True,
                    },
                },
                {
                    "message_remapper": {
                        "sources": ["msg"],
                        "name": "sample message remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "pipeline": {
                        "filters": [{
                            "query": "source:foo",
                        }],
                        "processors": [{
                            "url_parser": {
                                "name": "sample url parser",
                                "sources": [
                                    "url",
                                    "extra",
                                ],
                                "target": "http_url",
                                "normalize_ending_slashes": True,
                            },
                        }],
                        "name": "nested pipeline",
                        "is_enabled": True,
                    },
                },
                {
                    "service_remapper": {
                        "sources": ["service"],
                        "name": "sample service remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "status_remapper": {
                        "sources": [
                            "info",
                            "trace",
                        ],
                        "name": "sample status remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "string_builder_processor": {
                        "target": "user_activity",
                        "template": "%{user.name} logged in at %{timestamp}",
                        "name": "sample string builder processor",
                        "is_enabled": True,
                        "is_replace_missing": False,
                    },
                },
                {
                    "trace_id_remapper": {
                        "sources": ["dd.trace_id"],
                        "name": "sample trace id remapper",
                        "is_enabled": True,
                    },
                },
                {
                    "user_agent_parser": {
                        "sources": [
                            "user",
                            "agent",
                        ],
                        "target": "http_agent",
                        "is_encoded": False,
                        "name": "sample user agent parser",
                        "is_enabled": True,
                    },
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        To find the pipeline ID, click the "edit" button in the UI to open the pipeline details.

        The pipeline ID is the last part of the URL.

        ```sh
        $ pulumi import datadog:index/logsCustomPipeline:LogsCustomPipeline name> <pipelineID>
        ```

        :param str resource_name: The name of the resource.
        :param LogsCustomPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsCustomPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsCustomPipelineFilterArgs', 'LogsCustomPipelineFilterArgsDict']]]]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 processors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsCustomPipelineProcessorArgs', 'LogsCustomPipelineProcessorArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsCustomPipelineArgs.__new__(LogsCustomPipelineArgs)

            __props__.__dict__["description"] = description
            if filters is None and not opts.urn:
                raise TypeError("Missing required property 'filters'")
            __props__.__dict__["filters"] = filters
            __props__.__dict__["is_enabled"] = is_enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["processors"] = processors
            __props__.__dict__["tags"] = tags
        super(LogsCustomPipeline, __self__).__init__(
            'datadog:index/logsCustomPipeline:LogsCustomPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsCustomPipelineFilterArgs', 'LogsCustomPipelineFilterArgsDict']]]]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            processors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogsCustomPipelineProcessorArgs', 'LogsCustomPipelineProcessorArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'LogsCustomPipeline':
        """
        Get an existing LogsCustomPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsCustomPipelineState.__new__(_LogsCustomPipelineState)

        __props__.__dict__["description"] = description
        __props__.__dict__["filters"] = filters
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["processors"] = processors
        __props__.__dict__["tags"] = tags
        return LogsCustomPipeline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Sequence['outputs.LogsCustomPipelineFilter']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def processors(self) -> pulumi.Output[Optional[Sequence['outputs.LogsCustomPipelineProcessor']]]:
        return pulumi.get(self, "processors")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags")

