# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LogsIndexOrderArgs', 'LogsIndexOrder']

@pulumi.input_type
class LogsIndexOrderArgs:
    def __init__(__self__, *,
                 indexes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogsIndexOrder resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] indexes: The index resource list. Logs are tested against the query filter of each index one by one following the order of the list.
        :param pulumi.Input[_builtins.str] name: The unique name of the index order resource.
        """
        pulumi.set(__self__, "indexes", indexes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def indexes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The index resource list. Logs are tested against the query filter of each index one by one following the order of the list.
        """
        return pulumi.get(self, "indexes")

    @indexes.setter
    def indexes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "indexes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the index order resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LogsIndexOrderState:
    def __init__(__self__, *,
                 indexes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogsIndexOrder resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] indexes: The index resource list. Logs are tested against the query filter of each index one by one following the order of the list.
        :param pulumi.Input[_builtins.str] name: The unique name of the index order resource.
        """
        if indexes is not None:
            pulumi.set(__self__, "indexes", indexes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The index resource list. Logs are tested against the query filter of each index one by one following the order of the list.
        """
        return pulumi.get(self, "indexes")

    @indexes.setter
    def indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "indexes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the index order resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("datadog:index/logsIndexOrder:LogsIndexOrder")
class LogsIndexOrder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 indexes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog Logs Index API resource. This can be used to manage the order of Datadog logs indexes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_index_order = datadog.LogsIndexOrder("sample_index_order",
            name="sample_index_order",
            indexes=[sample_index["id"]])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        The Datadog Terraform Provider does not support the creation and deletion of index orders. There must be at most one `datadog_logs_index_order` resource

        `<name>` can be whatever you specify in your code. Datadog does not store the name on the server.

        ```sh
        $ pulumi import datadog:index/logsIndexOrder:LogsIndexOrder name> <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] indexes: The index resource list. Logs are tested against the query filter of each index one by one following the order of the list.
        :param pulumi.Input[_builtins.str] name: The unique name of the index order resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsIndexOrderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Logs Index API resource. This can be used to manage the order of Datadog logs indexes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_index_order = datadog.LogsIndexOrder("sample_index_order",
            name="sample_index_order",
            indexes=[sample_index["id"]])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        The Datadog Terraform Provider does not support the creation and deletion of index orders. There must be at most one `datadog_logs_index_order` resource

        `<name>` can be whatever you specify in your code. Datadog does not store the name on the server.

        ```sh
        $ pulumi import datadog:index/logsIndexOrder:LogsIndexOrder name> <name>
        ```

        :param str resource_name: The name of the resource.
        :param LogsIndexOrderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsIndexOrderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 indexes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsIndexOrderArgs.__new__(LogsIndexOrderArgs)

            if indexes is None and not opts.urn:
                raise TypeError("Missing required property 'indexes'")
            __props__.__dict__["indexes"] = indexes
            __props__.__dict__["name"] = name
        super(LogsIndexOrder, __self__).__init__(
            'datadog:index/logsIndexOrder:LogsIndexOrder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            indexes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogsIndexOrder':
        """
        Get an existing LogsIndexOrder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] indexes: The index resource list. Logs are tested against the query filter of each index one by one following the order of the list.
        :param pulumi.Input[_builtins.str] name: The unique name of the index order resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsIndexOrderState.__new__(_LogsIndexOrderState)

        __props__.__dict__["indexes"] = indexes
        __props__.__dict__["name"] = name
        return LogsIndexOrder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def indexes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The index resource list. Logs are tested against the query filter of each index one by one following the order of the list.
        """
        return pulumi.get(self, "indexes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the index order resource.
        """
        return pulumi.get(self, "name")

