# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 app_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tags: Optional[pulumi.Input['ProviderDefaultTagsArgs']] = None,
                 http_client_retry_backoff_base: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_backoff_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 http_client_retry_max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 org_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] api_key: (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        :param pulumi.Input[_builtins.str] api_url: The API URL. This can also be set via the DD_HOST environment variable, and defaults to `https://api.datadoghq.com`.
               Note that this URL must not end with the `/api/` path. For example, `https://api.datadoghq.com/` is a correct value,
               while `https://api.datadoghq.com/api/` is not. And if you're working with "EU" version of Datadog, use
               `https://api.datadoghq.eu/`. Other Datadog region examples: `https://api.us5.datadoghq.com/`,
               `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See https://docs.datadoghq.com/getting_started/site/
               for all available regions.
        :param pulumi.Input[_builtins.str] app_key: (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        :param pulumi.Input[_builtins.str] aws_access_key_id: The AWS access key ID; used for cloud-provider-based authentication. This can also be set using the `AWS_ACCESS_KEY_ID`
               environment variable. Required when using `cloud_provider_type` set to `aws`.
        :param pulumi.Input[_builtins.str] aws_secret_access_key: The AWS secret access key; used for cloud-provider-based authentication. This can also be set using the
               `AWS_SECRET_ACCESS_KEY` environment variable. Required when using `cloud_provider_type` set to `aws`.
        :param pulumi.Input[_builtins.str] aws_session_token: The AWS session token; used for cloud-provider-based authentication. This can also be set using the `AWS_SESSION_TOKEN`
               environment variable. Required when using `cloud_provider_type` set to `aws` and using temporary credentials.
        :param pulumi.Input[_builtins.str] cloud_provider_region: The cloud provider region specifier; used for cloud-provider-based authentication. For example, `us-east-1` for AWS.
        :param pulumi.Input[_builtins.str] cloud_provider_type: Specifies the cloud provider used for cloud-provider-based authentication, enabling keyless access without API or app
               keys. Only [`aws`] is supported. This feature is in Preview. If you'd like to enable it for your organization, contact
               [support](https://docs.datadoghq.com/help/).
        :param pulumi.Input['ProviderDefaultTagsArgs'] default_tags: [Experimental - Logs Pipelines, Monitors Security Monitoring Rules, and Service Level Objectives only] Configuration
               block containing settings to apply default resource tags across all resources.
        :param pulumi.Input[_builtins.int] http_client_retry_backoff_base: The HTTP request retry back off base. Defaults to 2.
        :param pulumi.Input[_builtins.int] http_client_retry_backoff_multiplier: The HTTP request retry back off multiplier. Defaults to 2.
        :param pulumi.Input[_builtins.str] http_client_retry_enabled: Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        :param pulumi.Input[_builtins.int] http_client_retry_max_retries: The HTTP request maximum retry number. Defaults to 3.
        :param pulumi.Input[_builtins.int] http_client_retry_timeout: The HTTP request retry timeout period. Defaults to 60 seconds.
        :param pulumi.Input[_builtins.str] org_uuid: The organization UUID; used for cloud-provider-based authentication. See the [Datadog API
               documentation](https://docs.datadoghq.com/api/v1/organizations/) for more information.
        :param pulumi.Input[_builtins.str] validate: Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
               is true. When false, api_key won't be checked.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if aws_access_key_id is not None:
            pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        if aws_secret_access_key is not None:
            pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if cloud_provider_region is not None:
            pulumi.set(__self__, "cloud_provider_region", cloud_provider_region)
        if cloud_provider_type is not None:
            pulumi.set(__self__, "cloud_provider_type", cloud_provider_type)
        if default_tags is not None:
            pulumi.set(__self__, "default_tags", default_tags)
        if http_client_retry_backoff_base is not None:
            pulumi.set(__self__, "http_client_retry_backoff_base", http_client_retry_backoff_base)
        if http_client_retry_backoff_multiplier is not None:
            pulumi.set(__self__, "http_client_retry_backoff_multiplier", http_client_retry_backoff_multiplier)
        if http_client_retry_enabled is not None:
            pulumi.set(__self__, "http_client_retry_enabled", http_client_retry_enabled)
        if http_client_retry_max_retries is not None:
            pulumi.set(__self__, "http_client_retry_max_retries", http_client_retry_max_retries)
        if http_client_retry_timeout is not None:
            pulumi.set(__self__, "http_client_retry_timeout", http_client_retry_timeout)
        if org_uuid is not None:
            pulumi.set(__self__, "org_uuid", org_uuid)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API URL. This can also be set via the DD_HOST environment variable, and defaults to `https://api.datadoghq.com`.
        Note that this URL must not end with the `/api/` path. For example, `https://api.datadoghq.com/` is a correct value,
        while `https://api.datadoghq.com/api/` is not. And if you're working with "EU" version of Datadog, use
        `https://api.datadoghq.eu/`. Other Datadog region examples: `https://api.us5.datadoghq.com/`,
        `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See https://docs.datadoghq.com/getting_started/site/
        for all available regions.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)

    @_builtins.property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_key", value)

    @_builtins.property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS access key ID; used for cloud-provider-based authentication. This can also be set using the `AWS_ACCESS_KEY_ID`
        environment variable. Required when using `cloud_provider_type` set to `aws`.
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS secret access key; used for cloud-provider-based authentication. This can also be set using the
        `AWS_SECRET_ACCESS_KEY` environment variable. Required when using `cloud_provider_type` set to `aws`.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_secret_access_key", value)

    @_builtins.property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS session token; used for cloud-provider-based authentication. This can also be set using the `AWS_SESSION_TOKEN`
        environment variable. Required when using `cloud_provider_type` set to `aws` and using temporary credentials.
        """
        return pulumi.get(self, "aws_session_token")

    @aws_session_token.setter
    def aws_session_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_session_token", value)

    @_builtins.property
    @pulumi.getter(name="cloudProviderRegion")
    def cloud_provider_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud provider region specifier; used for cloud-provider-based authentication. For example, `us-east-1` for AWS.
        """
        return pulumi.get(self, "cloud_provider_region")

    @cloud_provider_region.setter
    def cloud_provider_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_provider_region", value)

    @_builtins.property
    @pulumi.getter(name="cloudProviderType")
    def cloud_provider_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cloud provider used for cloud-provider-based authentication, enabling keyless access without API or app
        keys. Only [`aws`] is supported. This feature is in Preview. If you'd like to enable it for your organization, contact
        [support](https://docs.datadoghq.com/help/).
        """
        return pulumi.get(self, "cloud_provider_type")

    @cloud_provider_type.setter
    def cloud_provider_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_provider_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTags")
    def default_tags(self) -> Optional[pulumi.Input['ProviderDefaultTagsArgs']]:
        """
        [Experimental - Logs Pipelines, Monitors Security Monitoring Rules, and Service Level Objectives only] Configuration
        block containing settings to apply default resource tags across all resources.
        """
        return pulumi.get(self, "default_tags")

    @default_tags.setter
    def default_tags(self, value: Optional[pulumi.Input['ProviderDefaultTagsArgs']]):
        pulumi.set(self, "default_tags", value)

    @_builtins.property
    @pulumi.getter(name="httpClientRetryBackoffBase")
    def http_client_retry_backoff_base(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The HTTP request retry back off base. Defaults to 2.
        """
        return pulumi.get(self, "http_client_retry_backoff_base")

    @http_client_retry_backoff_base.setter
    def http_client_retry_backoff_base(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_client_retry_backoff_base", value)

    @_builtins.property
    @pulumi.getter(name="httpClientRetryBackoffMultiplier")
    def http_client_retry_backoff_multiplier(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The HTTP request retry back off multiplier. Defaults to 2.
        """
        return pulumi.get(self, "http_client_retry_backoff_multiplier")

    @http_client_retry_backoff_multiplier.setter
    def http_client_retry_backoff_multiplier(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_client_retry_backoff_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="httpClientRetryEnabled")
    def http_client_retry_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        """
        return pulumi.get(self, "http_client_retry_enabled")

    @http_client_retry_enabled.setter
    def http_client_retry_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_client_retry_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpClientRetryMaxRetries")
    def http_client_retry_max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The HTTP request maximum retry number. Defaults to 3.
        """
        return pulumi.get(self, "http_client_retry_max_retries")

    @http_client_retry_max_retries.setter
    def http_client_retry_max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_client_retry_max_retries", value)

    @_builtins.property
    @pulumi.getter(name="httpClientRetryTimeout")
    def http_client_retry_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The HTTP request retry timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "http_client_retry_timeout")

    @http_client_retry_timeout.setter
    def http_client_retry_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_client_retry_timeout", value)

    @_builtins.property
    @pulumi.getter(name="orgUuid")
    def org_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization UUID; used for cloud-provider-based authentication. See the [Datadog API
        documentation](https://docs.datadoghq.com/api/v1/organizations/) for more information.
        """
        return pulumi.get(self, "org_uuid")

    @org_uuid.setter
    def org_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_uuid", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
        is true. When false, api_key won't be checked.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("pulumi:providers:datadog")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 app_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tags: Optional[pulumi.Input[Union['ProviderDefaultTagsArgs', 'ProviderDefaultTagsArgsDict']]] = None,
                 http_client_retry_backoff_base: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_backoff_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 http_client_retry_max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 org_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the datadog package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        :param pulumi.Input[_builtins.str] api_url: The API URL. This can also be set via the DD_HOST environment variable, and defaults to `https://api.datadoghq.com`.
               Note that this URL must not end with the `/api/` path. For example, `https://api.datadoghq.com/` is a correct value,
               while `https://api.datadoghq.com/api/` is not. And if you're working with "EU" version of Datadog, use
               `https://api.datadoghq.eu/`. Other Datadog region examples: `https://api.us5.datadoghq.com/`,
               `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See https://docs.datadoghq.com/getting_started/site/
               for all available regions.
        :param pulumi.Input[_builtins.str] app_key: (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        :param pulumi.Input[_builtins.str] aws_access_key_id: The AWS access key ID; used for cloud-provider-based authentication. This can also be set using the `AWS_ACCESS_KEY_ID`
               environment variable. Required when using `cloud_provider_type` set to `aws`.
        :param pulumi.Input[_builtins.str] aws_secret_access_key: The AWS secret access key; used for cloud-provider-based authentication. This can also be set using the
               `AWS_SECRET_ACCESS_KEY` environment variable. Required when using `cloud_provider_type` set to `aws`.
        :param pulumi.Input[_builtins.str] aws_session_token: The AWS session token; used for cloud-provider-based authentication. This can also be set using the `AWS_SESSION_TOKEN`
               environment variable. Required when using `cloud_provider_type` set to `aws` and using temporary credentials.
        :param pulumi.Input[_builtins.str] cloud_provider_region: The cloud provider region specifier; used for cloud-provider-based authentication. For example, `us-east-1` for AWS.
        :param pulumi.Input[_builtins.str] cloud_provider_type: Specifies the cloud provider used for cloud-provider-based authentication, enabling keyless access without API or app
               keys. Only [`aws`] is supported. This feature is in Preview. If you'd like to enable it for your organization, contact
               [support](https://docs.datadoghq.com/help/).
        :param pulumi.Input[Union['ProviderDefaultTagsArgs', 'ProviderDefaultTagsArgsDict']] default_tags: [Experimental - Logs Pipelines, Monitors Security Monitoring Rules, and Service Level Objectives only] Configuration
               block containing settings to apply default resource tags across all resources.
        :param pulumi.Input[_builtins.int] http_client_retry_backoff_base: The HTTP request retry back off base. Defaults to 2.
        :param pulumi.Input[_builtins.int] http_client_retry_backoff_multiplier: The HTTP request retry back off multiplier. Defaults to 2.
        :param pulumi.Input[_builtins.str] http_client_retry_enabled: Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        :param pulumi.Input[_builtins.int] http_client_retry_max_retries: The HTTP request maximum retry number. Defaults to 3.
        :param pulumi.Input[_builtins.int] http_client_retry_timeout: The HTTP request retry timeout period. Defaults to 60 seconds.
        :param pulumi.Input[_builtins.str] org_uuid: The organization UUID; used for cloud-provider-based authentication. See the [Datadog API
               documentation](https://docs.datadoghq.com/api/v1/organizations/) for more information.
        :param pulumi.Input[_builtins.str] validate: Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
               is true. When false, api_key won't be checked.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the datadog package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 app_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tags: Optional[pulumi.Input[Union['ProviderDefaultTagsArgs', 'ProviderDefaultTagsArgsDict']]] = None,
                 http_client_retry_backoff_base: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_backoff_multiplier: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 http_client_retry_max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 http_client_retry_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 org_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 validate: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["api_url"] = api_url
            __props__.__dict__["app_key"] = None if app_key is None else pulumi.Output.secret(app_key)
            __props__.__dict__["aws_access_key_id"] = None if aws_access_key_id is None else pulumi.Output.secret(aws_access_key_id)
            __props__.__dict__["aws_secret_access_key"] = None if aws_secret_access_key is None else pulumi.Output.secret(aws_secret_access_key)
            __props__.__dict__["aws_session_token"] = None if aws_session_token is None else pulumi.Output.secret(aws_session_token)
            __props__.__dict__["cloud_provider_region"] = cloud_provider_region
            __props__.__dict__["cloud_provider_type"] = cloud_provider_type
            __props__.__dict__["default_tags"] = pulumi.Output.from_input(default_tags).apply(pulumi.runtime.to_json) if default_tags is not None else None
            __props__.__dict__["http_client_retry_backoff_base"] = pulumi.Output.from_input(http_client_retry_backoff_base).apply(pulumi.runtime.to_json) if http_client_retry_backoff_base is not None else None
            __props__.__dict__["http_client_retry_backoff_multiplier"] = pulumi.Output.from_input(http_client_retry_backoff_multiplier).apply(pulumi.runtime.to_json) if http_client_retry_backoff_multiplier is not None else None
            __props__.__dict__["http_client_retry_enabled"] = http_client_retry_enabled
            __props__.__dict__["http_client_retry_max_retries"] = pulumi.Output.from_input(http_client_retry_max_retries).apply(pulumi.runtime.to_json) if http_client_retry_max_retries is not None else None
            __props__.__dict__["http_client_retry_timeout"] = pulumi.Output.from_input(http_client_retry_timeout).apply(pulumi.runtime.to_json) if http_client_retry_timeout is not None else None
            __props__.__dict__["org_uuid"] = org_uuid
            __props__.__dict__["validate"] = validate
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "appKey", "awsAccessKeyId", "awsSecretAccessKey", "awsSessionToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'datadog',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API URL. This can also be set via the DD_HOST environment variable, and defaults to `https://api.datadoghq.com`.
        Note that this URL must not end with the `/api/` path. For example, `https://api.datadoghq.com/` is a correct value,
        while `https://api.datadoghq.com/api/` is not. And if you're working with "EU" version of Datadog, use
        `https://api.datadoghq.eu/`. Other Datadog region examples: `https://api.us5.datadoghq.com/`,
        `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See https://docs.datadoghq.com/getting_started/site/
        for all available regions.
        """
        return pulumi.get(self, "api_url")

    @_builtins.property
    @pulumi.getter(name="appKey")
    def app_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
        """
        return pulumi.get(self, "app_key")

    @_builtins.property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS access key ID; used for cloud-provider-based authentication. This can also be set using the `AWS_ACCESS_KEY_ID`
        environment variable. Required when using `cloud_provider_type` set to `aws`.
        """
        return pulumi.get(self, "aws_access_key_id")

    @_builtins.property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS secret access key; used for cloud-provider-based authentication. This can also be set using the
        `AWS_SECRET_ACCESS_KEY` environment variable. Required when using `cloud_provider_type` set to `aws`.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @_builtins.property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS session token; used for cloud-provider-based authentication. This can also be set using the `AWS_SESSION_TOKEN`
        environment variable. Required when using `cloud_provider_type` set to `aws` and using temporary credentials.
        """
        return pulumi.get(self, "aws_session_token")

    @_builtins.property
    @pulumi.getter(name="cloudProviderRegion")
    def cloud_provider_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The cloud provider region specifier; used for cloud-provider-based authentication. For example, `us-east-1` for AWS.
        """
        return pulumi.get(self, "cloud_provider_region")

    @_builtins.property
    @pulumi.getter(name="cloudProviderType")
    def cloud_provider_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the cloud provider used for cloud-provider-based authentication, enabling keyless access without API or app
        keys. Only [`aws`] is supported. This feature is in Preview. If you'd like to enable it for your organization, contact
        [support](https://docs.datadoghq.com/help/).
        """
        return pulumi.get(self, "cloud_provider_type")

    @_builtins.property
    @pulumi.getter(name="httpClientRetryEnabled")
    def http_client_retry_enabled(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enables request retries on HTTP status codes 429 and 5xx. Valid values are [`true`, `false`]. Defaults to `true`.
        """
        return pulumi.get(self, "http_client_retry_enabled")

    @_builtins.property
    @pulumi.getter(name="orgUuid")
    def org_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization UUID; used for cloud-provider-based authentication. See the [Datadog API
        documentation](https://docs.datadoghq.com/api/v1/organizations/) for more information.
        """
        return pulumi.get(self, "org_uuid")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enables validation of the provided API key during provider initialization. Valid values are [`true`, `false`]. Default
        is true. When false, api_key won't be checked.
        """
        return pulumi.get(self, "validate")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:datadog/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

