# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyntheticsTestArgs', 'SyntheticsTest']

@pulumi.input_type
class SyntheticsTestArgs:
    def __init__(__self__, *,
                 locations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]] = None,
                 config_initial_application_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[_builtins.bool]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_options_list: Optional[pulumi.Input['SyntheticsTestMobileOptionsListArgs']] = None,
                 mobile_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]]] = None,
                 options_list: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']] = None,
                 request_basicauth: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']] = None,
                 request_client_certificate: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']] = None,
                 request_definition: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_proxy: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 set_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 subtype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 variables_from_script: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SyntheticsTest resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations or find the possible values listed in [this API response](https://app.datadoghq.com/api/v1/synthetics/locations?only_public=true).
        :param pulumi.Input[_builtins.str] name: Name of Datadog synthetics test.
        :param pulumi.Input[_builtins.str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[_builtins.str] type: Synthetics test type. Valid values are `api`, `browser`, `mobile`.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]] api_steps: Steps for multistep API tests
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_initial_application_arguments: Initial application arguments for the mobile test.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test.
        :param pulumi.Input[_builtins.bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[_builtins.str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]] mobile_steps: Steps for mobile tests
        :param pulumi.Input['SyntheticsTestRequestBasicauthArgs'] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestClientCertificateArgs'] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestDefinitionArgs'] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input['SyntheticsTestRequestProxyArgs'] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_query: Query arguments name and value map.
        :param pulumi.Input[_builtins.str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[_builtins.str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[_builtins.str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if api_steps is not None:
            pulumi.set(__self__, "api_steps", api_steps)
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if browser_steps is not None:
            pulumi.set(__self__, "browser_steps", browser_steps)
        if browser_variables is not None:
            pulumi.set(__self__, "browser_variables", browser_variables)
        if config_initial_application_arguments is not None:
            pulumi.set(__self__, "config_initial_application_arguments", config_initial_application_arguments)
        if config_variables is not None:
            pulumi.set(__self__, "config_variables", config_variables)
        if device_ids is not None:
            pulumi.set(__self__, "device_ids", device_ids)
        if force_delete_dependencies is not None:
            pulumi.set(__self__, "force_delete_dependencies", force_delete_dependencies)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if mobile_options_list is not None:
            pulumi.set(__self__, "mobile_options_list", mobile_options_list)
        if mobile_steps is not None:
            pulumi.set(__self__, "mobile_steps", mobile_steps)
        if options_list is not None:
            pulumi.set(__self__, "options_list", options_list)
        if request_basicauth is not None:
            pulumi.set(__self__, "request_basicauth", request_basicauth)
        if request_client_certificate is not None:
            pulumi.set(__self__, "request_client_certificate", request_client_certificate)
        if request_definition is not None:
            pulumi.set(__self__, "request_definition", request_definition)
        if request_files is not None:
            pulumi.set(__self__, "request_files", request_files)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if request_metadata is not None:
            pulumi.set(__self__, "request_metadata", request_metadata)
        if request_proxy is not None:
            pulumi.set(__self__, "request_proxy", request_proxy)
        if request_query is not None:
            pulumi.set(__self__, "request_query", request_query)
        if set_cookie is not None:
            pulumi.set(__self__, "set_cookie", set_cookie)
        if subtype is not None:
            pulumi.set(__self__, "subtype", subtype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variables_from_script is not None:
            pulumi.set(__self__, "variables_from_script", variables_from_script)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations or find the possible values listed in [this API response](https://app.datadoghq.com/api/v1/synthetics/locations?only_public=true).
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "locations", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of Datadog synthetics test.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Synthetics test type. Valid values are `api`, `browser`, `mobile`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="apiSteps")
    def api_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]:
        """
        Steps for multistep API tests
        """
        return pulumi.get(self, "api_steps")

    @api_steps.setter
    def api_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]):
        pulumi.set(self, "api_steps", value)

    @_builtins.property
    @pulumi.getter
    def assertions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]:
        """
        Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "assertions")

    @assertions.setter
    def assertions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]):
        pulumi.set(self, "assertions", value)

    @_builtins.property
    @pulumi.getter(name="browserSteps")
    def browser_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]:
        """
        Steps for browser tests.
        """
        return pulumi.get(self, "browser_steps")

    @browser_steps.setter
    def browser_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]):
        pulumi.set(self, "browser_steps", value)

    @_builtins.property
    @pulumi.getter(name="browserVariables")
    def browser_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]:
        """
        Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "browser_variables")

    @browser_variables.setter
    def browser_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]):
        pulumi.set(self, "browser_variables", value)

    @_builtins.property
    @pulumi.getter(name="configInitialApplicationArguments")
    def config_initial_application_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Initial application arguments for the mobile test.
        """
        return pulumi.get(self, "config_initial_application_arguments")

    @config_initial_application_arguments.setter
    def config_initial_application_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config_initial_application_arguments", value)

    @_builtins.property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]:
        """
        Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "config_variables")

    @config_variables.setter
    def config_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]):
        pulumi.set(self, "config_variables", value)

    @_builtins.property
    @pulumi.getter(name="deviceIds")
    def device_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required if `type = "browser"`. Array with the different device IDs used to run the test.
        """
        return pulumi.get(self, "device_ids")

    @device_ids.setter
    def device_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_ids", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteDependencies")
    def force_delete_dependencies(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        """
        return pulumi.get(self, "force_delete_dependencies")

    @force_delete_dependencies.setter
    def force_delete_dependencies(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_dependencies", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="mobileOptionsList")
    def mobile_options_list(self) -> Optional[pulumi.Input['SyntheticsTestMobileOptionsListArgs']]:
        return pulumi.get(self, "mobile_options_list")

    @mobile_options_list.setter
    def mobile_options_list(self, value: Optional[pulumi.Input['SyntheticsTestMobileOptionsListArgs']]):
        pulumi.set(self, "mobile_options_list", value)

    @_builtins.property
    @pulumi.getter(name="mobileSteps")
    def mobile_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]]]:
        """
        Steps for mobile tests
        """
        return pulumi.get(self, "mobile_steps")

    @mobile_steps.setter
    def mobile_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]]]):
        pulumi.set(self, "mobile_steps", value)

    @_builtins.property
    @pulumi.getter(name="optionsList")
    def options_list(self) -> Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]:
        return pulumi.get(self, "options_list")

    @options_list.setter
    def options_list(self, value: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]):
        pulumi.set(self, "options_list", value)

    @_builtins.property
    @pulumi.getter(name="requestBasicauth")
    def request_basicauth(self) -> Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]:
        """
        The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_basicauth")

    @request_basicauth.setter
    def request_basicauth(self, value: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]):
        pulumi.set(self, "request_basicauth", value)

    @_builtins.property
    @pulumi.getter(name="requestClientCertificate")
    def request_client_certificate(self) -> Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]:
        """
        Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_client_certificate")

    @request_client_certificate.setter
    def request_client_certificate(self, value: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]):
        pulumi.set(self, "request_client_certificate", value)

    @_builtins.property
    @pulumi.getter(name="requestDefinition")
    def request_definition(self) -> Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]:
        """
        Required if `type = "api"`. The synthetics test request.
        """
        return pulumi.get(self, "request_definition")

    @request_definition.setter
    def request_definition(self, value: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]):
        pulumi.set(self, "request_definition", value)

    @_builtins.property
    @pulumi.getter(name="requestFiles")
    def request_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]:
        """
        Files to be used as part of the request in the test.
        """
        return pulumi.get(self, "request_files")

    @request_files.setter
    def request_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]):
        pulumi.set(self, "request_files", value)

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Header name and value map.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_headers", value)

    @_builtins.property
    @pulumi.getter(name="requestMetadata")
    def request_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata to include when performing the gRPC request.
        """
        return pulumi.get(self, "request_metadata")

    @request_metadata.setter
    def request_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_metadata", value)

    @_builtins.property
    @pulumi.getter(name="requestProxy")
    def request_proxy(self) -> Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]:
        """
        The proxy to perform the test.
        """
        return pulumi.get(self, "request_proxy")

    @request_proxy.setter
    def request_proxy(self, value: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]):
        pulumi.set(self, "request_proxy", value)

    @_builtins.property
    @pulumi.getter(name="requestQuery")
    def request_query(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Query arguments name and value map.
        """
        return pulumi.get(self, "request_query")

    @request_query.setter
    def request_query(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_query", value)

    @_builtins.property
    @pulumi.getter(name="setCookie")
    def set_cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        """
        return pulumi.get(self, "set_cookie")

    @set_cookie.setter
    def set_cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "set_cookie", value)

    @_builtins.property
    @pulumi.getter
    def subtype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        """
        return pulumi.get(self, "subtype")

    @subtype.setter
    def subtype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subtype", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="variablesFromScript")
    def variables_from_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variables defined from JavaScript code for API HTTP tests.
        """
        return pulumi.get(self, "variables_from_script")

    @variables_from_script.setter
    def variables_from_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variables_from_script", value)


@pulumi.input_type
class _SyntheticsTestState:
    def __init__(__self__, *,
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]] = None,
                 config_initial_application_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[_builtins.bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_options_list: Optional[pulumi.Input['SyntheticsTestMobileOptionsListArgs']] = None,
                 mobile_steps: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options_list: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']] = None,
                 request_basicauth: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']] = None,
                 request_client_certificate: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']] = None,
                 request_definition: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_proxy: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 set_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subtype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 variables_from_script: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SyntheticsTest resources.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]] api_steps: Steps for multistep API tests
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_initial_application_arguments: Initial application arguments for the mobile test.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test.
        :param pulumi.Input[_builtins.bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations or find the possible values listed in [this API response](https://app.datadoghq.com/api/v1/synthetics/locations?only_public=true).
        :param pulumi.Input[_builtins.str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]] mobile_steps: Steps for mobile tests
        :param pulumi.Input[_builtins.int] monitor_id: ID of the monitor associated with the Datadog synthetics test.
        :param pulumi.Input[_builtins.str] name: Name of Datadog synthetics test.
        :param pulumi.Input['SyntheticsTestRequestBasicauthArgs'] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestClientCertificateArgs'] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input['SyntheticsTestRequestDefinitionArgs'] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input['SyntheticsTestRequestProxyArgs'] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_query: Query arguments name and value map.
        :param pulumi.Input[_builtins.str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[_builtins.str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[_builtins.str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[_builtins.str] type: Synthetics test type. Valid values are `api`, `browser`, `mobile`.
        :param pulumi.Input[_builtins.str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        if api_steps is not None:
            pulumi.set(__self__, "api_steps", api_steps)
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if browser_steps is not None:
            pulumi.set(__self__, "browser_steps", browser_steps)
        if browser_variables is not None:
            pulumi.set(__self__, "browser_variables", browser_variables)
        if config_initial_application_arguments is not None:
            pulumi.set(__self__, "config_initial_application_arguments", config_initial_application_arguments)
        if config_variables is not None:
            pulumi.set(__self__, "config_variables", config_variables)
        if device_ids is not None:
            pulumi.set(__self__, "device_ids", device_ids)
        if force_delete_dependencies is not None:
            pulumi.set(__self__, "force_delete_dependencies", force_delete_dependencies)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if mobile_options_list is not None:
            pulumi.set(__self__, "mobile_options_list", mobile_options_list)
        if mobile_steps is not None:
            pulumi.set(__self__, "mobile_steps", mobile_steps)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_list is not None:
            pulumi.set(__self__, "options_list", options_list)
        if request_basicauth is not None:
            pulumi.set(__self__, "request_basicauth", request_basicauth)
        if request_client_certificate is not None:
            pulumi.set(__self__, "request_client_certificate", request_client_certificate)
        if request_definition is not None:
            pulumi.set(__self__, "request_definition", request_definition)
        if request_files is not None:
            pulumi.set(__self__, "request_files", request_files)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if request_metadata is not None:
            pulumi.set(__self__, "request_metadata", request_metadata)
        if request_proxy is not None:
            pulumi.set(__self__, "request_proxy", request_proxy)
        if request_query is not None:
            pulumi.set(__self__, "request_query", request_query)
        if set_cookie is not None:
            pulumi.set(__self__, "set_cookie", set_cookie)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subtype is not None:
            pulumi.set(__self__, "subtype", subtype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if variables_from_script is not None:
            pulumi.set(__self__, "variables_from_script", variables_from_script)

    @_builtins.property
    @pulumi.getter(name="apiSteps")
    def api_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]:
        """
        Steps for multistep API tests
        """
        return pulumi.get(self, "api_steps")

    @api_steps.setter
    def api_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestApiStepArgs']]]]):
        pulumi.set(self, "api_steps", value)

    @_builtins.property
    @pulumi.getter
    def assertions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]:
        """
        Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "assertions")

    @assertions.setter
    def assertions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestAssertionArgs']]]]):
        pulumi.set(self, "assertions", value)

    @_builtins.property
    @pulumi.getter(name="browserSteps")
    def browser_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]:
        """
        Steps for browser tests.
        """
        return pulumi.get(self, "browser_steps")

    @browser_steps.setter
    def browser_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserStepArgs']]]]):
        pulumi.set(self, "browser_steps", value)

    @_builtins.property
    @pulumi.getter(name="browserVariables")
    def browser_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]:
        """
        Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "browser_variables")

    @browser_variables.setter
    def browser_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestBrowserVariableArgs']]]]):
        pulumi.set(self, "browser_variables", value)

    @_builtins.property
    @pulumi.getter(name="configInitialApplicationArguments")
    def config_initial_application_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Initial application arguments for the mobile test.
        """
        return pulumi.get(self, "config_initial_application_arguments")

    @config_initial_application_arguments.setter
    def config_initial_application_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config_initial_application_arguments", value)

    @_builtins.property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]:
        """
        Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "config_variables")

    @config_variables.setter
    def config_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestConfigVariableArgs']]]]):
        pulumi.set(self, "config_variables", value)

    @_builtins.property
    @pulumi.getter(name="deviceIds")
    def device_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Required if `type = "browser"`. Array with the different device IDs used to run the test.
        """
        return pulumi.get(self, "device_ids")

    @device_ids.setter
    def device_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_ids", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteDependencies")
    def force_delete_dependencies(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        """
        return pulumi.get(self, "force_delete_dependencies")

    @force_delete_dependencies.setter
    def force_delete_dependencies(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete_dependencies", value)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations or find the possible values listed in [this API response](https://app.datadoghq.com/api/v1/synthetics/locations?only_public=true).
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "locations", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="mobileOptionsList")
    def mobile_options_list(self) -> Optional[pulumi.Input['SyntheticsTestMobileOptionsListArgs']]:
        return pulumi.get(self, "mobile_options_list")

    @mobile_options_list.setter
    def mobile_options_list(self, value: Optional[pulumi.Input['SyntheticsTestMobileOptionsListArgs']]):
        pulumi.set(self, "mobile_options_list", value)

    @_builtins.property
    @pulumi.getter(name="mobileSteps")
    def mobile_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]]]:
        """
        Steps for mobile tests
        """
        return pulumi.get(self, "mobile_steps")

    @mobile_steps.setter
    def mobile_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestMobileStepArgs']]]]):
        pulumi.set(self, "mobile_steps", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the monitor associated with the Datadog synthetics test.
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Datadog synthetics test.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionsList")
    def options_list(self) -> Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]:
        return pulumi.get(self, "options_list")

    @options_list.setter
    def options_list(self, value: Optional[pulumi.Input['SyntheticsTestOptionsListArgs']]):
        pulumi.set(self, "options_list", value)

    @_builtins.property
    @pulumi.getter(name="requestBasicauth")
    def request_basicauth(self) -> Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]:
        """
        The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_basicauth")

    @request_basicauth.setter
    def request_basicauth(self, value: Optional[pulumi.Input['SyntheticsTestRequestBasicauthArgs']]):
        pulumi.set(self, "request_basicauth", value)

    @_builtins.property
    @pulumi.getter(name="requestClientCertificate")
    def request_client_certificate(self) -> Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]:
        """
        Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_client_certificate")

    @request_client_certificate.setter
    def request_client_certificate(self, value: Optional[pulumi.Input['SyntheticsTestRequestClientCertificateArgs']]):
        pulumi.set(self, "request_client_certificate", value)

    @_builtins.property
    @pulumi.getter(name="requestDefinition")
    def request_definition(self) -> Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]:
        """
        Required if `type = "api"`. The synthetics test request.
        """
        return pulumi.get(self, "request_definition")

    @request_definition.setter
    def request_definition(self, value: Optional[pulumi.Input['SyntheticsTestRequestDefinitionArgs']]):
        pulumi.set(self, "request_definition", value)

    @_builtins.property
    @pulumi.getter(name="requestFiles")
    def request_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]:
        """
        Files to be used as part of the request in the test.
        """
        return pulumi.get(self, "request_files")

    @request_files.setter
    def request_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticsTestRequestFileArgs']]]]):
        pulumi.set(self, "request_files", value)

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Header name and value map.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_headers", value)

    @_builtins.property
    @pulumi.getter(name="requestMetadata")
    def request_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata to include when performing the gRPC request.
        """
        return pulumi.get(self, "request_metadata")

    @request_metadata.setter
    def request_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_metadata", value)

    @_builtins.property
    @pulumi.getter(name="requestProxy")
    def request_proxy(self) -> Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]:
        """
        The proxy to perform the test.
        """
        return pulumi.get(self, "request_proxy")

    @request_proxy.setter
    def request_proxy(self, value: Optional[pulumi.Input['SyntheticsTestRequestProxyArgs']]):
        pulumi.set(self, "request_proxy", value)

    @_builtins.property
    @pulumi.getter(name="requestQuery")
    def request_query(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Query arguments name and value map.
        """
        return pulumi.get(self, "request_query")

    @request_query.setter
    def request_query(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_query", value)

    @_builtins.property
    @pulumi.getter(name="setCookie")
    def set_cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        """
        return pulumi.get(self, "set_cookie")

    @set_cookie.setter
    def set_cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "set_cookie", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def subtype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        """
        return pulumi.get(self, "subtype")

    @subtype.setter
    def subtype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subtype", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Synthetics test type. Valid values are `api`, `browser`, `mobile`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="variablesFromScript")
    def variables_from_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variables defined from JavaScript code for API HTTP tests.
        """
        return pulumi.get(self, "variables_from_script")

    @variables_from_script.setter
    def variables_from_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variables_from_script", value)


@pulumi.type_token("datadog:index/syntheticsTest:SyntheticsTest")
class SyntheticsTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestApiStepArgs', 'SyntheticsTestApiStepArgsDict']]]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestAssertionArgs', 'SyntheticsTestAssertionArgsDict']]]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserStepArgs', 'SyntheticsTestBrowserStepArgsDict']]]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserVariableArgs', 'SyntheticsTestBrowserVariableArgsDict']]]]] = None,
                 config_initial_application_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestConfigVariableArgs', 'SyntheticsTestConfigVariableArgsDict']]]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[_builtins.bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_options_list: Optional[pulumi.Input[Union['SyntheticsTestMobileOptionsListArgs', 'SyntheticsTestMobileOptionsListArgsDict']]] = None,
                 mobile_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestMobileStepArgs', 'SyntheticsTestMobileStepArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options_list: Optional[pulumi.Input[Union['SyntheticsTestOptionsListArgs', 'SyntheticsTestOptionsListArgsDict']]] = None,
                 request_basicauth: Optional[pulumi.Input[Union['SyntheticsTestRequestBasicauthArgs', 'SyntheticsTestRequestBasicauthArgsDict']]] = None,
                 request_client_certificate: Optional[pulumi.Input[Union['SyntheticsTestRequestClientCertificateArgs', 'SyntheticsTestRequestClientCertificateArgsDict']]] = None,
                 request_definition: Optional[pulumi.Input[Union['SyntheticsTestRequestDefinitionArgs', 'SyntheticsTestRequestDefinitionArgsDict']]] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestRequestFileArgs', 'SyntheticsTestRequestFileArgsDict']]]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_proxy: Optional[pulumi.Input[Union['SyntheticsTestRequestProxyArgs', 'SyntheticsTestRequestProxyArgsDict']]] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 set_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subtype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 variables_from_script: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog synthetics test resource. This can be used to create and manage Datadog synthetics test.

        #### *Warning*
        Starting from version 3.1.0+, the direct usage of global variables in the configuration is deprecated, in favor of
        local variables of type `global`. As an example, if you were previously using `{{ GLOBAL_VAR }}` directly in your
        configuration, add a `config_variable` of type `global` with the `id` matching the `id` of the global variable `GLOBAL_VAR`, which can be found in the Synthetics UI or from the output of the `SyntheticsGlobalVariable` resource. The name can be chosen freely.

        In practice, it means going from (simplified configuration):

        to

        which you can now use in your request definition:

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_datadog as datadog

        # Example Usage (Synthetics API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_uptime = datadog.SyntheticsTest("test_uptime",
            name="An Uptime test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "method": "GET",
                "url": "https://www.example.org",
            },
            request_headers={
                "Content-Type": "application/json",
            },
            assertions=[{
                "type": "statusCode",
                "operator": "is",
                "target": "200",
            }],
            options_list={
                "tick_every": 900,
                "retry": {
                    "count": 2,
                    "interval": 300,
                },
                "monitor_options": {
                    "renotify_interval": 120,
                },
            })
        # Example Usage (Authenticated API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_api = datadog.SyntheticsTest("test_api",
            name="An API test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "method": "GET",
                "url": "https://www.example.org",
            },
            request_headers={
                "Content-Type": "application/json",
                "Authentication": "Token: 1234566789",
            },
            assertions=[{
                "type": "statusCode",
                "operator": "is",
                "target": "200",
            }],
            options_list={
                "tick_every": 900,
                "retry": {
                    "count": 2,
                    "interval": 300,
                },
                "monitor_options": {
                    "renotify_interval": 120,
                    "escalation_message": "test escalation message",
                },
            })
        # Example Usage (Synthetics SSL test)
        # Create a new Datadog Synthetics API/SSL test on example.org
        test_ssl = datadog.SyntheticsTest("test_ssl",
            name="An API test on example.org",
            type="api",
            subtype="ssl",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
            },
            assertions=[{
                "type": "certificate",
                "operator": "isInMoreThan",
                "target": "30",
            }],
            options_list={
                "tick_every": 900,
                "accept_self_signed": True,
            })
        # Example Usage (Synthetics TCP test)
        # Create a new Datadog Synthetics API/TCP test on example.org
        test_tcp = datadog.SyntheticsTest("test_tcp",
            name="An API test on example.org",
            type="api",
            subtype="tcp",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
            },
            assertions=[{
                "type": "responseTime",
                "operator": "lessThan",
                "target": "2000",
            }],
            config_variables=[{
                "type": "global",
                "name": "MY_GLOBAL_VAR",
                "id": "76636cd1-82e2-4aeb-9cfe-51366a8198a2",
            }],
            options_list={
                "tick_every": 900,
            })
        # Example Usage (Synthetics DNS test)
        # Create a new Datadog Synthetics API/DNS test on example.org
        test_dns = datadog.SyntheticsTest("test_dns",
            name="An API test on example.org",
            type="api",
            subtype="dns",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
            },
            assertions=[{
                "type": "recordSome",
                "operator": "is",
                "property": "A",
                "target": "0.0.0.0",
            }],
            options_list={
                "tick_every": 900,
            })
        # Example Usage (Synthetics ICMP test)
        # Create a new Datadog Synthetics ICMP test on example.org
        test_api_icmp = datadog.SyntheticsTest("test_api_icmp",
            name="ICMP Test on example.com",
            type="api",
            subtype="icmp",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.com",
                "no_saving_response_body": False,
                "number_of_packets": 1,
                "persist_cookies": False,
                "should_track_hops": False,
                "timeout": 0,
            },
            assertions=[
                {
                    "operator": "is",
                    "target": "0",
                    "type": "packetLossPercentage",
                },
                {
                    "operator": "lessThan",
                    "property": "avg",
                    "target": "1000",
                    "type": "latency",
                },
                {
                    "operator": "moreThanOrEqual",
                    "target": "1",
                    "type": "packetsReceived",
                },
            ],
            options_list={
                "tick_every": 900,
                "retry": {
                    "count": 2,
                    "interval": 300,
                },
                "monitor_options": {
                    "renotify_interval": 120,
                },
            })
        # Example Usage (Synthetics Multistep API test)
        # Create a new Datadog Synthetics Multistep API test
        test_multi_step = datadog.SyntheticsTest("test_multi_step",
            name="Multistep API test",
            type="api",
            subtype="multi",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            api_steps=[
                {
                    "name": "An API test on example.org",
                    "subtype": "http",
                    "assertions": [{
                        "type": "statusCode",
                        "operator": "is",
                        "target": "200",
                    }],
                    "request_definition": {
                        "method": "GET",
                        "url": "https://www.example.org",
                    },
                    "request_headers": {
                        "Content-Type": "application/json",
                        "Authentication": "Token: 1234566789",
                    },
                },
                {
                    "name": "An API test on example.org",
                    "subtype": "http",
                    "assertions": [{
                        "type": "statusCode",
                        "operator": "is",
                        "target": "200",
                    }],
                    "request_definition": {
                        "method": "GET",
                        "url": "http://example.org",
                    },
                },
                {
                    "name": "A gRPC health check on example.org",
                    "subtype": "grpc",
                    "assertions": [{
                        "type": "grpcMetadata",
                        "operator": "is",
                        "property": "X-Header",
                        "target": "test",
                    }],
                    "request_definition": {
                        "host": "example.org",
                        "port": "443",
                        "call_type": "healthcheck",
                        "service": "greeter.Greeter",
                    },
                },
                {
                    "name": "A gRPC behavior check on example.org",
                    "subtype": "grpc",
                    "assertions": [{
                        "type": "grpcHealthcheckStatus",
                        "operator": "is",
                        "target": "1",
                    }],
                    "request_definition": {
                        "host": "example.org",
                        "port": "443",
                        "call_type": "unary",
                        "service": "greeter.Greeter",
                        "method": "SayHello",
                        "message": "{\\"name\\": \\"John\\"}",
                        "plain_proto_file": \"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
                    },
                },
            ],
            options_list={
                "tick_every": 900,
                "accept_self_signed": True,
            })
        # Example Usage (Synthetics Browser test)
        # Create a new Datadog Synthetics Browser test starting on https://www.example.org
        test_browser = datadog.SyntheticsTest("test_browser",
            name="A Browser test on example.org",
            type="browser",
            status="paused",
            message="Notify @qa",
            device_ids=["laptop_large"],
            locations=["aws:eu-central-1"],
            tags=[],
            request_definition={
                "method": "GET",
                "url": "https://www.example.org",
            },
            browser_steps=[
                {
                    "name": "Check current url",
                    "type": "assertCurrentUrl",
                    "params": {
                        "check": "contains",
                        "value": "datadoghq",
                    },
                },
                {
                    "name": "Test a downloaded file",
                    "type": "assertFileDownload",
                    "params": {
                        "file": json.dumps({
                            "md5": "abcdef1234567890",
                            "sizeCheck": {
                                "type": "equals",
                                "value": 1,
                            },
                            "nameCheck": {
                                "type": "contains",
                                "value": ".xls",
                            },
                        }),
                    },
                },
                {
                    "name": "Upload a file",
                    "type": "uploadFiles",
                    "params": {
                        "files": json.dumps([{
                            "name": "hello.txt",
                            "size": 11,
                            "content": "Hello world",
                        }]),
                        "element_user_locator": {
                            "value": {
                                "type": "css",
                                "value": "#simple-file-upload",
                            },
                        },
                        "element": json.dumps({
                            "userLocator": {
                                "failTestOnCannotLocate": True,
                                "values": [{
                                    "type": "css",
                                    "value": "#simple-file-upload",
                                }],
                            },
                        }),
                    },
                },
                {
                    "name": "Test sending http requests",
                    "type": "assertRequests",
                    "params": {
                        "requests": json.dumps({
                            "count": {
                                "type": "equals",
                                "value": 1,
                            },
                            "url": "https://www.example.org",
                        }),
                    },
                },
            ],
            browser_variables=[
                {
                    "type": "text",
                    "name": "MY_PATTERN_VAR",
                    "pattern": "{{numeric(3)}}",
                    "example": "597",
                },
                {
                    "type": "email",
                    "name": "MY_EMAIL_VAR",
                    "pattern": "jd8-afe-ydv.{{ numeric(10) }}@synthetics.dtdg.co",
                    "example": "jd8-afe-ydv.4546132139@synthetics.dtdg.co",
                },
                {
                    "type": "global",
                    "name": "MY_GLOBAL_VAR",
                    "id": "76636cd1-82e2-4aeb-9cfe-51366a8198a2",
                },
            ],
            options_list={
                "tick_every": 3600,
            })
        # Example Usage (Synthetics Mobile test)
        # Create a new Datadog Synthetics Mobile test starting on https://www.example.org
        test_mobile = datadog.SyntheticsTest("test_mobile",
            type="mobile",
            name="A Mobile test on example.org",
            status="paused",
            message="Notify @datadog.user",
            tags=[
                "foo:bar",
                "baz",
            ],
            config_variables=[{
                "example": "123",
                "name": "VARIABLE_NAME",
                "pattern": "{{numeric(3)}}",
                "type": "text",
                "secure": False,
            }],
            config_initial_application_arguments={
                "test_process_argument": "test1",
            },
            device_ids=["synthetics:mobile:device:apple_iphone_14_plus_ios_16"],
            locations=["aws:eu-central-1"],
            mobile_options_list={
                "min_failure_duration": 0,
                "retry": {
                    "count": 0,
                    "interval": 300,
                },
                "tick_every": 43200,
                "scheduling": {
                    "timeframes": [
                        {
                            "day": 5,
                            "from_": "07:00",
                            "to": "16:00",
                        },
                        {
                            "day": 7,
                            "from_": "07:00",
                            "to": "16:00",
                        },
                    ],
                    "timezone": "UTC",
                },
                "monitor_name": "mobile-test-monitor",
                "monitor_options": {
                    "renotify_interval": 10,
                    "escalation_message": "test escalation message",
                    "renotify_occurrences": 3,
                    "notification_preset_name": "show_all",
                },
                "monitor_priority": 5,
                "ci": {
                    "execution_rule": "blocking",
                },
                "default_step_timeout": 10,
                "device_ids": ["synthetics:mobile:device:apple_iphone_14_plus_ios_16"],
                "no_screenshot": True,
                "allow_application_crash": False,
                "disable_auto_accept_alert": True,
                "mobile_application": {
                    "application_id": "5f055d15-0000-aaaa-zzzz-6739f83346aa",
                    "reference_id": "434d4719-0000-aaaa-zzzz-31082b544718",
                    "reference_type": "version",
                },
            },
            mobile_steps=[
                {
                    "name": "Tap on StaticText \\"Tap\\"",
                    "params": {
                        "element": {
                            "context": "NATIVE_APP",
                            "view_name": "StaticText",
                            "context_type": "native",
                            "text_content": "Tap",
                            "multi_locator": {},
                            "relative_position": {
                                "x": 0.07256155303030302,
                                "y": 0.41522381756756754,
                            },
                            "user_locator": {
                                "fail_test_on_cannot_locate": False,
                                "values": [{
                                    "type": "id",
                                    "value": "some_id",
                                }],
                            },
                            "element_description": "<XCUIElementTypeStaticText value=\\"Tap\\" name=\\"Tap\\" label=\\"Tap\\">",
                        },
                    },
                    "timeout": 100,
                    "type": "tap",
                    "allow_failure": False,
                    "is_critical": True,
                    "no_screenshot": False,
                    "has_new_step_element": False,
                },
                {
                    "name": "Test View \\"Tap\\" content",
                    "params": {
                        "check": "contains",
                        "value": "Tap",
                        "element": {
                            "context": "NATIVE_APP",
                            "view_name": "View",
                            "context_type": "native",
                            "text_content": "Tap",
                            "multi_locator": {},
                            "relative_position": {
                                "x": 0.27660448306074764,
                                "y": 0.6841517857142857,
                            },
                            "user_locator": {
                                "fail_test_on_cannot_locate": False,
                                "values": [{
                                    "type": "id",
                                    "value": "some_id",
                                }],
                            },
                            "element_description": "<XCUIElementTypeOther name=\\"Tap\\" label=\\"Tap\\">",
                        },
                    },
                    "timeout": 100,
                    "type": "assertElementContent",
                    "allow_failure": False,
                    "is_critical": True,
                    "no_screenshot": False,
                    "has_new_step_element": False,
                },
            ])
        # Example Usage (GRPC API behavior check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # targeting service `greeter.Greeter` with the method `SayHello`
        # and the message {"name": "John"}
        test_grpc_unary = datadog.SyntheticsTest("test_grpc_unary",
            name="GRPC API behavior check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
                "call_type": "unary",
                "service": "greeter.Greeter",
                "method": "SayHello",
                "message": "{\\"name\\": \\"John\\"}",
                "plain_proto_file": \"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
            },
            request_metadata={
                "header": "value",
            },
            assertions=[
                {
                    "type": "responseTime",
                    "operator": "lessThan",
                    "target": "2000",
                },
                {
                    "operator": "is",
                    "type": "grpcHealthcheckStatus",
                    "target": "1",
                },
                {
                    "operator": "is",
                    "type": "grpcProto",
                    "target": "proto target",
                },
                {
                    "operator": "is",
                    "property": "property",
                    "type": "grpcMetadata",
                    "target": "123",
                },
            ],
            options_list={
                "tick_every": 900,
            })
        # Example Usage (GRPC API health check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # testing the overall health of the service
        test_grpc_health = datadog.SyntheticsTest("test_grpc_health",
            name="GRPC API health check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
                "call_type": "healthcheck",
                "service": "greeter.Greeter",
            },
            assertions=[
                {
                    "type": "responseTime",
                    "operator": "lessThan",
                    "target": "2000",
                },
                {
                    "operator": "is",
                    "type": "grpcHealthcheckStatus",
                    "target": "1",
                },
            ],
            options_list={
                "tick_every": 900,
            })
        ```

        ## Import

        Synthetics tests can be imported using their public string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsTest:SyntheticsTest fizz abc-123-xyz
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestApiStepArgs', 'SyntheticsTestApiStepArgsDict']]]] api_steps: Steps for multistep API tests
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestAssertionArgs', 'SyntheticsTestAssertionArgsDict']]]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserStepArgs', 'SyntheticsTestBrowserStepArgsDict']]]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserVariableArgs', 'SyntheticsTestBrowserVariableArgsDict']]]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_initial_application_arguments: Initial application arguments for the mobile test.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestConfigVariableArgs', 'SyntheticsTestConfigVariableArgsDict']]]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test.
        :param pulumi.Input[_builtins.bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations or find the possible values listed in [this API response](https://app.datadoghq.com/api/v1/synthetics/locations?only_public=true).
        :param pulumi.Input[_builtins.str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestMobileStepArgs', 'SyntheticsTestMobileStepArgsDict']]]] mobile_steps: Steps for mobile tests
        :param pulumi.Input[_builtins.str] name: Name of Datadog synthetics test.
        :param pulumi.Input[Union['SyntheticsTestRequestBasicauthArgs', 'SyntheticsTestRequestBasicauthArgsDict']] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[Union['SyntheticsTestRequestClientCertificateArgs', 'SyntheticsTestRequestClientCertificateArgsDict']] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[Union['SyntheticsTestRequestDefinitionArgs', 'SyntheticsTestRequestDefinitionArgsDict']] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestRequestFileArgs', 'SyntheticsTestRequestFileArgsDict']]]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input[Union['SyntheticsTestRequestProxyArgs', 'SyntheticsTestRequestProxyArgsDict']] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_query: Query arguments name and value map.
        :param pulumi.Input[_builtins.str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[_builtins.str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[_builtins.str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[_builtins.str] type: Synthetics test type. Valid values are `api`, `browser`, `mobile`.
        :param pulumi.Input[_builtins.str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticsTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog synthetics test resource. This can be used to create and manage Datadog synthetics test.

        #### *Warning*
        Starting from version 3.1.0+, the direct usage of global variables in the configuration is deprecated, in favor of
        local variables of type `global`. As an example, if you were previously using `{{ GLOBAL_VAR }}` directly in your
        configuration, add a `config_variable` of type `global` with the `id` matching the `id` of the global variable `GLOBAL_VAR`, which can be found in the Synthetics UI or from the output of the `SyntheticsGlobalVariable` resource. The name can be chosen freely.

        In practice, it means going from (simplified configuration):

        to

        which you can now use in your request definition:

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_datadog as datadog

        # Example Usage (Synthetics API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_uptime = datadog.SyntheticsTest("test_uptime",
            name="An Uptime test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "method": "GET",
                "url": "https://www.example.org",
            },
            request_headers={
                "Content-Type": "application/json",
            },
            assertions=[{
                "type": "statusCode",
                "operator": "is",
                "target": "200",
            }],
            options_list={
                "tick_every": 900,
                "retry": {
                    "count": 2,
                    "interval": 300,
                },
                "monitor_options": {
                    "renotify_interval": 120,
                },
            })
        # Example Usage (Authenticated API test)
        # Create a new Datadog Synthetics API/HTTP test on https://www.example.org
        test_api = datadog.SyntheticsTest("test_api",
            name="An API test on example.org",
            type="api",
            subtype="http",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "method": "GET",
                "url": "https://www.example.org",
            },
            request_headers={
                "Content-Type": "application/json",
                "Authentication": "Token: 1234566789",
            },
            assertions=[{
                "type": "statusCode",
                "operator": "is",
                "target": "200",
            }],
            options_list={
                "tick_every": 900,
                "retry": {
                    "count": 2,
                    "interval": 300,
                },
                "monitor_options": {
                    "renotify_interval": 120,
                    "escalation_message": "test escalation message",
                },
            })
        # Example Usage (Synthetics SSL test)
        # Create a new Datadog Synthetics API/SSL test on example.org
        test_ssl = datadog.SyntheticsTest("test_ssl",
            name="An API test on example.org",
            type="api",
            subtype="ssl",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
            },
            assertions=[{
                "type": "certificate",
                "operator": "isInMoreThan",
                "target": "30",
            }],
            options_list={
                "tick_every": 900,
                "accept_self_signed": True,
            })
        # Example Usage (Synthetics TCP test)
        # Create a new Datadog Synthetics API/TCP test on example.org
        test_tcp = datadog.SyntheticsTest("test_tcp",
            name="An API test on example.org",
            type="api",
            subtype="tcp",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
            },
            assertions=[{
                "type": "responseTime",
                "operator": "lessThan",
                "target": "2000",
            }],
            config_variables=[{
                "type": "global",
                "name": "MY_GLOBAL_VAR",
                "id": "76636cd1-82e2-4aeb-9cfe-51366a8198a2",
            }],
            options_list={
                "tick_every": 900,
            })
        # Example Usage (Synthetics DNS test)
        # Create a new Datadog Synthetics API/DNS test on example.org
        test_dns = datadog.SyntheticsTest("test_dns",
            name="An API test on example.org",
            type="api",
            subtype="dns",
            status="live",
            message="Notify @pagerduty",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
            },
            assertions=[{
                "type": "recordSome",
                "operator": "is",
                "property": "A",
                "target": "0.0.0.0",
            }],
            options_list={
                "tick_every": 900,
            })
        # Example Usage (Synthetics ICMP test)
        # Create a new Datadog Synthetics ICMP test on example.org
        test_api_icmp = datadog.SyntheticsTest("test_api_icmp",
            name="ICMP Test on example.com",
            type="api",
            subtype="icmp",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.com",
                "no_saving_response_body": False,
                "number_of_packets": 1,
                "persist_cookies": False,
                "should_track_hops": False,
                "timeout": 0,
            },
            assertions=[
                {
                    "operator": "is",
                    "target": "0",
                    "type": "packetLossPercentage",
                },
                {
                    "operator": "lessThan",
                    "property": "avg",
                    "target": "1000",
                    "type": "latency",
                },
                {
                    "operator": "moreThanOrEqual",
                    "target": "1",
                    "type": "packetsReceived",
                },
            ],
            options_list={
                "tick_every": 900,
                "retry": {
                    "count": 2,
                    "interval": 300,
                },
                "monitor_options": {
                    "renotify_interval": 120,
                },
            })
        # Example Usage (Synthetics Multistep API test)
        # Create a new Datadog Synthetics Multistep API test
        test_multi_step = datadog.SyntheticsTest("test_multi_step",
            name="Multistep API test",
            type="api",
            subtype="multi",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            api_steps=[
                {
                    "name": "An API test on example.org",
                    "subtype": "http",
                    "assertions": [{
                        "type": "statusCode",
                        "operator": "is",
                        "target": "200",
                    }],
                    "request_definition": {
                        "method": "GET",
                        "url": "https://www.example.org",
                    },
                    "request_headers": {
                        "Content-Type": "application/json",
                        "Authentication": "Token: 1234566789",
                    },
                },
                {
                    "name": "An API test on example.org",
                    "subtype": "http",
                    "assertions": [{
                        "type": "statusCode",
                        "operator": "is",
                        "target": "200",
                    }],
                    "request_definition": {
                        "method": "GET",
                        "url": "http://example.org",
                    },
                },
                {
                    "name": "A gRPC health check on example.org",
                    "subtype": "grpc",
                    "assertions": [{
                        "type": "grpcMetadata",
                        "operator": "is",
                        "property": "X-Header",
                        "target": "test",
                    }],
                    "request_definition": {
                        "host": "example.org",
                        "port": "443",
                        "call_type": "healthcheck",
                        "service": "greeter.Greeter",
                    },
                },
                {
                    "name": "A gRPC behavior check on example.org",
                    "subtype": "grpc",
                    "assertions": [{
                        "type": "grpcHealthcheckStatus",
                        "operator": "is",
                        "target": "1",
                    }],
                    "request_definition": {
                        "host": "example.org",
                        "port": "443",
                        "call_type": "unary",
                        "service": "greeter.Greeter",
                        "method": "SayHello",
                        "message": "{\\"name\\": \\"John\\"}",
                        "plain_proto_file": \"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
                    },
                },
            ],
            options_list={
                "tick_every": 900,
                "accept_self_signed": True,
            })
        # Example Usage (Synthetics Browser test)
        # Create a new Datadog Synthetics Browser test starting on https://www.example.org
        test_browser = datadog.SyntheticsTest("test_browser",
            name="A Browser test on example.org",
            type="browser",
            status="paused",
            message="Notify @qa",
            device_ids=["laptop_large"],
            locations=["aws:eu-central-1"],
            tags=[],
            request_definition={
                "method": "GET",
                "url": "https://www.example.org",
            },
            browser_steps=[
                {
                    "name": "Check current url",
                    "type": "assertCurrentUrl",
                    "params": {
                        "check": "contains",
                        "value": "datadoghq",
                    },
                },
                {
                    "name": "Test a downloaded file",
                    "type": "assertFileDownload",
                    "params": {
                        "file": json.dumps({
                            "md5": "abcdef1234567890",
                            "sizeCheck": {
                                "type": "equals",
                                "value": 1,
                            },
                            "nameCheck": {
                                "type": "contains",
                                "value": ".xls",
                            },
                        }),
                    },
                },
                {
                    "name": "Upload a file",
                    "type": "uploadFiles",
                    "params": {
                        "files": json.dumps([{
                            "name": "hello.txt",
                            "size": 11,
                            "content": "Hello world",
                        }]),
                        "element_user_locator": {
                            "value": {
                                "type": "css",
                                "value": "#simple-file-upload",
                            },
                        },
                        "element": json.dumps({
                            "userLocator": {
                                "failTestOnCannotLocate": True,
                                "values": [{
                                    "type": "css",
                                    "value": "#simple-file-upload",
                                }],
                            },
                        }),
                    },
                },
                {
                    "name": "Test sending http requests",
                    "type": "assertRequests",
                    "params": {
                        "requests": json.dumps({
                            "count": {
                                "type": "equals",
                                "value": 1,
                            },
                            "url": "https://www.example.org",
                        }),
                    },
                },
            ],
            browser_variables=[
                {
                    "type": "text",
                    "name": "MY_PATTERN_VAR",
                    "pattern": "{{numeric(3)}}",
                    "example": "597",
                },
                {
                    "type": "email",
                    "name": "MY_EMAIL_VAR",
                    "pattern": "jd8-afe-ydv.{{ numeric(10) }}@synthetics.dtdg.co",
                    "example": "jd8-afe-ydv.4546132139@synthetics.dtdg.co",
                },
                {
                    "type": "global",
                    "name": "MY_GLOBAL_VAR",
                    "id": "76636cd1-82e2-4aeb-9cfe-51366a8198a2",
                },
            ],
            options_list={
                "tick_every": 3600,
            })
        # Example Usage (Synthetics Mobile test)
        # Create a new Datadog Synthetics Mobile test starting on https://www.example.org
        test_mobile = datadog.SyntheticsTest("test_mobile",
            type="mobile",
            name="A Mobile test on example.org",
            status="paused",
            message="Notify @datadog.user",
            tags=[
                "foo:bar",
                "baz",
            ],
            config_variables=[{
                "example": "123",
                "name": "VARIABLE_NAME",
                "pattern": "{{numeric(3)}}",
                "type": "text",
                "secure": False,
            }],
            config_initial_application_arguments={
                "test_process_argument": "test1",
            },
            device_ids=["synthetics:mobile:device:apple_iphone_14_plus_ios_16"],
            locations=["aws:eu-central-1"],
            mobile_options_list={
                "min_failure_duration": 0,
                "retry": {
                    "count": 0,
                    "interval": 300,
                },
                "tick_every": 43200,
                "scheduling": {
                    "timeframes": [
                        {
                            "day": 5,
                            "from_": "07:00",
                            "to": "16:00",
                        },
                        {
                            "day": 7,
                            "from_": "07:00",
                            "to": "16:00",
                        },
                    ],
                    "timezone": "UTC",
                },
                "monitor_name": "mobile-test-monitor",
                "monitor_options": {
                    "renotify_interval": 10,
                    "escalation_message": "test escalation message",
                    "renotify_occurrences": 3,
                    "notification_preset_name": "show_all",
                },
                "monitor_priority": 5,
                "ci": {
                    "execution_rule": "blocking",
                },
                "default_step_timeout": 10,
                "device_ids": ["synthetics:mobile:device:apple_iphone_14_plus_ios_16"],
                "no_screenshot": True,
                "allow_application_crash": False,
                "disable_auto_accept_alert": True,
                "mobile_application": {
                    "application_id": "5f055d15-0000-aaaa-zzzz-6739f83346aa",
                    "reference_id": "434d4719-0000-aaaa-zzzz-31082b544718",
                    "reference_type": "version",
                },
            },
            mobile_steps=[
                {
                    "name": "Tap on StaticText \\"Tap\\"",
                    "params": {
                        "element": {
                            "context": "NATIVE_APP",
                            "view_name": "StaticText",
                            "context_type": "native",
                            "text_content": "Tap",
                            "multi_locator": {},
                            "relative_position": {
                                "x": 0.07256155303030302,
                                "y": 0.41522381756756754,
                            },
                            "user_locator": {
                                "fail_test_on_cannot_locate": False,
                                "values": [{
                                    "type": "id",
                                    "value": "some_id",
                                }],
                            },
                            "element_description": "<XCUIElementTypeStaticText value=\\"Tap\\" name=\\"Tap\\" label=\\"Tap\\">",
                        },
                    },
                    "timeout": 100,
                    "type": "tap",
                    "allow_failure": False,
                    "is_critical": True,
                    "no_screenshot": False,
                    "has_new_step_element": False,
                },
                {
                    "name": "Test View \\"Tap\\" content",
                    "params": {
                        "check": "contains",
                        "value": "Tap",
                        "element": {
                            "context": "NATIVE_APP",
                            "view_name": "View",
                            "context_type": "native",
                            "text_content": "Tap",
                            "multi_locator": {},
                            "relative_position": {
                                "x": 0.27660448306074764,
                                "y": 0.6841517857142857,
                            },
                            "user_locator": {
                                "fail_test_on_cannot_locate": False,
                                "values": [{
                                    "type": "id",
                                    "value": "some_id",
                                }],
                            },
                            "element_description": "<XCUIElementTypeOther name=\\"Tap\\" label=\\"Tap\\">",
                        },
                    },
                    "timeout": 100,
                    "type": "assertElementContent",
                    "allow_failure": False,
                    "is_critical": True,
                    "no_screenshot": False,
                    "has_new_step_element": False,
                },
            ])
        # Example Usage (GRPC API behavior check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # targeting service `greeter.Greeter` with the method `SayHello`
        # and the message {"name": "John"}
        test_grpc_unary = datadog.SyntheticsTest("test_grpc_unary",
            name="GRPC API behavior check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
                "call_type": "unary",
                "service": "greeter.Greeter",
                "method": "SayHello",
                "message": "{\\"name\\": \\"John\\"}",
                "plain_proto_file": \"\"\"syntax = "proto3";

        package greeter;

        // The greeting service definition.
        service Greeter {
          // Sends a greeting
          rpc SayHello (HelloRequest) returns (HelloReply) {}
        }

        // The request message containing the user's name.
        message HelloRequest {
          string name = 1;
        }

        // The response message containing the greetings
        message HelloReply {
          string message = 1;
        }
        \"\"\",
            },
            request_metadata={
                "header": "value",
            },
            assertions=[
                {
                    "type": "responseTime",
                    "operator": "lessThan",
                    "target": "2000",
                },
                {
                    "operator": "is",
                    "type": "grpcHealthcheckStatus",
                    "target": "1",
                },
                {
                    "operator": "is",
                    "type": "grpcProto",
                    "target": "proto target",
                },
                {
                    "operator": "is",
                    "property": "property",
                    "type": "grpcMetadata",
                    "target": "123",
                },
            ],
            options_list={
                "tick_every": 900,
            })
        # Example Usage (GRPC API health check test)
        # Create a new Datadog GRPC API test calling host example.org on port 443
        # testing the overall health of the service
        test_grpc_health = datadog.SyntheticsTest("test_grpc_health",
            name="GRPC API health check test",
            type="api",
            subtype="grpc",
            status="live",
            locations=["aws:eu-central-1"],
            tags=[
                "foo:bar",
                "foo",
                "env:test",
            ],
            request_definition={
                "host": "example.org",
                "port": "443",
                "call_type": "healthcheck",
                "service": "greeter.Greeter",
            },
            assertions=[
                {
                    "type": "responseTime",
                    "operator": "lessThan",
                    "target": "2000",
                },
                {
                    "operator": "is",
                    "type": "grpcHealthcheckStatus",
                    "target": "1",
                },
            ],
            options_list={
                "tick_every": 900,
            })
        ```

        ## Import

        Synthetics tests can be imported using their public string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsTest:SyntheticsTest fizz abc-123-xyz
        ```

        :param str resource_name: The name of the resource.
        :param SyntheticsTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticsTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestApiStepArgs', 'SyntheticsTestApiStepArgsDict']]]]] = None,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestAssertionArgs', 'SyntheticsTestAssertionArgsDict']]]]] = None,
                 browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserStepArgs', 'SyntheticsTestBrowserStepArgsDict']]]]] = None,
                 browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserVariableArgs', 'SyntheticsTestBrowserVariableArgsDict']]]]] = None,
                 config_initial_application_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestConfigVariableArgs', 'SyntheticsTestConfigVariableArgsDict']]]]] = None,
                 device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 force_delete_dependencies: Optional[pulumi.Input[_builtins.bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_options_list: Optional[pulumi.Input[Union['SyntheticsTestMobileOptionsListArgs', 'SyntheticsTestMobileOptionsListArgsDict']]] = None,
                 mobile_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestMobileStepArgs', 'SyntheticsTestMobileStepArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options_list: Optional[pulumi.Input[Union['SyntheticsTestOptionsListArgs', 'SyntheticsTestOptionsListArgsDict']]] = None,
                 request_basicauth: Optional[pulumi.Input[Union['SyntheticsTestRequestBasicauthArgs', 'SyntheticsTestRequestBasicauthArgsDict']]] = None,
                 request_client_certificate: Optional[pulumi.Input[Union['SyntheticsTestRequestClientCertificateArgs', 'SyntheticsTestRequestClientCertificateArgsDict']]] = None,
                 request_definition: Optional[pulumi.Input[Union['SyntheticsTestRequestDefinitionArgs', 'SyntheticsTestRequestDefinitionArgsDict']]] = None,
                 request_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestRequestFileArgs', 'SyntheticsTestRequestFileArgsDict']]]]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_proxy: Optional[pulumi.Input[Union['SyntheticsTestRequestProxyArgs', 'SyntheticsTestRequestProxyArgsDict']]] = None,
                 request_query: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 set_cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subtype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 variables_from_script: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticsTestArgs.__new__(SyntheticsTestArgs)

            __props__.__dict__["api_steps"] = api_steps
            __props__.__dict__["assertions"] = assertions
            __props__.__dict__["browser_steps"] = browser_steps
            __props__.__dict__["browser_variables"] = browser_variables
            __props__.__dict__["config_initial_application_arguments"] = config_initial_application_arguments
            __props__.__dict__["config_variables"] = config_variables
            __props__.__dict__["device_ids"] = device_ids
            __props__.__dict__["force_delete_dependencies"] = force_delete_dependencies
            if locations is None and not opts.urn:
                raise TypeError("Missing required property 'locations'")
            __props__.__dict__["locations"] = locations
            __props__.__dict__["message"] = message
            __props__.__dict__["mobile_options_list"] = mobile_options_list
            __props__.__dict__["mobile_steps"] = mobile_steps
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["options_list"] = options_list
            __props__.__dict__["request_basicauth"] = request_basicauth
            __props__.__dict__["request_client_certificate"] = request_client_certificate
            __props__.__dict__["request_definition"] = request_definition
            __props__.__dict__["request_files"] = request_files
            __props__.__dict__["request_headers"] = request_headers
            __props__.__dict__["request_metadata"] = request_metadata
            __props__.__dict__["request_proxy"] = request_proxy
            __props__.__dict__["request_query"] = request_query
            __props__.__dict__["set_cookie"] = set_cookie
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["subtype"] = subtype
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["variables_from_script"] = variables_from_script
            __props__.__dict__["monitor_id"] = None
        super(SyntheticsTest, __self__).__init__(
            'datadog:index/syntheticsTest:SyntheticsTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestApiStepArgs', 'SyntheticsTestApiStepArgsDict']]]]] = None,
            assertions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestAssertionArgs', 'SyntheticsTestAssertionArgsDict']]]]] = None,
            browser_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserStepArgs', 'SyntheticsTestBrowserStepArgsDict']]]]] = None,
            browser_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserVariableArgs', 'SyntheticsTestBrowserVariableArgsDict']]]]] = None,
            config_initial_application_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            config_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestConfigVariableArgs', 'SyntheticsTestConfigVariableArgsDict']]]]] = None,
            device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            force_delete_dependencies: Optional[pulumi.Input[_builtins.bool]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            mobile_options_list: Optional[pulumi.Input[Union['SyntheticsTestMobileOptionsListArgs', 'SyntheticsTestMobileOptionsListArgsDict']]] = None,
            mobile_steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestMobileStepArgs', 'SyntheticsTestMobileStepArgsDict']]]]] = None,
            monitor_id: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            options_list: Optional[pulumi.Input[Union['SyntheticsTestOptionsListArgs', 'SyntheticsTestOptionsListArgsDict']]] = None,
            request_basicauth: Optional[pulumi.Input[Union['SyntheticsTestRequestBasicauthArgs', 'SyntheticsTestRequestBasicauthArgsDict']]] = None,
            request_client_certificate: Optional[pulumi.Input[Union['SyntheticsTestRequestClientCertificateArgs', 'SyntheticsTestRequestClientCertificateArgsDict']]] = None,
            request_definition: Optional[pulumi.Input[Union['SyntheticsTestRequestDefinitionArgs', 'SyntheticsTestRequestDefinitionArgsDict']]] = None,
            request_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestRequestFileArgs', 'SyntheticsTestRequestFileArgsDict']]]]] = None,
            request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            request_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            request_proxy: Optional[pulumi.Input[Union['SyntheticsTestRequestProxyArgs', 'SyntheticsTestRequestProxyArgsDict']]] = None,
            request_query: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            set_cookie: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subtype: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            variables_from_script: Optional[pulumi.Input[_builtins.str]] = None) -> 'SyntheticsTest':
        """
        Get an existing SyntheticsTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestApiStepArgs', 'SyntheticsTestApiStepArgsDict']]]] api_steps: Steps for multistep API tests
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestAssertionArgs', 'SyntheticsTestAssertionArgsDict']]]] assertions: Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserStepArgs', 'SyntheticsTestBrowserStepArgsDict']]]] browser_steps: Steps for browser tests.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestBrowserVariableArgs', 'SyntheticsTestBrowserVariableArgsDict']]]] browser_variables: Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config_initial_application_arguments: Initial application arguments for the mobile test.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestConfigVariableArgs', 'SyntheticsTestConfigVariableArgsDict']]]] config_variables: Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_ids: Required if `type = "browser"`. Array with the different device IDs used to run the test.
        :param pulumi.Input[_builtins.bool] force_delete_dependencies: A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] locations: Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations or find the possible values listed in [this API response](https://app.datadoghq.com/api/v1/synthetics/locations?only_public=true).
        :param pulumi.Input[_builtins.str] message: A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestMobileStepArgs', 'SyntheticsTestMobileStepArgsDict']]]] mobile_steps: Steps for mobile tests
        :param pulumi.Input[_builtins.int] monitor_id: ID of the monitor associated with the Datadog synthetics test.
        :param pulumi.Input[_builtins.str] name: Name of Datadog synthetics test.
        :param pulumi.Input[Union['SyntheticsTestRequestBasicauthArgs', 'SyntheticsTestRequestBasicauthArgsDict']] request_basicauth: The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[Union['SyntheticsTestRequestClientCertificateArgs', 'SyntheticsTestRequestClientCertificateArgsDict']] request_client_certificate: Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        :param pulumi.Input[Union['SyntheticsTestRequestDefinitionArgs', 'SyntheticsTestRequestDefinitionArgsDict']] request_definition: Required if `type = "api"`. The synthetics test request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticsTestRequestFileArgs', 'SyntheticsTestRequestFileArgsDict']]]] request_files: Files to be used as part of the request in the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_headers: Header name and value map.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_metadata: Metadata to include when performing the gRPC request.
        :param pulumi.Input[Union['SyntheticsTestRequestProxyArgs', 'SyntheticsTestRequestProxyArgsDict']] request_proxy: The proxy to perform the test.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_query: Query arguments name and value map.
        :param pulumi.Input[_builtins.str] set_cookie: Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        :param pulumi.Input[_builtins.str] status: Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        :param pulumi.Input[_builtins.str] subtype: The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        :param pulumi.Input[_builtins.str] type: Synthetics test type. Valid values are `api`, `browser`, `mobile`.
        :param pulumi.Input[_builtins.str] variables_from_script: Variables defined from JavaScript code for API HTTP tests.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticsTestState.__new__(_SyntheticsTestState)

        __props__.__dict__["api_steps"] = api_steps
        __props__.__dict__["assertions"] = assertions
        __props__.__dict__["browser_steps"] = browser_steps
        __props__.__dict__["browser_variables"] = browser_variables
        __props__.__dict__["config_initial_application_arguments"] = config_initial_application_arguments
        __props__.__dict__["config_variables"] = config_variables
        __props__.__dict__["device_ids"] = device_ids
        __props__.__dict__["force_delete_dependencies"] = force_delete_dependencies
        __props__.__dict__["locations"] = locations
        __props__.__dict__["message"] = message
        __props__.__dict__["mobile_options_list"] = mobile_options_list
        __props__.__dict__["mobile_steps"] = mobile_steps
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["options_list"] = options_list
        __props__.__dict__["request_basicauth"] = request_basicauth
        __props__.__dict__["request_client_certificate"] = request_client_certificate
        __props__.__dict__["request_definition"] = request_definition
        __props__.__dict__["request_files"] = request_files
        __props__.__dict__["request_headers"] = request_headers
        __props__.__dict__["request_metadata"] = request_metadata
        __props__.__dict__["request_proxy"] = request_proxy
        __props__.__dict__["request_query"] = request_query
        __props__.__dict__["set_cookie"] = set_cookie
        __props__.__dict__["status"] = status
        __props__.__dict__["subtype"] = subtype
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["variables_from_script"] = variables_from_script
        return SyntheticsTest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiSteps")
    def api_steps(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestApiStep']]]:
        """
        Steps for multistep API tests
        """
        return pulumi.get(self, "api_steps")

    @_builtins.property
    @pulumi.getter
    def assertions(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestAssertion']]]:
        """
        Assertions used for the test. Multiple `assertion` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "assertions")

    @_builtins.property
    @pulumi.getter(name="browserSteps")
    def browser_steps(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestBrowserStep']]]:
        """
        Steps for browser tests.
        """
        return pulumi.get(self, "browser_steps")

    @_builtins.property
    @pulumi.getter(name="browserVariables")
    def browser_variables(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestBrowserVariable']]]:
        """
        Variables used for a browser test steps. Multiple `variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "browser_variables")

    @_builtins.property
    @pulumi.getter(name="configInitialApplicationArguments")
    def config_initial_application_arguments(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Initial application arguments for the mobile test.
        """
        return pulumi.get(self, "config_initial_application_arguments")

    @_builtins.property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestConfigVariable']]]:
        """
        Variables used for the test configuration. Multiple `config_variable` blocks are allowed with the structure below.
        """
        return pulumi.get(self, "config_variables")

    @_builtins.property
    @pulumi.getter(name="deviceIds")
    def device_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Required if `type = "browser"`. Array with the different device IDs used to run the test.
        """
        return pulumi.get(self, "device_ids")

    @_builtins.property
    @pulumi.getter(name="forceDeleteDependencies")
    def force_delete_dependencies(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean indicating whether this synthetics test can be deleted even if it's referenced by other resources (for example, SLOs and composite monitors).
        """
        return pulumi.get(self, "force_delete_dependencies")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Array of locations used to run the test. Refer to the Datadog Synthetics location data source to retrieve the list of locations or find the possible values listed in [this API response](https://app.datadoghq.com/api/v1/synthetics/locations?only_public=true).
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A message to include with notifications for this synthetics test. Email notifications can be sent to specific users by using the same `@username` notation as events. Defaults to `""`.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="mobileOptionsList")
    def mobile_options_list(self) -> pulumi.Output[Optional['outputs.SyntheticsTestMobileOptionsList']]:
        return pulumi.get(self, "mobile_options_list")

    @_builtins.property
    @pulumi.getter(name="mobileSteps")
    def mobile_steps(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestMobileStep']]]:
        """
        Steps for mobile tests
        """
        return pulumi.get(self, "mobile_steps")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[_builtins.int]:
        """
        ID of the monitor associated with the Datadog synthetics test.
        """
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of Datadog synthetics test.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optionsList")
    def options_list(self) -> pulumi.Output[Optional['outputs.SyntheticsTestOptionsList']]:
        return pulumi.get(self, "options_list")

    @_builtins.property
    @pulumi.getter(name="requestBasicauth")
    def request_basicauth(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestBasicauth']]:
        """
        The HTTP basic authentication credentials. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_basicauth")

    @_builtins.property
    @pulumi.getter(name="requestClientCertificate")
    def request_client_certificate(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestClientCertificate']]:
        """
        Client certificate to use when performing the test request. Exactly one nested block is allowed with the structure below.
        """
        return pulumi.get(self, "request_client_certificate")

    @_builtins.property
    @pulumi.getter(name="requestDefinition")
    def request_definition(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestDefinition']]:
        """
        Required if `type = "api"`. The synthetics test request.
        """
        return pulumi.get(self, "request_definition")

    @_builtins.property
    @pulumi.getter(name="requestFiles")
    def request_files(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticsTestRequestFile']]]:
        """
        Files to be used as part of the request in the test.
        """
        return pulumi.get(self, "request_files")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Header name and value map.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter(name="requestMetadata")
    def request_metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata to include when performing the gRPC request.
        """
        return pulumi.get(self, "request_metadata")

    @_builtins.property
    @pulumi.getter(name="requestProxy")
    def request_proxy(self) -> pulumi.Output[Optional['outputs.SyntheticsTestRequestProxy']]:
        """
        The proxy to perform the test.
        """
        return pulumi.get(self, "request_proxy")

    @_builtins.property
    @pulumi.getter(name="requestQuery")
    def request_query(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Query arguments name and value map.
        """
        return pulumi.get(self, "request_query")

    @_builtins.property
    @pulumi.getter(name="setCookie")
    def set_cookie(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
        """
        return pulumi.get(self, "set_cookie")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subtype(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`, `udp`, `websocket`, `grpc`.
        """
        return pulumi.get(self, "subtype")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags to associate with your synthetics test. This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Synthetics test type. Valid values are `api`, `browser`, `mobile`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="variablesFromScript")
    def variables_from_script(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variables defined from JavaScript code for API HTTP tests.
        """
        return pulumi.get(self, "variables_from_script")

