# Copyright 2025 The Meridian Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Helper functions and constants for Analysis module unit tests.

These constants are meant to be used in the end-to-end-like unit tests. They
were generated by running the model in a colab. The model was initialized with
random data (using seed=0), using same settings as the test Colab notebook.
"""

from collections.abc import Mapping, Sequence
import math
from xml import etree as et

from meridian import constants as c
import numpy as np
import pandas as pd
import xarray as xr


__all__ = []


INC_OUTCOME_MEDIA_AND_RF_USE_PRIOR = np.array([[
    [250.93, 914.95, 1488.56, 2499.96, 194.59],
    [323.77, 766.39, 499.36, 218.52, 536.27],
    [454.30, 381.87, 274.42, 812.97, 316.66],
    [216.75, 581.56, 565.30, 391.46, 161.34],
    [279.34, 2646.60, 2225.99, 454.78, 612.63],
    [421.48, 689.09, 408.15, 941.84, 114.84],
    [1383.32, 810.77, 511.27, 598.21, 283.58],
    [717.54, 192.93, 249.84, 240.15, 1106.14],
    [194.41, 55.73, 432.67, 126.29, 162.53],
    [252.09, 52.38, 297.78, 125.89, 226.06],
]])
INC_OUTCOME_MEDIA_AND_RF_USE_POSTERIOR = np.array([
    [
        [582.06, 636.00, 170.72, 131.45, 747.25],
        [576.95, 628.67, 171.09, 131.47, 761.42],
        [579.18, 635.11, 174.04, 132.01, 759.44],
        [565.29, 639.10, 177.51, 131.00, 754.27],
        [560.16, 635.52, 173.50, 131.34, 761.65],
        [558.92, 646.11, 176.58, 130.95, 746.63],
        [552.30, 657.84, 170.02, 130.94, 748.13],
        [560.61, 664.25, 171.13, 131.26, 740.95],
        [552.71, 659.69, 170.69, 130.04, 738.11],
        [553.07, 660.30, 170.71, 130.10, 738.35],
    ],
    [
        [79.00, 164.46, 53.80, 495.31, 159.67],
        [79.02, 164.46, 53.79, 495.32, 159.69],
        [79.02, 164.52, 53.80, 495.09, 159.11],
        [79.04, 164.57, 53.95, 494.78, 159.33],
        [78.69, 164.55, 53.93, 494.57, 159.17],
        [78.78, 164.59, 53.89, 494.68, 159.05],
        [79.10, 164.85, 53.85, 495.01, 159.23],
        [79.85, 164.75, 53.78, 495.48, 160.84],
        [79.86, 164.61, 53.71, 494.85, 160.99],
        [79.84, 164.81, 53.60, 495.19, 161.18],
    ],
])
INC_OUTCOME_MEDIA_AND_RF_NEW_PARAMS = np.array([
    [
        [105.49, 92.62, 30.55, 26.51, 124.33],
        [104.7, 91.55, 30.6, 26.54, 126.78],
        [105.12, 92.48, 31.07, 26.67, 126.47],
        [102.51, 93.13, 31.85, 26.56, 125.77],
        [101.57, 92.58, 31.17, 26.65, 127.0],
        [101.34, 94.11, 31.76, 26.53, 124.61],
        [100.07, 95.82, 30.45, 26.63, 124.95],
        [101.56, 96.78, 30.65, 26.71, 123.68],
        [100.19, 96.11, 30.56, 26.46, 123.28],
        [100.25, 96.2, 30.57, 26.48, 123.31],
    ],
    [
        [14.75, 30.32, 9.86, 97.02, 27.36],
        [14.75, 30.32, 9.86, 97.02, 27.37],
        [14.76, 30.32, 9.86, 97.01, 27.27],
        [14.76, 30.32, 9.86, 96.87, 27.31],
        [14.69, 30.32, 9.85, 96.88, 27.31],
        [14.7, 30.33, 9.85, 96.91, 27.29],
        [14.77, 30.34, 9.85, 96.84, 27.42],
        [14.89, 30.33, 9.83, 96.87, 27.7],
        [14.91, 30.29, 9.82, 96.85, 27.75],
        [14.91, 30.33, 9.8, 96.9, 27.78],
    ],
])
INC_OUTCOME_MEDIA_ONLY_NEW_PARAMS = np.array([
    [
        [70.79386, 887.3538, 206.95084],
        [12.432843, 1498.6337, 13.650631],
        [210.13004, 1249.0194, 136.05183],
        [11.8573265, 1226.2638, 53.150593],
        [14.463062, 711.3038, 29.058144],
        [436.8775, 534.6654, 52.619774],
        [120.41998, 1005.5066, 44.285625],
        [103.88259, 1239.4484, 162.9408],
        [95.22613, 1220.5891, 61.506477],
        [130.00635, 436.42526, 20.972694],
    ],
    [
        [16.943043, 298.15854, 16.290949],
        [16.942688, 298.15637, 16.291037],
        [16.942997, 298.16455, 16.291815],
        [16.943108, 298.16544, 16.292109],
        [16.94289, 298.15503, 16.292725],
        [16.941252, 298.1506, 16.291363],
        [16.943195, 298.2188, 16.293066],
        [16.931208, 298.4427, 16.305803],
        [16.91723, 297.2865, 16.36602],
        [16.897263, 297.91827, 16.419819],
    ],
])
INC_OUTCOME_RF_ONLY_NEW_PARAMS = np.array([
    [
        [91.34808, 205.88185],
        [91.18264, 206.20079],
        [90.58128, 205.82399],
        [90.47417, 206.62871],
        [90.66333, 206.28223],
        [90.78027, 205.23451],
        [91.11021, 206.33527],
        [90.685616, 206.42043],
        [90.274414, 206.90916],
        [89.79674, 205.4469],
    ],
    [
        [265.14978, 91.20291],
        [272.6573, 74.412254],
        [255.82745, 81.017944],
        [305.80847, 73.81889],
        [332.42578, 76.14858],
        [327.3277, 71.36236],
        [342.1096, 69.68611],
        [383.22217, 65.759766],
        [382.83713, 68.23784],
        [493.76462, 66.86809],
    ],
])
INC_OUTCOME_MEDIA_ONLY_USE_PRIOR = np.array([[
    [551.34, 1071.77, 600.61],
    [416.56, 220.16, 302.47],
    [328.12, 191.68, 108.85],
    [858.76, 480.41, 163.72],
    [156.49, 216.55, 871.51],
    [2208.06, 752.48, 60.76],
    [212.20, 85.28, 20.00],
    [160.69, 642.43, 651.54],
    [1335.38, 513.54, 181.51],
    [147.56, 426.27, 354.36],
]])
INC_OUTCOME_MEDIA_ONLY_USE_POSTERIOR = np.array([
    [
        [341.47, 4323.64, 1198.80],
        [70.05, 7476.11, 69.56],
        [1124.28, 6274.36, 693.93],
        [60.03, 5857.76, 263.23],
        [77.94, 3465.37, 143.75],
        [2336.68, 2529.21, 277.47],
        [625.78, 5145.63, 268.51],
        [592.20, 6010.15, 1035.03],
        [503.91, 6103.16, 358.96],
        [833.23, 1976.09, 124.21],
    ],
    [
        [87.94, 1695.98, 99.80],
        [87.93, 1695.97, 99.80],
        [87.94, 1696.01, 99.80],
        [87.94, 1696.01, 99.81],
        [87.94, 1695.97, 99.81],
        [87.93, 1695.96, 99.80],
        [87.93, 1696.37, 99.81],
        [87.89, 1697.92, 99.89],
        [87.84, 1692.52, 100.31],
        [87.72, 1696.20, 100.65],
    ],
])
INC_OUTCOME_RF_ONLY_USE_PRIOR = np.array([[
    [646.24, 318.49],
    [441.57, 256.74],
    [1331.16, 97.92],
    [168.89, 601.37],
    [299.61, 297.77],
    [1382.17, 487.59],
    [318.69, 159.89],
    [812.50, 1734.59],
    [257.95, 871.77],
    [162.43, 675.57],
]])
INC_OUTCOME_RF_ONLY_USE_POSTERIOR = np.array([
    [
        [386.06, 1037.53],
        [385.36, 1039.23],
        [382.93, 1037.09],
        [382.42, 1041.15],
        [383.14, 1039.56],
        [383.37, 1034.98],
        [384.68, 1039.13],
        [382.77, 1040.12],
        [381.06, 1042.39],
        [379.17, 1035.06],
    ],
    [
        [1181.46, 353.52],
        [1193.12, 340.00],
        [1096.41, 341.53],
        [1329.99, 347.21],
        [1429.17, 333.79],
        [1425.08, 329.34],
        [1497.22, 306.80],
        [1625.06, 304.85],
        [1622.44, 305.77],
        [2081.52, 317.14],
    ],
])

INC_OUTCOME_NON_MEDIA_USE_PRIOR = np.array([[
    [
        5.297e02,
        2.930e02,
        2.677e02,
        8.525e02,
        4.928e02,
        -6.732e05,
        -9.344e04,
        2.366e05,
        -3.368e05,
    ],
    [
        8.667e01,
        5.333e02,
        7.794e02,
        2.703e02,
        2.679e02,
        -6.813e04,
        1.557e05,
        1.123e05,
        -3.768e04,
    ],
    [
        4.647e02,
        2.914e02,
        3.165e02,
        3.285e02,
        4.524e02,
        -1.484e05,
        -7.160e05,
        5.994e04,
        -6.157e04,
    ],
    [
        7.034e02,
        6.047e01,
        1.184e02,
        2.647e02,
        3.022e02,
        -5.980e04,
        -5.054e05,
        -7.100e04,
        5.156e05,
    ],
    [
        1.105e03,
        1.486e03,
        1.729e02,
        3.167e02,
        2.660e02,
        -1.372e05,
        5.433e05,
        1.552e05,
        -1.327e05,
    ],
    [
        2.216e02,
        4.411e02,
        1.254e03,
        3.295e02,
        4.110e02,
        1.196e05,
        -2.278e05,
        7.862e04,
        1.129e05,
    ],
    [
        7.480e02,
        2.665e02,
        1.705e02,
        1.805e02,
        2.840e02,
        3.730e05,
        -3.130e05,
        1.099e05,
        -1.897e05,
    ],
    [
        6.140e02,
        6.552e02,
        2.245e02,
        2.145e02,
        4.806e02,
        -9.055e03,
        -2.358e05,
        -4.722e04,
        -1.610e05,
    ],
    [
        1.113e03,
        8.533e02,
        6.742e02,
        5.307e02,
        1.387e02,
        2.961e05,
        4.278e05,
        1.057e05,
        2.885e05,
    ],
    [
        3.804e02,
        1.248e02,
        5.768e02,
        6.984e02,
        3.007e02,
        1.687e05,
        1.381e05,
        -4.316e04,
        2.224e05,
    ],
]])
INC_OUTCOME_NON_MEDIA_USE_POSTERIOR = np.array([
    [
        [
            1.991e02,
            5.116e02,
            5.191e01,
            6.623e02,
            1.969e02,
            6.355e04,
            6.137e04,
            1.885e04,
            1.414e04,
        ],
        [
            1.980e02,
            5.257e02,
            5.190e01,
            6.690e02,
            1.947e02,
            6.186e04,
            6.107e04,
            1.791e04,
            1.379e04,
        ],
        [
            1.984e02,
            5.229e02,
            5.186e01,
            6.678e02,
            1.950e02,
            6.190e04,
            6.057e04,
            1.801e04,
            1.462e04,
        ],
        [
            1.984e02,
            5.234e02,
            5.193e01,
            6.658e02,
            1.899e02,
            5.850e04,
            5.792e04,
            1.745e04,
            1.331e04,
        ],
        [
            1.980e02,
            5.205e02,
            5.196e01,
            6.697e02,
            1.898e02,
            5.965e04,
            5.862e04,
            1.714e04,
            1.445e04,
        ],
        [
            1.960e02,
            5.301e02,
            5.181e01,
            6.764e02,
            1.999e02,
            6.082e04,
            5.874e04,
            1.672e04,
            1.176e04,
        ],
        [
            1.988e02,
            5.094e02,
            5.180e01,
            6.780e02,
            1.979e02,
            5.893e04,
            5.686e04,
            1.647e04,
            1.202e04,
        ],
        [
            1.991e02,
            5.109e02,
            5.174e01,
            6.698e02,
            1.972e02,
            5.288e04,
            5.654e04,
            1.636e04,
            1.309e04,
        ],
        [
            1.986e02,
            5.084e02,
            5.175e01,
            6.669e02,
            1.948e02,
            5.378e04,
            5.640e04,
            1.671e04,
            1.332e04,
        ],
        [
            1.986e02,
            5.123e02,
            5.178e01,
            6.670e02,
            1.965e02,
            5.519e04,
            5.608e04,
            1.721e04,
            1.107e04,
        ],
    ],
    [
        [
            1.431e03,
            8.507e01,
            2.222e02,
            2.692e02,
            1.240e02,
            5.840e04,
            1.407e05,
            -3.598e04,
            6.875e04,
        ],
        [
            1.432e03,
            8.505e01,
            2.231e02,
            2.683e02,
            1.240e02,
            5.933e04,
            1.402e05,
            -3.604e04,
            6.769e04,
        ],
        [
            1.430e03,
            8.500e01,
            2.248e02,
            2.675e02,
            1.235e02,
            5.684e04,
            1.393e05,
            -3.585e04,
            6.492e04,
        ],
        [
            1.436e03,
            8.512e01,
            2.231e02,
            2.667e02,
            1.244e02,
            5.558e04,
            1.391e05,
            -3.566e04,
            5.967e04,
        ],
        [
            1.447e03,
            8.433e01,
            2.226e02,
            2.650e02,
            1.254e02,
            5.029e04,
            1.344e05,
            -3.523e04,
            5.162e04,
        ],
        [
            1.430e03,
            8.481e01,
            2.232e02,
            2.641e02,
            1.254e02,
            5.083e04,
            1.412e05,
            -3.529e04,
            4.894e04,
        ],
        [
            1.457e03,
            8.494e01,
            2.258e02,
            2.621e02,
            1.247e02,
            5.094e04,
            1.386e05,
            -3.560e04,
            4.367e04,
        ],
        [
            1.456e03,
            8.486e01,
            2.276e02,
            2.646e02,
            1.246e02,
            4.977e04,
            1.430e05,
            -3.544e04,
            4.030e04,
        ],
        [
            1.484e03,
            8.516e01,
            2.252e02,
            2.668e02,
            1.241e02,
            4.880e04,
            1.479e05,
            -3.523e04,
            4.206e04,
        ],
        [
            1.475e03,
            8.522e01,
            2.238e02,
            2.669e02,
            1.244e02,
            4.895e04,
            1.481e05,
            -3.557e04,
            4.163e04,
        ],
    ],
])

INC_OUTCOME_NON_PAID_USE_PRIOR = np.array([[
    [
        5.297e02,
        2.930e02,
        2.677e02,
        8.525e02,
        4.928e02,
        3.304e05,
        1.000e04,
        5.644e07,
        3.129e03,
        6.678e10,
        -6.732e05,
        -9.344e04,
        2.366e05,
        -3.368e05,
    ],
    [
        8.667e01,
        5.333e02,
        7.794e02,
        2.703e02,
        2.679e02,
        2.233e06,
        1.185e05,
        6.033e05,
        1.621e04,
        3.810e06,
        -6.813e04,
        1.557e05,
        1.123e05,
        -3.768e04,
    ],
    [
        4.647e02,
        2.914e02,
        3.165e02,
        3.285e02,
        4.524e02,
        3.128e05,
        1.167e07,
        9.420e05,
        6.456e04,
        1.707e06,
        -1.484e05,
        -7.160e05,
        5.994e04,
        -6.157e04,
    ],
    [
        7.034e02,
        6.047e01,
        1.184e02,
        2.647e02,
        3.022e02,
        1.618e05,
        1.878e05,
        1.379e04,
        1.894e06,
        1.130e07,
        -5.980e04,
        -5.054e05,
        -7.100e04,
        5.156e05,
    ],
    [
        1.105e03,
        1.486e03,
        1.729e02,
        3.167e02,
        2.660e02,
        6.419e06,
        1.665e06,
        1.271e07,
        4.631e04,
        9.470e06,
        -1.372e05,
        5.433e05,
        1.552e05,
        -1.327e05,
    ],
    [
        2.216e02,
        4.411e02,
        1.254e03,
        3.295e02,
        4.110e02,
        5.366e05,
        7.267e04,
        5.929e07,
        1.730e06,
        4.749e06,
        1.196e05,
        -2.278e05,
        7.862e04,
        1.129e05,
    ],
    [
        7.480e02,
        2.665e02,
        1.705e02,
        1.805e02,
        2.840e02,
        5.344e06,
        1.730e05,
        3.684e06,
        5.869e05,
        7.029e04,
        3.730e05,
        -3.130e05,
        1.099e05,
        -1.897e05,
    ],
    [
        6.140e02,
        6.552e02,
        2.245e02,
        2.145e02,
        4.806e02,
        1.232e05,
        4.200e03,
        3.061e06,
        8.085e03,
        6.251e05,
        -9.055e03,
        -2.358e05,
        -4.722e04,
        -1.610e05,
    ],
    [
        1.113e03,
        8.533e02,
        6.742e02,
        5.307e02,
        1.387e02,
        6.012e06,
        1.252e04,
        2.521e05,
        6.543e05,
        4.772e07,
        2.961e05,
        4.278e05,
        1.057e05,
        2.885e05,
    ],
    [
        3.804e02,
        1.248e02,
        5.768e02,
        6.984e02,
        3.007e02,
        1.615e04,
        4.729e07,
        8.092e04,
        5.135e05,
        2.484e04,
        1.687e05,
        1.381e05,
        -4.316e04,
        2.224e05,
    ],
]])


INC_OUTCOME_NON_PAID_USE_POSTERIOR = np.array([
    [
        [
            1.991e02,
            5.116e02,
            5.190e01,
            6.623e02,
            1.969e02,
            3.668e03,
            9.245e03,
            1.354e04,
            5.733e03,
            1.108e03,
            6.355e04,
            6.137e04,
            1.885e04,
            1.414e04,
        ],
        [
            1.980e02,
            5.257e02,
            5.190e01,
            6.690e02,
            1.947e02,
            3.741e03,
            8.479e03,
            1.164e04,
            5.672e03,
            1.700e03,
            6.186e04,
            6.107e04,
            1.791e04,
            1.379e04,
        ],
        [
            1.984e02,
            5.229e02,
            5.186e01,
            6.678e02,
            1.950e02,
            3.738e03,
            8.182e03,
            1.171e04,
            5.648e03,
            1.517e03,
            6.190e04,
            6.057e04,
            1.801e04,
            1.462e04,
        ],
        [
            1.984e02,
            5.234e02,
            5.193e01,
            6.658e02,
            1.899e02,
            3.852e03,
            7.536e03,
            1.125e04,
            5.647e03,
            2.117e03,
            5.850e04,
            5.792e04,
            1.745e04,
            1.331e04,
        ],
        [
            1.980e02,
            5.205e02,
            5.196e01,
            6.697e02,
            1.898e02,
            3.841e03,
            7.093e03,
            1.136e04,
            5.641e03,
            1.926e03,
            5.965e04,
            5.862e04,
            1.714e04,
            1.445e04,
        ],
        [
            1.960e02,
            5.301e02,
            5.181e01,
            6.764e02,
            1.999e02,
            3.774e03,
            7.215e03,
            1.161e04,
            5.649e03,
            1.137e03,
            6.082e04,
            5.874e04,
            1.672e04,
            1.176e04,
        ],
        [
            1.988e02,
            5.094e02,
            5.180e01,
            6.780e02,
            1.979e02,
            3.785e03,
            7.502e03,
            1.171e04,
            5.622e03,
            8.346e02,
            5.893e04,
            5.686e04,
            1.647e04,
            1.202e04,
        ],
        [
            1.991e02,
            5.109e02,
            5.174e01,
            6.698e02,
            1.972e02,
            4.175e03,
            6.718e03,
            1.256e04,
            5.601e03,
            8.898e02,
            5.288e04,
            5.654e04,
            1.636e04,
            1.309e04,
        ],
        [
            1.986e02,
            5.084e02,
            5.175e01,
            6.669e02,
            1.948e02,
            4.056e03,
            6.772e03,
            1.265e04,
            5.565e03,
            8.285e02,
            5.378e04,
            5.640e04,
            1.671e04,
            1.332e04,
        ],
        [
            1.986e02,
            5.123e02,
            5.178e01,
            6.670e02,
            1.965e02,
            4.216e03,
            6.105e03,
            1.231e04,
            5.582e03,
            5.810e02,
            5.519e04,
            5.608e04,
            1.721e04,
            1.107e04,
        ],
    ],
    [
        [
            1.431e03,
            8.507e01,
            2.222e02,
            2.692e02,
            1.240e02,
            1.965e03,
            2.488e03,
            1.009e04,
            3.308e03,
            8.591e03,
            5.840e04,
            1.407e05,
            -3.598e04,
            6.875e04,
        ],
        [
            1.432e03,
            8.505e01,
            2.231e02,
            2.683e02,
            1.240e02,
            1.965e03,
            2.491e03,
            1.022e04,
            3.309e03,
            8.430e03,
            5.933e04,
            1.402e05,
            -3.604e04,
            6.769e04,
        ],
        [
            1.430e03,
            8.500e01,
            2.248e02,
            2.675e02,
            1.235e02,
            1.964e03,
            2.492e03,
            6.681e03,
            3.316e03,
            8.150e03,
            5.684e04,
            1.393e05,
            -3.585e04,
            6.492e04,
        ],
        [
            1.436e03,
            8.512e01,
            2.231e02,
            2.667e02,
            1.244e02,
            1.960e03,
            2.509e03,
            6.729e03,
            3.325e03,
            8.230e03,
            5.558e04,
            1.391e05,
            -3.566e04,
            5.967e04,
        ],
        [
            1.447e03,
            8.433e01,
            2.226e02,
            2.650e02,
            1.254e02,
            1.961e03,
            2.506e03,
            3.038e03,
            3.337e03,
            7.613e03,
            5.029e04,
            1.344e05,
            -3.523e04,
            5.162e04,
        ],
        [
            1.430e03,
            8.481e01,
            2.232e02,
            2.641e02,
            1.254e02,
            1.958e03,
            2.491e03,
            2.489e03,
            3.327e03,
            7.391e03,
            5.083e04,
            1.412e05,
            -3.529e04,
            4.894e04,
        ],
        [
            1.457e03,
            8.494e01,
            2.258e02,
            2.621e02,
            1.247e02,
            1.962e03,
            2.488e03,
            2.176e03,
            3.347e03,
            7.023e03,
            5.094e04,
            1.386e05,
            -3.560e04,
            4.367e04,
        ],
        [
            1.456e03,
            8.486e01,
            2.276e02,
            2.646e02,
            1.246e02,
            1.963e03,
            2.474e03,
            2.079e03,
            3.343e03,
            6.850e03,
            4.977e04,
            1.430e05,
            -3.544e04,
            4.030e04,
        ],
        [
            1.484e03,
            8.516e01,
            2.252e02,
            2.668e02,
            1.241e02,
            1.962e03,
            2.471e03,
            1.917e03,
            3.368e03,
            6.657e03,
            4.880e04,
            1.479e05,
            -3.523e04,
            4.206e04,
        ],
        [
            1.475e03,
            8.522e01,
            2.238e02,
            2.669e02,
            1.244e02,
            1.962e03,
            2.474e03,
            1.609e03,
            3.361e03,
            6.794e03,
            4.895e04,
            1.481e05,
            -3.557e04,
            4.163e04,
        ],
    ],
])


INC_OUTCOME_NON_MEDIA_MAX = np.array([
    [
        [
            1.991e02,
            5.116e02,
            5.190e01,
            6.623e02,
            1.969e02,
            -5.644e04,
            -6.282e04,
            -1.721e04,
            -1.362e04,
        ],
        [
            1.980e02,
            5.257e02,
            5.190e01,
            6.690e02,
            1.947e02,
            -5.492e04,
            -6.247e04,
            -1.637e04,
            -1.329e04,
        ],
        [
            1.984e02,
            5.229e02,
            5.186e01,
            6.678e02,
            1.950e02,
            -5.496e04,
            -6.199e04,
            -1.645e04,
            -1.410e04,
        ],
        [
            1.984e02,
            5.234e02,
            5.193e01,
            6.658e02,
            1.899e02,
            -5.189e04,
            -5.948e04,
            -1.595e04,
            -1.284e04,
        ],
        [
            1.980e02,
            5.205e02,
            5.196e01,
            6.697e02,
            1.898e02,
            -5.291e04,
            -6.014e04,
            -1.567e04,
            -1.395e04,
        ],
        [
            1.960e02,
            5.301e02,
            5.181e01,
            6.764e02,
            1.999e02,
            -5.397e04,
            -6.036e04,
            -1.529e04,
            -1.132e04,
        ],
        [
            1.988e02,
            5.094e02,
            5.180e01,
            6.780e02,
            1.979e02,
            -5.227e04,
            -5.857e04,
            -1.507e04,
            -1.157e04,
        ],
        [
            1.991e02,
            5.109e02,
            5.174e01,
            6.698e02,
            1.972e02,
            -4.684e04,
            -5.840e04,
            -1.497e04,
            -1.261e04,
        ],
        [
            1.986e02,
            5.084e02,
            5.175e01,
            6.669e02,
            1.948e02,
            -4.765e04,
            -5.827e04,
            -1.528e04,
            -1.282e04,
        ],
        [
            1.986e02,
            5.123e02,
            5.178e01,
            6.670e02,
            1.965e02,
            -4.892e04,
            -5.794e04,
            -1.573e04,
            -1.063e04,
        ],
    ],
    [
        [
            1.431e03,
            8.507e01,
            2.222e02,
            2.692e02,
            1.240e02,
            -5.204e04,
            -1.360e05,
            3.212e04,
            -6.661e04,
        ],
        [
            1.432e03,
            8.505e01,
            2.231e02,
            2.683e02,
            1.240e02,
            -5.287e04,
            -1.356e05,
            3.217e04,
            -6.557e04,
        ],
        [
            1.430e03,
            8.500e01,
            2.248e02,
            2.675e02,
            1.235e02,
            -5.063e04,
            -1.346e05,
            3.200e04,
            -6.298e04,
        ],
        [
            1.436e03,
            8.512e01,
            2.231e02,
            2.667e02,
            1.244e02,
            -4.951e04,
            -1.344e05,
            3.183e04,
            -5.796e04,
        ],
        [
            1.447e03,
            8.433e01,
            2.226e02,
            2.650e02,
            1.254e02,
            -4.474e04,
            -1.298e05,
            3.144e04,
            -5.029e04,
        ],
        [
            1.430e03,
            8.481e01,
            2.232e02,
            2.641e02,
            1.254e02,
            -4.522e04,
            -1.365e05,
            3.150e04,
            -4.747e04,
        ],
        [
            1.457e03,
            8.494e01,
            2.258e02,
            2.621e02,
            1.247e02,
            -4.530e04,
            -1.340e05,
            3.177e04,
            -4.230e04,
        ],
        [
            1.456e03,
            8.486e01,
            2.276e02,
            2.646e02,
            1.246e02,
            -4.425e04,
            -1.382e05,
            3.163e04,
            -3.916e04,
        ],
        [
            1.484e03,
            8.516e01,
            2.252e02,
            2.668e02,
            1.241e02,
            -4.339e04,
            -1.430e05,
            3.144e04,
            -4.083e04,
        ],
        [
            1.475e03,
            8.522e01,
            2.238e02,
            2.669e02,
            1.244e02,
            -4.355e04,
            -1.432e05,
            3.175e04,
            -4.040e04,
        ],
    ],
])

INC_OUTCOME_NON_MEDIA_MIX = np.array([
    [
        [
            1.991e02,
            5.116e02,
            5.190e01,
            6.623e02,
            1.969e02,
            6.355e04,
            -6.282e04,
            -1.721e04,
            1.414e04,
        ],
        [
            1.980e02,
            5.257e02,
            5.190e01,
            6.690e02,
            1.947e02,
            6.186e04,
            -6.247e04,
            -1.637e04,
            1.379e04,
        ],
        [
            1.984e02,
            5.229e02,
            5.186e01,
            6.678e02,
            1.950e02,
            6.190e04,
            -6.199e04,
            -1.645e04,
            1.462e04,
        ],
        [
            1.984e02,
            5.234e02,
            5.193e01,
            6.658e02,
            1.899e02,
            5.850e04,
            -5.948e04,
            -1.595e04,
            1.331e04,
        ],
        [
            1.980e02,
            5.205e02,
            5.196e01,
            6.697e02,
            1.898e02,
            5.965e04,
            -6.014e04,
            -1.567e04,
            1.445e04,
        ],
        [
            1.960e02,
            5.301e02,
            5.181e01,
            6.764e02,
            1.999e02,
            6.082e04,
            -6.036e04,
            -1.529e04,
            1.176e04,
        ],
        [
            1.988e02,
            5.094e02,
            5.180e01,
            6.780e02,
            1.979e02,
            5.893e04,
            -5.857e04,
            -1.507e04,
            1.202e04,
        ],
        [
            1.991e02,
            5.109e02,
            5.174e01,
            6.698e02,
            1.972e02,
            5.288e04,
            -5.840e04,
            -1.497e04,
            1.309e04,
        ],
        [
            1.986e02,
            5.084e02,
            5.175e01,
            6.669e02,
            1.948e02,
            5.378e04,
            -5.827e04,
            -1.528e04,
            1.332e04,
        ],
        [
            1.986e02,
            5.123e02,
            5.178e01,
            6.670e02,
            1.965e02,
            5.519e04,
            -5.794e04,
            -1.573e04,
            1.107e04,
        ],
    ],
    [
        [
            1.431e03,
            8.507e01,
            2.222e02,
            2.692e02,
            1.240e02,
            5.840e04,
            -1.360e05,
            3.212e04,
            6.875e04,
        ],
        [
            1.432e03,
            8.505e01,
            2.231e02,
            2.683e02,
            1.240e02,
            5.933e04,
            -1.356e05,
            3.217e04,
            6.769e04,
        ],
        [
            1.430e03,
            8.500e01,
            2.248e02,
            2.675e02,
            1.235e02,
            5.684e04,
            -1.346e05,
            3.200e04,
            6.492e04,
        ],
        [
            1.436e03,
            8.512e01,
            2.231e02,
            2.667e02,
            1.244e02,
            5.558e04,
            -1.344e05,
            3.183e04,
            5.967e04,
        ],
        [
            1.447e03,
            8.433e01,
            2.226e02,
            2.650e02,
            1.254e02,
            5.029e04,
            -1.298e05,
            3.144e04,
            5.162e04,
        ],
        [
            1.430e03,
            8.481e01,
            2.232e02,
            2.641e02,
            1.254e02,
            5.083e04,
            -1.365e05,
            3.150e04,
            4.894e04,
        ],
        [
            1.457e03,
            8.494e01,
            2.258e02,
            2.621e02,
            1.247e02,
            5.094e04,
            -1.340e05,
            3.177e04,
            4.367e04,
        ],
        [
            1.456e03,
            8.486e01,
            2.276e02,
            2.646e02,
            1.246e02,
            4.977e04,
            -1.382e05,
            3.163e04,
            4.030e04,
        ],
        [
            1.484e03,
            8.516e01,
            2.252e02,
            2.668e02,
            1.241e02,
            4.880e04,
            -1.430e05,
            3.144e04,
            4.206e04,
        ],
        [
            1.475e03,
            8.522e01,
            2.238e02,
            2.669e02,
            1.244e02,
            4.895e04,
            -1.432e05,
            3.175e04,
            4.163e04,
        ],
    ],
])

INC_OUTCOME_NON_MEDIA_FIXED = np.array([
    [
        [
            1.991e02,
            5.116e02,
            5.191e01,
            6.623e02,
            1.969e02,
            -2.250e05,
            1.676e04,
            1.058e04,
            -4.475e03,
        ],
        [
            1.980e02,
            5.257e02,
            5.190e01,
            6.690e02,
            1.947e02,
            -2.190e05,
            1.669e04,
            1.005e04,
            -4.375e03,
        ],
        [
            1.984e02,
            5.229e02,
            5.186e01,
            6.678e02,
            1.950e02,
            -2.191e05,
            1.654e04,
            1.011e04,
            -4.644e03,
        ],
        [
            1.984e02,
            5.234e02,
            5.193e01,
            6.658e02,
            1.899e02,
            -2.070e05,
            1.575e04,
            9.798e03,
            -4.228e03,
        ],
        [
            1.980e02,
            5.205e02,
            5.196e01,
            6.697e02,
            1.898e02,
            -2.111e05,
            1.595e04,
            9.621e03,
            -4.596e03,
        ],
        [
            1.960e02,
            5.301e02,
            5.181e01,
            6.764e02,
            1.999e02,
            -2.153e05,
            1.596e04,
            9.384e03,
            -3.718e03,
        ],
        [
            1.988e02,
            5.094e02,
            5.180e01,
            6.780e02,
            1.979e02,
            -2.085e05,
            1.539e04,
            9.246e03,
            -3.802e03,
        ],
        [
            1.991e02,
            5.109e02,
            5.174e01,
            6.698e02,
            1.972e02,
            -1.870e05,
            1.525e04,
            9.182e03,
            -4.143e03,
        ],
        [
            1.986e02,
            5.084e02,
            5.175e01,
            6.669e02,
            1.948e02,
            -1.902e05,
            1.520e04,
            9.380e03,
            -4.212e03,
        ],
        [
            1.986e02,
            5.123e02,
            5.178e01,
            6.670e02,
            1.965e02,
            -1.952e05,
            1.512e04,
            9.660e03,
            -3.480e03,
        ],
    ],
    [
        [
            1.431e03,
            8.507e01,
            2.222e02,
            2.692e02,
            1.240e02,
            -2.072e05,
            4.133e04,
            -2.037e04,
            -2.202e04,
        ],
        [
            1.432e03,
            8.505e01,
            2.231e02,
            2.683e02,
            1.240e02,
            -2.105e05,
            4.117e04,
            -2.041e04,
            -2.168e04,
        ],
        [
            1.430e03,
            8.500e01,
            2.248e02,
            2.675e02,
            1.235e02,
            -2.016e05,
            4.092e04,
            -2.030e04,
            -2.085e04,
        ],
        [
            1.436e03,
            8.512e01,
            2.231e02,
            2.667e02,
            1.244e02,
            -1.972e05,
            4.087e04,
            -2.019e04,
            -1.921e04,
        ],
        [
            1.447e03,
            8.433e01,
            2.226e02,
            2.650e02,
            1.254e02,
            -1.783e05,
            3.951e04,
            -1.994e04,
            -1.672e04,
        ],
        [
            1.430e03,
            8.481e01,
            2.232e02,
            2.641e02,
            1.254e02,
            -1.802e05,
            4.147e04,
            -1.998e04,
            -1.571e04,
        ],
        [
            1.457e03,
            8.494e01,
            2.258e02,
            2.621e02,
            1.247e02,
            -1.805e05,
            4.070e04,
            -2.015e04,
            -1.398e04,
        ],
        [
            1.456e03,
            8.486e01,
            2.276e02,
            2.646e02,
            1.246e02,
            -1.764e05,
            4.198e04,
            -2.006e04,
            -1.299e04,
        ],
        [
            1.484e03,
            8.516e01,
            2.252e02,
            2.668e02,
            1.241e02,
            -1.729e05,
            4.340e04,
            -1.995e04,
            -1.352e04,
        ],
        [
            1.475e03,
            8.522e01,
            2.238e02,
            2.669e02,
            1.244e02,
            -1.735e05,
            4.349e04,
            -2.014e04,
            -1.338e04,
        ],
    ],
])

MROI_MEDIA_AND_RF_USE_PRIOR = np.array([[
    [0.3399, 1.7045, 3.1300, 2.7845, 0.3523],
    [0.4540, 1.3445, 0.9966, 0.2985, 0.4917],
    [0.7575, 0.3504, 0.5767, 1.0278, 0.8805],
    [0.3337, 0.4499, 0.6881, 0.3966, 0.1746],
    [0.3649, 2.8715, 3.3528, 0.7638, 0.8069],
    [0.8379, 1.6386, 0.7886, 1.8928, 0.3080],
    [2.8982, 1.9764, 1.2727, 1.1683, 0.2494],
    [1.4771, 0.4279, 0.5875, 0.4700, 1.1623],
    [0.3116, 0.1210, 0.4312, 0.1828, 0.2387],
    [0.5794, 0.0999, 0.6654, 0.2890, 0.3041],
]])
MROI_MEDIA_AND_RF_USE_PRIOR_BY_REACH = np.array([[
    [0.3399, 1.7045, 3.1300, 9.1854, 0.6759],
    [0.4540, 1.3445, 0.9966, 0.8028, 1.8628],
    [0.7574, 0.3504, 0.5767, 2.9870, 1.1000],
    [0.3337, 0.4499, 0.6881, 1.4383, 0.5605],
    [0.3649, 2.8715, 3.3528, 1.6709, 2.1280],
    [0.8379, 1.6386, 0.7886, 3.4605, 0.3989],
    [2.8982, 1.9764, 1.2727, 2.1979, 0.9851],
    [1.4771, 0.4279, 0.5875, 0.8823, 3.8424],
    [0.3116, 0.1210, 0.4312, 0.4640, 0.5646],
    [0.5794, 0.0999, 0.6654, 0.4625, 0.7852],
]])
MROI_MEDIA_AND_RF_USE_POSTERIOR = np.array([
    [
        [1.6876, 1.9684, 0.5030, 0.0934, 0.1623],
        [1.6734, 1.9471, 0.5040, 0.0958, 0.1645],
        [1.6799, 1.9672, 0.5139, 0.0969, 0.1641],
        [1.6378, 1.9834, 0.5252, 0.1009, 0.1620],
        [1.6236, 1.9732, 0.5131, 0.1012, 0.1631],
        [1.6196, 2.0069, 0.5218, 0.0993, 0.1604],
        [1.6011, 2.0436, 0.5036, 0.1036, 0.1613],
        [1.6256, 2.0625, 0.5077, 0.1045, 0.1597],
        [1.6034, 2.0482, 0.5070, 0.1037, 0.1592],
        [1.6045, 2.0500, 0.5069, 0.1039, 0.1591],
    ],
    [
        [0.2256, 0.3251, 0.1359, 0.1392, 0.1424],
        [0.2256, 0.3250, 0.1359, 0.1392, 0.1424],
        [0.2256, 0.3253, 0.1360, 0.1394, 0.1419],
        [0.2258, 0.3255, 0.1364, 0.1371, 0.1421],
        [0.2247, 0.3255, 0.1363, 0.1370, 0.1420],
        [0.2250, 0.3256, 0.1362, 0.1375, 0.1419],
        [0.2260, 0.3264, 0.1362, 0.1343, 0.1424],
        [0.2282, 0.3266, 0.1359, 0.1343, 0.1436],
        [0.2283, 0.3265, 0.1358, 0.1349, 0.1437],
        [0.2282, 0.3271, 0.1354, 0.1335, 0.1442],
    ],
])
MROI_MEDIA_AND_RF_USE_POSTERIOR_BY_REACH = np.array([
    [
        [1.6876, 1.9684, 0.5030, 0.4830, 2.5956],
        [1.6734, 1.9471, 0.5040, 0.4830, 2.6450],
        [1.6799, 1.9672, 0.5139, 0.4850, 2.6381],
        [1.6378, 1.9834, 0.5252, 0.4813, 2.6201],
        [1.6236, 1.9732, 0.5131, 0.4825, 2.6458],
        [1.6196, 2.0069, 0.5218, 0.4811, 2.5936],
        [1.6011, 2.0436, 0.5036, 0.4811, 2.5988],
        [1.6256, 2.0625, 0.5077, 0.4822, 2.5739],
        [1.6034, 2.0482, 0.5070, 0.4778, 2.5640],
        [1.6045, 2.0500, 0.5069, 0.4780, 2.5648],
    ],
    [
        [0.2256, 0.3251, 0.1359, 1.8198, 0.5546],
        [0.2256, 0.3250, 0.1359, 1.8199, 0.5547],
        [0.2256, 0.3253, 0.1360, 1.8191, 0.5527],
        [0.2258, 0.3255, 0.1364, 1.8179, 0.5534],
        [0.2247, 0.3255, 0.1363, 1.8171, 0.5529],
        [0.2250, 0.3256, 0.1362, 1.8175, 0.5525],
        [0.2260, 0.3264, 0.1362, 1.8187, 0.5531],
        [0.2282, 0.3266, 0.1359, 1.8205, 0.5587],
        [0.2283, 0.3265, 0.1358, 1.8181, 0.5592],
        [0.2282, 0.3271, 0.1354, 1.8194, 0.5598],
    ],
])
MROI_MEDIA_ONLY_USE_PRIOR = np.array([[
    [1.0740, 1.3019, 0.7984],
    [0.8990, 0.4201, 0.7120],
    [0.1340, 0.4114, 0.2389],
    [1.1974, 0.9624, 0.3721],
    [0.2613, 0.3995, 2.0881],
    [2.7704, 0.8456, 0.1207],
    [0.4953, 0.0424, 0.0423],
    [0.2991, 0.4112, 0.7823],
    [0.4918, 1.0556, 0.3962],
    [0.1665, 1.0178, 0.3253],
]])
MROI_MEDIA_ONLY_USE_POSTERIOR = np.array([
    [
        [0.4422, 9.3207, 2.3945],
        [0.1470, 12.8182, 0.1610],
        [1.0377, 13.3305, 1.8174],
        [0.0568, 14.6320, 0.4360],
        [0.1162, 5.4620, 0.2345],
        [4.7597, 5.0803, 0.2372],
        [1.1496, 11.8842, 0.4796],
        [0.9482, 12.9420, 1.6867],
        [0.8706, 14.3139, 0.5490],
        [1.6256, 4.4582, 0.1215],
    ],
    [
        [0.1977, 5.3532, 0.3220],
        [0.1976, 5.3530, 0.3220],
        [0.1977, 5.3534, 0.3220],
        [0.1977, 5.3533, 0.3220],
        [0.1977, 5.3531, 0.3220],
        [0.1977, 5.3531, 0.3220],
        [0.1977, 5.3543, 0.3219],
        [0.1973, 5.3592, 0.3223],
        [0.1977, 5.3426, 0.3237],
        [0.1973, 5.3541, 0.3248],
    ],
])
MROI_RF_ONLY_USE_PRIOR = np.array([[
    [0.5429, 0.3957],
    [0.4478, 0.2091],
    [1.9448, 0.2493],
    [0.2426, 1.0238],
    [0.4595, 0.5257],
    [1.4106, 0.5619],
    [0.6273, 0.1139],
    [1.8461, 2.2882],
    [0.5036, 0.8826],
    [0.2506, 0.7252],
]])
MROI_RF_ONLY_USE_PRIOR_BY_REACH = np.array([[
    [2.3753, 1.1037],
    [1.6244, 0.8928],
    [4.8863, 0.3513],
    [0.6133, 2.0871],
    [1.0978, 1.0359],
    [5.0919, 1.7021],
    [1.1755, 0.5495],
    [2.9831, 6.0266],
    [0.9513, 3.0227],
    [0.5975, 2.3417],
]])
MROI_RF_ONLY_USE_POSTERIOR = np.array([
    [
        [1.1980, 0.6598],
        [1.2059, 0.6493],
        [1.1873, 0.6377],
        [1.1821, 0.6507],
        [1.2059, 0.6492],
        [1.2163, 0.6443],
        [1.2193, 0.6353],
        [1.2197, 0.6444],
        [1.2144, 0.6423],
        [1.2055, 0.6393],
    ],
    [
        [1.6838, 1.0183],
        [1.6449, 0.2891],
        [1.8734, 0.6988],
        [1.8439, 0.2740],
        [2.2058, 0.5334],
        [1.7365, 0.3025],
        [1.8021, 0.5561],
        [3.3720, 0.3345],
        [2.6666, 0.5455],
        [2.8244, 0.3173],
    ],
])
MROI_RF_ONLY_USE_POSTERIOR_BY_REACH = np.array([
    [
        [1.4183, 3.6023],
        [1.4208, 3.6155],
        [1.3974, 3.5974],
        [1.4042, 3.6202],
        [1.4139, 3.6172],
        [1.4103, 3.5999],
        [1.4261, 3.5983],
        [1.4050, 3.6211],
        [1.4014, 3.6159],
        [1.4058, 3.5957],
    ],
    [
        [4.3477, 1.2222],
        [4.3790, 1.1917],
        [4.0231, 1.1834],
        [4.8855, 1.2039],
        [5.2465, 1.1637],
        [5.2446, 1.1340],
        [5.5086, 1.0636],
        [5.9674, 1.0501],
        [5.9643, 1.0677],
        [7.6481, 1.0991],
    ],
])

SAMPLE_ROI = np.array([
    [
        [1.5295, 1.0948],
        [1.0263, 1.0758],
        [0.6959, 0.2681],
        [3.6885, 1.9717],
    ],
    [
        [2.5433, 1.4539],
        [2.2783, 1.4228],
        [0.1932, 0.5897],
        [6.6965, 2.3686],
    ],
    [
        [2.7188, 0.4426],
        [1.8222, 0.4378],
        [1.0201, 0.2100],
        [7.4064, 0.6906],
    ],
    [
        [2.3552, 1.1502],
        [1.5546, 1.1511],
        [0.4632, 0.4780],
        [6.6092, 1.8199],
    ],
    [[1.2903, 1.5795], [0.8852, 1.5619], [0.4716, 0.5527], [3.0709, 2.6449]],
    [
        [2.0644, 1.1582],
        [1.7468, 1.1545],
        [0.6929, 0.6849],
        [4.1972, 1.6350],
    ],
])
SAMPLE_ROI_NEW_DATA = np.array([
    [
        [1.56763196, 1.04716325],
        [1.04454029, 1.02826679],
        [0.70443258, 0.27417667],
        [3.75964105, 1.86893576],
    ],
    [
        [2.40648031, 1.42752671],
        [2.14508867, 1.39736521],
        [0.18536552, 0.58383978],
        [6.22361684, 2.31998056],
    ],
    [
        [2.50060892, 0.40254918],
        [1.68540454, 0.39818001],
        [0.93389383, 0.19190538],
        [6.70395389, 0.62588809],
    ],
    [
        [2.3445375, 1.15238607],
        [1.54786396, 1.15332222],
        [0.46009327, 0.47705953],
        [6.58699446, 1.82520183],
    ],
    [
        [1.28817225, 1.58117354],
        [0.88339752, 1.56353891],
        [0.47020949, 0.55195928],
        [3.07263788, 2.64894781],
    ],
    [
        [2.02729774, 1.12732518],
        [1.71521258, 1.12453651],
        [0.68484985, 0.67228897],
        [4.11828271, 1.58598067],
    ],
])
SAMPLE_ROI_KPI = np.array([
    [
        [0.4906, 0.3487],
        [0.3282, 0.3426],
        [0.2221, 0.0853],
        [1.1906, 0.6280],
    ],
    [
        [0.8133, 0.4731],
        [0.7389, 0.4629],
        [0.0629, 0.1878],
        [2.1344, 0.7750],
    ],
    [
        [0.8685, 0.1409],
        [0.5808, 0.1394],
        [0.3255, 0.0668],
        [2.3597, 0.2199],
    ],
    [
        [0.7637, 0.3663],
        [0.4951, 0.3666],
        [0.1475, 0.1522],
        [2.1481, 0.5796],
    ],
    [
        [0.4124, 0.5070],
        [0.2880, 0.5012],
        [0.1503, 0.1791],
        [0.9788, 0.8474],
    ],
    [
        [0.6623, 0.3717],
        [0.5570, 0.3705],
        [0.2228, 0.2187],
        [1.3418, 0.5257],
    ],
])
SAMPLE_MROI = np.array([
    [
        [0.8354, 0.9310],
        [0.5167, 0.9147],
        [0.3215, 0.2250],
        [2.2587, 1.6802],
    ],
    [
        [1.0984, 1.1655],
        [0.8972, 1.1371],
        [0.1094, 0.3251],
        [2.4685, 2.0506],
    ],
    [
        [1.2490, 0.3233],
        [0.7384, 0.3197],
        [0.4967, 0.1358],
        [3.2525, 0.5220],
    ],
    [[0.9274, 0.1185], [0.6169, 0.1190], [0.2306, 0.0957], [2.3833, 0.1392]],
    [
        [0.4968, 0.1521],
        [0.3301, 0.1516],
        [0.2034, 0.1419],
        [1.0355, 0.1641],
    ],
    [
        # mROI metric don't make sense for "All Channels".
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
    ],
])
SAMPLE_MROI_NEW_DATA = np.array([
    [
        [0.86685735, 0.9019572],
        [0.5474438, 0.88566875],
        [0.33536345, 0.23084486],
        [2.325597, 1.615559],
    ],
    [
        [0.98578817, 1.1203848],
        [0.79026884, 1.0930933],
        [0.09857258, 0.306825],
        [2.1813164, 1.9769008],
    ],
    [
        [1.1169803, 0.29080662],
        [0.65436214, 0.28769404],
        [0.4310956, 0.12189759],
        [2.9086902, 0.46900335],
    ],
    [
        [0.9376944, 0.11894181],
        [0.6223348, 0.11948171],
        [0.23284341, 0.09595118],
        [2.408213, 0.13983254],
    ],
    [
        [0.501675, 0.15347004],
        [0.33212814, 0.15300572],
        [0.20545325, 0.14246973],
        [1.0451934, 0.16632313],
    ],
    [
        # mROI metric don't make sense for "All Channels".
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
    ],
])
SAMPLE_MROI_KPI = np.array([
    [
        [0.2664, 0.2965],
        [0.1641, 0.2913],
        [0.1021, 0.0716],
        [0.7221, 0.5351],
    ],
    [
        [0.3500, 0.3783],
        [0.2839, 0.3691],
        [0.0352, 0.1035],
        [0.7852, 0.6678],
    ],
    [
        [0.3967, 0.1029],
        [0.2331, 0.1018],
        [0.1576, 0.0432],
        [1.0333, 0.1662],
    ],
    [
        [0.3016, 0.0377],
        [0.1964, 0.0379],
        [0.0734, 0.0304],
        [0.7780, 0.0443],
    ],
    [
        [0.1587, 0.0489],
        [0.1065, 0.0487],
        [0.0647, 0.0459],
        [0.3297, 0.0525],
    ],
    [
        # mROI metric don't make sense for "All Channels".
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
    ],
])
SAMPLE_CPIK = np.array([
    [
        [2.8661, 6.6404],
        [3.0759, 6.6109],
        [0.9453, 1.5924],
        [4.5251, 11.7106],
    ],
    [
        [4.5544, 3.3371],
        [1.3881, 3.3520],
        [0.6126, 1.3256],
        [16.2636, 5.3240],
    ],
    [
        [1.8160, 9.7881],
        [1.7320, 9.8038],
        [0.4411, 4.5464],
        [3.0846, 14.9515],
    ],
    [
        [2.8815, 4.1235],
        [2.0311, 4.1006],
        [0.5963, 1.7252],
        [6.7785, 6.5685],
    ],
    [
        [3.7698, 3.4308],
        [3.5929, 3.4163],
        [1.1134, 1.1871],
        [6.8500, 5.6810],
    ],
    [
        [2.1300, 3.2514],
        [1.7994, 3.2514],
        [0.7523, 1.9204],
        [4.5320, 4.5842],
    ],
])
SAMPLE_CPIK_NEW_DATA = np.array([
    [
        [2.78905678, 6.55801868],
        [3.01741695, 6.53180027],
        [0.92153698, 1.68010235],
        [4.47077053, 11.45247331],
    ],
    [
        [4.74355936, 3.37736249],
        [1.48299181, 3.3916676],
        [0.63506174, 1.35346212],
        [16.96108036, 5.37818699],
    ],
    [
        [1.94818652, 10.73061943],
        [1.8766824, 10.74547863],
        [0.48264052, 5.01688185],
        [3.36790035, 16.36223383],
    ],
    [
        [2.8985, 4.1235],
        [2.0395, 4.1006],
        [0.6001, 1.7203],
        [6.8248, 6.5819],
    ],
    [
        [3.7833, 3.4308],
        [3.6012, 3.4163],
        [1.1134, 1.1871],
        [6.8720, 5.6888],
    ],
    [
        [2.16551495, 3.32448149],
        [1.8315326, 3.32347631],
        [0.76563665, 1.97984869],
        [4.585267, 4.67061219],
    ],
])
SAMPLE_EFFECTIVENESS = np.array([
    [
        [3.0950e-01, 2.2154e-01],
        [2.0768e-01, 2.1768e-01],
        [1.4081e-01, 5.4255e-02],
        [7.4636e-01, 3.9898e-01],
    ],
    [
        [5.1542e-01, 2.9465e-01],
        [4.6172e-01, 2.8834e-01],
        [3.9163e-02, 1.1952e-01],
        [1.3571e00, 4.8001e-01],
    ],
    [
        [5.4621e-01, 8.8930e-02],
        [3.6608e-01, 8.7973e-02],
        [2.0495e-01, 4.2191e-02],
        [1.48794e00, 1.3875e-01],
    ],
    [
        [1.9593e-04, 9.5685e-05],
        [1.2933e-04, 9.5761e-05],
        [3.8535e-05, 3.9767e-05],
        [5.4982e-04, 1.5140e-04],
    ],
    [
        [1.0622e-04, 1.3003e-04],
        [7.2868e-05, 1.2857e-04],
        [3.8824e-05, 4.5498e-05],
        [2.5280e-04, 2.1773e-04],
    ],
    [
        # Effectiveness metric don't make sense for "All Channels".
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
    ],
])
SAMPLE_EFFECTIVENESS_NEW_DATA = np.array([
    [
        [0.31652692, 0.21143702],
        [0.21090737, 0.2076215],
        [0.14223483, 0.05536012],
        [0.75912433, 0.37736439],
    ],
    [
        [0.47203428, 0.28001127],
        [0.42076194, 0.27409503],
        [0.03635969, 0.11452094],
        [1.22077059, 0.45506725],
    ],
    [
        [0.51076651, 0.08222342],
        [0.34425539, 0.08133098],
        [0.19075419, 0.03919798],
        [1.36932836, 0.12784192],
    ],
    [
        [1.9593e-04, 9.5685e-05],
        [1.2933e-04, 9.5761e-05],
        [3.8535e-05, 3.9767e-05],
        [5.4982e-04, 1.5140e-04],
    ],
    [
        [1.0622e-04, 1.3003e-04],
        [7.3432e-05, 1.2857e-04],
        [3.8824e-05, 4.5498e-05],
        [2.5280e-04, 2.1773e-04],
    ],
    [
        # Effectiveness metric don't make sense for "All Channels".
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
    ],
])
SAMPLE_EFFECTIVENESS_KPI = np.array([
    [
        [9.9277e-02, 7.0560e-02],
        [6.6422e-02, 6.9333e-02],
        [4.4954e-02, 1.7279e-02],
        [2.4091e-01, 1.2707e-01],
    ],
    [
        [1.6482e-01, 9.5891e-02],
        [1.4974e-01, 9.3827e-02],
        [1.2753e-02, 3.8064e-02],
        [4.3255e-01, 1.5707e-01],
    ],
    [
        [1.7448e-01, 2.8321e-02],
        [1.1669e-01, 2.8016e-02],
        [6.5400e-02, 1.3436e-02],
        [4.7407e-01, 4.4187e-02],
    ],
    [
        [6.3538e-05, 3.0473e-05],
        [4.1191e-05, 3.0498e-05],
        [1.2272e-05, 1.2665e-05],
        [1.7870e-04, 4.8219e-05],
    ],
    [
        [3.3949e-05, 4.1739e-05],
        [2.3709e-05, 4.1265e-05],
        [1.2372e-05, 1.4746e-05],
        [8.0578e-05, 6.9762e-05],
    ],
    [
        # Effectiveness metric don't make sense for "All Channels".
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
        [math.nan, math.nan],
    ],
])
SAMPLE_SPEND = np.array([293.807, 278.854, 255.744, 272.165, 287.876, 1388.448])
SAMPLE_SPEND_NEW_DATA = np.array(
    [281.872, 314.6267, 288.8191, 272.165, 287.876, 1445.3599]
)
SAMPLE_PCT_OF_SPEND = np.array([21.160, 20.083, 18.419, 19.602, 20.733, 100.0])
SAMPLE_PCT_OF_SPEND_NEW_DATA = np.array(
    [19.5018, 21.7680, 19.9825, 18.8302, 19.9173, 100.0]
)

SAMPLE_INCREMENTAL_OUTCOME = np.array([
    [
        [449.3971, 321.6781],
        [301.5584, 316.0848],
        [204.4690, 78.7793],
        [1083.7236, 579.3290],
    ],
    [
        [709.2308, 405.4423],
        [635.3278, 396.7662],
        [53.8891, 164.4619],
        [1867.3624, 660.5021],
    ],
    [
        [695.3375, 113.2083],
        [466.0205, 111.9899],
        [260.9031, 53.7094],
        [1894.1516, 176.6288],
    ],
    [
        [641.0110, 313.0473],
        [423.1232, 313.0473],
        [126.0751, 130.1054],
        [1798.8108, 495.3362],
    ],
    [
        [371.4706, 454.7283],
        [254.8279, 449.6505],
        [135.7712, 159.1129],
        [884.0682, 761.4331],
    ],
    [
        [2866.4497, 1608.1071],
        [2425.4753, 1602.9943],
        [962.0666, 951.0228],
        [5827.7158, 2270.1303],
    ],
])
SAMPLE_INCREMENTAL_OUTCOME_NEW_DATA = np.array([
    [
        [441.8716, 295.1661],
        [294.4267, 289.8396],
        [198.5598, 77.2827],
        [1059.7375, 526.8006],
    ],
    [
        [757.1430, 449.1380],
        [674.90216064, 439.64840698],
        [58.32094135, 183.69158936],
        [1958.11610107, 729.92785034],
    ],
    [
        [722.2237, 116.2639],
        [486.7771, 115.0020],
        [269.72642365, 55.4259491],
        [1936.23026123, 180.76846619],
    ],
    [
        [638.1017, 313.6394],
        [421.2747, 313.8942],
        [125.2213, 129.8390],
        [1792.7512, 496.7565],
    ],
    [
        [370.8348, 454.7283],
        [254.3095, 450.1063],
        [135.3623, 158.8961],
        [884.0682, 762.5704],
    ],
    [
        [2930.17456055, 1629.39038086],
        [2479.09936523, 1625.35986328],
        [989.85450439, 971.6994812],
        [5952.40058594, 2292.31287842],
    ],
])
SAMPLE_INC_OUTCOME_KPI = np.array([
    [
        [144.1503, 102.4545],
        [96.4451, 100.6727],
        [65.2740, 25.0893],
        [349.8139, 184.5193],
    ],
    [
        [226.7942, 131.9462],
        [206.0485, 129.1067],
        [17.5491, 52.3763],
        [595.1923, 216.1331],
    ],
    [
        [222.1169, 36.0536],
        [148.5511, 35.6655],
        [83.2549, 17.1049],
        [603.4962, 56.2512],
    ],
    [
        [207.8744, 99.6991],
        [134.7621, 99.7785],
        [40.1513, 41.4353],
        [584.6558, 157.7549],
    ],
    [
        [118.7230, 145.9658],
        [82.9160, 144.3085],
        [43.2690, 51.5697],
        [281.7918, 243.9656],
    ],
    [
        [919.6607, 516.1203],
        [773.4373, 514.5176],
        [309.4688, 303.7702],
        [1863.1441, 729.9609],
    ],
])
SAMPLE_BASELINE_EXPECTED_OUTCOME = np.array([
    [11180.9931, 20127.6386],
    [-919.5247, 20048.3613],
    [-24876.6487, 13877.7523],
    [55426.2115, 26502.3695],
])
SAMPLE_BASELINE_EXPECTED_OUTCOME_NON_PAID = np.array([
    [25385.072, -158578.44],
    [-24382.074, -156690.16],
    [-808058.25, -196256.48],
    [906303.44, -132320.92],
])
SAMPLE_PCT_OF_CONTRIBUTION = np.array([
    [
        [3.1991, 1.4799],
        [2.1467, 1.4542],
        [1.4555, 0.3624],
        [7.7147, 2.6653],
    ],
    [
        [5.0488, 1.8653],
        [4.5227, 1.8254],
        [0.3836, 0.7566],
        [13.2932, 3.0387],
    ],
    [
        [4.9499, 0.5208],
        [3.3174, 0.5152],
        [1.8573, 0.2471],
        [13.4839, 0.8126],
    ],
    [
        [4.5631, 1.4402],
        [3.0121, 1.4402],
        [0.8974, 0.5985],
        [12.8052, 2.2789],
    ],
    [
        [2.6444, 2.0920],
        [1.8140, 2.0687],
        [0.9665, 0.7320],
        [6.2934, 3.5031],
    ],
    [
        [20.4054, 7.3984],
        [17.2663, 7.3749],
        [6.8486, 4.3753],
        [41.4859, 10.4442],
    ],
])
SAMPLE_PCT_OF_CONTRIBUTION_NEW_DATA = np.array([
    [
        [3.1313, 1.3566],
        [2.0864, 1.3321],
        [1.4071, 0.3552],
        [7.5099, 2.4213],
    ],
    [
        [5.3655, 2.0643],
        [4.7827, 2.0207],
        [0.41329631, 0.84428596],
        [13.87635608, 3.35490491],
    ],
    [
        [5.1181, 0.5344],
        [3.44958735, 0.52857387],
        [1.91143938, 0.25474956],
        [13.72126045, 0.83085063],
    ],
    [
        [4.52196169, 1.4429],
        [2.98539972, 1.4441],
        [0.88739212, 0.59676804],
        [12.70448227, 2.2853],
    ],
    [
        [2.62795258, 2.0920],
        [1.80218649, 2.0707],
        [0.95925686, 0.7320],
        [6.26837456, 3.5082],
    ],
    [
        [20.76493454, 7.48902893],
        [17.56834984, 7.47050285],
        [7.01468825, 4.46613917],
        [42.18219433, 10.53596172],
    ],
])
SAMPLE_BASELINE_PCT_OF_CONTRIBUTION = np.array([
    [79.5945, 92.6015],
    [-6.5458, 92.2368],
    [-177.0902, 63.8475],
    [394.5644, 121.9298],
])
SAMPLE_BASELINE_PCT_OF_CONTRIBUTION_NON_PAID = np.array([
    [3.783993e-04, -3.296633e02],
    [-3.634485e-04, -3.257378e02],
    [-1.204522e-02, -4.079909e02],
    [1.350970e-02, -2.750774e02],
])
ADSTOCK_DECAY_CI_HI = np.array([1.0, 1.0, 0.8658, 0.9709, 0.7496])
ADSTOCK_DECAY_CI_LO = np.array([1.0, 1.0, 0.8328, 0.5749, 0.6936])
ADSTOCK_DECAY_MEAN = np.array([1.0, 1.0, 0.8493, 0.8630, 0.7215])
ORGANIC_ADSTOCK_DECAY_CI_HI = np.array([1.0, 0.9636, 0.9291, 0.8962, 0.8650])
ORGANIC_ADSTOCK_DECAY_CI_LO = np.array([1.0, 0.6623, 0.4394, 0.2920, 0.1944])
ORGANIC_ADSTOCK_DECAY_MEAN = np.array([1.0, 0.8076, 0.6633, 0.5537, 0.4693])
ORGANIC_RF_ADSTOCK_DECAY_CI_HI = np.array([1.0, 0.9208, 0.8482, 0.781, 0.7202])
ORGANIC_RF_ADSTOCK_DECAY_CI_LO = np.array([1.0, 0.6674, 0.4460, 0.2985, 0.2001])
ORGANIC_RF_ADSTOCK_DECAY_MEAN = np.array([1.0, 0.8344, 0.7042, 0.6001, 0.5155])
HILL_CURVES_CI_HI = np.array([0.0, 0.0, 0.00098, 0.00895, 0.00195])
HILL_CURVES_CI_LO = np.array([0.0, 0.0, 0.00085, 0.00322, 0.00169])
HILL_CURVES_MEAN = np.array([0.0, 0.0, 0.00091, 0.00606, 0.00183])
HILL_CURVES_COUNT_HISTOGRAM = np.array(
    [34.55127961, 34.55127961, 51.82691941, 51.82691941, 17.2756398]
)
HILL_CURVES_SCALED_COUNT_HISTOGRAM = np.array(
    [0.06667, 0.06667, 0.09999999, 0.09999999, 0.03333]
)
HILL_CURVES_START_INTERVAL_HISTOGRAM = np.array(
    [0.00445, 0.00468, 0.004898, 0.00512, 0.00534]
)
HILL_CURVES_END_INTERVAL_HISTOGRAM = np.array(
    [0.00468, 0.004898, 0.00512, 0.00534, 0.00557]
)

PREDICTIVE_ACCURACY_NO_HOLDOUT_ID_NO_GEOS_OR_TIMES = np.array(
    [-2.785, -5.832, 10.677, 0.696, 1.001, 0.596]
)
PREDICTIVE_ACCURACY_NO_HOLDOUT_ID_GEOS_NO_TIMES = np.array(
    [-4.295, -4.705, 3.646, 1.158, 1.083, 0.820]
)
PREDICTIVE_ACCURACY_NO_HOLDOUT_ID_TIMES_NO_GEOS = np.array(
    [-1.394, -0.814, 2.242, 0.992, 1.177, 0.608]
)
PREDICTIVE_ACCURACY_NO_HOLDOUT_ID_TIMES_AND_GEOS = np.array(
    [-13.597, -7.360, 1.634, 0.887, 0.990, 0.757]
)
PREDICTIVE_ACCURACY_HOLDOUT_ID_NO_GEOS_OR_TIMES = np.array([
    -2.690704,
    -3.231603,
    -2.784759,
    -2.866354,
    -1.595214,
    -5.836171,
    12.76909,
    1.634914,
    10.724035,
    0.720384,
    1.306767,
    0.696319,
    0.993516,
    1.036484,
    1.00181,
    0.595755,
    0.945436,
    0.596676,
])
PREDICTIVE_ACCURACY_HOLDOUT_ID_GEOS_NO_TIMES = np.array([
    -5.167992,
    -2.34246,
    -4.297958,
    -3.945161,
    -2.930509,
    -4.711397,
    4.080629,
    1.58583,
    3.647858,
    1.457559,
    1.268536,
    1.15958,
    1.123409,
    0.932309,
    1.083609,
    0.8971,
    0.932309,
    0.820476,
])
PREDICTIVE_ACCURACY_HOLDOUT_ID_TIMES_NO_GEOS = np.array([
    -1.398977,
    0.791522,
    -1.392633,
    -0.294972,
    0.791522,
    -0.813414,
    2.577664,
    0.059942,
    2.241968,
    1.445928,
    0.059942,
    0.992835,
    1.349253,
    0.051477,
    1.177509,
    0.693587,
    0.051477,
    0.608612,
])
PREDICTIVE_ACCURACY_HOLDOUT_ID_TIMES_AND_GEO = np.array([
    -20.432268,
    0.791522,
    -13.597249,
    -4.614312,
    0.791522,
    -7.370245,
    2.422502,
    0.059942,
    1.634982,
    2.440133,
    0.059942,
    0.888314,
    1.646492,
    0.051477,
    0.991585,
    1.25399,
    0.051477,
    0.758228,
])
PREDICTIVE_ACCURACY_HOLDOUT_ID_NATIONAL_NO_TIMES = np.array([
    -15.619549,
    -28.130356,
    -17.316074,
    16.30377,
    10.817584,
    15.296103,
    2.40538,
    2.640707,
    2.449049,
])
PREDICTIVE_ACCURACY_HOLDOUT_ID_NATIONAL_TIMES = np.array([
    -22.270792,
    np.nan,
    -22.270792,
    161.652573,
    np.nan,
    161.652573,
    4.597788,
    np.nan,
    4.597788,
])

SAMPLE_IMPRESSIONS = np.array([
    1.4520000e03,
    1.3760000e03,
    1.2730000e03,
    3.2716225e06,
    3.4970928e06,
    6.7728160e06,
])
SAMPLE_IMPRESSIONS_NEW_DATA = np.array([
    1.396000e03,
    1.604000e03,
    1.414000e03,
    3.2261100e06,
    3.4631668e06,
    6.693691e06,
])
SAMPLE_PCT_OF_IMPRESSIONS = np.array([
    2.143865e-02,
    2.031651e-02,
    1.879573e-02,
    4.830520e01,
    5.163425e01,
    1.000000e02,
])
SAMPLE_PCT_OF_IMPRESSIONS_NEW_DATA = np.array([
    2.0855458e-02,
    2.3962863e-02,
    2.1124369e-02,
    4.8196281e01,
    5.1737774e01,
    1.000000e02,
])

SAMPLE_CPM = np.array([
    2.023468e02,
    2.026558e02,
    2.008992e02,
    8.318969e-02,
    8.231886e-02,
    2.050032e-01,
])
SAMPLE_CPM_NEW_DATA = np.array([
    201.91405,
    196.15132,
    204.25684,
    8.436329e-02,
    8.312529e-02,
    0.21592869,
])


def generate_model_fit_data(
    geo: Sequence[str] | None = None,
    time: Sequence[str] | None = None,
    actual: Sequence[Sequence[int]] | None = None,
) -> xr.Dataset:
  """Helper method to generate simulated model fit analyzed data."""
  metric = [c.MEAN, c.MEDIAN, c.CI_LO, c.CI_HI]
  if geo:
    n_geos = len(geo)
  else:
    n_geos = 5
    geo = [f"geo {i}" for i in range(n_geos)]
  if time:
    n_time = len(time)
  else:
    n_time = 52
    time = pd.date_range("2023-01-01", freq="W-SUN", periods=n_time).format(
        formatter=lambda x: x.strftime("%Y-%m-%d")
    )

  np.random.seed(0)
  expected = abs(np.random.lognormal(10, 1, size=(n_geos, n_time, 4)))
  baseline = abs(np.random.lognormal(10, 1, size=(n_geos, n_time, 4)))
  if not actual:
    actual = abs(np.random.lognormal(10, 1, size=(n_geos, n_time)))

  return xr.Dataset(
      data_vars={
          c.EXPECTED: (
              [c.GEO, c.TIME, c.METRIC],
              expected,
          ),
          c.BASELINE: (
              [c.GEO, c.TIME, c.METRIC],
              baseline,
          ),
          c.ACTUAL: ([c.GEO, c.TIME], actual),
      },
      coords={
          c.GEO: geo,
          c.TIME: time,
          c.METRIC: metric,
      },
      attrs={c.CONFIDENCE_LEVEL: c.DEFAULT_CONFIDENCE_LEVEL},
  )


def generate_predictive_accuracy_table(
    with_holdout: bool = False, column_var: str | None = None
) -> pd.DataFrame:
  """Helper method to simulate predictive accuracy DataFrame for Summarizer."""
  metric = [c.R_SQUARED, c.MAPE, c.WMAPE]
  geo_granularity = [c.GEO, c.NATIONAL]
  evaluation_set = [c.TRAIN, c.TEST, c.ALL_DATA]

  shape = [len(metric), len(geo_granularity)]
  dims = [c.METRIC, c.GEO_GRANULARITY]
  coords = {
      c.METRIC: metric,
      c.GEO_GRANULARITY: geo_granularity,
  }
  if with_holdout:
    shape.append(len(evaluation_set))
    dims.append(c.EVALUATION_SET_VAR)
    coords[c.EVALUATION_SET_VAR] = evaluation_set
  np.random.seed(0)
  value = np.random.lognormal(0, 1, size=shape)
  ds = xr.Dataset(
      data_vars={
          c.VALUE: (dims, value),
      },
      coords=coords,
  )
  df = ds.to_dataframe().reset_index()
  if not column_var:
    return df
  coords = list(ds.coords)
  if column_var not in coords:
    raise ValueError(
        f"The DataFrame cannot be pivoted by {column_var} as it does not"
        " exist in the DataFrame."
    )
  indices = coords.copy()
  indices.remove(column_var)
  pivoted_df = (
      df.pivot(
          index=indices,
          columns=column_var,
          values=c.VALUE,
      )
      .reset_index()
      .rename_axis(None, axis=1)
  )
  # The 2-Pager displays the national predictive accuracy metric data only.
  national_table = pivoted_df[pivoted_df[c.GEO_GRANULARITY] == c.NATIONAL]
  return national_table


def generate_paid_summary_metrics() -> xr.Dataset:
  """Helper method to generate simulated media summary metrics data."""
  channel = [f"ch_{i}" for i in range(3)] + [f"rf_ch_{i}" for i in range(2)]
  channel.append(c.ALL_CHANNELS)
  metric = [c.MEAN, c.MEDIAN, c.CI_LO, c.CI_HI]
  distribution = [c.PRIOR, c.POSTERIOR]

  np.random.seed(0)
  shape = (len(channel), len(metric), len(distribution))
  pct_of_spend = np.random.randint(low=0, high=100, size=len(channel))
  spend = np.random.randint(low=10, high=1000, size=len(channel))
  impressions = np.random.randint(low=10, high=1000, size=len(channel))
  cpm = np.random.random(size=len(channel))
  roi = np.random.lognormal(1, 1, size=shape)
  mroi = np.random.lognormal(0, 1, size=shape)
  cpik = np.random.lognormal(0, 1, size=shape)
  incremental_outcome = np.random.lognormal(10, 1, size=shape)
  effectiveness = np.random.lognormal(1, 1, size=shape)
  pct_of_contribution = np.random.randint(low=0, high=50, size=shape)
  pct_of_impressions = np.random.randint(low=0, high=100, size=len(channel))

  return xr.Dataset(
      data_vars={
          c.IMPRESSIONS: ([c.CHANNEL], impressions),
          c.PCT_OF_IMPRESSIONS: ([c.CHANNEL], pct_of_impressions),
          c.SPEND: ([c.CHANNEL], spend),
          c.PCT_OF_SPEND: ([c.CHANNEL], pct_of_spend),
          c.CPM: ([c.CHANNEL], cpm),
          c.INCREMENTAL_OUTCOME: (
              [c.CHANNEL, c.METRIC, c.DISTRIBUTION],
              incremental_outcome,
          ),
          c.PCT_OF_CONTRIBUTION: (
              [c.CHANNEL, c.METRIC, c.DISTRIBUTION],
              pct_of_contribution,
          ),
          c.ROI: (
              [c.CHANNEL, c.METRIC, c.DISTRIBUTION],
              roi,
          ),
          c.EFFECTIVENESS: (
              [c.CHANNEL, c.METRIC, c.DISTRIBUTION],
              effectiveness,
          ),
          c.MROI: (
              [c.CHANNEL, c.METRIC, c.DISTRIBUTION],
              mroi,
          ),
          c.CPIK: (
              [c.CHANNEL, c.METRIC, c.DISTRIBUTION],
              cpik,
          ),
      },
      coords={
          c.CHANNEL: channel,
          c.METRIC: metric,
          c.DISTRIBUTION: distribution,
      },
      attrs={c.CONFIDENCE_LEVEL: c.DEFAULT_CONFIDENCE_LEVEL},
  )


def generate_all_summary_metrics(aggregate_times: bool = True) -> xr.Dataset:
  """Helper method to generate simulated summary metrics data."""
  channel = (
      [f"ch_{i}" for i in range(3)]
      + [f"rf_ch_{i}" for i in range(2)]
      + [f"organic_media_{i}" for i in range(4)]
      + [f"organic_rf_ch_{i}" for i in range(1)]
      + [f"non_media_{i}" for i in range(2)]
  )
  channel.append(c.ALL_CHANNELS)
  metric = [c.MEAN, c.MEDIAN, c.CI_LO, c.CI_HI]
  distribution = [c.PRIOR, c.POSTERIOR]
  time = pd.date_range("2023-01-01", freq="W-SUN", periods=5).format(
      formatter=lambda x: x.strftime("%Y-%m-%d")
  )

  np.random.seed(0)

  if aggregate_times:
    shape = (len(channel), len(metric), len(distribution))
    dims = [c.CHANNEL, c.METRIC, c.DISTRIBUTION]
  else:
    shape = (len(time), len(channel), len(metric), len(distribution))
    dims = [c.TIME, c.CHANNEL, c.METRIC, c.DISTRIBUTION]

  incremental_outcome = np.random.lognormal(10, 1, size=shape)
  effectiveness = np.random.lognormal(1, 1, size=shape)
  pct_of_contribution = np.random.randint(low=0, high=50, size=shape)

  coords = {
      c.CHANNEL: channel,
      c.METRIC: metric,
      c.DISTRIBUTION: distribution,
  }
  if not aggregate_times:
    coords[c.TIME] = time

  return xr.Dataset(
      data_vars={
          c.INCREMENTAL_OUTCOME: (dims, incremental_outcome),
          c.PCT_OF_CONTRIBUTION: (dims, pct_of_contribution),
          c.EFFECTIVENESS: (dims, effectiveness),
      },
      coords=coords,
      attrs={c.CONFIDENCE_LEVEL: c.DEFAULT_CONFIDENCE_LEVEL},
  )


def generate_response_curve_data(
    n_channels: int = 5, spend_multiplier: Sequence[int] | None = None
) -> xr.Dataset:
  """Helper method to generate simulated response curve data."""
  channels = [f"channel {i}" for i in range(n_channels)]
  metric = [c.MEAN, c.CI_LO, c.CI_HI]
  spend_multiplier = (
      list(np.arange(0, 2, 0.05))
      if spend_multiplier is None
      else spend_multiplier
  )

  np.random.seed(0)
  shape = (
      len(spend_multiplier),
      len(channels),
      len(metric),
  )
  spend = np.random.lognormal(
      25, 1, size=(len(spend_multiplier), len(channels))
  )
  incremental_outcome = np.random.lognormal(10, 1, size=shape)

  xarray = xr.Dataset(
      data_vars={
          c.SPEND: (
              [c.SPEND_MULTIPLIER, c.CHANNEL],
              spend,
          ),
          c.INCREMENTAL_OUTCOME: (
              [c.SPEND_MULTIPLIER, c.CHANNEL, c.METRIC],
              incremental_outcome,
          ),
      },
      coords={
          c.CHANNEL: channels,
          c.METRIC: metric,
          c.SPEND_MULTIPLIER: spend_multiplier,
      },
      attrs={c.CONFIDENCE_LEVEL: c.DEFAULT_CONFIDENCE_LEVEL},
  )
  return xarray


def generate_predictive_accuracy_data(holdout_id: bool = False) -> xr.Dataset:
  """Helper method to generate simulated predictive accuracy data."""

  np.random.seed(0)

  xr_dims = [c.METRIC, c.GEO_GRANULARITY]
  xr_coords = {
      c.METRIC: [c.R_SQUARED, c.MAPE, c.WMAPE],
      c.GEO_GRANULARITY: [c.GEO, c.NATIONAL],
  }
  rsquared_arr = [np.random.uniform(0.0, 1.0) for _ in range(2)]
  mape_arr = [np.random.uniform(0.0, 1.0) for _ in range(2)]
  wmape_arr = [np.random.uniform(0.0, 1.0) for _ in range(2)]

  if not holdout_id:
    stacked_metric_values = np.stack([rsquared_arr, mape_arr, wmape_arr])
    xr_data = {c.VALUE: (xr_dims, stacked_metric_values)}
  else:
    geo_train = [np.random.uniform(0.0, 1.0) for _ in range(3)]
    national_train = [np.random.uniform(0.0, 1.0) for _ in range(3)]
    geo_test = [np.random.uniform(0.0, 1.0) for _ in range(3)]
    national_test = [np.random.uniform(0.0, 1.0) for _ in range(3)]
    geo_all_data = [np.random.uniform(0.0, 1.0) for _ in range(3)]
    national_all_data = [np.random.uniform(0.0, 1.0) for _ in range(3)]

    stacked_train = np.stack([geo_train, national_train], axis=-1)
    stacked_test = np.stack([geo_test, national_test], axis=-1)
    stacked_all_data = np.stack([geo_all_data, national_all_data], axis=-1)
    stacked_total = np.stack(
        [stacked_train, stacked_test, stacked_all_data], axis=-1
    )

    xr_dims.append(c.EVALUATION_SET_VAR)
    xr_coords[c.EVALUATION_SET_VAR] = list(c.EVALUATION_SET)
    xr_data = {c.VALUE: (xr_dims, stacked_total)}

  return xr.Dataset(data_vars=xr_data, coords=xr_coords)


def generate_optimal_frequency_data(
    channel_prefix: str = c.RF_CHANNEL,
    num_channels: int = 5,
    use_roi: bool = True,
) -> xr.Dataset:
  """Helper method to generate simulated optimal frequency data."""
  frequency = list(np.arange(1, 7.05, 0.1))
  rf_channel = [f"{channel_prefix}_{i}" for i in range(num_channels)]
  metric = [c.MEAN, c.MEDIAN, c.CI_LO, c.CI_HI]

  np.random.seed(0)
  metric_by_frequency = np.random.lognormal(
      1, 1, size=(len(frequency), len(rf_channel), len(metric))
  )
  optimal_frequency = np.random.lognormal(1, 1, size=(len(rf_channel)))
  optimized_effectiveness = np.random.lognormal(
      1, 1, size=(len(rf_channel), len(metric))
  )
  optimized_incremental_outcome = np.random.lognormal(
      1, 1, size=(len(rf_channel), len(metric))
  )
  optimized_pct_of_contribution = np.random.lognormal(
      1, 1, size=(len(rf_channel), len(metric))
  )
  optimized_roi = np.random.lognormal(1, 1, size=(len(rf_channel), len(metric)))
  optimized_mroi_by_reach = np.random.lognormal(
      1, 1, size=(len(rf_channel), len(metric))
  )
  optimized_mroi_by_frequency = np.random.lognormal(
      1, 1, size=(len(rf_channel), len(metric))
  )
  optimized_cpik = np.random.lognormal(
      1, 1, size=(len(rf_channel), len(metric))
  )

  metric_name = c.ROI if use_roi else c.CPIK
  data_vars = {
      metric_name: (
          [c.FREQUENCY, c.RF_CHANNEL, c.METRIC],
          metric_by_frequency,
      ),
      c.OPTIMAL_FREQUENCY: (
          [c.RF_CHANNEL],
          optimal_frequency,
      ),
      c.OPTIMIZED_EFFECTIVENESS: (
          [c.RF_CHANNEL, c.METRIC],
          optimized_effectiveness,
      ),
      c.OPTIMIZED_INCREMENTAL_OUTCOME: (
          [c.RF_CHANNEL, c.METRIC],
          optimized_incremental_outcome,
      ),
      c.OPTIMIZED_PCT_OF_CONTRIBUTION: (
          [c.RF_CHANNEL, c.METRIC],
          optimized_pct_of_contribution,
      ),
  }

  if use_roi:
    data_vars[c.OPTIMIZED_ROI] = (
        (c.RF_CHANNEL, c.METRIC),
        optimized_roi,
    )
    data_vars[c.OPTIMIZED_MROI_BY_REACH] = (
        (c.RF_CHANNEL, c.METRIC),
        optimized_mroi_by_reach,
    )
    data_vars[c.OPTIMIZED_MROI_BY_FREQUENCY] = (
        (c.RF_CHANNEL, c.METRIC),
        optimized_mroi_by_frequency,
    )
  else:
    data_vars[c.OPTIMIZED_CPIK] = (
        (c.RF_CHANNEL, c.METRIC),
        optimized_cpik,
    )

  return xr.Dataset(
      data_vars=data_vars,
      coords={
          c.FREQUENCY: frequency,
          c.RF_CHANNEL: rf_channel,
          c.METRIC: metric,
      },
  )


def generate_hill_curves_dataframe() -> pd.DataFrame:
  """Helper method to generate simulated hill curve data."""
  channel_names = (
      [f"ch_{i}" for i in range(3)]
      + [f"rf_ch_{i}" for i in range(2)]
      + [f"organic_ch_{i}" for i in range(2)]
      + [f"organic_rf_ch_{i}" for i in range(1)]
  )
  channel_array = []
  channel_type_array = []
  for channel_name in channel_names:
    for _ in range(100):
      channel_array.append(channel_name)
      if channel_name.startswith("ch_"):
        channel_type_array.append(c.MEDIA)
      elif channel_name.startswith("rf_ch_"):
        channel_type_array.append(c.RF)
      elif channel_name.startswith("organic_ch_"):
        channel_type_array.append(c.ORGANIC_MEDIA)
      elif channel_name.startswith("organic_rf_ch_"):
        channel_type_array.append(c.ORGANIC_RF)

  np.random.seed(0)
  media_units_array = [
      np.random.uniform(0, 1000) for _ in range(len(channel_array))
  ]
  distribution_array = [
      c.POSTERIOR if i % 2 == 0 else c.PRIOR for i in range(len(channel_array))
  ]
  ci_hi_array = [np.random.rand() for _ in range(len(channel_array))]
  ci_lo_array = [np.random.rand() for _ in range(len(channel_array))]
  mean_array = [np.random.rand() for _ in range(len(channel_array))]

  one_channel_impressions_hist = [
      np.random.rand() if i == 0 else None for i in range(100)
  ]
  one_channel_start_interval_hist = [
      np.random.uniform(0, 1000) if i == 0 else None for i in range(100)
  ]
  one_channel_end_interval_hist = [
      np.random.uniform(0, 1000) if i == 0 else None for i in range(100)
  ]

  scaled_count, start_interval, end_interval = [], [], []

  for _ in range(len(channel_names)):
    scaled_count.extend(one_channel_impressions_hist)
    start_interval.extend(one_channel_start_interval_hist)
    end_interval.extend(one_channel_end_interval_hist)

  data_hill = {
      c.CHANNEL: channel_array,
      c.MEDIA_UNITS: media_units_array,
      c.DISTRIBUTION: distribution_array,
      c.CI_HI: ci_hi_array,
      c.CI_LO: ci_lo_array,
      c.MEAN: mean_array,
      c.CHANNEL_TYPE: channel_type_array,
      c.SCALED_COUNT_HISTOGRAM: scaled_count,
      c.START_INTERVAL_HISTOGRAM: start_interval,
      c.END_INTERVAL_HISTOGRAM: end_interval,
  }

  return pd.DataFrame(data_hill).reset_index(drop=True)


def generate_adstock_decay_data() -> pd.DataFrame:
  """Helper method to generate simulated adstock decay data."""
  channel_names = [f"ch_{i}" for i in range(3)] + [
      f"rf_ch_{i}" for i in range(2)
  ]

  channel_array, time_units_array = [], []
  np.random.seed(0)

  for channel in range(len(channel_names)):
    for _ in range(100):
      channel_array.append(channel)
    time_units_array.extend(np.linspace(0, 20, 100))

  distribution_array = [
      c.PRIOR if i % 2 == 0 else c.POSTERIOR for i in range(len(channel_array))
  ]
  mean_array = [np.random.rand() for _ in range(len(channel_array))]
  ci_lo_array = [np.random.rand() for _ in range(len(channel_array))]
  ci_hi_array = [np.random.rand() for _ in range(len(channel_array))]

  data_hill = {
      c.TIME_UNITS: time_units_array,
      c.CHANNEL: channel_array,
      c.DISTRIBUTION: distribution_array,
      c.MEAN: mean_array,
      c.CI_LO: ci_lo_array,
      c.CI_HI: ci_hi_array,
  }

  return pd.DataFrame(data_hill).reset_index(drop=True)


def get_child_element(
    root: et.ElementTree.Element,
    path: str,
    attribs: Mapping[str, str] | None = None,
) -> et.ElementTree.Element:
  """Searches for a descendant element under `root` with the given path.

  Args:
    root: The top-level element to search from.
    path: Path fom the root to search.
    attribs: Optional attribute match to search for.

  Returns:
    ElementTree Element found from the path and attribute match.
  Raises:
    AssertionError if not found.
  """
  for div in root.findall(path):
    if attribs:
      if not (attribs.items() <= div.attrib.items()):
        continue
    return div
  raise AssertionError(
      f"Cannot find child element {path} under {root} "
      + (f"with {attribs}" if attribs else "")
  )


def get_table_row_values(
    tr: et.ElementTree.Element, row_element="td"
) -> Sequence[str]:
  row_values = []
  for row in tr.findall(row_element):
    row_values.append(row.text or "")
  return row_values


def generate_selected_times(start: str, periods: int) -> Sequence[str]:
  return pd.date_range(start, freq="W-SUN", periods=periods).format(
      formatter=lambda x: x.strftime("%Y-%m-%d")
  )
