# aliBuild's Anonymous Aggregate User Behaviour Analytics

aliBuild has begun gathering **anonymous** aggregate user behaviour
analytics. You will be notified the first time you run an aliBuild with
this feature enabled, and you will be able to opt out. Read below for
all the details.

## Why?
Resources which we can dedicate to support multiple architectures and
compilers are limited. As a result, we do not have the resources to do
detailed user studies of aliBuild users to decide on how best to design
future features and prioritise current work. Anonymous aggregate user
analytics allow us to prioritise fixes and features based on how, where
and when people use aliBuild.
For example:

- if a recipe is widely used and is failing often it will enable us to
  prioritise fixing that recipe over others.
- collecting the OS version allows us to decide what versions of Linux / OS X to
  prioritise and support and identify build failures that occur only on single
  versions.

## What?
aliBuild's analytics record some shared information for every event:

- The aliBuild user agent e.g. `aliBuild/1.3.0 (Macintosh; x86-64 osx) Python/2.7.9`
- The Google Analytics version i.e. `1`
  (https://developers.google.com/analytics/devguides/collection/protocol/v1/parameters#v)
- The aliBuild analytics tracking ID e.g. `UA-77346950-1`
  (https://developers.google.com/analytics/devguides/collection/protocol/v1/parameters#tid)
- A aliBuild analytics user ID e.g. `1BAB65CC-FE7F-4D8C-AB45-B7DB5A6BA9CB`.
  This is generated by `uuidgen` and stored in `~/.config/alibuild/analytics-uuid`
  This does not allow us to track individual users but does enable us to
  accurately measure user counts vs. event counts
  (https://developers.google.com/analytics/devguides/collection/protocol/v1/parameters#cid)
- The Google Analytics anonymous IP setting is enabled i.e. `1`
  (https://developers.google.com/analytics/devguides/collection/protocol/v1/parameters#aip)
- The aliBuild application name e.g. `aliBuild` (https://developers.google.com/analytics/devguides/collection/protocol/v1/parameters#an)
- The aliBuild application version e.g. `1.3.0` (https://developers.google.com/analytics/devguides/collection/protocol/v1/parameters#av)
- The aliBuild analytics hit type e.g. `screenview` (https://developers.google.com/analytics/devguides/collection/protocol/v1/parameters#t)

aliBuild's analytics records the following different events:

- a `screenview` hit type with the official aliBuild command you have run (with
  arguments stripped) e.g. `aliBuild build` (not `aliBuild build AliceO2`)
- an `event` hit type with the `install` event category, the aliBuild recipe you
  have requested to build and any used options e.g. `AliRoot devel=AliRoot sys=cmake deps=ROOT` as the
  action and an event label e.g. `osx_x86-64` to indicate
  the OS version. This allows us to identify formulae that need fixed and where
  more easily.
- an `event` hit type with the `BuildSuccess` event category, the aliBuild
  recipe invoked to install e.g. `zlib` as the action and an event label
  e.g. `osx_x86-64 v1.2.8 abcdef0123` to indicate the architecture, the version and
  the hash of the package being build.
- an `event` hit type with the `BuildError` event category, the aliBuild
  formula that failed to install e.g. `AliRoot` as the action and an event label
  e.g. `osx_x86-64 master abcdef0123` to indicate the architecture, the branch / tag
  and the commit that failed.
- an `exception` hit type with the `exception` event category, exception
  description of the exception name e.g. `IOError` and whether
  the exception was fatal e.g. `1`

You can also view all the information that is sent by aliBuild's
analytics by setting `ALIBUILD_ANALYTICS_DEBUG=1` in your environment.
Please note this will also stop any analytics being sent.

It is impossible for the aliBuild developers to match any particular
event to any particular user, even if we had access to the aliBuild
analytics user ID (which we do not). As far as we can tell it would
be impossible Google to match the randomly generated aliBuild-only
analytics user ID to any other Google Analytics user ID. If Google
turned evil the only thing they could do would be to lie about
anonymising IP addresses and attempt to match users based on IP
addresses.

## When/Where?
aliBuild's analytics are sent throughout aliBuild's execution to Google
Analytics over HTTPS.

## Who?
aliBuild's analytics are accessible to aliBuild's current maintainers
and ALICE Offline Coordination.

## How?
The code is viewable in:

https://github.com/alisw/alibuild/blob/master/alibuild_helpers/analytics.py

They are done in a separate background process and fail fast to
avoid delaying any execution. They will fail immediately and silently if
you have no network connection.

## Opting out
aliBuild analytics helps us maintainers and leaving it on is
appreciated. However, if you want to opt out of aliBuild's analytics,
you can set this variable in your environment:

```sh
export ALIBUILD_NO_ANALYTICS=1
```

Alternatively, this will prevent analytics from ever being sent:

```sh
aliBuild analytics off
```

In case you decide you want to turn analytics back on:

```sh
aliBuild analytics on
```

## Thanks
We would like to thank the Homebrew project as this file and the actual
python reimplementation of the analytics is based on their documentation
and code.
