# sparkfly
The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.

The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.1.11
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://help.sparkfly.com/](https://help.sparkfly.com/)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import sparkfly
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import sparkfly
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import sparkfly
from sparkfly.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api-staging.sparkfly.com/v1.0
# See configuration.py for a list of all supported configuration parameters.
configuration = sparkfly.Configuration(
    host = "https://api-staging.sparkfly.com/v1.0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: XAuthToken
configuration.api_key['XAuthToken'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['XAuthToken'] = 'Bearer'


# Enter a context with an instance of the API client
async with sparkfly.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = sparkfly.AudiencesApi(api_client)
    audience_id = 'audience_id_example' # str | audience to find or modify

    try:
        # Remove an Audience
        await api_instance.delete_audiences_id(audience_id)
    except ApiException as e:
        print("Exception when calling AudiencesApi->delete_audiences_id: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api-staging.sparkfly.com/v1.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AudiencesApi* | [**delete_audiences_id**](docs/AudiencesApi.md#delete_audiences_id) | **DELETE** /audiences/{audience_id} | Remove an Audience
*AudiencesApi* | [**delete_audiences_id_sub_audiences_sub_audience_id**](docs/AudiencesApi.md#delete_audiences_id_sub_audiences_sub_audience_id) | **DELETE** /audiences/{audience_id}/sub_audiences/{sub_audience_id} | Remove a Sub-Audience
*AudiencesApi* | [**get_audiences**](docs/AudiencesApi.md#get_audiences) | **GET** /audiences | List all Audiences
*AudiencesApi* | [**get_audiences_id**](docs/AudiencesApi.md#get_audiences_id) | **GET** /audiences/{audience_id} | Retrieve an Audience
*AudiencesApi* | [**get_audiences_id_sub_audiences**](docs/AudiencesApi.md#get_audiences_id_sub_audiences) | **GET** /audiences/{audience_id}/sub_audiences | List all Sub-Audiences
*AudiencesApi* | [**get_audiences_id_sub_audiences_sub_audience_id**](docs/AudiencesApi.md#get_audiences_id_sub_audiences_sub_audience_id) | **GET** /audiences/{audience_id}/sub_audiences/{sub_audience_id} | Retrieve a Sub-Audience
*AudiencesApi* | [**post_audiences**](docs/AudiencesApi.md#post_audiences) | **POST** /audiences | Create an Audience
*AudiencesApi* | [**post_audiences_id_sub_audiences**](docs/AudiencesApi.md#post_audiences_id_sub_audiences) | **POST** /audiences/{audience_id}/sub_audiences | Create a Sub-Audience
*AudiencesApi* | [**put_audiences_id**](docs/AudiencesApi.md#put_audiences_id) | **PUT** /audiences/{audience_id} | Update an Audience
*AudiencesApi* | [**put_audiences_id_sub_audiences_sub_audience_id**](docs/AudiencesApi.md#put_audiences_id_sub_audiences_sub_audience_id) | **PUT** /audiences/{audience_id}/sub_audiences/{sub_audience_id} | Update a Sub-Audience
*AuthenticationApi* | [**post_auth**](docs/AuthenticationApi.md#post_auth) | **POST** /auth | Request an Authentication Token
*BIStoreListsApi* | [**get_merchants_bi_store_lists**](docs/BIStoreListsApi.md#get_merchants_bi_store_lists) | **GET** /merchants/bi_store_lists | List all BI Store Lists
*CampaignsApi* | [**get_campaign**](docs/CampaignsApi.md#get_campaign) | **GET** /campaigns/{campaign_id} | Retrieve a Campaign by Campaign ID
*CampaignsApi* | [**get_campaign_tags**](docs/CampaignsApi.md#get_campaign_tags) | **GET** /campaigns/tags | Retrieve Campaign Tags
*CampaignsApi* | [**get_campaigns**](docs/CampaignsApi.md#get_campaigns) | **GET** /campaigns | List all Campaigns
*CampaignsApi* | [**post_campaign**](docs/CampaignsApi.md#post_campaign) | **POST** /campaigns | Create a Campaign
*CampaignsApi* | [**put_campaign**](docs/CampaignsApi.md#put_campaign) | **PUT** /campaigns/{campaign_id} | Update a Campaign by Campaign ID
*CampaignsApi* | [**put_campaigns_campaign_id_actions_approve**](docs/CampaignsApi.md#put_campaigns_campaign_id_actions_approve) | **PUT** /campaigns/{campaign_id}/actions/{action} | Set a Campaign&#39;s Status
*CtmApi* | [**get_ctm_custom_messages**](docs/CtmApi.md#get_ctm_custom_messages) | **GET** /v2/ctm/customposmessages | CTM Custom Messages
*CtmApi* | [**get_ctm_store**](docs/CtmApi.md#get_ctm_store) | **GET** /v2/ctm/stores | CTM Stores
*CtmApi* | [**get_show_ctm**](docs/CtmApi.md#get_show_ctm) | **GET** /ctm/members/{site_id}/{credential} | CTM Show Response
*CtmApi* | [**post_allocate_ctm**](docs/CtmApi.md#post_allocate_ctm) | **POST** /ctm/allocate/{site_id}/{credential} | CTM Allocate
*CtmApi* | [**post_deallocate_ctm**](docs/CtmApi.md#post_deallocate_ctm) | **POST** /ctm/deallocate/{site_id} | CTM Dealocate
*CtmApi* | [**post_qitems_ctm**](docs/CtmApi.md#post_qitems_ctm) | **POST** /ctm/qitems/{site_id}/{credential} | CTM Qitems
*CtmApi* | [**post_update_ctm**](docs/CtmApi.md#post_update_ctm) | **POST** /v2/ctm/members/{site_id}/{credential} | CTM Update Response
*CtmApi* | [**post_update_ctm_siteid**](docs/CtmApi.md#post_update_ctm_siteid) | **POST** /v2/ctm/members/{site_id} | CTM Update Response
*CtmApi* | [**put_show_ctm**](docs/CtmApi.md#put_show_ctm) | **PUT** /v2/ctm/members/{site_id}/{credential} | CTM Show Response
*CtmApi* | [**put_transaction_update_ctm**](docs/CtmApi.md#put_transaction_update_ctm) | **PUT** /ctm/members/{site_id} | CTM Transaction Update
*CtmApi* | [**put_update_ctm**](docs/CtmApi.md#put_update_ctm) | **PUT** /ctm/members/{site_id}/{credential} | CTM Update Response
*EligibleItemSetsApi* | [**delete_offers_offer_id_eligible_item_sets_id**](docs/EligibleItemSetsApi.md#delete_offers_offer_id_eligible_item_sets_id) | **DELETE** /offers/{offer_id}/eligible_item_sets/{id} | Remove an Eligible Item Set
*EligibleItemSetsApi* | [**get_offers_offer_id_eligible_item_sets**](docs/EligibleItemSetsApi.md#get_offers_offer_id_eligible_item_sets) | **GET** /offers/{offer_id}/eligible_item_sets | List all Eligible Item Sets
*EligibleItemSetsApi* | [**get_offers_offer_id_eligible_item_sets_id**](docs/EligibleItemSetsApi.md#get_offers_offer_id_eligible_item_sets_id) | **GET** /offers/{offer_id}/eligible_item_sets/{id} | Get an Eligible Item Set
*EligibleItemSetsApi* | [**post_offers_offer_id_eligible_item_sets**](docs/EligibleItemSetsApi.md#post_offers_offer_id_eligible_item_sets) | **POST** /offers/{offer_id}/eligible_item_sets | Create an Eligible Item Set
*EligibleItemSetsApi* | [**put_offers_offer_id_eligible_item_sets_id**](docs/EligibleItemSetsApi.md#put_offers_offer_id_eligible_item_sets_id) | **PUT** /offers/{offer_id}/eligible_item_sets/{id} | Update an Eligible Item Set
*EmailOptInApi* | [**post_optins**](docs/EmailOptInApi.md#post_optins) | **POST** /optins | Email Opt In
*ImpressionsApi* | [**delete_impressions_id**](docs/ImpressionsApi.md#delete_impressions_id) | **DELETE** /impressions/{id} | Delete an Impression
*ImpressionsApi* | [**get_impressions**](docs/ImpressionsApi.md#get_impressions) | **GET** /impressions | List Impressions
*ImpressionsApi* | [**post_impressions**](docs/ImpressionsApi.md#post_impressions) | **POST** /impressions | Create an Impression
*ItemsApi* | [**delete_item_sets_item_set_id**](docs/ItemsApi.md#delete_item_sets_item_set_id) | **DELETE** /item_sets/{item_set_id} | Delete an Item Set
*ItemsApi* | [**delete_item_sets_item_set_id_items_id**](docs/ItemsApi.md#delete_item_sets_item_set_id_items_id) | **DELETE** /item_sets/{item_set_id}/items/{id} | Remove Item from Set
*ItemsApi* | [**delete_items_id**](docs/ItemsApi.md#delete_items_id) | **DELETE** /items/{id} | Delete Item
*ItemsApi* | [**get_item_sets**](docs/ItemsApi.md#get_item_sets) | **GET** /item_sets | Item Set Index
*ItemsApi* | [**get_item_sets_item_set_id**](docs/ItemsApi.md#get_item_sets_item_set_id) | **GET** /item_sets/{item_set_id} | Get an Item Set
*ItemsApi* | [**get_item_sets_item_set_id_items**](docs/ItemsApi.md#get_item_sets_item_set_id_items) | **GET** /item_sets/{item_set_id}/items | Item Set Item Index
*ItemsApi* | [**get_items**](docs/ItemsApi.md#get_items) | **GET** /items | Item Index
*ItemsApi* | [**get_items_id**](docs/ItemsApi.md#get_items_id) | **GET** /items/{id} | Get Item
*ItemsApi* | [**post_item_sets**](docs/ItemsApi.md#post_item_sets) | **POST** /item_sets | Item Set Create
*ItemsApi* | [**post_item_sets_item_set_id_items_id**](docs/ItemsApi.md#post_item_sets_item_set_id_items_id) | **POST** /item_sets/{item_set_id}/items/{id} | Add Item to Set
*ItemsApi* | [**post_items**](docs/ItemsApi.md#post_items) | **POST** /items | Create Item
*ItemsApi* | [**put_item_sets_item_set_id**](docs/ItemsApi.md#put_item_sets_item_set_id) | **PUT** /item_sets/{item_set_id} | Update an Item Set
*ItemsApi* | [**put_items_id**](docs/ItemsApi.md#put_items_id) | **PUT** /items/{id} | Update Item
*MemberPrivacyApi* | [**get_privacy_member_export**](docs/MemberPrivacyApi.md#get_privacy_member_export) | **GET** /privacy/member/export | Exports Data Associated with a Member
*MemberPrivacyApi* | [**post_privacy_member_delete_request**](docs/MemberPrivacyApi.md#post_privacy_member_delete_request) | **POST** /privacy/member/delete_request | Creates a Deletion Request for a Member
*MembersApi* | [**delete_members_member_id**](docs/MembersApi.md#delete_members_member_id) | **DELETE** /members/{member_id} | Remove a Member
*MembersApi* | [**get_members_member_id**](docs/MembersApi.md#get_members_member_id) | **GET** /members/{member_id} | Find a Member
*MembersApi* | [**get_members_profile**](docs/MembersApi.md#get_members_profile) | **GET** /members/{id}/profile | Retrieve a Member Profile
*MembersApi* | [**get_members_search**](docs/MembersApi.md#get_members_search) | **GET** /members/search | Search for a Member
*MembersApi* | [**post_members**](docs/MembersApi.md#post_members) | **POST** /members | Create a Member
*MembersApi* | [**post_members_profile**](docs/MembersApi.md#post_members_profile) | **POST** /members/{id}/profile | Create/Update a Member Profile
*MembersApi* | [**put_members_member_id**](docs/MembersApi.md#put_members_member_id) | **PUT** /members/{member_id} | Update a Member
*OfferListsApi* | [**delete_offer_lists_offer_list_id**](docs/OfferListsApi.md#delete_offer_lists_offer_list_id) | **DELETE** /offer_lists/{offer_list_id} | Remove an Offer List
*OfferListsApi* | [**get_offer_lists**](docs/OfferListsApi.md#get_offer_lists) | **GET** /offer_lists | List all Offer Lists
*OfferListsApi* | [**get_offer_lists_offer_list_id**](docs/OfferListsApi.md#get_offer_lists_offer_list_id) | **GET** /offer_lists/{offer_list_id} | Retrieve an Offer List
*OfferListsApi* | [**post_offer_lists**](docs/OfferListsApi.md#post_offer_lists) | **POST** /offer_lists | Create an Offer List
*OfferListsApi* | [**put_offer_lists_offer_list_id**](docs/OfferListsApi.md#put_offer_lists_offer_list_id) | **PUT** /offer_lists/{offer_list_id} | Update an Offer List
*OfferPOSOfferCodesApi* | [**delete_offers_offer_id_pos_offer_codes_id**](docs/OfferPOSOfferCodesApi.md#delete_offers_offer_id_pos_offer_codes_id) | **DELETE** /offers/{offer_id}/pos_offer_codes/{id} | Remove an Offer POS Offer Code
*OfferPOSOfferCodesApi* | [**get_offers_offer_id_pos_offer_codes**](docs/OfferPOSOfferCodesApi.md#get_offers_offer_id_pos_offer_codes) | **GET** /offers/{offer_id}/pos_offer_codes | List all Offer POS Offer Codes
*OfferPOSOfferCodesApi* | [**get_offers_offer_id_pos_offer_codes_id**](docs/OfferPOSOfferCodesApi.md#get_offers_offer_id_pos_offer_codes_id) | **GET** /offers/{offer_id}/pos_offer_codes/{id} | Get an Offer POS Offer Code
*OfferPOSOfferCodesApi* | [**post_offers_offer_id_pos_offer_codes**](docs/OfferPOSOfferCodesApi.md#post_offers_offer_id_pos_offer_codes) | **POST** /offers/{offer_id}/pos_offer_codes | Create an Offer POS Offer Code
*OfferPOSOfferCodesApi* | [**put_offers_offer_id_pos_offer_codes_id**](docs/OfferPOSOfferCodesApi.md#put_offers_offer_id_pos_offer_codes_id) | **PUT** /offers/{offer_id}/pos_offer_codes/{id} | Update an Offer POS Offer Code
*OfferStatesApi* | [**get_members_member_id_offer_states**](docs/OfferStatesApi.md#get_members_member_id_offer_states) | **GET** /members/{member_id}/offer_states | Get all Offer States
*OfferStatesApi* | [**get_members_member_id_offer_states_offer_state_id**](docs/OfferStatesApi.md#get_members_member_id_offer_states_offer_state_id) | **GET** /members/{member_id}/offer_states/{offerstate_id} | Get Offer State by Offer State ID
*OfferStatesApi* | [**get_members_member_id_offers_offer_id**](docs/OfferStatesApi.md#get_members_member_id_offers_offer_id) | **GET** /members/{member_id}/offers/{offer_id} | Get Offer State by Offer ID
*OfferStatesApi* | [**get_members_offer_states**](docs/OfferStatesApi.md#get_members_offer_states) | **GET** /members/offer_states | Get Offer State from Query Parameters
*OfferStatesApi* | [**post_members_id_offer_states_issue**](docs/OfferStatesApi.md#post_members_id_offer_states_issue) | **POST** /members/offer_states/issue | Issue an Offer to a member (high throughput)
*OfferStatesApi* | [**post_members_member_id_offer_states**](docs/OfferStatesApi.md#post_members_member_id_offer_states) | **POST** /members/{member_id}/offer_states | Create Offer State
*OfferStatesApi* | [**post_members_member_id_offer_states_offerstate_id**](docs/OfferStatesApi.md#post_members_member_id_offer_states_offerstate_id) | **POST** /members/{member_id}/offer_states/{offerstate_id} | Update Offer State - Post
*OfferStatesApi* | [**post_members_member_id_offer_states_offerstate_id_void**](docs/OfferStatesApi.md#post_members_member_id_offer_states_offerstate_id_void) | **POST** /members/{member_id}/offer_states/{offerstate_id}/void | Void Offer State
*OfferStatesApi* | [**post_members_member_id_offer_states_offerstate_id_voidmember_identifier_member_identifier**](docs/OfferStatesApi.md#post_members_member_id_offer_states_offerstate_id_voidmember_identifier_member_identifier) | **POST** /members/offer_states/{offerstate_id}/void | Void Offer State by Member Identifier
*OfferStatesApi* | [**post_members_offer_states**](docs/OfferStatesApi.md#post_members_offer_states) | **POST** /members/offer_states | Create Offer State from Query Parameters
*OfferStatesApi* | [**put_members_member_id_offer_states_offer_state_id**](docs/OfferStatesApi.md#put_members_member_id_offer_states_offer_state_id) | **PUT** /members/{member_id}/offer_states/{offerstate_id} | Update Offer State
*OffersApi* | [**delete_offers_offer_id**](docs/OffersApi.md#delete_offers_offer_id) | **DELETE** /offers/{offer_id} | Delete an Offer
*OffersApi* | [**get_offers**](docs/OffersApi.md#get_offers) | **GET** /offers | List all Offers
*OffersApi* | [**get_offers_offer_id**](docs/OffersApi.md#get_offers_offer_id) | **GET** /offers/{offer_id} | Find an Offer
*OffersApi* | [**post_offers**](docs/OffersApi.md#post_offers) | **POST** /offers | Create an Offer
*OffersApi* | [**put_offers_offer_id**](docs/OffersApi.md#put_offers_offer_id) | **PUT** /offers/{offer_id} | Update an Offer
*POSOfferCodesApi* | [**get_pos_offer_codes**](docs/POSOfferCodesApi.md#get_pos_offer_codes) | **GET** /pos_offer_codes | List all POS Offer Codes
*POSOfferCodesApi* | [**get_pos_offer_codes_id**](docs/POSOfferCodesApi.md#get_pos_offer_codes_id) | **GET** /pos_offer_codes/{id} | Get a POS Offer Code
*StoreListsApi* | [**delete_merchants_merchant_id_store_lists_store_list_id**](docs/StoreListsApi.md#delete_merchants_merchant_id_store_lists_store_list_id) | **DELETE** /merchants/{merchant_id}/store_lists/{store_list_id} | Remove a Store List
*StoreListsApi* | [**get_merchants_merchant_id_store_lists**](docs/StoreListsApi.md#get_merchants_merchant_id_store_lists) | **GET** /merchants/{merchant_id}/store_lists | List all Store Lists
*StoreListsApi* | [**get_merchants_merchant_id_store_lists_store_list_id**](docs/StoreListsApi.md#get_merchants_merchant_id_store_lists_store_list_id) | **GET** /merchants/{merchant_id}/store_lists/{store_list_id} | Retrieve a Store List
*StoreListsApi* | [**post_merchants_merchant_id_store_lists**](docs/StoreListsApi.md#post_merchants_merchant_id_store_lists) | **POST** /merchants/{merchant_id}/store_lists | Create a Store List
*StoreListsApi* | [**put_merchants_merchant_id_store_lists_store_list_id**](docs/StoreListsApi.md#put_merchants_merchant_id_store_lists_store_list_id) | **PUT** /merchants/{merchant_id}/store_lists/{store_list_id} | Update a Store List
*StoresApi* | [**delete_merchants_merchant_id_stores_store_id**](docs/StoresApi.md#delete_merchants_merchant_id_stores_store_id) | **DELETE** /merchants/{merchant_id}/stores/{store_id} | Remove a Store
*StoresApi* | [**get_merchants_merchant_id_stores**](docs/StoresApi.md#get_merchants_merchant_id_stores) | **GET** /merchants/{merchant_id}/stores | List all Stores
*StoresApi* | [**get_merchants_merchant_id_stores_index**](docs/StoresApi.md#get_merchants_merchant_id_stores_index) | **GET** /merchants/stores/index | List all Stores with Active Offers
*StoresApi* | [**get_merchants_merchant_id_stores_store_id**](docs/StoresApi.md#get_merchants_merchant_id_stores_store_id) | **GET** /merchants/{merchant_id}/stores/{store_id} | Retrieve a Store
*StoresApi* | [**post_merchants_merchant_id_stores**](docs/StoresApi.md#post_merchants_merchant_id_stores) | **POST** /merchants/{merchant_id}/stores | Create a Store
*StoresApi* | [**put_merchants_merchant_id_stores_store_id**](docs/StoresApi.md#put_merchants_merchant_id_stores_store_id) | **PUT** /merchants/{merchant_id}/stores/{store_id} | Update a Store
*TemplatesApi* | [**get_templates**](docs/TemplatesApi.md#get_templates) | **GET** /templates | Get all Templates


## Documentation For Models

 - [APIError](docs/APIError.md)
 - [Audience](docs/Audience.md)
 - [BiStoreList](docs/BiStoreList.md)
 - [BiStoreListStoreListsInner](docs/BiStoreListStoreListsInner.md)
 - [CampaignIndexBody](docs/CampaignIndexBody.md)
 - [CampaignRequest](docs/CampaignRequest.md)
 - [CampaignRequestCampaign](docs/CampaignRequestCampaign.md)
 - [CampaignResponse](docs/CampaignResponse.md)
 - [CampaignResponseCampaign](docs/CampaignResponseCampaign.md)
 - [CampaignTagsResponse](docs/CampaignTagsResponse.md)
 - [ClarkAndRiggsIndexBody](docs/ClarkAndRiggsIndexBody.md)
 - [ClarkAndRiggsProductCreateBody](docs/ClarkAndRiggsProductCreateBody.md)
 - [ClarkAndRiggsProductResponseBody](docs/ClarkAndRiggsProductResponseBody.md)
 - [ClarkAndRiggsProductResponseBodyClarkAndRiggsProduct](docs/ClarkAndRiggsProductResponseBodyClarkAndRiggsProduct.md)
 - [CredentialBatchIndexBody](docs/CredentialBatchIndexBody.md)
 - [CredentialBatchRequest](docs/CredentialBatchRequest.md)
 - [CredentialBatchResponseBody](docs/CredentialBatchResponseBody.md)
 - [CredentialBatchResponseBodyCredentialBatch](docs/CredentialBatchResponseBodyCredentialBatch.md)
 - [CredentialBatchResponseBodyCredentialBatchCampaign](docs/CredentialBatchResponseBodyCredentialBatchCampaign.md)
 - [CredentialBatchResponseBodyCredentialBatchOffer](docs/CredentialBatchResponseBodyCredentialBatchOffer.md)
 - [CtmQitemsRequest](docs/CtmQitemsRequest.md)
 - [CtmRedemptionJobRequest](docs/CtmRedemptionJobRequest.md)
 - [CtmRedemptionJobRequestItemsInner](docs/CtmRedemptionJobRequestItemsInner.md)
 - [CtmRedemptionJobRequestRedeemedOffersInner](docs/CtmRedemptionJobRequestRedeemedOffersInner.md)
 - [CtmRedemptionJobRequestRedeemedOffersInnerQualifyingItemsInner](docs/CtmRedemptionJobRequestRedeemedOffersInnerQualifyingItemsInner.md)
 - [CtmRedemptionJobRequestSelectedOffersInner](docs/CtmRedemptionJobRequestSelectedOffersInner.md)
 - [CtmTransactionJobRequest](docs/CtmTransactionJobRequest.md)
 - [CtmTransactionShowResponse](docs/CtmTransactionShowResponse.md)
 - [CtmTransactionShowResponseAvailibleOffersInner](docs/CtmTransactionShowResponseAvailibleOffersInner.md)
 - [CtmTransactionShowResponseReusableOffers](docs/CtmTransactionShowResponseReusableOffers.md)
 - [CtmTransactionShowResponseTransaction](docs/CtmTransactionShowResponseTransaction.md)
 - [CtmTransactionShowResponseTransactionAddOffersInner](docs/CtmTransactionShowResponseTransactionAddOffersInner.md)
 - [CtmTransactionShowResponseTransactionAddOffersInnerQualifyingItemsInner](docs/CtmTransactionShowResponseTransactionAddOffersInnerQualifyingItemsInner.md)
 - [CtmTransactionShowResponseTransactionAvailibleOffersInner](docs/CtmTransactionShowResponseTransactionAvailibleOffersInner.md)
 - [CtmTransactionShowResponseTransactionCredentialsInner](docs/CtmTransactionShowResponseTransactionCredentialsInner.md)
 - [CtmTransactionShowResponseTransactionCredentialsInnerTxCredential](docs/CtmTransactionShowResponseTransactionCredentialsInnerTxCredential.md)
 - [CtmTransactionShowResponseTransactionDisplayMessagesInner](docs/CtmTransactionShowResponseTransactionDisplayMessagesInner.md)
 - [CtmTransactionShowResponseTransactionErrorsInner](docs/CtmTransactionShowResponseTransactionErrorsInner.md)
 - [CtmTransactionShowResponseTransactionRecieptMessagesInner](docs/CtmTransactionShowResponseTransactionRecieptMessagesInner.md)
 - [EmailOptIn](docs/EmailOptIn.md)
 - [EmailOptInError](docs/EmailOptInError.md)
 - [Errors](docs/Errors.md)
 - [GetOfferLists200Response](docs/GetOfferLists200Response.md)
 - [GetOfferLists200ResponseOfferListsInner](docs/GetOfferLists200ResponseOfferListsInner.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [Impression](docs/Impression.md)
 - [ImpressionAllOfImpression](docs/ImpressionAllOfImpression.md)
 - [ImpressionErrorBody](docs/ImpressionErrorBody.md)
 - [ImpressionIndexBody](docs/ImpressionIndexBody.md)
 - [ImpressionRequest](docs/ImpressionRequest.md)
 - [ImpressionRequestImpression](docs/ImpressionRequestImpression.md)
 - [ImpressionRequestImpressionAnnotations](docs/ImpressionRequestImpressionAnnotations.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineObject2](docs/InlineObject2.md)
 - [InlineObject3](docs/InlineObject3.md)
 - [InlineObject4](docs/InlineObject4.md)
 - [InlineObject5](docs/InlineObject5.md)
 - [Item](docs/Item.md)
 - [ItemAllOfItem](docs/ItemAllOfItem.md)
 - [ItemIndexBody](docs/ItemIndexBody.md)
 - [ItemRequest](docs/ItemRequest.md)
 - [ItemRequestItem](docs/ItemRequestItem.md)
 - [ItemSet](docs/ItemSet.md)
 - [ItemSetAllOfItemSet](docs/ItemSetAllOfItemSet.md)
 - [ItemSetIndexBody](docs/ItemSetIndexBody.md)
 - [ItemSetRequest](docs/ItemSetRequest.md)
 - [ItemSetRequestItemSet](docs/ItemSetRequestItemSet.md)
 - [Member](docs/Member.md)
 - [MemberAllOfMember](docs/MemberAllOfMember.md)
 - [MemberPrivacy](docs/MemberPrivacy.md)
 - [MemberPrivacyCredentialsInner](docs/MemberPrivacyCredentialsInner.md)
 - [MemberPrivacyMember](docs/MemberPrivacyMember.md)
 - [MemberProfile](docs/MemberProfile.md)
 - [MemberRequest](docs/MemberRequest.md)
 - [MemberRequestMember](docs/MemberRequestMember.md)
 - [Offer](docs/Offer.md)
 - [OfferAllOfOffer](docs/OfferAllOfOffer.md)
 - [OfferEligibleItemSet](docs/OfferEligibleItemSet.md)
 - [OfferEligibleItemSetAllOfEligibleItemSet](docs/OfferEligibleItemSetAllOfEligibleItemSet.md)
 - [OfferEligibleItemSetRequest](docs/OfferEligibleItemSetRequest.md)
 - [OfferEligibleItemSetRequestEligibleItemSet](docs/OfferEligibleItemSetRequestEligibleItemSet.md)
 - [OfferEligibleItemsSetIndex](docs/OfferEligibleItemsSetIndex.md)
 - [OfferIndexBody](docs/OfferIndexBody.md)
 - [OfferList](docs/OfferList.md)
 - [OfferPosOfferCode](docs/OfferPosOfferCode.md)
 - [OfferPosOfferCodeAllOfOfferPosOfferCode](docs/OfferPosOfferCodeAllOfOfferPosOfferCode.md)
 - [OfferPosOfferCodeIndex](docs/OfferPosOfferCodeIndex.md)
 - [OfferPosOfferCodeRequest](docs/OfferPosOfferCodeRequest.md)
 - [OfferPosOfferCodeRequestOfferPosOfferCode](docs/OfferPosOfferCodeRequestOfferPosOfferCode.md)
 - [OfferRequest](docs/OfferRequest.md)
 - [OfferRequestOffer](docs/OfferRequestOffer.md)
 - [OfferRequestOfferEligibility](docs/OfferRequestOfferEligibility.md)
 - [OfferRequestOfferFormatting](docs/OfferRequestOfferFormatting.md)
 - [OfferRequestOfferFormattingEligibleStoreMap](docs/OfferRequestOfferFormattingEligibleStoreMap.md)
 - [OfferState](docs/OfferState.md)
 - [OfferStateAllOfOfferState](docs/OfferStateAllOfOfferState.md)
 - [OfferStateError](docs/OfferStateError.md)
 - [OfferStateIndexBody](docs/OfferStateIndexBody.md)
 - [OfferStateRequest](docs/OfferStateRequest.md)
 - [OfferStateRequestOfferState](docs/OfferStateRequestOfferState.md)
 - [OfferStateUpdate](docs/OfferStateUpdate.md)
 - [OfferStateUpdateOfferState](docs/OfferStateUpdateOfferState.md)
 - [PageResponseBody](docs/PageResponseBody.md)
 - [PosOfferCode](docs/PosOfferCode.md)
 - [PosOfferCodeAllOfPosOfferCode](docs/PosOfferCodeAllOfPosOfferCode.md)
 - [PosOfferCodeIndexBody](docs/PosOfferCodeIndexBody.md)
 - [PostAudiencesIdSubAudiencesRequest](docs/PostAudiencesIdSubAudiencesRequest.md)
 - [PostAudiencesRequest](docs/PostAudiencesRequest.md)
 - [PostAuth401Response](docs/PostAuth401Response.md)
 - [PostMembersIdOfferStatesIssue201Response](docs/PostMembersIdOfferStatesIssue201Response.md)
 - [PostMembersIdOfferStatesIssue201ResponseOfferState](docs/PostMembersIdOfferStatesIssue201ResponseOfferState.md)
 - [PostMembersIdOfferStatesIssueRequest](docs/PostMembersIdOfferStatesIssueRequest.md)
 - [PostMembersIdOfferStatesIssueRequestOfferState](docs/PostMembersIdOfferStatesIssueRequestOfferState.md)
 - [PostMembersProfileRequest](docs/PostMembersProfileRequest.md)
 - [PostOfferListsRequest](docs/PostOfferListsRequest.md)
 - [PostOfferListsRequestOfferList](docs/PostOfferListsRequestOfferList.md)
 - [Store](docs/Store.md)
 - [StoreAllOfStore](docs/StoreAllOfStore.md)
 - [StoreAllOfStoreLocation](docs/StoreAllOfStoreLocation.md)
 - [StoreIndexBody](docs/StoreIndexBody.md)
 - [StoreList](docs/StoreList.md)
 - [StoreListAllOfStoreList](docs/StoreListAllOfStoreList.md)
 - [StoreListIndexBody](docs/StoreListIndexBody.md)
 - [StoreListRequest](docs/StoreListRequest.md)
 - [StoreListRequestStoreList](docs/StoreListRequestStoreList.md)
 - [StoreRequest](docs/StoreRequest.md)
 - [StoreRequestStore](docs/StoreRequestStore.md)
 - [StoreRequestStoreContacts](docs/StoreRequestStoreContacts.md)
 - [StoreRequestStoreContactsPrimary](docs/StoreRequestStoreContactsPrimary.md)
 - [StoreRequestStoreLocation](docs/StoreRequestStoreLocation.md)
 - [SubAudience](docs/SubAudience.md)
 - [Template](docs/Template.md)
 - [Template2](docs/Template2.md)
 - [TemplateTemplatesInner](docs/TemplateTemplatesInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="XAuthToken"></a>
### XAuthToken

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header

<a id="XAuthIdentity"></a>
### XAuthIdentity

- **Type**: API key
- **API key parameter name**: X-Auth-Identity
- **Location**: HTTP header

<a id="XAuthKey"></a>
### XAuthKey

- **Type**: API key
- **API key parameter name**: X-Auth-Key
- **Location**: HTTP header


## Author

support@sparkfly.com


