# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from sparkfly.models.ctm_qitems_request import CtmQitemsRequest
from sparkfly.models.ctm_redemption_job_request import CtmRedemptionJobRequest
from sparkfly.models.ctm_transaction_job_request import CtmTransactionJobRequest
from sparkfly.models.ctm_transaction_show_response import CtmTransactionShowResponse

from sparkfly.api_client import ApiClient, RequestSerialized
from sparkfly.api_response import ApiResponse
from sparkfly.rest import RESTResponseType


class CtmApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def get_ctm_custom_messages(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> object:
        """CTM Custom Messages

        ctm custom messages

        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ctm_custom_messages_serialize(
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_ctm_custom_messages_with_http_info(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[object]:
        """CTM Custom Messages

        ctm custom messages

        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ctm_custom_messages_serialize(
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_ctm_custom_messages_without_preload_content(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Custom Messages

        ctm custom messages

        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ctm_custom_messages_serialize(
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_ctm_custom_messages_serialize(
        self,
        content_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/ctm/customposmessages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_ctm_store(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> object:
        """CTM Stores

        ctm stores

        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ctm_store_serialize(
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_ctm_store_with_http_info(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[object]:
        """CTM Stores

        ctm stores

        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ctm_store_serialize(
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_ctm_store_without_preload_content(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Stores

        ctm stores

        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ctm_store_serialize(
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_ctm_store_serialize(
        self,
        content_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/ctm/stores',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_show_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        x_sparkfly_metadata: Annotated[Optional[StrictStr], Field(description="Metadata")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        pos_version: Annotated[Optional[StrictStr], Field(description="search for records with a pos version")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        ctm_redemption_job_request: Optional[CtmRedemptionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> CtmTransactionShowResponse:
        """CTM Show Response

        ctm show response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param x_sparkfly_metadata: Metadata
        :type x_sparkfly_metadata: str
        :param token: search for records with a matching token
        :type token: str
        :param pos_version: search for records with a pos version
        :type pos_version: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param ctm_redemption_job_request:
        :type ctm_redemption_job_request: CtmRedemptionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_show_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            x_sparkfly_metadata=x_sparkfly_metadata,
            token=token,
            pos_version=pos_version,
            pos_vendor=pos_vendor,
            ctm_redemption_job_request=ctm_redemption_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CtmTransactionShowResponse",
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_show_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        x_sparkfly_metadata: Annotated[Optional[StrictStr], Field(description="Metadata")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        pos_version: Annotated[Optional[StrictStr], Field(description="search for records with a pos version")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        ctm_redemption_job_request: Optional[CtmRedemptionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[CtmTransactionShowResponse]:
        """CTM Show Response

        ctm show response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param x_sparkfly_metadata: Metadata
        :type x_sparkfly_metadata: str
        :param token: search for records with a matching token
        :type token: str
        :param pos_version: search for records with a pos version
        :type pos_version: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param ctm_redemption_job_request:
        :type ctm_redemption_job_request: CtmRedemptionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_show_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            x_sparkfly_metadata=x_sparkfly_metadata,
            token=token,
            pos_version=pos_version,
            pos_vendor=pos_vendor,
            ctm_redemption_job_request=ctm_redemption_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CtmTransactionShowResponse",
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_show_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        x_sparkfly_metadata: Annotated[Optional[StrictStr], Field(description="Metadata")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        pos_version: Annotated[Optional[StrictStr], Field(description="search for records with a pos version")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        ctm_redemption_job_request: Optional[CtmRedemptionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Show Response

        ctm show response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param x_sparkfly_metadata: Metadata
        :type x_sparkfly_metadata: str
        :param token: search for records with a matching token
        :type token: str
        :param pos_version: search for records with a pos version
        :type pos_version: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param ctm_redemption_job_request:
        :type ctm_redemption_job_request: CtmRedemptionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_show_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            x_sparkfly_metadata=x_sparkfly_metadata,
            token=token,
            pos_version=pos_version,
            pos_vendor=pos_vendor,
            ctm_redemption_job_request=ctm_redemption_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CtmTransactionShowResponse",
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_show_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        credential,
        content_type,
        x_sparkfly_metadata,
        token,
        pos_version,
        pos_vendor,
        ctm_redemption_job_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        if credential is not None:
            _path_params['credential'] = credential
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        if pos_version is not None:
            
            _query_params.append(('pos_version', pos_version))
            
        if pos_vendor is not None:
            
            _query_params.append(('pos_vendor', pos_vendor))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if x_sparkfly_metadata is not None:
            _header_params['X-Sparkfly-Metadata'] = x_sparkfly_metadata
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter
        if ctm_redemption_job_request is not None:
            _body_params = ctm_redemption_job_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/ctm/members/{site_id}/{credential}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def post_allocate_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        offer_id: Annotated[Optional[StrictStr], Field(description="search for records with a matching offer id")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """CTM Allocate

        ctm allocate

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param offer_id: search for records with a matching offer id
        :type offer_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_allocate_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def post_allocate_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        offer_id: Annotated[Optional[StrictStr], Field(description="search for records with a matching offer id")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """CTM Allocate

        ctm allocate

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param offer_id: search for records with a matching offer id
        :type offer_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_allocate_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def post_allocate_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        offer_id: Annotated[Optional[StrictStr], Field(description="search for records with a matching offer id")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Allocate

        ctm allocate

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param offer_id: search for records with a matching offer id
        :type offer_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_allocate_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            offer_id=offer_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_allocate_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        credential,
        content_type,
        token,
        offer_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        if credential is not None:
            _path_params['credential'] = credential
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        if offer_id is not None:
            
            _query_params.append(('offer_id', offer_id))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/ctm/allocate/{site_id}/{credential}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def post_deallocate_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        offer_id: Annotated[Optional[StrictStr], Field(description="search for records with a matching offer id")] = None,
        credential_identifier: Annotated[Optional[StrictStr], Field(description="The identifier of the credential")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """CTM Dealocate

        ctm dealocate

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param offer_id: search for records with a matching offer id
        :type offer_id: str
        :param credential_identifier: The identifier of the credential
        :type credential_identifier: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_deallocate_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            offer_id=offer_id,
            credential_identifier=credential_identifier,
            pos_vendor=pos_vendor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def post_deallocate_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        offer_id: Annotated[Optional[StrictStr], Field(description="search for records with a matching offer id")] = None,
        credential_identifier: Annotated[Optional[StrictStr], Field(description="The identifier of the credential")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """CTM Dealocate

        ctm dealocate

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param offer_id: search for records with a matching offer id
        :type offer_id: str
        :param credential_identifier: The identifier of the credential
        :type credential_identifier: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_deallocate_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            offer_id=offer_id,
            credential_identifier=credential_identifier,
            pos_vendor=pos_vendor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def post_deallocate_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        offer_id: Annotated[Optional[StrictStr], Field(description="search for records with a matching offer id")] = None,
        credential_identifier: Annotated[Optional[StrictStr], Field(description="The identifier of the credential")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Dealocate

        ctm dealocate

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param offer_id: search for records with a matching offer id
        :type offer_id: str
        :param credential_identifier: The identifier of the credential
        :type credential_identifier: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_deallocate_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            offer_id=offer_id,
            credential_identifier=credential_identifier,
            pos_vendor=pos_vendor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_deallocate_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        content_type,
        token,
        offer_id,
        credential_identifier,
        pos_vendor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        if offer_id is not None:
            
            _query_params.append(('offer_id', offer_id))
            
        if credential_identifier is not None:
            
            _query_params.append(('credential_identifier', credential_identifier))
            
        if pos_vendor is not None:
            
            _query_params.append(('pos_vendor', pos_vendor))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/ctm/deallocate/{site_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def post_qitems_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_qitems_request: Optional[CtmQitemsRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """CTM Qitems

        ctm qitems

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_qitems_request:
        :type ctm_qitems_request: CtmQitemsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_qitems_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_qitems_request=ctm_qitems_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def post_qitems_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_qitems_request: Optional[CtmQitemsRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """CTM Qitems

        ctm qitems

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_qitems_request:
        :type ctm_qitems_request: CtmQitemsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_qitems_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_qitems_request=ctm_qitems_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def post_qitems_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_qitems_request: Optional[CtmQitemsRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Qitems

        ctm qitems

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_qitems_request:
        :type ctm_qitems_request: CtmQitemsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_qitems_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_qitems_request=ctm_qitems_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_qitems_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        credential,
        content_type,
        token,
        ctm_qitems_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        if credential is not None:
            _path_params['credential'] = credential
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter
        if ctm_qitems_request is not None:
            _body_params = ctm_qitems_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/ctm/qitems/{site_id}/{credential}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def post_update_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def post_update_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def post_update_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_update_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        credential,
        content_type,
        token,
        ctm_transaction_job_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        if credential is not None:
            _path_params['credential'] = credential
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter
        if ctm_transaction_job_request is not None:
            _body_params = ctm_transaction_job_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v2/ctm/members/{site_id}/{credential}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def post_update_ctm_siteid(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_update_ctm_siteid_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def post_update_ctm_siteid_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_update_ctm_siteid_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def post_update_ctm_siteid_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_update_ctm_siteid_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_update_ctm_siteid_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        content_type,
        token,
        ctm_transaction_job_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter
        if ctm_transaction_job_request is not None:
            _body_params = ctm_transaction_job_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v2/ctm/members/{site_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def put_show_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        x_sparkfly_metadata: Annotated[Optional[StrictStr], Field(description="Metadata")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        pos_version: Annotated[Optional[StrictStr], Field(description="search for records with a pos version")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        ctm_redemption_job_request: Optional[CtmRedemptionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> CtmTransactionShowResponse:
        """CTM Show Response

        ctm show response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param x_sparkfly_metadata: Metadata
        :type x_sparkfly_metadata: str
        :param token: search for records with a matching token
        :type token: str
        :param pos_version: search for records with a pos version
        :type pos_version: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param ctm_redemption_job_request:
        :type ctm_redemption_job_request: CtmRedemptionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_show_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            x_sparkfly_metadata=x_sparkfly_metadata,
            token=token,
            pos_version=pos_version,
            pos_vendor=pos_vendor,
            ctm_redemption_job_request=ctm_redemption_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CtmTransactionShowResponse",
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def put_show_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        x_sparkfly_metadata: Annotated[Optional[StrictStr], Field(description="Metadata")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        pos_version: Annotated[Optional[StrictStr], Field(description="search for records with a pos version")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        ctm_redemption_job_request: Optional[CtmRedemptionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[CtmTransactionShowResponse]:
        """CTM Show Response

        ctm show response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param x_sparkfly_metadata: Metadata
        :type x_sparkfly_metadata: str
        :param token: search for records with a matching token
        :type token: str
        :param pos_version: search for records with a pos version
        :type pos_version: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param ctm_redemption_job_request:
        :type ctm_redemption_job_request: CtmRedemptionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_show_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            x_sparkfly_metadata=x_sparkfly_metadata,
            token=token,
            pos_version=pos_version,
            pos_vendor=pos_vendor,
            ctm_redemption_job_request=ctm_redemption_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CtmTransactionShowResponse",
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def put_show_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        x_sparkfly_metadata: Annotated[Optional[StrictStr], Field(description="Metadata")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        pos_version: Annotated[Optional[StrictStr], Field(description="search for records with a pos version")] = None,
        pos_vendor: Annotated[Optional[StrictStr], Field(description="search for records with a pos vendor")] = None,
        ctm_redemption_job_request: Optional[CtmRedemptionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Show Response

        ctm show response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param x_sparkfly_metadata: Metadata
        :type x_sparkfly_metadata: str
        :param token: search for records with a matching token
        :type token: str
        :param pos_version: search for records with a pos version
        :type pos_version: str
        :param pos_vendor: search for records with a pos vendor
        :type pos_vendor: str
        :param ctm_redemption_job_request:
        :type ctm_redemption_job_request: CtmRedemptionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_show_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            x_sparkfly_metadata=x_sparkfly_metadata,
            token=token,
            pos_version=pos_version,
            pos_vendor=pos_vendor,
            ctm_redemption_job_request=ctm_redemption_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CtmTransactionShowResponse",
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_show_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        credential,
        content_type,
        x_sparkfly_metadata,
        token,
        pos_version,
        pos_vendor,
        ctm_redemption_job_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        if credential is not None:
            _path_params['credential'] = credential
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        if pos_version is not None:
            
            _query_params.append(('pos_version', pos_version))
            
        if pos_vendor is not None:
            
            _query_params.append(('pos_vendor', pos_vendor))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if x_sparkfly_metadata is not None:
            _header_params['X-Sparkfly-Metadata'] = x_sparkfly_metadata
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter
        if ctm_redemption_job_request is not None:
            _body_params = ctm_redemption_job_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v2/ctm/members/{site_id}/{credential}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def put_transaction_update_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """CTM Transaction Update

        ctm transaction update

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_transaction_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def put_transaction_update_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """CTM Transaction Update

        ctm transaction update

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_transaction_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def put_transaction_update_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Transaction Update

        ctm transaction update

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_transaction_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_transaction_update_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        content_type,
        token,
        ctm_transaction_job_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter
        if ctm_transaction_job_request is not None:
            _body_params = ctm_transaction_job_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/ctm/members/{site_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def put_update_ctm(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def put_update_ctm_with_http_info(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def put_update_ctm_without_preload_content(
        self,
        tran_id: Annotated[StrictStr, Field(description="Required transaction identifier")],
        term_id: Annotated[StrictStr, Field(description="Required term identifier")],
        site_id: Annotated[StrictStr, Field(description="search for records with a matching site id")],
        credential: Annotated[StrictStr, Field(description="search for records with a matching credential")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        token: Annotated[Optional[StrictStr], Field(description="search for records with a matching token")] = None,
        ctm_transaction_job_request: Optional[CtmTransactionJobRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """CTM Update Response

        ctm update response

        :param tran_id: Required transaction identifier (required)
        :type tran_id: str
        :param term_id: Required term identifier (required)
        :type term_id: str
        :param site_id: search for records with a matching site id (required)
        :type site_id: str
        :param credential: search for records with a matching credential (required)
        :type credential: str
        :param content_type: application/json
        :type content_type: str
        :param token: search for records with a matching token
        :type token: str
        :param ctm_transaction_job_request:
        :type ctm_transaction_job_request: CtmTransactionJobRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_update_ctm_serialize(
            tran_id=tran_id,
            term_id=term_id,
            site_id=site_id,
            credential=credential,
            content_type=content_type,
            token=token,
            ctm_transaction_job_request=ctm_transaction_job_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '422': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_update_ctm_serialize(
        self,
        tran_id,
        term_id,
        site_id,
        credential,
        content_type,
        token,
        ctm_transaction_job_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        if credential is not None:
            _path_params['credential'] = credential
        # process the query parameters
        if token is not None:
            
            _query_params.append(('token', token))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        if tran_id is not None:
            _header_params['tran_id'] = tran_id
        if term_id is not None:
            _header_params['term_id'] = term_id
        # process the form parameters
        # process the body parameter
        if ctm_transaction_job_request is not None:
            _body_params = ctm_transaction_job_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/ctm/members/{site_id}/{credential}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


