# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Any, List, Optional
from typing_extensions import Annotated
from sparkfly.models.offer import Offer
from sparkfly.models.offer_index_body import OfferIndexBody
from sparkfly.models.offer_request import OfferRequest

from sparkfly.api_client import ApiClient, RequestSerialized
from sparkfly.api_response import ApiResponse
from sparkfly.rest import RESTResponseType


class OffersApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def delete_offers_offer_id(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Delete an Offer

        Deletes an offer by ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_offers_offer_id_with_http_info(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Delete an Offer

        Deletes an offer by ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_offers_offer_id_without_preload_content(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Delete an Offer

        Deletes an offer by ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_offers_offer_id_serialize(
        self,
        offer_id,
        content_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/offers/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_offers(
        self,
        page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="page offset to display a range of records from")] = None,
        per_page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="maximum number of records to return in the search")] = None,
        order: Annotated[Optional[StrictStr], Field(description="sort the records in either ascending (asc) or descending (desc) order")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="Attempts to match by name or id")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="sort records by a field name")] = None,
        status: Annotated[Optional[StrictStr], Field(description="search for records matching the desired status")] = None,
        merchant_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching merchant ID")] = None,
        manufacturer_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching manufacturer ID")] = None,
        store_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching store ID")] = None,
        offer_list_id: Annotated[Optional[List[Any]], Field(description="search for records with a matching offer list ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> OfferIndexBody:
        """List all Offers

        Search for offers.

        :param page: page offset to display a range of records from
        :type page: str
        :param per_page: maximum number of records to return in the search
        :type per_page: str
        :param order: sort the records in either ascending (asc) or descending (desc) order
        :type order: str
        :param search_text: Attempts to match by name or id
        :type search_text: str
        :param sort_by: sort records by a field name
        :type sort_by: str
        :param status: search for records matching the desired status
        :type status: str
        :param merchant_id: search for records with a matching merchant ID
        :type merchant_id: int
        :param manufacturer_id: search for records with a matching manufacturer ID
        :type manufacturer_id: int
        :param store_id: search for records with a matching store ID
        :type store_id: int
        :param offer_list_id: search for records with a matching offer list ID
        :type offer_list_id: List[object]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_offers_serialize(
            page=page,
            per_page=per_page,
            order=order,
            search_text=search_text,
            sort_by=sort_by,
            status=status,
            merchant_id=merchant_id,
            manufacturer_id=manufacturer_id,
            store_id=store_id,
            offer_list_id=offer_list_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferIndexBody",
            '401': None,
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_offers_with_http_info(
        self,
        page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="page offset to display a range of records from")] = None,
        per_page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="maximum number of records to return in the search")] = None,
        order: Annotated[Optional[StrictStr], Field(description="sort the records in either ascending (asc) or descending (desc) order")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="Attempts to match by name or id")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="sort records by a field name")] = None,
        status: Annotated[Optional[StrictStr], Field(description="search for records matching the desired status")] = None,
        merchant_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching merchant ID")] = None,
        manufacturer_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching manufacturer ID")] = None,
        store_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching store ID")] = None,
        offer_list_id: Annotated[Optional[List[Any]], Field(description="search for records with a matching offer list ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[OfferIndexBody]:
        """List all Offers

        Search for offers.

        :param page: page offset to display a range of records from
        :type page: str
        :param per_page: maximum number of records to return in the search
        :type per_page: str
        :param order: sort the records in either ascending (asc) or descending (desc) order
        :type order: str
        :param search_text: Attempts to match by name or id
        :type search_text: str
        :param sort_by: sort records by a field name
        :type sort_by: str
        :param status: search for records matching the desired status
        :type status: str
        :param merchant_id: search for records with a matching merchant ID
        :type merchant_id: int
        :param manufacturer_id: search for records with a matching manufacturer ID
        :type manufacturer_id: int
        :param store_id: search for records with a matching store ID
        :type store_id: int
        :param offer_list_id: search for records with a matching offer list ID
        :type offer_list_id: List[object]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_offers_serialize(
            page=page,
            per_page=per_page,
            order=order,
            search_text=search_text,
            sort_by=sort_by,
            status=status,
            merchant_id=merchant_id,
            manufacturer_id=manufacturer_id,
            store_id=store_id,
            offer_list_id=offer_list_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferIndexBody",
            '401': None,
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_offers_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="page offset to display a range of records from")] = None,
        per_page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="maximum number of records to return in the search")] = None,
        order: Annotated[Optional[StrictStr], Field(description="sort the records in either ascending (asc) or descending (desc) order")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="Attempts to match by name or id")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="sort records by a field name")] = None,
        status: Annotated[Optional[StrictStr], Field(description="search for records matching the desired status")] = None,
        merchant_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching merchant ID")] = None,
        manufacturer_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching manufacturer ID")] = None,
        store_id: Annotated[Optional[StrictInt], Field(description="search for records with a matching store ID")] = None,
        offer_list_id: Annotated[Optional[List[Any]], Field(description="search for records with a matching offer list ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """List all Offers

        Search for offers.

        :param page: page offset to display a range of records from
        :type page: str
        :param per_page: maximum number of records to return in the search
        :type per_page: str
        :param order: sort the records in either ascending (asc) or descending (desc) order
        :type order: str
        :param search_text: Attempts to match by name or id
        :type search_text: str
        :param sort_by: sort records by a field name
        :type sort_by: str
        :param status: search for records matching the desired status
        :type status: str
        :param merchant_id: search for records with a matching merchant ID
        :type merchant_id: int
        :param manufacturer_id: search for records with a matching manufacturer ID
        :type manufacturer_id: int
        :param store_id: search for records with a matching store ID
        :type store_id: int
        :param offer_list_id: search for records with a matching offer list ID
        :type offer_list_id: List[object]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_offers_serialize(
            page=page,
            per_page=per_page,
            order=order,
            search_text=search_text,
            sort_by=sort_by,
            status=status,
            merchant_id=merchant_id,
            manufacturer_id=manufacturer_id,
            store_id=store_id,
            offer_list_id=offer_list_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OfferIndexBody",
            '401': None,
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_offers_serialize(
        self,
        page,
        per_page,
        order,
        search_text,
        sort_by,
        status,
        merchant_id,
        manufacturer_id,
        store_id,
        offer_list_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
            'offer_list_id': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        if search_text is not None:
            
            _query_params.append(('search_text', search_text))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if merchant_id is not None:
            
            _query_params.append(('merchant_id', merchant_id))
            
        if manufacturer_id is not None:
            
            _query_params.append(('manufacturer_id', manufacturer_id))
            
        if store_id is not None:
            
            _query_params.append(('store_id', store_id))
            
        if offer_list_id is not None:
            
            _query_params.append(('offer_list_id', offer_list_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/offers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_offers_offer_id(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> Offer:
        """Find an Offer

        Finds an offer by the ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Offer",
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_offers_offer_id_with_http_info(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[Offer]:
        """Find an Offer

        Finds an offer by the ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Offer",
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_offers_offer_id_without_preload_content(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Find an Offer

        Finds an offer by the ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Offer",
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_offers_offer_id_serialize(
        self,
        offer_id,
        content_type,
        offer_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if offer_request is not None:
            _body_params = offer_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/offers/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def post_offers(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> Offer:
        """Create an Offer

        Creates an offer. redemption_grace_period is the grace period provided for generating and redeeming codes.  If not provided. The default will be the related Campaign's End Date. If not provided however a grace period exists on the Campaign. The grace period will be the Campaign End Date + Campaign Grace Period Days.  In all cases, the Campaign End Date or Offer End Date - which ever occurs first - plus any applicable grace period days.  (ex: You cannot set a campaign end date beyond the offer expiration date. In this case it will follow the offer expiration date)

        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_offers_serialize(
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Offer",
            '400': "Offer",
            '401': None,
            '422': "Offer",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def post_offers_with_http_info(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[Offer]:
        """Create an Offer

        Creates an offer. redemption_grace_period is the grace period provided for generating and redeeming codes.  If not provided. The default will be the related Campaign's End Date. If not provided however a grace period exists on the Campaign. The grace period will be the Campaign End Date + Campaign Grace Period Days.  In all cases, the Campaign End Date or Offer End Date - which ever occurs first - plus any applicable grace period days.  (ex: You cannot set a campaign end date beyond the offer expiration date. In this case it will follow the offer expiration date)

        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_offers_serialize(
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Offer",
            '400': "Offer",
            '401': None,
            '422': "Offer",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def post_offers_without_preload_content(
        self,
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Create an Offer

        Creates an offer. redemption_grace_period is the grace period provided for generating and redeeming codes.  If not provided. The default will be the related Campaign's End Date. If not provided however a grace period exists on the Campaign. The grace period will be the Campaign End Date + Campaign Grace Period Days.  In all cases, the Campaign End Date or Offer End Date - which ever occurs first - plus any applicable grace period days.  (ex: You cannot set a campaign end date beyond the offer expiration date. In this case it will follow the offer expiration date)

        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_offers_serialize(
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Offer",
            '400': "Offer",
            '401': None,
            '422': "Offer",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_offers_serialize(
        self,
        content_type,
        offer_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if offer_request is not None:
            _body_params = offer_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/offers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def put_offers_offer_id(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> Offer:
        """Update an Offer

        Updates an offer by ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Offer",
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def put_offers_offer_id_with_http_info(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[Offer]:
        """Update an Offer

        Updates an offer by ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Offer",
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def put_offers_offer_id_without_preload_content(
        self,
        offer_id: Annotated[StrictStr, Field(description="Primary ID of the offer")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        offer_request: Optional[OfferRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Update an Offer

        Updates an offer by ID.

        :param offer_id: Primary ID of the offer (required)
        :type offer_id: str
        :param content_type: application/json
        :type content_type: str
        :param offer_request:
        :type offer_request: OfferRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_offers_offer_id_serialize(
            offer_id=offer_id,
            content_type=content_type,
            offer_request=offer_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Offer",
            '401': None,
            '404': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_offers_offer_id_serialize(
        self,
        offer_id,
        content_type,
        offer_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if offer_id is not None:
            _path_params['offer_id'] = offer_id
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if offer_request is not None:
            _body_params = offer_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/offers/{offer_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


