# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from sparkfly.models.store_list import StoreList
from sparkfly.models.store_list_index_body import StoreListIndexBody
from sparkfly.models.store_list_request import StoreListRequest

from sparkfly.api_client import ApiClient, RequestSerialized
from sparkfly.api_response import ApiResponse
from sparkfly.rest import RESTResponseType


class StoreListsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def delete_merchants_merchant_id_store_lists_store_list_id(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> None:
        """Remove a Store List

        Remove a store list.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_merchants_merchant_id_store_lists_store_list_id_with_http_info(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[None]:
        """Remove a Store List

        Remove a store list.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_merchants_merchant_id_store_lists_store_list_id_without_preload_content(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Remove a Store List

        Remove a store list.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_merchants_merchant_id_store_lists_store_list_id_serialize(
        self,
        merchant_id,
        store_list_id,
        content_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if merchant_id is not None:
            _path_params['merchant_id'] = merchant_id
        if store_list_id is not None:
            _path_params['store_list_id'] = store_list_id
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/merchants/{merchant_id}/store_lists/{store_list_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_merchants_merchant_id_store_lists(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="page offset to display a range of records from")] = None,
        per_page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="maximum number of records to return in the search")] = None,
        order: Annotated[Optional[StrictStr], Field(description="sort the records in either ascending (asc) or descending (desc) order")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="order the returned records by a specified field")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="search for records containing the text")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> StoreListIndexBody:
        """List all Store Lists

        Search for store lists by merchant ID.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param content_type: application/json
        :type content_type: str
        :param page: page offset to display a range of records from
        :type page: str
        :param per_page: maximum number of records to return in the search
        :type per_page: str
        :param order: sort the records in either ascending (asc) or descending (desc) order
        :type order: str
        :param sort_by: order the returned records by a specified field
        :type sort_by: str
        :param search_text: search for records containing the text
        :type search_text: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchants_merchant_id_store_lists_serialize(
            merchant_id=merchant_id,
            content_type=content_type,
            page=page,
            per_page=per_page,
            order=order,
            sort_by=sort_by,
            search_text=search_text,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreListIndexBody",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_merchants_merchant_id_store_lists_with_http_info(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="page offset to display a range of records from")] = None,
        per_page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="maximum number of records to return in the search")] = None,
        order: Annotated[Optional[StrictStr], Field(description="sort the records in either ascending (asc) or descending (desc) order")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="order the returned records by a specified field")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="search for records containing the text")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[StoreListIndexBody]:
        """List all Store Lists

        Search for store lists by merchant ID.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param content_type: application/json
        :type content_type: str
        :param page: page offset to display a range of records from
        :type page: str
        :param per_page: maximum number of records to return in the search
        :type per_page: str
        :param order: sort the records in either ascending (asc) or descending (desc) order
        :type order: str
        :param sort_by: order the returned records by a specified field
        :type sort_by: str
        :param search_text: search for records containing the text
        :type search_text: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchants_merchant_id_store_lists_serialize(
            merchant_id=merchant_id,
            content_type=content_type,
            page=page,
            per_page=per_page,
            order=order,
            sort_by=sort_by,
            search_text=search_text,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreListIndexBody",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_merchants_merchant_id_store_lists_without_preload_content(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="page offset to display a range of records from")] = None,
        per_page: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="maximum number of records to return in the search")] = None,
        order: Annotated[Optional[StrictStr], Field(description="sort the records in either ascending (asc) or descending (desc) order")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="order the returned records by a specified field")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="search for records containing the text")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """List all Store Lists

        Search for store lists by merchant ID.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param content_type: application/json
        :type content_type: str
        :param page: page offset to display a range of records from
        :type page: str
        :param per_page: maximum number of records to return in the search
        :type per_page: str
        :param order: sort the records in either ascending (asc) or descending (desc) order
        :type order: str
        :param sort_by: order the returned records by a specified field
        :type sort_by: str
        :param search_text: search for records containing the text
        :type search_text: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchants_merchant_id_store_lists_serialize(
            merchant_id=merchant_id,
            content_type=content_type,
            page=page,
            per_page=per_page,
            order=order,
            sort_by=sort_by,
            search_text=search_text,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreListIndexBody",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_merchants_merchant_id_store_lists_serialize(
        self,
        merchant_id,
        content_type,
        page,
        per_page,
        order,
        sort_by,
        search_text,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if merchant_id is not None:
            _path_params['merchant_id'] = merchant_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by))
            
        if search_text is not None:
            
            _query_params.append(('search_text', search_text))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/merchants/{merchant_id}/store_lists',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_merchants_merchant_id_store_lists_store_list_id(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        page: Annotated[Optional[StrictInt], Field(description="page offset")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="number of items per page")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="search for matching text")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="id or name")] = None,
        order: Annotated[Optional[StrictStr], Field(description="asc or desc for ascending or descending, respectively")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> StoreList:
        """Retrieve a Store List

        Look up a store list by ID.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param page: page offset
        :type page: int
        :param per_page: number of items per page
        :type per_page: int
        :param search_text: search for matching text
        :type search_text: str
        :param sort_by: id or name
        :type sort_by: str
        :param order: asc or desc for ascending or descending, respectively
        :type order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            page=page,
            per_page=per_page,
            search_text=search_text,
            sort_by=sort_by,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreList",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_merchants_merchant_id_store_lists_store_list_id_with_http_info(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        page: Annotated[Optional[StrictInt], Field(description="page offset")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="number of items per page")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="search for matching text")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="id or name")] = None,
        order: Annotated[Optional[StrictStr], Field(description="asc or desc for ascending or descending, respectively")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[StoreList]:
        """Retrieve a Store List

        Look up a store list by ID.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param page: page offset
        :type page: int
        :param per_page: number of items per page
        :type per_page: int
        :param search_text: search for matching text
        :type search_text: str
        :param sort_by: id or name
        :type sort_by: str
        :param order: asc or desc for ascending or descending, respectively
        :type order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            page=page,
            per_page=per_page,
            search_text=search_text,
            sort_by=sort_by,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreList",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_merchants_merchant_id_store_lists_store_list_id_without_preload_content(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        page: Annotated[Optional[StrictInt], Field(description="page offset")] = None,
        per_page: Annotated[Optional[StrictInt], Field(description="number of items per page")] = None,
        search_text: Annotated[Optional[StrictStr], Field(description="search for matching text")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="id or name")] = None,
        order: Annotated[Optional[StrictStr], Field(description="asc or desc for ascending or descending, respectively")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Retrieve a Store List

        Look up a store list by ID.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param page: page offset
        :type page: int
        :param per_page: number of items per page
        :type per_page: int
        :param search_text: search for matching text
        :type search_text: str
        :param sort_by: id or name
        :type sort_by: str
        :param order: asc or desc for ascending or descending, respectively
        :type order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            page=page,
            per_page=per_page,
            search_text=search_text,
            sort_by=sort_by,
            order=order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreList",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_merchants_merchant_id_store_lists_store_list_id_serialize(
        self,
        merchant_id,
        store_list_id,
        content_type,
        page,
        per_page,
        search_text,
        sort_by,
        order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if merchant_id is not None:
            _path_params['merchant_id'] = merchant_id
        if store_list_id is not None:
            _path_params['store_list_id'] = store_list_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if per_page is not None:
            
            _query_params.append(('per_page', per_page))
            
        if search_text is not None:
            
            _query_params.append(('search_text', search_text))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/merchants/{merchant_id}/store_lists/{store_list_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def post_merchants_merchant_id_store_lists(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        store_list_request: Optional[StoreListRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> StoreList:
        """Create a Store List

        Add a new store list for a merchant.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param content_type: application/json
        :type content_type: str
        :param store_list_request:
        :type store_list_request: StoreListRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_merchants_merchant_id_store_lists_serialize(
            merchant_id=merchant_id,
            content_type=content_type,
            store_list_request=store_list_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "StoreList",
            '400': "APIError",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def post_merchants_merchant_id_store_lists_with_http_info(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        store_list_request: Optional[StoreListRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[StoreList]:
        """Create a Store List

        Add a new store list for a merchant.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param content_type: application/json
        :type content_type: str
        :param store_list_request:
        :type store_list_request: StoreListRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_merchants_merchant_id_store_lists_serialize(
            merchant_id=merchant_id,
            content_type=content_type,
            store_list_request=store_list_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "StoreList",
            '400': "APIError",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def post_merchants_merchant_id_store_lists_without_preload_content(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        store_list_request: Optional[StoreListRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Create a Store List

        Add a new store list for a merchant.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param content_type: application/json
        :type content_type: str
        :param store_list_request:
        :type store_list_request: StoreListRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_merchants_merchant_id_store_lists_serialize(
            merchant_id=merchant_id,
            content_type=content_type,
            store_list_request=store_list_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "StoreList",
            '400': "APIError",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_merchants_merchant_id_store_lists_serialize(
        self,
        merchant_id,
        content_type,
        store_list_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if merchant_id is not None:
            _path_params['merchant_id'] = merchant_id
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if store_list_request is not None:
            _body_params = store_list_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/merchants/{merchant_id}/store_lists',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def put_merchants_merchant_id_store_lists_store_list_id(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        store_list_request: Optional[StoreListRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> StoreList:
        """Update a Store List

        Update an existing store list.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param store_list_request:
        :type store_list_request: StoreListRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            store_list_request=store_list_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreList",
            '400': "APIError",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def put_merchants_merchant_id_store_lists_store_list_id_with_http_info(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        store_list_request: Optional[StoreListRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> ApiResponse[StoreList]:
        """Update a Store List

        Update an existing store list.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param store_list_request:
        :type store_list_request: StoreListRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            store_list_request=store_list_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreList",
            '400': "APIError",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def put_merchants_merchant_id_store_lists_store_list_id_without_preload_content(
        self,
        merchant_id: Annotated[StrictStr, Field(description="merchant ID owning the store lists")],
        store_list_id: Annotated[StrictStr, Field(description="the store list to search for")],
        content_type: Annotated[Optional[StrictStr], Field(description="application/json")] = None,
        store_list_request: Optional[StoreListRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=1)] = 0,
    ) -> RESTResponseType:
        """Update a Store List

        Update an existing store list.

        :param merchant_id: merchant ID owning the store lists (required)
        :type merchant_id: str
        :param store_list_id: the store list to search for (required)
        :type store_list_id: str
        :param content_type: application/json
        :type content_type: str
        :param store_list_request:
        :type store_list_request: StoreListRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_merchants_merchant_id_store_lists_store_list_id_serialize(
            merchant_id=merchant_id,
            store_list_id=store_list_id,
            content_type=content_type,
            store_list_request=store_list_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "StoreList",
            '400': "APIError",
            '404': "APIError",
            '500': "APIError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_merchants_merchant_id_store_lists_store_list_id_serialize(
        self,
        merchant_id,
        store_list_id,
        content_type,
        store_list_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _hosts = [
            'https://api-staging.sparkfly.com/v1.0'
        ]
        _host = _hosts[_host_index]

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if merchant_id is not None:
            _path_params['merchant_id'] = merchant_id
        if store_list_id is not None:
            _path_params['store_list_id'] = store_list_id
        # process the query parameters
        # process the header parameters
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if store_list_request is not None:
            _body_params = store_list_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'XAuthToken'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/merchants/{merchant_id}/store_lists/{store_list_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


