# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sparkfly.models.ctm_redemption_job_request_items_inner import CtmRedemptionJobRequestItemsInner
from sparkfly.models.ctm_redemption_job_request_redeemed_offers_inner import CtmRedemptionJobRequestRedeemedOffersInner
from sparkfly.models.ctm_redemption_job_request_selected_offers_inner import CtmRedemptionJobRequestSelectedOffersInner
from typing import Optional, Set
from typing_extensions import Self

class CtmRedemptionJobRequest(BaseModel):
    """
    used for ctm show
    """ # noqa: E501
    offers: Optional[List[StrictInt]] = None
    redeemed_offers: Optional[List[CtmRedemptionJobRequestRedeemedOffersInner]] = None
    items: Optional[List[CtmRedemptionJobRequestItemsInner]] = None
    credentials: Optional[List[StrictStr]] = None
    purchase_amt: Optional[StrictInt] = None
    site_id: Optional[StrictStr] = None
    store_number: Optional[StrictStr] = None
    credential: Optional[StrictStr] = None
    term_id: Optional[StrictStr] = None
    tran_id: Optional[StrictStr] = None
    external_transaction_id: Optional[StrictStr] = None
    operator_id: Optional[StrictStr] = None
    reciept_id: Optional[StrictStr] = None
    business_date: Optional[StrictStr] = None
    translator_id: Optional[StrictStr] = None
    num_guests: Optional[StrictInt] = None
    till_id: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    total_due: Optional[StrictInt] = None
    total_discount: Optional[StrictInt] = None
    total_service: Optional[StrictInt] = None
    total_tax: Optional[StrictInt] = None
    total_paid: Optional[StrictInt] = None
    pos_vendor: Optional[StrictStr] = None
    pos_version: Optional[StrictStr] = None
    selected_offers: Optional[List[CtmRedemptionJobRequestSelectedOffersInner]] = None
    revenue_center: Optional[StrictStr] = None
    account_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["offers", "redeemed_offers", "items", "credentials", "purchase_amt", "site_id", "store_number", "credential", "term_id", "tran_id", "external_transaction_id", "operator_id", "reciept_id", "business_date", "translator_id", "num_guests", "till_id", "status", "total_due", "total_discount", "total_service", "total_tax", "total_paid", "pos_vendor", "pos_version", "selected_offers", "revenue_center", "account_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CtmRedemptionJobRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in redeemed_offers (list)
        _items = []
        if self.redeemed_offers:
            for _item_redeemed_offers in self.redeemed_offers:
                if _item_redeemed_offers:
                    _items.append(_item_redeemed_offers.to_dict())
            _dict['redeemed_offers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in selected_offers (list)
        _items = []
        if self.selected_offers:
            for _item_selected_offers in self.selected_offers:
                if _item_selected_offers:
                    _items.append(_item_selected_offers.to_dict())
            _dict['selected_offers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CtmRedemptionJobRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "offers": obj.get("offers"),
            "redeemed_offers": [CtmRedemptionJobRequestRedeemedOffersInner.from_dict(_item) for _item in obj["redeemed_offers"]] if obj.get("redeemed_offers") is not None else None,
            "items": [CtmRedemptionJobRequestItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "credentials": obj.get("credentials"),
            "purchase_amt": obj.get("purchase_amt"),
            "site_id": obj.get("site_id"),
            "store_number": obj.get("store_number"),
            "credential": obj.get("credential"),
            "term_id": obj.get("term_id"),
            "tran_id": obj.get("tran_id"),
            "external_transaction_id": obj.get("external_transaction_id"),
            "operator_id": obj.get("operator_id"),
            "reciept_id": obj.get("reciept_id"),
            "business_date": obj.get("business_date"),
            "translator_id": obj.get("translator_id"),
            "num_guests": obj.get("num_guests"),
            "till_id": obj.get("till_id"),
            "status": obj.get("status"),
            "total_due": obj.get("total_due"),
            "total_discount": obj.get("total_discount"),
            "total_service": obj.get("total_service"),
            "total_tax": obj.get("total_tax"),
            "total_paid": obj.get("total_paid"),
            "pos_vendor": obj.get("pos_vendor"),
            "pos_version": obj.get("pos_version"),
            "selected_offers": [CtmRedemptionJobRequestSelectedOffersInner.from_dict(_item) for _item in obj["selected_offers"]] if obj.get("selected_offers") is not None else None,
            "revenue_center": obj.get("revenue_center"),
            "account_id": obj.get("account_id")
        })
        return _obj


