# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CtmTransactionJobRequest(BaseModel):
    """
    used for ctm update and transaction update
    """ # noqa: E501
    credentials: Optional[List[StrictStr]] = None
    items: Optional[List[Dict[str, Any]]] = None
    purchase_amt: Optional[StrictInt] = None
    site_id: Optional[StrictStr] = None
    term_id: Optional[StrictStr] = None
    tran_id: Optional[StrictStr] = None
    receipt_id: Optional[StrictStr] = None
    operator_id: Optional[StrictStr] = None
    business_date: Optional[StrictStr] = None
    translator_id: Optional[StrictStr] = None
    num_guests: Optional[StrictInt] = None
    till_id: Optional[StrictStr] = None
    total_due: Optional[StrictInt] = None
    total_discount: Optional[StrictInt] = None
    total_service: Optional[StrictInt] = None
    total_tax: Optional[StrictInt] = None
    total_paid: Optional[StrictInt] = None
    account_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["credentials", "items", "purchase_amt", "site_id", "term_id", "tran_id", "receipt_id", "operator_id", "business_date", "translator_id", "num_guests", "till_id", "total_due", "total_discount", "total_service", "total_tax", "total_paid", "account_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CtmTransactionJobRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CtmTransactionJobRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "credentials": obj.get("credentials"),
            "items": obj.get("items"),
            "purchase_amt": obj.get("purchase_amt"),
            "site_id": obj.get("site_id"),
            "term_id": obj.get("term_id"),
            "tran_id": obj.get("tran_id"),
            "receipt_id": obj.get("receipt_id"),
            "operator_id": obj.get("operator_id"),
            "business_date": obj.get("business_date"),
            "translator_id": obj.get("translator_id"),
            "num_guests": obj.get("num_guests"),
            "till_id": obj.get("till_id"),
            "total_due": obj.get("total_due"),
            "total_discount": obj.get("total_discount"),
            "total_service": obj.get("total_service"),
            "total_tax": obj.get("total_tax"),
            "total_paid": obj.get("total_paid"),
            "account_id": obj.get("account_id")
        })
        return _obj


