# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from sparkfly.models.ctm_transaction_show_response_transaction_add_offers_inner import CtmTransactionShowResponseTransactionAddOffersInner
from sparkfly.models.ctm_transaction_show_response_transaction_availible_offers_inner import CtmTransactionShowResponseTransactionAvailibleOffersInner
from sparkfly.models.ctm_transaction_show_response_transaction_credentials_inner import CtmTransactionShowResponseTransactionCredentialsInner
from sparkfly.models.ctm_transaction_show_response_transaction_display_messages_inner import CtmTransactionShowResponseTransactionDisplayMessagesInner
from sparkfly.models.ctm_transaction_show_response_transaction_errors_inner import CtmTransactionShowResponseTransactionErrorsInner
from sparkfly.models.ctm_transaction_show_response_transaction_reciept_messages_inner import CtmTransactionShowResponseTransactionRecieptMessagesInner
from typing import Optional, Set
from typing_extensions import Self

class CtmTransactionShowResponseTransaction(BaseModel):
    """
    CtmTransactionShowResponseTransaction
    """ # noqa: E501
    errors: Optional[List[CtmTransactionShowResponseTransactionErrorsInner]] = None
    display_messages: Optional[List[CtmTransactionShowResponseTransactionDisplayMessagesInner]] = None
    reciept_messages: Optional[List[CtmTransactionShowResponseTransactionRecieptMessagesInner]] = None
    credentials: Optional[List[CtmTransactionShowResponseTransactionCredentialsInner]] = None
    add_offers: Optional[List[CtmTransactionShowResponseTransactionAddOffersInner]] = None
    remove_offers: Optional[List[CtmTransactionShowResponseTransactionAddOffersInner]] = None
    availible_offers: Optional[List[CtmTransactionShowResponseTransactionAvailibleOffersInner]] = None
    __properties: ClassVar[List[str]] = ["errors", "display_messages", "reciept_messages", "credentials", "add_offers", "remove_offers", "availible_offers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CtmTransactionShowResponseTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in display_messages (list)
        _items = []
        if self.display_messages:
            for _item_display_messages in self.display_messages:
                if _item_display_messages:
                    _items.append(_item_display_messages.to_dict())
            _dict['display_messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reciept_messages (list)
        _items = []
        if self.reciept_messages:
            for _item_reciept_messages in self.reciept_messages:
                if _item_reciept_messages:
                    _items.append(_item_reciept_messages.to_dict())
            _dict['reciept_messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credentials (list)
        _items = []
        if self.credentials:
            for _item_credentials in self.credentials:
                if _item_credentials:
                    _items.append(_item_credentials.to_dict())
            _dict['credentials'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in add_offers (list)
        _items = []
        if self.add_offers:
            for _item_add_offers in self.add_offers:
                if _item_add_offers:
                    _items.append(_item_add_offers.to_dict())
            _dict['add_offers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remove_offers (list)
        _items = []
        if self.remove_offers:
            for _item_remove_offers in self.remove_offers:
                if _item_remove_offers:
                    _items.append(_item_remove_offers.to_dict())
            _dict['remove_offers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in availible_offers (list)
        _items = []
        if self.availible_offers:
            for _item_availible_offers in self.availible_offers:
                if _item_availible_offers:
                    _items.append(_item_availible_offers.to_dict())
            _dict['availible_offers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CtmTransactionShowResponseTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "errors": [CtmTransactionShowResponseTransactionErrorsInner.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "display_messages": [CtmTransactionShowResponseTransactionDisplayMessagesInner.from_dict(_item) for _item in obj["display_messages"]] if obj.get("display_messages") is not None else None,
            "reciept_messages": [CtmTransactionShowResponseTransactionRecieptMessagesInner.from_dict(_item) for _item in obj["reciept_messages"]] if obj.get("reciept_messages") is not None else None,
            "credentials": [CtmTransactionShowResponseTransactionCredentialsInner.from_dict(_item) for _item in obj["credentials"]] if obj.get("credentials") is not None else None,
            "add_offers": [CtmTransactionShowResponseTransactionAddOffersInner.from_dict(_item) for _item in obj["add_offers"]] if obj.get("add_offers") is not None else None,
            "remove_offers": [CtmTransactionShowResponseTransactionAddOffersInner.from_dict(_item) for _item in obj["remove_offers"]] if obj.get("remove_offers") is not None else None,
            "availible_offers": [CtmTransactionShowResponseTransactionAvailibleOffersInner.from_dict(_item) for _item in obj["availible_offers"]] if obj.get("availible_offers") is not None else None
        })
        return _obj


