# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sparkfly.models.errors import Errors
from sparkfly.models.impression_request_impression_annotations import ImpressionRequestImpressionAnnotations
from typing import Optional, Set
from typing_extensions import Self

class ImpressionAllOfImpression(BaseModel):
    """
    ImpressionAllOfImpression
    """ # noqa: E501
    id: Optional[StrictInt] = None
    cookie_id: Optional[StrictStr] = None
    offer_xid: Optional[StrictStr] = None
    annotations: Optional[ImpressionRequestImpressionAnnotations] = None
    created_at: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    channel_id: Optional[StrictStr] = None
    channel_name: Optional[StrictStr] = None
    creative_name: Optional[StrictStr] = None
    errors: Optional[Errors] = None
    __properties: ClassVar[List[str]] = ["id", "cookie_id", "offer_xid", "annotations", "created_at", "updated_at", "channel_id", "channel_name", "creative_name", "errors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImpressionAllOfImpression from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of annotations
        if self.annotations:
            _dict['annotations'] = self.annotations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of errors
        if self.errors:
            _dict['errors'] = self.errors.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImpressionAllOfImpression from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "cookie_id": obj.get("cookie_id"),
            "offer_xid": obj.get("offer_xid"),
            "annotations": ImpressionRequestImpressionAnnotations.from_dict(obj["annotations"]) if obj.get("annotations") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "channel_id": obj.get("channel_id"),
            "channel_name": obj.get("channel_name"),
            "creative_name": obj.get("creative_name"),
            "errors": Errors.from_dict(obj["errors"]) if obj.get("errors") is not None else None
        })
        return _obj


