# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from sparkfly.models.inline_object3 import InlineObject3
from typing import Optional, Set
from typing_extensions import Self

class InlineObject4(BaseModel):
    """
    InlineObject4
    """ # noqa: E501
    page: Optional[StrictInt] = None
    per_page: Optional[StrictInt] = None
    total_entries: Optional[StrictInt] = None
    total_pages: Optional[StrictInt] = None
    subaudiences: Optional[List[InlineObject3]] = None
    __properties: ClassVar[List[str]] = ["page", "per_page", "total_entries", "total_pages", "subaudiences"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InlineObject4 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in subaudiences (list)
        _items = []
        if self.subaudiences:
            for _item_subaudiences in self.subaudiences:
                if _item_subaudiences:
                    _items.append(_item_subaudiences.to_dict())
            _dict['subaudiences'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InlineObject4 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "page": obj.get("page"),
            "per_page": obj.get("per_page"),
            "total_entries": obj.get("total_entries"),
            "total_pages": obj.get("total_pages"),
            "subaudiences": [InlineObject3.from_dict(_item) for _item in obj["subaudiences"]] if obj.get("subaudiences") is not None else None
        })
        return _obj


