# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class MemberProfile(BaseModel):
    """
    Represents personal identifying information associated with a Sparkfly Member. No fields are required nor guaranteed to be stored. Member profile data may be outsourced to third party client's upon request.
    """ # noqa: E501
    first_name: Optional[StrictStr] = Field(default=None, description="The member's first name.")
    last_name: Optional[StrictStr] = Field(default=None, description="The member's last name.")
    phone: Optional[StrictStr] = Field(default=None, description="The member's contact phone number.")
    email: Optional[StrictStr] = Field(default=None, description="The member's e-mail address.")
    birth_month: Optional[Annotated[int, Field(le=12, strict=True, ge=1)]] = Field(default=None, description="Month of birth expressed as a 1-based index (1 = January, 2 = February, etc.)")
    birth_day: Optional[StrictInt] = Field(default=None, description="The day of the month the member was born.")
    custom_data: Optional[Dict[str, Any]] = Field(default=None, description="Arbitrary additional data attached to this member's profile.")
    __properties: ClassVar[List[str]] = ["first_name", "last_name", "phone", "email", "birth_month", "birth_day", "custom_data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MemberProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MemberProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "phone": obj.get("phone"),
            "email": obj.get("email"),
            "birth_month": obj.get("birth_month"),
            "birth_day": obj.get("birth_day"),
            "custom_data": obj.get("custom_data")
        })
        return _obj


