# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OfferStateAllOfOfferState(BaseModel):
    """
    OfferStateAllOfOfferState
    """ # noqa: E501
    offer_state_id: Optional[StrictInt] = None
    offer_id: Optional[StrictInt] = None
    member_id: Optional[StrictInt] = None
    status: Optional[StrictStr] = None
    value: Optional[StrictInt] = None
    locked: Optional[StrictBool] = None
    activates_at: Optional[StrictStr] = None
    expires_at: Optional[StrictStr] = None
    external_ref_id: Optional[StrictStr] = None
    custom_data: Optional[StrictStr] = None
    credential_custom_data: Optional[StrictStr] = None
    offer_activities: Optional[List[Dict[str, Any]]] = None
    offer_name: Optional[StrictStr] = None
    offer_short_name: Optional[StrictStr] = None
    offer_campaign_name: Optional[StrictStr] = None
    offer_group: Optional[StrictStr] = None
    offer_description: Optional[StrictStr] = None
    offer_value_required: Optional[StrictInt] = None
    offer_terms_and_conditions: Optional[StrictStr] = None
    offer_web_image_url: Optional[StrictStr] = None
    offer_web_thumb_url: Optional[StrictStr] = None
    offer_mobile_image_url: Optional[StrictStr] = None
    offer_mobile_thumb_url: Optional[StrictStr] = None
    is_reward: Optional[StrictBool] = None
    credential_identifier: Optional[StrictStr] = None
    token: Optional[StrictStr] = None
    transferable: Optional[StrictBool] = None
    reusable: Optional[StrictBool] = None
    offer_tags: Optional[List[Dict[str, Any]]] = None
    offer_campaign_tags: Optional[List[Dict[str, Any]]] = None
    campaign_external_id: Optional[StrictStr] = None
    campaign_xid: Optional[StrictStr] = None
    campaign_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["offer_state_id", "offer_id", "member_id", "status", "value", "locked", "activates_at", "expires_at", "external_ref_id", "custom_data", "credential_custom_data", "offer_activities", "offer_name", "offer_short_name", "offer_campaign_name", "offer_group", "offer_description", "offer_value_required", "offer_terms_and_conditions", "offer_web_image_url", "offer_web_thumb_url", "offer_mobile_image_url", "offer_mobile_thumb_url", "is_reward", "credential_identifier", "token", "transferable", "reusable", "offer_tags", "offer_campaign_tags", "campaign_external_id", "campaign_xid", "campaign_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OfferStateAllOfOfferState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OfferStateAllOfOfferState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "offer_state_id": obj.get("offer_state_id"),
            "offer_id": obj.get("offer_id"),
            "member_id": obj.get("member_id"),
            "status": obj.get("status"),
            "value": obj.get("value"),
            "locked": obj.get("locked"),
            "activates_at": obj.get("activates_at"),
            "expires_at": obj.get("expires_at"),
            "external_ref_id": obj.get("external_ref_id"),
            "custom_data": obj.get("custom_data"),
            "credential_custom_data": obj.get("credential_custom_data"),
            "offer_activities": obj.get("offer_activities"),
            "offer_name": obj.get("offer_name"),
            "offer_short_name": obj.get("offer_short_name"),
            "offer_campaign_name": obj.get("offer_campaign_name"),
            "offer_group": obj.get("offer_group"),
            "offer_description": obj.get("offer_description"),
            "offer_value_required": obj.get("offer_value_required"),
            "offer_terms_and_conditions": obj.get("offer_terms_and_conditions"),
            "offer_web_image_url": obj.get("offer_web_image_url"),
            "offer_web_thumb_url": obj.get("offer_web_thumb_url"),
            "offer_mobile_image_url": obj.get("offer_mobile_image_url"),
            "offer_mobile_thumb_url": obj.get("offer_mobile_thumb_url"),
            "is_reward": obj.get("is_reward"),
            "credential_identifier": obj.get("credential_identifier"),
            "token": obj.get("token"),
            "transferable": obj.get("transferable"),
            "reusable": obj.get("reusable"),
            "offer_tags": obj.get("offer_tags"),
            "offer_campaign_tags": obj.get("offer_campaign_tags"),
            "campaign_external_id": obj.get("campaign_external_id"),
            "campaign_xid": obj.get("campaign_xid"),
            "campaign_id": obj.get("campaign_id")
        })
        return _obj


