# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PostMembersIdOfferStatesIssue201ResponseOfferState(BaseModel):
    """
    The newly created offer_state
    """ # noqa: E501
    id: StrictInt = Field(description="The unique ID of the offer_state.")
    member_id: StrictInt = Field(description="The member ID the offer_state was issued to.")
    offer_id: StrictInt = Field(description="The ID of the offer that was issued to the member.")
    campaign_id: StrictStr = Field(description="The Campaign XID of the campaign that was used to perform the issuance.")
    activates_at: Optional[datetime] = Field(default=None, description="When the offer_state will become redeemable at the POS, if specified in the request.")
    expires_at: Optional[datetime] = Field(default=None, description="When the offer_state will stop being redeemable at the POS, if specified in the request.")
    credential_identifier: StrictStr = Field(description="The credential identifier that can be entered or scanned at the POS to redeem the issued offer_state.")
    __properties: ClassVar[List[str]] = ["id", "member_id", "offer_id", "campaign_id", "activates_at", "expires_at", "credential_identifier"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostMembersIdOfferStatesIssue201ResponseOfferState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostMembersIdOfferStatesIssue201ResponseOfferState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "member_id": obj.get("member_id"),
            "offer_id": obj.get("offer_id"),
            "campaign_id": obj.get("campaign_id"),
            "activates_at": obj.get("activates_at"),
            "expires_at": obj.get("expires_at"),
            "credential_identifier": obj.get("credential_identifier")
        })
        return _obj


