# coding: utf-8

"""
    Core Operations

    The Sparkfly Platform provides a full lifecycle for promotions and rewards from creation to distribution to settlement. The platform integrates in real-time at the point-of-sale and provides item level discounting and tracking. The capabilities of the Sparkfly Platform are available through the use of the Sparkfly Platform API.  The Sparkfly documentation site is under development. If the documentation you're after isn't available here, please contact support@sparkfly.com and we will get you what you need.

    The version of the OpenAPI document: 1.0
    Contact: support@sparkfly.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PostMembersIdOfferStatesIssueRequestOfferState(BaseModel):
    """
    The offer_state to issue to the member.
    """ # noqa: E501
    external_ref_id: Optional[StrictStr] = Field(default=None, description="An external reference identifier that will be attached to the offer_state. Meaning and value are not specified and may be useful for external systems that wish to attach data to an offer_state.")
    campaign_id: StrictStr = Field(description="The Sparkfly campaign XID to use when issuing the offer_state. Must be an active (non-suspended) campaign under an active offer.")
    activates_at: Optional[datetime] = Field(default=None, description="When the issued offer should become redeemable at the POS.")
    expires_at: Optional[datetime] = Field(default=None, description="When the issued offer should stop being redeemable at the POS.")
    member_identifier: Optional[StrictStr] = Field(default=None, description="The member's external identifier. This field is required if member_id is absent.")
    member_id: Optional[StrictInt] = Field(default=None, description="The primary identifier of the member. This field is required if member_identifier is absent.")
    __properties: ClassVar[List[str]] = ["external_ref_id", "campaign_id", "activates_at", "expires_at", "member_identifier", "member_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostMembersIdOfferStatesIssueRequestOfferState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostMembersIdOfferStatesIssueRequestOfferState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "external_ref_id": obj.get("external_ref_id"),
            "campaign_id": obj.get("campaign_id"),
            "activates_at": obj.get("activates_at"),
            "expires_at": obj.get("expires_at"),
            "member_identifier": obj.get("member_identifier"),
            "member_id": obj.get("member_id")
        })
        return _obj


