# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.embedding_response import EmbeddingResponse
from .raw_client import AsyncRawEmbedClient, RawEmbedClient
from .tasks.client import AsyncTasksClient, TasksClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EmbedClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEmbedClient(client_wrapper=client_wrapper)
        self.tasks = TasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEmbedClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEmbedClient
        """
        return self._raw_client

    def create(
        self,
        *,
        model_name: str,
        text: typing.Optional[str] = OMIT,
        text_truncate: typing.Optional[str] = OMIT,
        image_url: typing.Optional[str] = OMIT,
        image_file: typing.Optional[core.File] = OMIT,
        audio_url: typing.Optional[str] = OMIT,
        audio_file: typing.Optional[core.File] = OMIT,
        audio_start_offset_sec: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EmbeddingResponse:
        """
        This method creates embeddings for text, image, and audio content.

        Before you create an embedding, ensure that your image or audio files meet the following prerequisites:
        - [Image embeddings](/v1.3/docs/guides/create-embeddings/image#prerequisites)
        - [Audio embeddings](/v1.3/docs/guides/create-embeddings/audio#prerequisites)

        Parameters for embeddings:
        - **Common parameters**:
          - `model_name`: The video understanding model you want to use. Example: "Marengo-retrieval-2.7".
        - **Text embeddings**:
          - `text`: Text for which to create an embedding.
        - **Image embeddings**:
          Provide one of the following:
          - `image_url`: Publicly accessible URL of your image file.
          - `image_file`:  Local image file.
        - **Audio embeddings**:
          Provide one of the following:
          - `audio_url`: Publicly accessible URL of your audio file.
          - `audio_file`: Local audio file.

        <Note title="Notes">
        - The Marengo video understanding model generates embeddings for all modalities in the same latent space. This shared space enables any-to-any searches across different types of content.
        - You can create multiple types of embeddings in a single API call.
        - Audio embeddings combine generic sound and human speech in a single embedding. For videos with transcriptions, you can retrieve transcriptions and then [create text embeddings](/v1.3/api-reference/text-image-audio-embeddings/create-text-image-audio-embeddings) from these transcriptions.
        </Note>

        Parameters
        ----------
        model_name : str
            The name of the model you want to use. The following models are available:
              - `Marengo-retrieval-2.7`

        text : typing.Optional[str]
            The text for which you wish to create an embedding.

            <Note title="Note">
            Text embeddings are limited to 77 tokens. If the text exceeds this limit, the platform truncates it according to the value of the `text_truncate` parameter described below.
            </Note>

            **Example**: "Man with a dog crossing the street"

        text_truncate : typing.Optional[str]
            Specifies how the platform truncates text that exceeds 77 tokens to fit the maximum length allowed for an embedding.
            This parameter can take one of the following values:
            - `start`: The platform will truncate the start of the provided text.
            - `end`: The platform will truncate the end of the provided text.
            - `none`: The platform will return an error if the text is longer than the maximum token limit.

            **Default**: `end`

        image_url : typing.Optional[str]
            The publicly accessible URL of the image for which you wish to create an embedding. This parameter is required for image embeddings if `image_file` is not provided.

        image_file : typing.Optional[core.File]
            See core.File for more documentation

        audio_url : typing.Optional[str]
            The publicly accessible URL of the audio file for which you wish to create an embedding. This parameter is required for audio embeddings if `audio_file` is not provided.

        audio_file : typing.Optional[core.File]
            See core.File for more documentation

        audio_start_offset_sec : typing.Optional[float]
            Specifies the start time, in seconds, from which the platform generates the audio embeddings. This parameter allows you to skip the initial portion of the audio during processing.
            **Default**: `0`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmbeddingResponse
            A text embedding has successfully been created.

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.embed.create(
            model_name="model_name",
        )
        """
        _response = self._raw_client.create(
            model_name=model_name,
            text=text,
            text_truncate=text_truncate,
            image_url=image_url,
            image_file=image_file,
            audio_url=audio_url,
            audio_file=audio_file,
            audio_start_offset_sec=audio_start_offset_sec,
            request_options=request_options,
        )
        return _response.data


class AsyncEmbedClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEmbedClient(client_wrapper=client_wrapper)
        self.tasks = AsyncTasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEmbedClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEmbedClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        model_name: str,
        text: typing.Optional[str] = OMIT,
        text_truncate: typing.Optional[str] = OMIT,
        image_url: typing.Optional[str] = OMIT,
        image_file: typing.Optional[core.File] = OMIT,
        audio_url: typing.Optional[str] = OMIT,
        audio_file: typing.Optional[core.File] = OMIT,
        audio_start_offset_sec: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EmbeddingResponse:
        """
        This method creates embeddings for text, image, and audio content.

        Before you create an embedding, ensure that your image or audio files meet the following prerequisites:
        - [Image embeddings](/v1.3/docs/guides/create-embeddings/image#prerequisites)
        - [Audio embeddings](/v1.3/docs/guides/create-embeddings/audio#prerequisites)

        Parameters for embeddings:
        - **Common parameters**:
          - `model_name`: The video understanding model you want to use. Example: "Marengo-retrieval-2.7".
        - **Text embeddings**:
          - `text`: Text for which to create an embedding.
        - **Image embeddings**:
          Provide one of the following:
          - `image_url`: Publicly accessible URL of your image file.
          - `image_file`:  Local image file.
        - **Audio embeddings**:
          Provide one of the following:
          - `audio_url`: Publicly accessible URL of your audio file.
          - `audio_file`: Local audio file.

        <Note title="Notes">
        - The Marengo video understanding model generates embeddings for all modalities in the same latent space. This shared space enables any-to-any searches across different types of content.
        - You can create multiple types of embeddings in a single API call.
        - Audio embeddings combine generic sound and human speech in a single embedding. For videos with transcriptions, you can retrieve transcriptions and then [create text embeddings](/v1.3/api-reference/text-image-audio-embeddings/create-text-image-audio-embeddings) from these transcriptions.
        </Note>

        Parameters
        ----------
        model_name : str
            The name of the model you want to use. The following models are available:
              - `Marengo-retrieval-2.7`

        text : typing.Optional[str]
            The text for which you wish to create an embedding.

            <Note title="Note">
            Text embeddings are limited to 77 tokens. If the text exceeds this limit, the platform truncates it according to the value of the `text_truncate` parameter described below.
            </Note>

            **Example**: "Man with a dog crossing the street"

        text_truncate : typing.Optional[str]
            Specifies how the platform truncates text that exceeds 77 tokens to fit the maximum length allowed for an embedding.
            This parameter can take one of the following values:
            - `start`: The platform will truncate the start of the provided text.
            - `end`: The platform will truncate the end of the provided text.
            - `none`: The platform will return an error if the text is longer than the maximum token limit.

            **Default**: `end`

        image_url : typing.Optional[str]
            The publicly accessible URL of the image for which you wish to create an embedding. This parameter is required for image embeddings if `image_file` is not provided.

        image_file : typing.Optional[core.File]
            See core.File for more documentation

        audio_url : typing.Optional[str]
            The publicly accessible URL of the audio file for which you wish to create an embedding. This parameter is required for audio embeddings if `audio_file` is not provided.

        audio_file : typing.Optional[core.File]
            See core.File for more documentation

        audio_start_offset_sec : typing.Optional[float]
            Specifies the start time, in seconds, from which the platform generates the audio embeddings. This parameter allows you to skip the initial portion of the audio during processing.
            **Default**: `0`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmbeddingResponse
            A text embedding has successfully been created.

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.embed.create(
                model_name="model_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model_name=model_name,
            text=text,
            text_truncate=text_truncate,
            image_url=image_url,
            image_file=image_file,
            audio_url=audio_url,
            audio_file=audio_file,
            audio_start_offset_sec=audio_start_offset_sec,
            request_options=request_options,
        )
        return _response.data
