# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ... import core
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...types.video_embedding_task import VideoEmbeddingTask
from .types.tasks_create_request_video_embedding_scope_item import TasksCreateRequestVideoEmbeddingScopeItem
from .types.tasks_create_response import TasksCreateResponse
from .types.tasks_list_response import TasksListResponse
from .types.tasks_retrieve_request_embedding_option_item import TasksRetrieveRequestEmbeddingOptionItem
from .types.tasks_retrieve_response import TasksRetrieveResponse
from .types.tasks_status_response import TasksStatusResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTasksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        started_at: typing.Optional[str] = None,
        ended_at: typing.Optional[str] = None,
        status: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[VideoEmbeddingTask]:
        """
        This method returns a list of the video embedding tasks in your account. The platform returns your video embedding tasks sorted by creation date, with the newest at the top of the list.

        <Note title="Notes">
        - Video embeddings are stored for seven days
        - When you invoke this method without specifying the `started_at` and `ended_at` parameters, the platform returns all the video embedding tasks created within the last seven days.
        </Note>

        Parameters
        ----------
        started_at : typing.Optional[str]
            Retrieve the video embedding tasks that were created after the given date and time, expressed in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ").

        ended_at : typing.Optional[str]
            Retrieve the video embedding tasks that were created before the given date and time, expressed in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ").

        status : typing.Optional[str]
            Filter video embedding tasks by their current status. Possible values are `processing`, `ready`, or `failed`.

        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[VideoEmbeddingTask]
            A list of video embedding tasks has successfully been retrieved.
        """
        page = page if page is not None else 1

        _response = self._client_wrapper.httpx_client.request(
            "embed/tasks",
            method="GET",
            params={
                "started_at": started_at,
                "ended_at": ended_at,
                "status": status,
                "page": page,
                "page_limit": page_limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TasksListResponse,
                    parse_obj_as(
                        type_=TasksListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True
                _get_next = lambda: self.list(
                    started_at=started_at,
                    ended_at=ended_at,
                    status=status,
                    page=page + 1,
                    page_limit=page_limit,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        model_name: str,
        video_file: typing.Optional[core.File] = OMIT,
        video_url: typing.Optional[str] = OMIT,
        video_start_offset_sec: typing.Optional[float] = OMIT,
        video_end_offset_sec: typing.Optional[float] = OMIT,
        video_clip_length: typing.Optional[float] = OMIT,
        video_embedding_scope: typing.Optional[typing.List[TasksCreateRequestVideoEmbeddingScopeItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TasksCreateResponse]:
        """
        This method creates a new video embedding task that uploads a video to the platform and creates one or multiple video embeddings.
        
        Upload options:
        - **Local file**: Use the `video_file` parameter
        - **Publicly accessible URL**: Use the `video_url` parameter.
        
        Specify at least one option. If both are provided, `video_url` takes precedence.
        
        <Accordion title="Video requirements">
          The videos you wish to upload must meet the following requirements:
          - **Video resolution**: Must be at least 360x360 and must not exceed 3840x2160.
          - **Aspect ratio**: Must be one of 1:1, 4:3, 4:5, 5:4, 16:9, 9:16, or 17:9.
          - **Video and audio formats**: Your video files must be encoded in the video and audio formats listed on the [FFmpeg Formats Documentation](https://ffmpeg.org/ffmpeg-formats.html) page. For videos in other formats, contact us at support@twelvelabs.io.
          - **Duration**: Must be between 4 seconds and 2 hours (7,200s).
          - **File size**: Must not exceed 2 GB.
            If you require different options, contact us at support@twelvelabs.io.
        </Accordion>
        
        <Note title="Notes">
        - The Marengo video understanding model generates embeddings for all modalities in the same latent space. This shared space enables any-to-any searches across different types of content.
        - Video embeddings are stored for seven days.
        - The platform supports uploading video files that can play without additional user interaction or custom video players. Ensure your URL points to the raw video file, not a web page containing the video. Links to third-party hosting sites, cloud storage services, or videos requiring extra steps to play are not supported.
        </Note>
        
        Parameters
        ----------
        model_name : str
            The name of the model you want to use. The following models are available:
              - `Marengo-retrieval-2.7`
        
        video_file : typing.Optional[core.File]
            See core.File for more documentation
        
        video_url : typing.Optional[str]
            Specify this parameter to upload a video from a publicly accessible URL.
        
        video_start_offset_sec : typing.Optional[float]
            The start offset in seconds from the beginning of the video where processing should begin. Specifying 0 means starting from the beginning of the video.
            
            **Default**: 0
            **Min**: 0
            **Max**: Duration of the video minus video_clip_length
        
        video_end_offset_sec : typing.Optional[float]
            The end offset in seconds from the beginning of the video where processing should stop.
            
            Ensure the following when you specify this parameter:
            - The end offset does not exceed the total duration of the video file.
            - The end offset is greater than the start offset.
            - You must set both the start and end offsets. Setting only one of these offsets is not permitted, resulting in an error.
            
            **Min**: video_start_offset + video_clip_length
            **Max**: Duration of the video file
        
        video_clip_length : typing.Optional[float]
            The desired duration in seconds for each clip for which the platform generates an embedding. Ensure that the clip length does not exceed the interval between the start and end offsets.
            
            **Default**: 6
            **Min**: 2
            **Max**: 10
        
        video_embedding_scope : typing.Optional[typing.List[TasksCreateRequestVideoEmbeddingScopeItem]]
            Defines the scope of video embedding generation. Valid values are the following:
            - `clip`: Creates embeddings for each video segment of `video_clip_length` seconds, from `video_start_offset_sec` to `video_end_offset_sec`.
            - `clip` and `video`: Creates embeddings for video segments and the entire video.
            
            To create embeddings for segments and the entire video in the same request, include this parameter twice as shown below:
            
            ```json
            --form video_embedding_scope=clip \
            --form video_embedding_scope=video
            ```
            
            **Default**: `clip`
        
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.
        
        Returns
        -------
        HttpResponse[TasksCreateResponse]
            A video embedding task has successfully been created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "embed/tasks",
            method="POST",
            data={
                "model_name": model_name,
                "video_url": video_url,
                "video_start_offset_sec": video_start_offset_sec,
                "video_end_offset_sec": video_end_offset_sec,
                "video_clip_length": video_clip_length,
                "video_embedding_scope": video_embedding_scope,
            },
            files={
                **({"video_file": video_file} if video_file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksCreateResponse,
                    parse_obj_as(
                        type_=TasksCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def status(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[TasksStatusResponse]:
        """
        This method retrieves the status of a video embedding task. Check the task status of a video embedding task to determine when you can retrieve the embedding.

        A task can have one of the following statuses:
        - `processing`: The platform is creating the embeddings.
        - `ready`:  Processing is complete. Retrieve the embeddings by invoking the [`GET`](/v1.3/api-reference/video-embeddings/retrieve-video-embeddings) method of the `/embed/tasks/{task_id} endpoint`.
        - `failed`: The task could not be completed, and the embeddings haven't been created.

        Parameters
        ----------
        task_id : str
            The unique identifier of your video embedding task.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TasksStatusResponse]
            The status of your video embedding task has been retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"embed/tasks/{jsonable_encoder(task_id)}/status",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksStatusResponse,
                    parse_obj_as(
                        type_=TasksStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self,
        task_id: str,
        *,
        embedding_option: typing.Optional[
            typing.Union[
                TasksRetrieveRequestEmbeddingOptionItem, typing.Sequence[TasksRetrieveRequestEmbeddingOptionItem]
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TasksRetrieveResponse]:
        """
        This method retrieves embeddings for a specific video embedding task. Ensure the task status is `ready` before invoking this method. Refer to the [Retrieve the status of a video embedding tasks](/v1.3/api-reference/video-embeddings/retrieve-video-embedding-task-status) page for instructions on checking the task status.

        Parameters
        ----------
        task_id : str
            The unique identifier of your video embedding task.

        embedding_option : typing.Optional[typing.Union[TasksRetrieveRequestEmbeddingOptionItem, typing.Sequence[TasksRetrieveRequestEmbeddingOptionItem]]]
            Specifies which types of embeddings to retrieve. You can include one or more of the following values:
              - `visual-text`:  Returns visual embeddings optimized for text search.
              - `audio`: Returns audio embeddings.

            The platform returns all available embeddings if you don't provide this parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TasksRetrieveResponse]
            Video embeddings have successfully been retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"embed/tasks/{jsonable_encoder(task_id)}",
            method="GET",
            params={
                "embedding_option": embedding_option,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksRetrieveResponse,
                    parse_obj_as(
                        type_=TasksRetrieveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTasksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        started_at: typing.Optional[str] = None,
        ended_at: typing.Optional[str] = None,
        status: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[VideoEmbeddingTask]:
        """
        This method returns a list of the video embedding tasks in your account. The platform returns your video embedding tasks sorted by creation date, with the newest at the top of the list.

        <Note title="Notes">
        - Video embeddings are stored for seven days
        - When you invoke this method without specifying the `started_at` and `ended_at` parameters, the platform returns all the video embedding tasks created within the last seven days.
        </Note>

        Parameters
        ----------
        started_at : typing.Optional[str]
            Retrieve the video embedding tasks that were created after the given date and time, expressed in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ").

        ended_at : typing.Optional[str]
            Retrieve the video embedding tasks that were created before the given date and time, expressed in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ").

        status : typing.Optional[str]
            Filter video embedding tasks by their current status. Possible values are `processing`, `ready`, or `failed`.

        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[VideoEmbeddingTask]
            A list of video embedding tasks has successfully been retrieved.
        """
        page = page if page is not None else 1

        _response = await self._client_wrapper.httpx_client.request(
            "embed/tasks",
            method="GET",
            params={
                "started_at": started_at,
                "ended_at": ended_at,
                "status": status,
                "page": page,
                "page_limit": page_limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TasksListResponse,
                    parse_obj_as(
                        type_=TasksListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True

                async def _get_next():
                    return await self.list(
                        started_at=started_at,
                        ended_at=ended_at,
                        status=status,
                        page=page + 1,
                        page_limit=page_limit,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        model_name: str,
        video_file: typing.Optional[core.File] = OMIT,
        video_url: typing.Optional[str] = OMIT,
        video_start_offset_sec: typing.Optional[float] = OMIT,
        video_end_offset_sec: typing.Optional[float] = OMIT,
        video_clip_length: typing.Optional[float] = OMIT,
        video_embedding_scope: typing.Optional[typing.List[TasksCreateRequestVideoEmbeddingScopeItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TasksCreateResponse]:
        """
        This method creates a new video embedding task that uploads a video to the platform and creates one or multiple video embeddings.
        
        Upload options:
        - **Local file**: Use the `video_file` parameter
        - **Publicly accessible URL**: Use the `video_url` parameter.
        
        Specify at least one option. If both are provided, `video_url` takes precedence.
        
        <Accordion title="Video requirements">
          The videos you wish to upload must meet the following requirements:
          - **Video resolution**: Must be at least 360x360 and must not exceed 3840x2160.
          - **Aspect ratio**: Must be one of 1:1, 4:3, 4:5, 5:4, 16:9, 9:16, or 17:9.
          - **Video and audio formats**: Your video files must be encoded in the video and audio formats listed on the [FFmpeg Formats Documentation](https://ffmpeg.org/ffmpeg-formats.html) page. For videos in other formats, contact us at support@twelvelabs.io.
          - **Duration**: Must be between 4 seconds and 2 hours (7,200s).
          - **File size**: Must not exceed 2 GB.
            If you require different options, contact us at support@twelvelabs.io.
        </Accordion>
        
        <Note title="Notes">
        - The Marengo video understanding model generates embeddings for all modalities in the same latent space. This shared space enables any-to-any searches across different types of content.
        - Video embeddings are stored for seven days.
        - The platform supports uploading video files that can play without additional user interaction or custom video players. Ensure your URL points to the raw video file, not a web page containing the video. Links to third-party hosting sites, cloud storage services, or videos requiring extra steps to play are not supported.
        </Note>
        
        Parameters
        ----------
        model_name : str
            The name of the model you want to use. The following models are available:
              - `Marengo-retrieval-2.7`
        
        video_file : typing.Optional[core.File]
            See core.File for more documentation
        
        video_url : typing.Optional[str]
            Specify this parameter to upload a video from a publicly accessible URL.
        
        video_start_offset_sec : typing.Optional[float]
            The start offset in seconds from the beginning of the video where processing should begin. Specifying 0 means starting from the beginning of the video.
            
            **Default**: 0
            **Min**: 0
            **Max**: Duration of the video minus video_clip_length
        
        video_end_offset_sec : typing.Optional[float]
            The end offset in seconds from the beginning of the video where processing should stop.
            
            Ensure the following when you specify this parameter:
            - The end offset does not exceed the total duration of the video file.
            - The end offset is greater than the start offset.
            - You must set both the start and end offsets. Setting only one of these offsets is not permitted, resulting in an error.
            
            **Min**: video_start_offset + video_clip_length
            **Max**: Duration of the video file
        
        video_clip_length : typing.Optional[float]
            The desired duration in seconds for each clip for which the platform generates an embedding. Ensure that the clip length does not exceed the interval between the start and end offsets.
            
            **Default**: 6
            **Min**: 2
            **Max**: 10
        
        video_embedding_scope : typing.Optional[typing.List[TasksCreateRequestVideoEmbeddingScopeItem]]
            Defines the scope of video embedding generation. Valid values are the following:
            - `clip`: Creates embeddings for each video segment of `video_clip_length` seconds, from `video_start_offset_sec` to `video_end_offset_sec`.
            - `clip` and `video`: Creates embeddings for video segments and the entire video.
            
            To create embeddings for segments and the entire video in the same request, include this parameter twice as shown below:
            
            ```json
            --form video_embedding_scope=clip \
            --form video_embedding_scope=video
            ```
            
            **Default**: `clip`
        
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.
        
        Returns
        -------
        AsyncHttpResponse[TasksCreateResponse]
            A video embedding task has successfully been created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "embed/tasks",
            method="POST",
            data={
                "model_name": model_name,
                "video_url": video_url,
                "video_start_offset_sec": video_start_offset_sec,
                "video_end_offset_sec": video_end_offset_sec,
                "video_clip_length": video_clip_length,
                "video_embedding_scope": video_embedding_scope,
            },
            files={
                **({"video_file": video_file} if video_file is not None else {}),
            },
            request_options=request_options,
            omit=OMIT,
            force_multipart=True,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksCreateResponse,
                    parse_obj_as(
                        type_=TasksCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def status(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[TasksStatusResponse]:
        """
        This method retrieves the status of a video embedding task. Check the task status of a video embedding task to determine when you can retrieve the embedding.

        A task can have one of the following statuses:
        - `processing`: The platform is creating the embeddings.
        - `ready`:  Processing is complete. Retrieve the embeddings by invoking the [`GET`](/v1.3/api-reference/video-embeddings/retrieve-video-embeddings) method of the `/embed/tasks/{task_id} endpoint`.
        - `failed`: The task could not be completed, and the embeddings haven't been created.

        Parameters
        ----------
        task_id : str
            The unique identifier of your video embedding task.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TasksStatusResponse]
            The status of your video embedding task has been retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"embed/tasks/{jsonable_encoder(task_id)}/status",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksStatusResponse,
                    parse_obj_as(
                        type_=TasksStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self,
        task_id: str,
        *,
        embedding_option: typing.Optional[
            typing.Union[
                TasksRetrieveRequestEmbeddingOptionItem, typing.Sequence[TasksRetrieveRequestEmbeddingOptionItem]
            ]
        ] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TasksRetrieveResponse]:
        """
        This method retrieves embeddings for a specific video embedding task. Ensure the task status is `ready` before invoking this method. Refer to the [Retrieve the status of a video embedding tasks](/v1.3/api-reference/video-embeddings/retrieve-video-embedding-task-status) page for instructions on checking the task status.

        Parameters
        ----------
        task_id : str
            The unique identifier of your video embedding task.

        embedding_option : typing.Optional[typing.Union[TasksRetrieveRequestEmbeddingOptionItem, typing.Sequence[TasksRetrieveRequestEmbeddingOptionItem]]]
            Specifies which types of embeddings to retrieve. You can include one or more of the following values:
              - `visual-text`:  Returns visual embeddings optimized for text search.
              - `audio`: Returns audio embeddings.

            The platform returns all available embeddings if you don't provide this parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TasksRetrieveResponse]
            Video embeddings have successfully been retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"embed/tasks/{jsonable_encoder(task_id)}",
            method="GET",
            params={
                "embedding_option": embedding_option,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TasksRetrieveResponse,
                    parse_obj_as(
                        type_=TasksRetrieveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
