# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.index_schema import IndexSchema
from .raw_client import AsyncRawIndexesClient, RawIndexesClient
from .types.indexes_create_request_models_item import IndexesCreateRequestModelsItem
from .types.indexes_create_response import IndexesCreateResponse
from .videos.client import AsyncVideosClient, VideosClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class IndexesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIndexesClient(client_wrapper=client_wrapper)
        self.videos = VideosClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIndexesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIndexesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        index_name: typing.Optional[str] = None,
        model_options: typing.Optional[str] = None,
        model_family: typing.Optional[str] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[IndexSchema]:
        """
        This method returns a list of the indexes in your account. The API returns indexes sorted by creation date, with the oldest indexes at the top of the list.

        Parameters
        ----------
        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        index_name : typing.Optional[str]
            Filter by the name of an index.

        model_options : typing.Optional[str]
            Filter by the model options. When filtering by multiple model options, the values must be comma-separated.

        model_family : typing.Optional[str]
            Filter by the model family. This parameter can take one of the following values: `marengo` or `pegasus`. You can specify a single value.

        created_at : typing.Optional[str]
            Filter indexes by the creation date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the indexes that were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            Filter indexes by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the indexes that were last updated on the specified date at or after the given time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[IndexSchema]
            The indexes have successfully been retrieved.

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        response = client.indexes.list(
            page=1,
            page_limit=10,
            sort_by="created_at",
            sort_option="desc",
            index_name="myIndex",
            model_options="visual,audio",
            model_family="marengo",
            created_at="2024-08-16T16:53:59Z",
            updated_at="2024-08-16T16:55:59Z",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page,
            page_limit=page_limit,
            sort_by=sort_by,
            sort_option=sort_option,
            index_name=index_name,
            model_options=model_options,
            model_family=model_family,
            created_at=created_at,
            updated_at=updated_at,
            request_options=request_options,
        )

    def create(
        self,
        *,
        index_name: str,
        models: typing.Sequence[IndexesCreateRequestModelsItem],
        addons: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IndexesCreateResponse:
        """
        This method creates an index.

        Parameters
        ----------
        index_name : str
            The name of the index. Make sure you use a succinct and descriptive name.

        models : typing.Sequence[IndexesCreateRequestModelsItem]
            An array that specifies the [video understanding models](/v1.3/docs/concepts/models) and the [model options](/v1.3/docs/concepts/modalities#model-options) to be enabled for this index. This determines how the platform processes your videos.

        addons : typing.Optional[typing.Sequence[str]]
            An array specifying which add-ons should be enabled. Each entry in the array is an addon, and the following values are supported:
            - `thumbnail`: Enables thumbnail generation.

            If you don't provide this parameter, no add-ons will be enabled.

            <Note title="Notes">
            - You can only enable addons when using the Marengo video understanding model.
            - You cannot disable an add-on once the index has been created.
            </Note>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IndexesCreateResponse
            An index has successfully been created

        Examples
        --------
        from twelvelabs import TwelveLabs
        from twelvelabs.indexes import IndexesCreateRequestModelsItem

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.indexes.create(
            index_name="myIndex",
            models=[
                IndexesCreateRequestModelsItem(
                    model_name="marengo2.7",
                    model_options=["visual", "audio"],
                ),
                IndexesCreateRequestModelsItem(
                    model_name="pegasus1.2",
                    model_options=["visual", "audio"],
                ),
            ],
            addons=["thumbnail"],
        )
        """
        _response = self._raw_client.create(
            index_name=index_name, models=models, addons=addons, request_options=request_options
        )
        return _response.data

    def retrieve(self, index_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> IndexSchema:
        """
        This method retrieves details about the specified index.

        Parameters
        ----------
        index_id : str
            Unique identifier of the index to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IndexSchema
            The specified index has successfully been retrieved.

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.indexes.retrieve(
            index_id="6298d673f1090f1100476d4c",
        )
        """
        _response = self._raw_client.retrieve(index_id, request_options=request_options)
        return _response.data

    def update(
        self, index_id: str, *, index_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        This method updates the name of the specified index.

        Parameters
        ----------
        index_id : str
            Unique identifier of the index to update.

        index_name : str
            The name of the index.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.indexes.update(
            index_id="6298d673f1090f1100476d4c",
            index_name="myIndex",
        )
        """
        _response = self._raw_client.update(index_id, index_name=index_name, request_options=request_options)
        return _response.data

    def delete(self, index_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        This method deletes the specified index and all the videos within it. This action cannot be undone.

        Parameters
        ----------
        index_id : str
            Unique identifier of the index to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.indexes.delete(
            index_id="6298d673f1090f1100476d4c",
        )
        """
        _response = self._raw_client.delete(index_id, request_options=request_options)
        return _response.data


class AsyncIndexesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIndexesClient(client_wrapper=client_wrapper)
        self.videos = AsyncVideosClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIndexesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIndexesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        index_name: typing.Optional[str] = None,
        model_options: typing.Optional[str] = None,
        model_family: typing.Optional[str] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[IndexSchema]:
        """
        This method returns a list of the indexes in your account. The API returns indexes sorted by creation date, with the oldest indexes at the top of the list.

        Parameters
        ----------
        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        index_name : typing.Optional[str]
            Filter by the name of an index.

        model_options : typing.Optional[str]
            Filter by the model options. When filtering by multiple model options, the values must be comma-separated.

        model_family : typing.Optional[str]
            Filter by the model family. This parameter can take one of the following values: `marengo` or `pegasus`. You can specify a single value.

        created_at : typing.Optional[str]
            Filter indexes by the creation date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the indexes that were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            Filter indexes by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the indexes that were last updated on the specified date at or after the given time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[IndexSchema]
            The indexes have successfully been retrieved.

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.indexes.list(
                page=1,
                page_limit=10,
                sort_by="created_at",
                sort_option="desc",
                index_name="myIndex",
                model_options="visual,audio",
                model_family="marengo",
                created_at="2024-08-16T16:53:59Z",
                updated_at="2024-08-16T16:55:59Z",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page,
            page_limit=page_limit,
            sort_by=sort_by,
            sort_option=sort_option,
            index_name=index_name,
            model_options=model_options,
            model_family=model_family,
            created_at=created_at,
            updated_at=updated_at,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        index_name: str,
        models: typing.Sequence[IndexesCreateRequestModelsItem],
        addons: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IndexesCreateResponse:
        """
        This method creates an index.

        Parameters
        ----------
        index_name : str
            The name of the index. Make sure you use a succinct and descriptive name.

        models : typing.Sequence[IndexesCreateRequestModelsItem]
            An array that specifies the [video understanding models](/v1.3/docs/concepts/models) and the [model options](/v1.3/docs/concepts/modalities#model-options) to be enabled for this index. This determines how the platform processes your videos.

        addons : typing.Optional[typing.Sequence[str]]
            An array specifying which add-ons should be enabled. Each entry in the array is an addon, and the following values are supported:
            - `thumbnail`: Enables thumbnail generation.

            If you don't provide this parameter, no add-ons will be enabled.

            <Note title="Notes">
            - You can only enable addons when using the Marengo video understanding model.
            - You cannot disable an add-on once the index has been created.
            </Note>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IndexesCreateResponse
            An index has successfully been created

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs
        from twelvelabs.indexes import IndexesCreateRequestModelsItem

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.indexes.create(
                index_name="myIndex",
                models=[
                    IndexesCreateRequestModelsItem(
                        model_name="marengo2.7",
                        model_options=["visual", "audio"],
                    ),
                    IndexesCreateRequestModelsItem(
                        model_name="pegasus1.2",
                        model_options=["visual", "audio"],
                    ),
                ],
                addons=["thumbnail"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            index_name=index_name, models=models, addons=addons, request_options=request_options
        )
        return _response.data

    async def retrieve(self, index_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> IndexSchema:
        """
        This method retrieves details about the specified index.

        Parameters
        ----------
        index_id : str
            Unique identifier of the index to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IndexSchema
            The specified index has successfully been retrieved.

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.indexes.retrieve(
                index_id="6298d673f1090f1100476d4c",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(index_id, request_options=request_options)
        return _response.data

    async def update(
        self, index_id: str, *, index_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        This method updates the name of the specified index.

        Parameters
        ----------
        index_id : str
            Unique identifier of the index to update.

        index_name : str
            The name of the index.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.indexes.update(
                index_id="6298d673f1090f1100476d4c",
                index_name="myIndex",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(index_id, index_name=index_name, request_options=request_options)
        return _response.data

    async def delete(self, index_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        This method deletes the specified index and all the videos within it. This action cannot be undone.

        Parameters
        ----------
        index_id : str
            Unique identifier of the index to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.indexes.delete(
                index_id="6298d673f1090f1100476d4c",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(index_id, request_options=request_options)
        return _response.data
