# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.user_metadata import UserMetadata
from ...types.video_vector import VideoVector
from .raw_client import AsyncRawVideosClient, RawVideosClient
from .types.videos_list_request_user_metadata_value import VideosListRequestUserMetadataValue
from .types.videos_retrieve_request_embedding_option_item import VideosRetrieveRequestEmbeddingOptionItem
from .types.videos_retrieve_response import VideosRetrieveResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VideosClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVideosClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVideosClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVideosClient
        """
        return self._raw_client

    def list(
        self,
        index_id: str,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        filename: typing.Optional[str] = None,
        duration: typing.Optional[float] = None,
        fps: typing.Optional[float] = None,
        width: typing.Optional[float] = None,
        height: typing.Optional[int] = None,
        size: typing.Optional[float] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        user_metadata: typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[VideoVector]:
        """
        This method returns a list of the videos in the specified index. By default, the API returns your videos sorted by creation date, with the newest at the top of the list.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index for which the API will retrieve the videos.

        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        filename : typing.Optional[str]
            Filter by filename.

        duration : typing.Optional[float]
            Filter by duration. Expressed in seconds.

        fps : typing.Optional[float]
            Filter by frames per second.

        width : typing.Optional[float]
            Filter by width.

        height : typing.Optional[int]
            Filter by height.

        size : typing.Optional[float]
            Filter by size. Expressed in bytes.

        created_at : typing.Optional[str]
            Filter videos by the creation date and time of their associated indexing tasks, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the videos whose indexing tasks were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            This filter applies only to videos updated using the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/{index-id}/videos/{video-id}` endpoint. It filters videos by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were last updated on the specified date at or after the given time.

        user_metadata : typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]]
            To enable filtering by custom fields, you must first add user-defined metadata to your video by calling the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/:index-id/videos/:video-id` endpoint.

            Examples:
            - To filter on a string: `?category=recentlyAdded`
            - To filter on an integer: `?batchNumber=5`
            - To filter on a float: `?rating=9.3`
            - To filter on a boolean: `?needsReview=true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[VideoVector]
            The video vectors in the specified index have successfully been retrieved.

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        response = client.indexes.videos.list(
            index_id="6298d673f1090f1100476d4c",
            page=1,
            page_limit=10,
            sort_by="created_at",
            sort_option="desc",
            filename="01.mp4",
            created_at="2024-08-16T16:53:59Z",
            updated_at="2024-08-16T16:53:59Z",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            index_id,
            page=page,
            page_limit=page_limit,
            sort_by=sort_by,
            sort_option=sort_option,
            filename=filename,
            duration=duration,
            fps=fps,
            width=width,
            height=height,
            size=size,
            created_at=created_at,
            updated_at=updated_at,
            user_metadata=user_metadata,
            request_options=request_options,
        )

    def retrieve(
        self,
        index_id: str,
        video_id: str,
        *,
        embedding_option: typing.Optional[
            typing.Union[
                VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]
            ]
        ] = None,
        transcription: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VideosRetrieveResponse:
        """
        This method retrieves information about the specified video.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to retrieve.

        embedding_option : typing.Optional[typing.Union[VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]]]
            Specifies which types of embeddings to retrieve. You can include one or more of the following values:
            - `visual-text`:  Returns visual embeddings optimized for text search.
            - `audio`: Returns audio embeddings.
            <br/>
            To retrieve embeddings for a video, it must be indexed using the Marengo video understanding model version 2.7 or later. For details on enabling this model for an index, see the [Create an index](/reference/create-index) page.

            The platform does not return embeddings if you don't provide this parameter.

            The values you specify in `embedding_option` must be included in the `model_options` defined when the index was created. For example, if `model_options` is set to `visual` only, then you cannot set `embedding_option` to `audio` or  both `visual-text` and `audio`.

        transcription : typing.Optional[bool]
            The parameter indicates whether to retrieve a transcription of the spoken words for the indexed video. Note that the official SDKs will support this feature in a future release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VideosRetrieveResponse
            The specified video information has successfully been retrieved.

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.indexes.videos.retrieve(
            index_id="6298d673f1090f1100476d4c",
            video_id="6298d673f1090f1100476d4c",
        )
        """
        _response = self._raw_client.retrieve(
            index_id,
            video_id,
            embedding_option=embedding_option,
            transcription=transcription,
            request_options=request_options,
        )
        return _response.data

    def delete(self, index_id: str, video_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        This method deletes all the information about the specified video. This action cannot be undone.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.indexes.videos.delete(
            index_id="6298d673f1090f1100476d4c",
            video_id="6298d673f1090f1100476d4c",
        )
        """
        _response = self._raw_client.delete(index_id, video_id, request_options=request_options)
        return _response.data

    def update(
        self,
        index_id: str,
        video_id: str,
        *,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Use this method to update one or more fields of the metadata of a video. Also, you can delete a field by setting it to `null`.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to update.

        user_metadata : typing.Optional[UserMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from twelvelabs import TwelveLabs

        client = TwelveLabs(
            api_key="YOUR_API_KEY",
        )
        client.indexes.videos.update(
            index_id="6298d673f1090f1100476d4c",
            video_id="6298d673f1090f1100476d4c",
            user_metadata={
                "category": "recentlyAdded",
                "batchNumber": 5,
                "rating": 9.3,
                "needsReview": True,
            },
        )
        """
        _response = self._raw_client.update(
            index_id, video_id, user_metadata=user_metadata, request_options=request_options
        )
        return _response.data


class AsyncVideosClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVideosClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVideosClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVideosClient
        """
        return self._raw_client

    async def list(
        self,
        index_id: str,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        filename: typing.Optional[str] = None,
        duration: typing.Optional[float] = None,
        fps: typing.Optional[float] = None,
        width: typing.Optional[float] = None,
        height: typing.Optional[int] = None,
        size: typing.Optional[float] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        user_metadata: typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[VideoVector]:
        """
        This method returns a list of the videos in the specified index. By default, the API returns your videos sorted by creation date, with the newest at the top of the list.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index for which the API will retrieve the videos.

        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        filename : typing.Optional[str]
            Filter by filename.

        duration : typing.Optional[float]
            Filter by duration. Expressed in seconds.

        fps : typing.Optional[float]
            Filter by frames per second.

        width : typing.Optional[float]
            Filter by width.

        height : typing.Optional[int]
            Filter by height.

        size : typing.Optional[float]
            Filter by size. Expressed in bytes.

        created_at : typing.Optional[str]
            Filter videos by the creation date and time of their associated indexing tasks, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the videos whose indexing tasks were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            This filter applies only to videos updated using the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/{index-id}/videos/{video-id}` endpoint. It filters videos by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were last updated on the specified date at or after the given time.

        user_metadata : typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]]
            To enable filtering by custom fields, you must first add user-defined metadata to your video by calling the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/:index-id/videos/:video-id` endpoint.

            Examples:
            - To filter on a string: `?category=recentlyAdded`
            - To filter on an integer: `?batchNumber=5`
            - To filter on a float: `?rating=9.3`
            - To filter on a boolean: `?needsReview=true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[VideoVector]
            The video vectors in the specified index have successfully been retrieved.

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.indexes.videos.list(
                index_id="6298d673f1090f1100476d4c",
                page=1,
                page_limit=10,
                sort_by="created_at",
                sort_option="desc",
                filename="01.mp4",
                created_at="2024-08-16T16:53:59Z",
                updated_at="2024-08-16T16:53:59Z",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            index_id,
            page=page,
            page_limit=page_limit,
            sort_by=sort_by,
            sort_option=sort_option,
            filename=filename,
            duration=duration,
            fps=fps,
            width=width,
            height=height,
            size=size,
            created_at=created_at,
            updated_at=updated_at,
            user_metadata=user_metadata,
            request_options=request_options,
        )

    async def retrieve(
        self,
        index_id: str,
        video_id: str,
        *,
        embedding_option: typing.Optional[
            typing.Union[
                VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]
            ]
        ] = None,
        transcription: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VideosRetrieveResponse:
        """
        This method retrieves information about the specified video.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to retrieve.

        embedding_option : typing.Optional[typing.Union[VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]]]
            Specifies which types of embeddings to retrieve. You can include one or more of the following values:
            - `visual-text`:  Returns visual embeddings optimized for text search.
            - `audio`: Returns audio embeddings.
            <br/>
            To retrieve embeddings for a video, it must be indexed using the Marengo video understanding model version 2.7 or later. For details on enabling this model for an index, see the [Create an index](/reference/create-index) page.

            The platform does not return embeddings if you don't provide this parameter.

            The values you specify in `embedding_option` must be included in the `model_options` defined when the index was created. For example, if `model_options` is set to `visual` only, then you cannot set `embedding_option` to `audio` or  both `visual-text` and `audio`.

        transcription : typing.Optional[bool]
            The parameter indicates whether to retrieve a transcription of the spoken words for the indexed video. Note that the official SDKs will support this feature in a future release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VideosRetrieveResponse
            The specified video information has successfully been retrieved.

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.indexes.videos.retrieve(
                index_id="6298d673f1090f1100476d4c",
                video_id="6298d673f1090f1100476d4c",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            index_id,
            video_id,
            embedding_option=embedding_option,
            transcription=transcription,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, index_id: str, video_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        This method deletes all the information about the specified video. This action cannot be undone.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.indexes.videos.delete(
                index_id="6298d673f1090f1100476d4c",
                video_id="6298d673f1090f1100476d4c",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(index_id, video_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        index_id: str,
        video_id: str,
        *,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Use this method to update one or more fields of the metadata of a video. Also, you can delete a field by setting it to `null`.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to update.

        user_metadata : typing.Optional[UserMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from twelvelabs import AsyncTwelveLabs

        client = AsyncTwelveLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.indexes.videos.update(
                index_id="6298d673f1090f1100476d4c",
                video_id="6298d673f1090f1100476d4c",
                user_metadata={
                    "category": "recentlyAdded",
                    "batchNumber": 5,
                    "rating": 9.3,
                    "needsReview": True,
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            index_id, video_id, user_metadata=user_metadata, request_options=request_options
        )
        return _response.data
