# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.not_found_error import NotFoundError
from ...types.not_found_error_body import NotFoundErrorBody
from ...types.user_metadata import UserMetadata
from ...types.video_vector import VideoVector
from .types.videos_list_request_user_metadata_value import VideosListRequestUserMetadataValue
from .types.videos_list_response import VideosListResponse
from .types.videos_retrieve_request_embedding_option_item import VideosRetrieveRequestEmbeddingOptionItem
from .types.videos_retrieve_response import VideosRetrieveResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawVideosClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        index_id: str,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        filename: typing.Optional[str] = None,
        duration: typing.Optional[float] = None,
        fps: typing.Optional[float] = None,
        width: typing.Optional[float] = None,
        height: typing.Optional[int] = None,
        size: typing.Optional[float] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        user_metadata: typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[VideoVector]:
        """
        This method returns a list of the videos in the specified index. By default, the API returns your videos sorted by creation date, with the newest at the top of the list.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index for which the API will retrieve the videos.

        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        filename : typing.Optional[str]
            Filter by filename.

        duration : typing.Optional[float]
            Filter by duration. Expressed in seconds.

        fps : typing.Optional[float]
            Filter by frames per second.

        width : typing.Optional[float]
            Filter by width.

        height : typing.Optional[int]
            Filter by height.

        size : typing.Optional[float]
            Filter by size. Expressed in bytes.

        created_at : typing.Optional[str]
            Filter videos by the creation date and time of their associated indexing tasks, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the videos whose indexing tasks were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            This filter applies only to videos updated using the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/{index-id}/videos/{video-id}` endpoint. It filters videos by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were last updated on the specified date at or after the given time.

        user_metadata : typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]]
            To enable filtering by custom fields, you must first add user-defined metadata to your video by calling the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/:index-id/videos/:video-id` endpoint.

            Examples:
            - To filter on a string: `?category=recentlyAdded`
            - To filter on an integer: `?batchNumber=5`
            - To filter on a float: `?rating=9.3`
            - To filter on a boolean: `?needsReview=true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[VideoVector]
            The video vectors in the specified index have successfully been retrieved.
        """
        page = page if page is not None else 1

        _response = self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos",
            method="GET",
            params={
                "page": page,
                "page_limit": page_limit,
                "sort_by": sort_by,
                "sort_option": sort_option,
                "filename": filename,
                "duration": duration,
                "fps": fps,
                "width": width,
                "height": height,
                "size": size,
                "created_at": created_at,
                "updated_at": updated_at,
                "user_metadata": convert_and_respect_annotation_metadata(
                    object_=user_metadata,
                    annotation=typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]],
                    direction="write",
                ),
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    VideosListResponse,
                    parse_obj_as(
                        type_=VideosListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True
                _get_next = lambda: self.list(
                    index_id,
                    page=page + 1,
                    page_limit=page_limit,
                    sort_by=sort_by,
                    sort_option=sort_option,
                    filename=filename,
                    duration=duration,
                    fps=fps,
                    width=width,
                    height=height,
                    size=size,
                    created_at=created_at,
                    updated_at=updated_at,
                    user_metadata=user_metadata,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self,
        index_id: str,
        video_id: str,
        *,
        embedding_option: typing.Optional[
            typing.Union[
                VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]
            ]
        ] = None,
        transcription: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[VideosRetrieveResponse]:
        """
        This method retrieves information about the specified video.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to retrieve.

        embedding_option : typing.Optional[typing.Union[VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]]]
            Specifies which types of embeddings to retrieve. You can include one or more of the following values:
            - `visual-text`:  Returns visual embeddings optimized for text search.
            - `audio`: Returns audio embeddings.
            <br/>
            To retrieve embeddings for a video, it must be indexed using the Marengo video understanding model version 2.7 or later. For details on enabling this model for an index, see the [Create an index](/reference/create-index) page.

            The platform does not return embeddings if you don't provide this parameter.

            The values you specify in `embedding_option` must be included in the `model_options` defined when the index was created. For example, if `model_options` is set to `visual` only, then you cannot set `embedding_option` to `audio` or  both `visual-text` and `audio`.

        transcription : typing.Optional[bool]
            The parameter indicates whether to retrieve a transcription of the spoken words for the indexed video. Note that the official SDKs will support this feature in a future release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[VideosRetrieveResponse]
            The specified video information has successfully been retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos/{jsonable_encoder(video_id)}",
            method="GET",
            params={
                "embedding_option": embedding_option,
                "transcription": transcription,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VideosRetrieveResponse,
                    parse_obj_as(
                        type_=VideosRetrieveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        NotFoundErrorBody,
                        parse_obj_as(
                            type_=NotFoundErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, index_id: str, video_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        This method deletes all the information about the specified video. This action cannot be undone.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos/{jsonable_encoder(video_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        index_id: str,
        video_id: str,
        *,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Use this method to update one or more fields of the metadata of a video. Also, you can delete a field by setting it to `null`.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to update.

        user_metadata : typing.Optional[UserMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos/{jsonable_encoder(video_id)}",
            method="PATCH",
            json={
                "user_metadata": user_metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawVideosClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        index_id: str,
        *,
        page: typing.Optional[int] = None,
        page_limit: typing.Optional[int] = None,
        sort_by: typing.Optional[str] = None,
        sort_option: typing.Optional[str] = None,
        filename: typing.Optional[str] = None,
        duration: typing.Optional[float] = None,
        fps: typing.Optional[float] = None,
        width: typing.Optional[float] = None,
        height: typing.Optional[int] = None,
        size: typing.Optional[float] = None,
        created_at: typing.Optional[str] = None,
        updated_at: typing.Optional[str] = None,
        user_metadata: typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[VideoVector]:
        """
        This method returns a list of the videos in the specified index. By default, the API returns your videos sorted by creation date, with the newest at the top of the list.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index for which the API will retrieve the videos.

        page : typing.Optional[int]
            A number that identifies the page to retrieve.

            **Default**: `1`.

        page_limit : typing.Optional[int]
            The number of items to return on each page.

            **Default**: `10`.
            **Max**: `50`.

        sort_by : typing.Optional[str]
            The field to sort on. The following options are available:
            - `updated_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was updated.
            - `created_at`: Sorts by the time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"), when the item was created.

            **Default**: `created_at`.

        sort_option : typing.Optional[str]
            The sorting direction. The following options are available:
            - `asc`
            - `desc`

            **Default**: `desc`.

        filename : typing.Optional[str]
            Filter by filename.

        duration : typing.Optional[float]
            Filter by duration. Expressed in seconds.

        fps : typing.Optional[float]
            Filter by frames per second.

        width : typing.Optional[float]
            Filter by width.

        height : typing.Optional[int]
            Filter by height.

        size : typing.Optional[float]
            Filter by size. Expressed in bytes.

        created_at : typing.Optional[str]
            Filter videos by the creation date and time of their associated indexing tasks, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the videos whose indexing tasks were created on the specified date at or after the given time.

        updated_at : typing.Optional[str]
            This filter applies only to videos updated using the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/{index-id}/videos/{video-id}` endpoint. It filters videos by the last update date and time, in the RFC 3339 format ("YYYY-MM-DDTHH:mm:ssZ"). The platform returns the video indexing tasks that were last updated on the specified date at or after the given time.

        user_metadata : typing.Optional[typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]]]
            To enable filtering by custom fields, you must first add user-defined metadata to your video by calling the [`PUT`](/v1.3/api-reference/videos/update) method of the `/indexes/:index-id/videos/:video-id` endpoint.

            Examples:
            - To filter on a string: `?category=recentlyAdded`
            - To filter on an integer: `?batchNumber=5`
            - To filter on a float: `?rating=9.3`
            - To filter on a boolean: `?needsReview=true`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[VideoVector]
            The video vectors in the specified index have successfully been retrieved.
        """
        page = page if page is not None else 1

        _response = await self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos",
            method="GET",
            params={
                "page": page,
                "page_limit": page_limit,
                "sort_by": sort_by,
                "sort_option": sort_option,
                "filename": filename,
                "duration": duration,
                "fps": fps,
                "width": width,
                "height": height,
                "size": size,
                "created_at": created_at,
                "updated_at": updated_at,
                "user_metadata": convert_and_respect_annotation_metadata(
                    object_=user_metadata,
                    annotation=typing.Dict[str, typing.Optional[VideosListRequestUserMetadataValue]],
                    direction="write",
                ),
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    VideosListResponse,
                    parse_obj_as(
                        type_=VideosListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True

                async def _get_next():
                    return await self.list(
                        index_id,
                        page=page + 1,
                        page_limit=page_limit,
                        sort_by=sort_by,
                        sort_option=sort_option,
                        filename=filename,
                        duration=duration,
                        fps=fps,
                        width=width,
                        height=height,
                        size=size,
                        created_at=created_at,
                        updated_at=updated_at,
                        user_metadata=user_metadata,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self,
        index_id: str,
        video_id: str,
        *,
        embedding_option: typing.Optional[
            typing.Union[
                VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]
            ]
        ] = None,
        transcription: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[VideosRetrieveResponse]:
        """
        This method retrieves information about the specified video.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to retrieve.

        embedding_option : typing.Optional[typing.Union[VideosRetrieveRequestEmbeddingOptionItem, typing.Sequence[VideosRetrieveRequestEmbeddingOptionItem]]]
            Specifies which types of embeddings to retrieve. You can include one or more of the following values:
            - `visual-text`:  Returns visual embeddings optimized for text search.
            - `audio`: Returns audio embeddings.
            <br/>
            To retrieve embeddings for a video, it must be indexed using the Marengo video understanding model version 2.7 or later. For details on enabling this model for an index, see the [Create an index](/reference/create-index) page.

            The platform does not return embeddings if you don't provide this parameter.

            The values you specify in `embedding_option` must be included in the `model_options` defined when the index was created. For example, if `model_options` is set to `visual` only, then you cannot set `embedding_option` to `audio` or  both `visual-text` and `audio`.

        transcription : typing.Optional[bool]
            The parameter indicates whether to retrieve a transcription of the spoken words for the indexed video. Note that the official SDKs will support this feature in a future release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[VideosRetrieveResponse]
            The specified video information has successfully been retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos/{jsonable_encoder(video_id)}",
            method="GET",
            params={
                "embedding_option": embedding_option,
                "transcription": transcription,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VideosRetrieveResponse,
                    parse_obj_as(
                        type_=VideosRetrieveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        NotFoundErrorBody,
                        parse_obj_as(
                            type_=NotFoundErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, index_id: str, video_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        This method deletes all the information about the specified video. This action cannot be undone.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos/{jsonable_encoder(video_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        index_id: str,
        video_id: str,
        *,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Use this method to update one or more fields of the metadata of a video. Also, you can delete a field by setting it to `null`.

        Parameters
        ----------
        index_id : str
            The unique identifier of the index to which the video has been uploaded.

        video_id : str
            The unique identifier of the video to update.

        user_metadata : typing.Optional[UserMetadata]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"indexes/{jsonable_encoder(index_id)}/videos/{jsonable_encoder(video_id)}",
            method="PATCH",
            json={
                "user_metadata": user_metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
