# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TransfersCreateResponseVideosItem(UniversalBaseModel):
    video_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of a video. This identifier serves a dual purpose:
    - It identifies the video itself.
    - It identifies the associated video indexing task.
    
    For example, due to this dual functionality, you can use this identifier to:
    - Retrieve details about the video itself by invoking the [`GET`](/v1.3/api-reference/videos/retrieve) method of the `/indexes/{index-id}/videos/{video-id}` endpoint.
    - Retrieve the status of the video indexing task by invoking the [`GET`](/v1.3/api-reference/tasks/retrieve) method of the `/tasks/{task_id}` endpoint.
    """

    filename: typing.Optional[str] = pydantic.Field(default=None)
    """
    The filename of the video.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
