# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .token_usage import TokenUsage


class Gist(UniversalBaseModel):
    """
    Generated title, topics, and hashtags for the specified video.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the response.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Suggested title for the video.
    """

    topics: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    An array of topics that are relevant to the video.
    """

    hashtags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    An array of hashtags that are relevant to the video.
    """

    usage: typing.Optional[TokenUsage] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
