# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ResponseFormat(UniversalBaseModel):
    """
    Use this parameter to specify the format of the response. When you omit this parameter, the platform returns unstructured text.
    """

    type: typing.Literal["json_schema"] = pydantic.Field(default="json_schema")
    """
    Set this parameter to "json_schema" to receive structured JSON responses.
    """

    json_schema: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Contains the JSON schema that defines the response structure. The schema must adhere to the [JSON Schema Draft 2020-12](https://json-schema.org/draft/2020-12) specification.
    
    **Supported types**
    - `array`
    - `boolean`
    - `integer`
    - `null`
    - `number`
    - `object`
    - `string`
    
    **Supported constraints**
    
    | Type | Supported keywords | Notes |
    |------|-------------------|-------|
    | `integer` | `maximum`, `exclusiveMaximum`, `minimum`, `exclusiveMinimum`. | - `maximum`: Sets the highest allowed value (inclusive).<br/>- `exclusiveMaximum`: Sets the highest allowed value (exclusive).<br/>-`minimum`: Sets the lowest allowed value (inclusive).<br/>- `exclusiveMinimum`: Sets the lowest allowed value (exclusive).<br/>These constraints are supported only for the `integer` type. |
    | `string` | `pattern`, `format` | - `pattern`: A regular expression that the string must match.<br/>- `format`: Validates predefined formats. It accepts the following values: `uuid`, `date-time`, `date`, and `time`.<br/>See string limitations below. |
    | `object` | `properties`, `required` | - `properties`: Defines object properties and their schemas. - `required`: Specifies mandatory properties.<br/>See object limitations below. |
    | `array` | `items`, `minItems` | `minItems` accepts only `0` or `1` |
    
    
    **String limitations**
    
    The platform validates strings using the `pattern` and `format` constraints only. When you include `minLength` or `maxLength` keywords in your schema, the platform returns an error: "String length constraints (minLength) are not supported."
    
    
    **Object limitations**
    
    When you use the `object` type:
    - The platform always ignores the `additionalProperties` setting.
    - The sequence of the properties is fixed.
    - The first property should be required. If the first property is optional, the platform moves the first required property to the first position.
    
    
    **Constant and enumerated values**
    
    The `const` and `enum` keywords support the following types:
    - `boolean`
    - `null`
    - `number`
    - `string`
    
    
    **Schema composition**
    
    The platform supports only `anyOf` for [schema composition](https://json-schema.org/understanding-json-schema/reference/combining).
    
    
    **Annotations**
    
    The platform accepts but ignores JSON schema annotations like `title`, `$comments`, and `description`.
    
    **Subschema references**
    
    You can reference subschemas using `$ref` with these requirements:
    - Define subschemas within `$defs`.
    - Use valid URIs that point to the internal subschema.
    
    For details, see the [JSON Schema documentation on $defs](https://json-schema.org/understanding-json-schema/structuring#defs).
    
    
    
    **Response validation**
    
    Check the `FinishReason` field to verify your JSON response is complete:
    - When `FinishReason` is `stop`, the generation completed normally, and the JSON is valid and complete.
    - When `FinishReason` is `length`, the platform truncates the response at the token limit. This may result in truncated, invalid JSON that fails to parse.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
