# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .finish_reason import FinishReason
from .stream_end_response_metadata import StreamEndResponseMetadata
from .stream_start_response_metadata import StreamStartResponseMetadata


class StreamAnalyzeResponse_StreamStart(UniversalBaseModel):
    """
    When the value of the `stream` parameter is set to `true`, the platform provides a streaming response in the NDJSON format.

    The stream contains three types of events:
    1. Stream start
    2. Text generation
    3. Stream end

    To integrate the response into your application, follow the guidelines below:
    - Parse each line of the response as a separate JSON object.
    - Check the `event_type` field to determine how to handle the event.
    - For `text_generation` events, process the `text` field as it arrives. Depending on your application's requirements, this may involve displaying the text incrementally, storing it for later use, or performing any tasks.
    - Use the `stream_start` and `stream_end` events to manage the lifecycle of your streaming session.
    """

    event_type: typing.Literal["stream_start"] = "stream_start"
    metadata: typing.Optional[StreamStartResponseMetadata] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class StreamAnalyzeResponse_TextGeneration(UniversalBaseModel):
    """
    When the value of the `stream` parameter is set to `true`, the platform provides a streaming response in the NDJSON format.

    The stream contains three types of events:
    1. Stream start
    2. Text generation
    3. Stream end

    To integrate the response into your application, follow the guidelines below:
    - Parse each line of the response as a separate JSON object.
    - Check the `event_type` field to determine how to handle the event.
    - For `text_generation` events, process the `text` field as it arrives. Depending on your application's requirements, this may involve displaying the text incrementally, storing it for later use, or performing any tasks.
    - Use the `stream_start` and `stream_end` events to manage the lifecycle of your streaming session.
    """

    event_type: typing.Literal["text_generation"] = "text_generation"
    text: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class StreamAnalyzeResponse_StreamEnd(UniversalBaseModel):
    """
    When the value of the `stream` parameter is set to `true`, the platform provides a streaming response in the NDJSON format.

    The stream contains three types of events:
    1. Stream start
    2. Text generation
    3. Stream end

    To integrate the response into your application, follow the guidelines below:
    - Parse each line of the response as a separate JSON object.
    - Check the `event_type` field to determine how to handle the event.
    - For `text_generation` events, process the `text` field as it arrives. Depending on your application's requirements, this may involve displaying the text incrementally, storing it for later use, or performing any tasks.
    - Use the `stream_start` and `stream_end` events to manage the lifecycle of your streaming session.
    """

    event_type: typing.Literal["stream_end"] = "stream_end"
    finish_reason: typing.Optional[FinishReason] = None
    metadata: typing.Optional[StreamEndResponseMetadata] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


StreamAnalyzeResponse = typing.Union[
    StreamAnalyzeResponse_StreamStart, StreamAnalyzeResponse_TextGeneration, StreamAnalyzeResponse_StreamEnd
]
